﻿using JmpZbPrint.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace JmpZbPrint.Dialog
{
    /// <summary>
    /// SupplierWin.xaml 的交互逻辑
    /// </summary>
    public partial class SelectEqu : Window
    {
        public List<EquInfo> EquList { get; set; } = new List<EquInfo>();
        public SelectEqu()
        {
            InitializeComponent();
            EquList = HttpHelper.GetAllEqu();
            g_equ.ItemsSource = EquList?.Take(30);
            txt_vendor.Focus();

        }
        public EquInfo EquInfo { get; set; }
        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
        }

        private void OnQueryClick(object sender, RoutedEventArgs e)
        {
            if (string.IsNullOrEmpty(txt_vendor.Text))
            {
                g_equ.ItemsSource = EquList;
            }
            else
            {
                g_equ.ItemsSource = EquList?.Where(t => t.name.Contains(txt_vendor.Text));
            }
        }

        private void OnSelectItemClick(object sender, RoutedEventArgs e)
        {
            EquInfo = g_equ.SelectedValue as EquInfo;
            this.Close();
        }
    }
}
