﻿using JmpZbModel;
using JmpZbPrint.Model;
using JmpZbPrint.UsControl;
using JmpZbPrint.ViewModel;
using MaterialDesignThemes.Wpf;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using JmpZbPrint.View;

namespace JmpZbPrint.Dialog
{
    /// <summary>
    /// PrintLogWindow.xaml 的交互逻辑
    /// </summary>
    public partial class PrintLogWindow : Window
    {
        public PrintLog PrintInfo { get; set; }

        private MainWindow _window;

        public PrintLogWindow(MainWindow window)
        {
            InitializeComponent();
            _window = window;
            var vm2 = new PrintLogWindowViewModel();
            this.DataContext = vm2;
        }
        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
        }

        private void OnSelectItemClick(object sender, RoutedEventArgs e)
        {
            var tsk_item = g_vender.SelectedValue as PrintLog;
            var res = _window.printServerHelper.SendPrintCmd(new SingleInfo()
            {
                Info1 = tsk_item.productName,
                Info2 = tsk_item.sizeName,
                Info3 = tsk_item.supplierName,
                Info4 = tsk_item.pieceNo ?? "1",
                Info5 = tsk_item.productTime,
                Info9 = tsk_item.epc.Replace(" ", ""),
                ModelType = "piece"
            });
            if (res)
            {
                MessageBox.Show("打印成功");
            }
            else
            {
                MessageBox.Show("打印失败");
            }
        }
    }
}
