﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Data;

namespace JmpZbPrint.Common
{
    [ValueConversion(typeof(DateTime), typeof(string))]
    public class DateTimeConverter : IValueConverter
    {
        //源属性传给目标属性时，调用此方法ConvertBack
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            DateTime obj;
            if (value == null)
            {
                obj = DateTime.Now;
            }
            else
            {
                obj = (DateTime)value;
            }
            if (parameter == null || string.IsNullOrEmpty(parameter.ToString()))
            {
                return obj.ToLocalTime();
            }
            else
            {
                return obj.ToString(parameter.ToString());
            }

        }

        //目标属性传给源属性时，调用此方法ConvertBack
        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value == null||string.IsNullOrEmpty(value.ToString()))
            {
                return DateTime.Now;
            }
            else
            {

                DateTime.TryParse(value.ToString(), out DateTime date);
                return date == default ? DateTime.Now: date;
            }
        }
    }
}
