﻿using GalaSoft.MvvmLight;
using Newtonsoft.Json;
using System.Windows;

namespace JmpZbPrint.Common
{
    public class Config : ViewModelBase
    {
        public Config()
        {
            AppTitle = "警用装备RFID初始化 v" + Application.ResourceAssembly.GetName().Version;
            AppVersion = Application.ResourceAssembly.GetName().Version.ToString();
            AppCode = "10002";

            DomainUrl = "http://41.190.20.132:18761/api/service";
            UserLogin = "http://41.190.20.132:10004/auth/userLogin";
            CardOnly = false;
            ApiVersion = "1.0";
            AppKey = "jg/eM+bvVcTtil9yQJ1u5g==";
            SecretKey = "0827414cbc1003ab865b975b6fae3c12";
            IsDirectEntryStock = false;
            IsAutoUpdate = true;
            AutoUpdateTime = 0;
            PrintType = 0;
        }

        /// <summary>
        /// 接口域名
        /// </summary>
        public string DomainUrl { get; set; }
        /// <summary>
        /// 登录 
        /// </summary>
        public string UserLogin { get; set; }
        [JsonIgnore]
        public string AppTitle { get; set; }
        [JsonIgnore]
        public string AppVersion { get; set; }
        public string AppCode { get; set; }
        public bool CardOnly { get; set; }
        public string AppKey { get; set; }
        public string SecretKey { get; set; }
        public string ApiVersion { get; set; }
        /// <summary>
        /// 初始化的标签直接自动入库
        /// </summary>
        public bool IsDirectEntryStock { get; set; }
        /// <summary>
        /// 是否自动更新
        /// </summary>
        public bool IsAutoUpdate { get; set; }
        /// <summary>
        /// 自动更新时间（小时）
        /// </summary>
        public int AutoUpdateTime { get; set; }
        /// <summary>
        /// 打印机类型
        /// 0   东芝
        /// 1   博思得
        /// </summary>
        public int PrintType { get; set; }
    }

    public static class UrlConfig
    {
        public const string GetPrintList = "/api/Print/GetPrintList";
        public const string SoftUpdate = "/api/SoftUpdate/GetLastUpdate";
        public const string GetAllSupplier = "/api/Print/GetAllSupplier";
        public const string GenExtTagEpc = "/api/Print/GenerateExtTagEpc";
        public const string CheckEpcIsInstantiation = "/api/Print/CheckEpcIsInstantiation";
        public const string GenInventory = "/api/Print/GenerateInventoryWithProgram";
        public const string GenRangeInventory = "/api/Print/GenerateRangeInventory";
        public const string BoxingInventory = "/api/Print/BoxingInventory";
        public const string BoxingInventoryNormalVersion = "/api/Print/BoxingInventoryNormalVersion";
        public const string UnpackRangeInventory = "/api/Print/UnpackRangeInventory";
        public const string GetInventoryListByBoxMarkEpc = "/api/EquipmentBoxMark/GetInventoryListByBoxMarkEpc";
        public const string GetBoxMarkList = "/api/EquipmentBoxMark/GetBoxMarkList";
        public const string GetNeedPrintBoxMarkList = "/api/EquipmentBoxMark/GetNeedPrintBoxMarkList";
        public const string ImportOldBoxMark = "/api/Print/ImportOldBoxMark";
        public const string GenIntTagEpc = "/api/Print/GenerateIntTagEpc";
        public const string UpdateEpc = "/api/Print/UpdateEpcState";
        public const string OrderList = "/api/Print/GetPrintOrder";
        public const string GetEquInfo = "/api/Print/GetEquInfoById";
        public const string GetAllEqu = "/api/Print/GetAllEqu";
        public const string DelEpc = "/api/Print/DeleteInventory";
        public const string DelEpcList = "/api/Print/DeleteInventoryByEpcList";
        public const string GetWarehouse = "/api/Warehouse/GetListWarehouse";
        public const string GetListShelf = "/api/Shelf/GetListShelf";
        public const string GetListEquipmentShelfPosition = "/api/Shelf/GetListEquipmentShelfPosition";
        public const string GetPrintBagList = "/api/Print/GetPrintBagList";
        public const string UpdateBagState = "/api/Print/UpdateBagState";
    }
}
