﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;

namespace JmpPrintService.PrintModel
{
    public static class ToshibaTemplate
    {
        public static int Version { get; set; } = 2;

        /// <summary>
        /// 供应商列最大字数
        /// </summary>
        private static int TitleMaxWord { get; set; } = 17;

        /// <summary>
        /// 单个字间隔
        /// </summary>
        private static int TitleWordLen { get; set; } = 55;

        //private static string PieceImgString { get; set; }
        //private static string BoxImgString { get; set; }
        private static Dictionary<string, string> dic_remplate = new Dictionary<string, string>();

        /// <summary>
        /// RFID物料命令
        /// </summary>
        /// <param name="str1"></param>
        /// <param name="str2"></param>
        /// <param name="str3"></param>
        /// <param name="str4"></param>
        /// <param name="str5"></param>
        /// <param name="str6"></param>
        /// <param name="strEpc"></param>
        /// <returns></returns>
        public static string GetRfidPrintCmd<T>(T entity, string strModelType)
        {
            string strTemplate = string.Empty;//File.ReadAllText(AppDomain.CurrentDomain.BaseDirectory + "Template\\1.txt");
            string strPath = string.Empty;
            switch (strModelType)
            {
                case "51":
                    strPath = AppDomain.CurrentDomain.BaseDirectory + "Template\\1.txt";
                    break;
                case "52":
                    strPath = AppDomain.CurrentDomain.BaseDirectory + "Template\\2.txt";
                    break;
                case "53":
                    strPath = AppDomain.CurrentDomain.BaseDirectory + "Template\\3.txt";
                    break;
            }

            if (!File.Exists(strPath)) { return string.Empty; }
            else
            {
                if (dic_remplate.ContainsKey(strModelType))
                {
                    strTemplate = dic_remplate[strModelType];
                }
                else
                {
                    strTemplate = File.ReadAllText(strPath);
                    dic_remplate.Add(strModelType, strTemplate);
                }
                var property = typeof(T);
                foreach (var property_item in property.GetProperties())
                {
                    var property_value = property_item.GetValue(entity)?.ToString() ?? "";
                    if (property_item.Name == "Info1" && strModelType == "52")
                    {
                        //个人箱二维码处理
                        var strQrCode = CommonHelper.PhotoImageInsert(property_value);
                        strTemplate = strTemplate.Replace(property_item.Name, strQrCode);
                    }
                    //特体件标加警号
                    else if (property_item.Name == "Info3" && strModelType == "53")
                    {
                        var police_no = property.GetProperty("Info5")?.GetValue(entity)?.ToString() ?? "";
                        strTemplate = strTemplate.Replace(property_item.Name, string.IsNullOrEmpty(police_no) ? property_value : $"{property_value}（{police_no}）");
                    }
                    else if (property_item.Name == "Info1" && strModelType == "51")
                    {
                        var info_x = GetTitleMarginLeft(property_value);
                        strTemplate = strTemplate.Replace(property_item.Name, property_value);
                        strTemplate = strTemplate.Replace("InfoX", info_x.PadLeft(4, '0'));
                    }
                    else
                    {
                        //if (strModelType == "53" && property_item.Name == "Info6")
                        //{
                        //    strTemplate = strTemplate.Replace("Info6", GetPieceImageString());
                        //}
                        //if (strModelType == "51" && property_item.Name == "Info6")
                        //{
                        //    strTemplate = strTemplate.Replace("Info6", GetBoxImageString());
                        //}
                        strTemplate = strTemplate.Replace(property_item.Name, property_value);
                    }
                }
                return strTemplate;
            }
        }

        public static string GetPrintCmd<T>(T entity, string strModel)
        {
            return string.Empty;
        }

        /// <summary>
        /// 读当前标签的EPC信息
        /// </summary>
        public static string ReadTagTID()
        {
            string sCommand = string.Empty;//"{C|}"+ "{WF;T24,I2|}";

            if (Version == 1)//东芝打印机B-SX5T旧版本
            {
                sCommand += "{C|}{WF;T24,I1|}";
            }
            if (Version == 2)//东芝打印机B-EX4T1-G新版本
            {
                sCommand += "{C|}{WF;A000,T24,I4,U1|}";
            }

            return sCommand;
        }

        /// <summary>
        /// 读当前标签的EPC信息
        /// </summary>
        public static string ReadTagEpc()
        {
            return "{C|}{WF;T24,I2|}";
        }

        /// <summary>
        /// 写EPC信息,不使用碳带 {D0580,1000,0500|}{C|}{@003;+0000|}{XB00;0000,0000,r,T24,G2,V1,B01=" + epc + "|}{XS;I,0001,0002C5301|}
        /// </summary>
        /// <param name="epc"></param>
        public static string WriteTag(string epc)
        {
            string sCommand = "{D0580,1000,0500|}"
                            + "{C|}"
                            + "{@003;+0000|}"
                            + "{XB00;0000,0000,r,T24,G2,V1,B01=" + epc + "|}"
                            + "{XS;I,0001,0002C5301|}";

            return epc;
        }

        private static string GetTitleMarginLeft(string strValue)
        {
            var str_len = strValue.Length;
            var total_margin = TitleMaxWord - str_len;
            if (total_margin <= 0) { return "0"; }
            else
            {
                return $"{total_margin / 2 * TitleWordLen}";
            }
        }

        //private static string GetPieceImageString()
        //{
        //    if (string.IsNullOrEmpty(PieceImgString))
        //    {
        //        PieceImgString = CommonHelper.Image2String((Bitmap)Image.FromFile(AppDomain.CurrentDomain.BaseDirectory + "piece_logo.jpg"));
        //    }
        //    return PieceImgString;
        //}

        //private static string GetBoxImageString()
        //{
        //    if (string.IsNullOrEmpty(BoxImgString))
        //    {
        //        BoxImgString = CommonHelper.Image2String((Bitmap)Image.FromFile(AppDomain.CurrentDomain.BaseDirectory + "box_logo.jpg"));
        //    }
        //    return BoxImgString;
        //}

    }
}
