﻿using System;
using System.Collections.Generic;
using System.IO.Ports;
using System.Reflection;
using System.Text;
using System.Threading;

namespace JmpPrintService.ComSet
{
    class ComPrint
    {
        /// <summary>
        /// 停止位
        /// </summary>
        private System.IO.Ports.StopBits _stopBits = System.IO.Ports.StopBits.One;

        /// <summary>
        /// 检验位
        /// </summary>
        private System.IO.Ports.Parity _checkBits = System.IO.Ports.Parity.None;

        /// <summary>
        /// 流控制
        /// </summary>
        private System.IO.Ports.Handshake _flowControl = System.IO.Ports.Handshake.None;

        /// <summary>
        /// 波特率
        /// </summary>
        private int _baudRate = 115200;

        /// <summary>
        /// 数据位
        /// </summary>
        private int _dataBits = 8;

        /// <summary>
        /// 串口名称
        /// </summary>
        private string _portName = "COM1";

        public static int ReadFlag = 0;//读写标志
        public static bool RFIDFlag = false;
        public static int PrintFlag = 0;//打印标志
        public static Queue<string> PrintMsg = new Queue<string>();

        public static Queue<string> EpcMsg = new Queue<string>();
        private SerialPort serialPort = new SerialPort();
        private List<byte> buffer = new List<byte>(4096);//默认分配1页内存
        private StringBuilder builder = new StringBuilder();
        private List<PrintStatusModel> printModelList = new List<PrintStatusModel>();

        private PrintStatusModel printModel = new PrintStatusModel();
        public void SetComName(string comName)
        {
            _portName = comName;
        }
        public ComPrint()
        {
            this.serialPort.DataReceived += new SerialDataReceivedEventHandler(StartRead);
        }
        /// <summary>
        /// 设置读写标志
        /// </summary>
        public void SetReadFlag()
        {
            if (!serialPort.IsOpen)
            {
                ReadFlag = 1;
                serialPort.PortName = "COM1";
                serialPort.BaudRate = 115200;//
                serialPort.Parity = Parity.None;// Parity.None;
                serialPort.DataBits = 8;// 8;
                serialPort.StopBits = StopBits.One;// StopBits.One;
                serialPort.Handshake = Handshake.None;// Handshake.None;
                serialPort.RtsEnable = true;
            }
            
        }
        public void Init()
        {

        }
        /// <summary>
        ///开始读取打印数据
        /// </summary>
        public void StartRead(object sender, SerialDataReceivedEventArgs e)
        {
            try
            {

                Thread.Sleep(500);
                //int len = 10;//数据长度
                if (!serialPort.IsOpen) return;

                int len = serialPort.BytesToRead;//数据长度
                byte[] buf = new byte[len];//声明一个临时数组，存储当前来的串口数据
                                           //string msga= serialPort.ReadExisting();
                int PortResult = serialPort.Read(buf, 0, len);//读取缓冲数据
                bool data_1_catched = false;//缓存记录数据是否捕获到
                //builder.Remove(0, builder.Length);//清楚字符串构造器的内容
                builder.Clear();
                buffer.AddRange(buf);
                List<string> builderList = new List<string>();
                printModelList.Clear();
                #region //2.完整性判断

                while (buffer.Count >= 6) //至少要包含头尾 01 02   03 04 0D 0A
                {
                    #region //2.1 New查找数据头尾
                    if (buffer[0] == 0x01 && buffer[1] == 0x02)
                    {//找到头
                        for (int i = 2; i < buffer.Count - 3; i++)
                        {
                            if (buffer[i] == 0x03 && buffer[i + 1] == 0x04 && buffer[i + 2] == 0x0D && buffer[i + 3] == 0x0A)
                            {//找到尾
                                for (int j = 2; j < i; j++)
                                {
                                    builder.Append(buffer[j].ToString("X2"));
                                }

                                builderList.Add(builder.ToString());
                                builder.Clear();
                                //builder.Remove(0, builder.Length);
                                data_1_catched = true;
                                buffer.RemoveRange(0, i + 4);
                            }
                        }
                    }
                    else
                    {
                        buffer.RemoveAt(0);
                    }
                    #endregion

                }

                #endregion
                #region //3.分析数据
                if (data_1_catched)
                {
                    foreach (string sbuilder in builderList)
                    {
                        if (sbuilder.Length > 36)
                        {
                            EpcMsg.Enqueue(sbuilder);
                        }
                        printModel = new PrintStatusModel();
                        printModel.TagReadData = "";
                        printModel.SPortData = sbuilder.ToString();

                        #region sbuilder
                        string sStatus = sbuilder.ToString().Substring(0, 4);
                        string sStatusType = sbuilder.ToString().Substring(4, 2);
                        string sData = sbuilder.ToString().Substring(6);
                        string sReturnMsg = "";
                        bool IsError = false;

                        if (sbuilder.ToString().Substring(0, 1) == "3")
                        {
                            printModel.PrintStatus = sStatus.Substring(1, 1) + sStatus.Substring(3, 1);

                            #region Status
                            switch (printModel.PrintStatus)
                            {
                                case "00":
                                    {
                                        IsError = false;
                                        sReturnMsg = "ON LINE";
                                        break;
                                    }
                                case "01":
                                    {
                                        IsError = true;
                                        sReturnMsg = "打印头未关闭";
                                        break;
                                    }
                                case "02":
                                    {
                                        IsError = false;
                                        sReturnMsg = "ON LINE";
                                        break;
                                    }
                                case "04":
                                    {
                                        IsError = true;
                                        sReturnMsg = "PAUSE ****";
                                        break;
                                    }
                                case "05":
                                    {
                                        IsError = false;
                                        sReturnMsg = "ON LINE";
                                        break;
                                    }
                                case "06":
                                    {
                                        IsError = true;
                                        sReturnMsg = "指令错误";
                                        break;
                                    }
                                case "07":
                                    {
                                        IsError = true;
                                        sReturnMsg = "COMMS ERROR";
                                        break;
                                    }
                                case "11":
                                    {
                                        IsError = true;
                                        sReturnMsg = "打印机卡纸";
                                        break;
                                    }
                                case "12":
                                    {
                                        IsError = true;
                                        sReturnMsg = "CUTTER ERROR ****";
                                        break;
                                    }
                                case "13":
                                    {
                                        IsError = true;
                                        sReturnMsg = "打印机缺纸";
                                        break;
                                    }
                                case "14":
                                    {
                                        IsError = true;
                                        sReturnMsg = "打印机无碳带";
                                        break;
                                    }
                                case "15":
                                    {
                                        IsError = true;
                                        sReturnMsg = "打印头未关闭 ****";
                                        break;
                                    }
                                case "17":
                                    {
                                        IsError = true;
                                        sReturnMsg = "HEAD ERROR ****";
                                        break;
                                    }
                                case "18":
                                    {
                                        IsError = true;
                                        sReturnMsg = "EXCESS HEAD TEMP";
                                        break;
                                    }
                                case "21":
                                    {
                                        IsError = true;
                                        sReturnMsg = "打印机碳带异常 ****";
                                        break;
                                    }
                                case "22":
                                    {
                                        IsError = true;
                                        sReturnMsg = "REWIND FULL ****";
                                        break;
                                    }
                                case "40":
                                    {
                                        IsError = false;
                                        sReturnMsg = "ON LINE";
                                        break;
                                    }
                                case "41":
                                    {
                                        IsError = false;
                                        sReturnMsg = "ON LINE";
                                        break;
                                    }
                                case "50":
                                    {
                                        IsError = true;
                                        sReturnMsg = "FLASH WRITE ERR.";
                                        break;
                                    }
                                case "51":
                                    {
                                        IsError = true;
                                        sReturnMsg = "FORMAT ERROR";
                                        break;
                                    }
                                case "54":
                                    {
                                        IsError = true;
                                        sReturnMsg = "FLASH CARD FULL";
                                        break;
                                    }
                                case "60":
                                    {

                                        sReturnMsg = "  ";
                                        break;
                                    }
                                case "61":
                                    {
                                        IsError = true;
                                        sReturnMsg = "数据写入失败";
                                        break;
                                    }
                                case "62":
                                    {
                                        IsError = true;
                                        sReturnMsg = "RFID ERROR";
                                        break;
                                    }
                                case "63":
                                    {
                                        IsError = false;
                                        sReturnMsg = "Writing data succeeded";
                                        break;
                                    }
                                case "64":
                                    {
                                        IsError = true;
                                        sReturnMsg = "Writing data failed.";
                                        break;
                                    }

                                case "65":
                                    {
                                        IsError = true;
                                        sReturnMsg = "RFID CONFIG ERR";
                                        break;
                                    }
                            }
                            #endregion

                            #region Status Type
                            switch (sStatusType)
                            {
                                case "31":
                                    {
                                        sReturnMsg = "状态请求命令 : " + sReturnMsg;
                                        break;
                                    }
                                case "32":
                                    {
                                        sReturnMsg = "自动状态传输 : " + sReturnMsg;
                                        break;
                                    }
                                case "33":
                                    {
                                        sReturnMsg = "接收缓存可用空间状态请求 : " + sReturnMsg;
                                        break;
                                    }
                                case "34":
                                    {
                                        sReturnMsg = "RFID数据读取状态 : " + sReturnMsg;
                                        break;
                                    }
                                case "35":
                                    {
                                        sReturnMsg = "RFID数据写入状态 : " + sReturnMsg;
                                        break;
                                    }
                            }
                            #endregion
                        }
                        else if (sbuilder.ToString().Substring(0, 2) == "46")
                        {
                            switch (sbuilder.ToString().Substring(2, 4))
                            {
                                case "3030":
                                    {
                                        sReturnMsg = "RFID 读取失败";
                                        printModel.TagReadData = "";
                                        printModel.TagReadSuccess = false;
                                        break;
                                    }
                                case "3234":
                                    {
                                        sReturnMsg = "RFID 读取成功 : " + sData;
                                        printModel.TagReadData = sData;
                                        printModel.TagReadSuccess = true;
                                        break;
                                    }
                            }
                        }
                        #endregion

                        printModel.IsReceived = true;
                        printModel.IsError = IsError;
                        printModel.PrintStatusMsg = sReturnMsg;
                        printModel.PrintMsg = sReturnMsg;

                        printModelList.Add(printModel);
                        ComPrint.PrintMsg.Enqueue(printModel.PrintStatus);

                    }
                }
                #endregion


            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }

        }

        /// <summary>
        /// 打开Com口
        /// </summary>
        /// <param name="isSuccess"></param>
        /// <param name="msg"></param>
        public void OpenComm(out bool isSuccess, out String msg)
        {
            try
            {
                if (this.serialPort.IsOpen)
                {
                    this.serialPort.Close();
                }
                //设置参数打开串口信息
                this.serialPort.PortName = this._portName;
                //波特率
                this.serialPort.BaudRate = this._baudRate;
                //数据位
                this.serialPort.DataBits = this._dataBits;
                //停止位
                this.serialPort.StopBits = this._stopBits;
                //检验位
                this.serialPort.Parity = this._checkBits;
                //流控制
                this.serialPort.Handshake = this._flowControl;
                this.serialPort.ReadTimeout = 2000;
                this.serialPort.Open();
                if (this.serialPort.IsOpen)
                {
                    isSuccess = true;
                    msg = ("串口打开成功!");
                    ReadFlag = 1;
                }
                else
                {
                    isSuccess = false;
                    ReadFlag = 0;
                    msg = ("串口打开失败!");
                }
            }
            catch (Exception ex)
            {
                isSuccess = false;
                ReadFlag = 0;
                msg = ("请确保打印机连接正常.Error:" + ex.Message);
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }

        public void CloseComm(out bool isSuccess, out string msg)
        {
            try
            {
                isSuccess = false;
                msg = string.Empty;
                if (this.serialPort == null)
                {
                    msg = ("无对应的串口信息!");
                    isSuccess = false;
                }
                if (this.serialPort.IsOpen)
                {
                    this.serialPort.Close();
                    msg = ("串口关闭成功!");
                    isSuccess = true;
                }

            }
            catch (Exception ex)
            {
                isSuccess = false;
                msg = ("请联系管理员.Error:" + ex.Message);
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }

         
        public void SendCmd2Print(string sSendText, out bool isSuccess, out String msg)
        {
            try
            {
                if (this.serialPort == null)
                {
                    msg = ("无串口信息!");
                    isSuccess = false;
                    return;
                }
                if (!this.serialPort.IsOpen)
                {
                    msg = ("串口没有打开!");
                    isSuccess = false;
                    return;
                }

                byte[] temp = System.Text.ASCIIEncoding.Default.GetBytes(sSendText);
                Char[] temp2 = System.Text.Encoding.GetEncoding("GB18030").GetChars(temp);
                Byte[] data = System.Text.Encoding.GetEncoding("GB18030").GetBytes(temp2);
                this.serialPort.Write(data, 0, data.Length);
                msg = ("串口已打开!");
                isSuccess = true;

            }
            catch (Exception ex)
            {
                msg = ("btn_Send_Click.Error:" + ex.Message);
                isSuccess = false;
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }
        public class PrintStatusModel
        {
            private bool _IsError = false;
            /// <summary>
            /// 是否发生错误
            /// </summary>
            public bool IsError
            {
                get { return _IsError; }
                set { _IsError = value; }
            }

            private bool _IsSuccess = false;
            /// <summary>
            /// 是否成功通过验证
            /// </summary>
            public bool IsSuccess
            {
                get { return _IsSuccess; }
                set { _IsSuccess = value; }
            }

            private bool _IsReceived = false;
            /// <summary>
            /// 是否接收数据成功
            /// </summary>
            public bool IsReceived
            {
                get { return _IsReceived; }
                set { _IsReceived = value; }
            }

            private bool _TagReadSuccess = false;
            /// <summary>
            /// 标签读取是否成功
            /// </summary>
            public bool TagReadSuccess
            {
                get { return _TagReadSuccess; }
                set { _TagReadSuccess = value; }
            }
            private string _TagReadData = "";
            /// <summary>
            /// 标签读取的数据
            /// </summary>
            public string TagReadData
            {
                get { return _TagReadData; }
                set { _TagReadData = value; }
            }

            private string _PrintStatus = "00";
            /// <summary>
            /// 打印机状态
            /// </summary>
            public string PrintStatus
            {
                get { return _PrintStatus; }
                set { _PrintStatus = value; }
            }

            private string _PrintStatusMsg = "";
            /// <summary>
            /// 打印机状态注释
            /// </summary>
            public string PrintStatusMsg
            {
                get { return _PrintStatusMsg; }
                set { _PrintStatusMsg = value; }
            }
            private string _PrintMsg = "";
            /// <summary>
            /// 打印机反馈信息
            /// </summary>
            public string PrintMsg
            {
                get { return _PrintMsg; }
                set { _PrintMsg = value; }
            }
            private string _sPortData = "";
            /// <summary>
            /// 串口返回数据
            /// </summary>
            public string SPortData
            {
                get { return _sPortData; }
                set { _sPortData = value; }
            }
        }

    }
}
