﻿using JmpZbModel;
using JmpPrintService.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace JmpPrintService.Basic
{
    public class ToshibaPrinter : PrinterBase
    {
        private ConnectBase printer = default;
        private CmdAnalysis cmdAnalysis = new CmdAnalysis();
        public ToshibaPrinter()
        {
        }

        public override bool SendMsg(string strMsg)
        {
            if (IsWork)
            {
                return printer?.SendMsg(strMsg) ?? false;
            }
            else { return false; }
        }

        public override bool OnStart(ConnectType connectType = ConnectType.COM)
        {
            ConnectType = connectType;
            if (ConnectType == ConnectType.COM)
            {
                printer = new ComConnect(cmdAnalysis.ToshibaSerialportMsg);
            }
            if (ConnectType == ConnectType.USB)
            {
                printer = new UsbConnect(cmdAnalysis.ToshibaSerialportMsg);
            }

            IsWork = printer?.Connection() ?? false;
            return IsWork;
        }

        public override bool OnStop()
        {
            IsWork = false;
            return printer?.DisConnection() ?? false;
        }

        public override bool SendQueryMsg()
        {
            string strCmd = "{C|}" + "{WS|}";
            return printer?.SendMsg(strCmd) ?? false;
        }

        public override PrintState GetPrintState()
        {
            return cmdAnalysis.GetPrintState();
        }

        public override void SetPrintState(PrintState state)
        {
            cmdAnalysis.SetPrintState(state);
        }
    }
}
