﻿using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;
using JmpZbModel;
using JmpZbPrint.Model;
using JmpZbPrint.UsControl;
using MaterialDesignThemes.Wpf;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Threading;
using JmpZbPrint.Common;
using WebSocketSharp;

namespace JmpZbPrint.ViewModel
{
    public class TagBindViewModel : ViewModelBase
    {
        public TagBindViewModel()
        {
            OnQueryCommand = new RelayCommand(OnQuery);
            OnPageChangeCmd = new RelayCommand(OnPageChange);
            OnWindowLoadCmd = new RelayCommand(OnWindowLoad);
            OnInitialTagCmd = new RelayCommand<print_info>(OnInitialTag);
            OnBoxingCmd = new RelayCommand(OnBoxing);
        }

        #region filed
        private ObservableCollection<print_info> _printList = new ObservableCollection<print_info>();
        public ObservableCollection<print_info> BindTaskList
        {
            get { return _printList; }
            set
            {
                _printList = value;
                RaisePropertyChanged();
            }
        }
        public AutoResetEvent resetEvent = new AutoResetEvent(false);

        private string _equName;
        public string EquName
        {
            get { return _equName; }
            set
            {
                _equName = value;
                RaisePropertyChanged();
            }
        }
        private string _vendorName;
        public string VendorName
        {
            get { return _vendorName; }
            set
            {
                _vendorName = value;
                RaisePropertyChanged();
            }
        }
        private int _epcType;
        public int EpcType
        {
            get { return _epcType; }
            set
            {
                _epcType = value;
                RaisePropertyChanged();
            }
        }

        private string _message = "状态：初始化设备连接准备中";
        public string UiMessage
        {
            get { return _message; }
            set
            {
                _message = value;
                RaisePropertyChanged();
            }
        }

        private string _msgccolor = "Green";
        public string MsgColor
        {
            get { return _msgccolor; }
            set
            {
                _msgccolor = value;
                RaisePropertyChanged();
            }
        }

        private bool _bindButton = false;
        public bool BindButton
        {
            get { return _bindButton; }
            set
            {
                _bindButton = value;
                RaisePropertyChanged();
            }
        }
        private int _total = 0;
        public int TotalRecord
        {
            get { return _total; }
            set
            {
                _total = value;
                RaisePropertyChanged();
            }
        }
        private int _page = 0;
        public int PageIndex
        {
            get { return _page; }
            set
            {
                _page = value;
                RaisePropertyChanged();
            }
        }

        private int _pageTotal = 0;
        public int PageTotal
        {
            get { return _pageTotal; }
            set
            {
                _pageTotal = value;
                RaisePropertyChanged();
            }
        }

        private int _pageSize = 50;
        public int PageSize
        {
            get { return _pageSize; }
            set
            {
                _pageSize = value;
                RaisePropertyChanged();
            }
        }

        private bool _isSelectAll = false;
        public bool IsSelectAll
        {
            get { return _isSelectAll; }
            set
            {
                _isSelectAll = value;
                RaisePropertyChanged();
                SelectAll();
            }
        }
        #endregion

        #region cmd attr
        public RelayCommand OnWindowLoadCmd { get; set; }
        public RelayCommand OnQueryCommand { get; set; }
        public RelayCommand OnPageChangeCmd { get; set; }
        public RelayCommand OnGenTagCmd { get; set; }
        public RelayCommand<print_info> OnInitialTagCmd { get; set; }

        public RelayCommand OnBoxingCmd { get; set; }

        #endregion

        #region method

        private void OnBoxing()
        {
            var seled = BindTaskList.Where(t => t.IsSelected == true).ToList();
            if (seled.Count > 0)
            {
                if (seled.Any(x => x.LabelType == "箱标"))
                {
                    MessageBox.Show("禁止箱标装箱");
                    return;
                }

                var havePurchaseLabel = seled.Any(x => x.isUnboxingLabel == false);
                if (MessageBox.Show("确认装箱选中的记录？" + (havePurchaseLabel ? "存在采购件标，将直接录入主平台。" : ""), "确认装箱", MessageBoxButton.OKCancel, MessageBoxImage.Question) ==
                    MessageBoxResult.OK)
                {
                    //判断物资一致性
                    var info = seled.First();
                    if (seled.Any(x => x.productId != info.productId))
                    {
                        MessageBox.Show("物资类型不一致，无法装箱");
                        return;
                    }
                    if (seled.Any(x => x.sizeId != info.sizeId))
                    {
                        MessageBox.Show("物资型号不一致，无法装箱");
                        return;
                    }
                    if (seled.Any(x => x.supplierId != info.supplierId))
                    {
                        MessageBox.Show("供应商不一致，无法装箱");
                        return;
                    }
                    if (seled.Any(x => x.warehouseId != info.warehouseId))
                    {
                        MessageBox.Show("入库仓库不一致，无法装箱");
                        return;
                    }

                    //创建箱标epc
                    var boxRequest = new request_int_info()
                    {
                        labelType = "箱标",
                        equCode = info.productNo,
                        productTime = Convert.ToDateTime(info.productTime),
                        sizeCode = info.sizeCode,
                        oneBoxNum = seled.Count,
                        quantity = 1,
                        supplierCode = info.supplierCode,
                        warrantyCycle = Convert.ToInt32(info.warrantyCycle)
                    };
                    var boxRes = HttpHelper.GenerateIntTagEpc(boxRequest, out string boxMsg);
                    if (!boxRes.Item1)
                    {
                        MessageBox.Show($"[{info.productName}-{info.sizeName}] 箱标生成失败，原因：{boxMsg}", "提示", MessageBoxButton.OK, MessageBoxImage.Error);
                        return;
                    }
                    var xbEpc = boxRes.Item2.First().epc;

                    var res = HttpHelper.BoxingInventoryNormalVersion(xbEpc, seled, out string msg);
                    if (res)
                    {
                        var _batch_no = DateTime.Now.ToString("yyyyMMddHHmmssfff");

                        foreach (var obj in seled)
                        {
                            LiteDbHelper.DeleteByEpc(obj.epc);
                        }
                        //不添加箱标记录进litedb
                    }
                    else
                    {
                        MessageBox.Show(msg);
                    }
                    OnQuery();
                }
            }
        }

        private WaitDialog waitDialog = default;
        public void OnWindowLoad()
        {
            InitWs();
            OnQuery();
        }
        public void OnWindowClosing()
        {

        }
        private void OnQuery()
        {
            BindTaskList.Clear();
            PageIndex = 1;
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = HttpHelper.GetPrintList(EpcType, LabelType.初始化, PageIndex, VendorName, EquName);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            BindTaskList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                BindTaskList = new ObservableCollection<print_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }
        private void OnPageChange()
        {
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = HttpHelper.GetPrintList(EpcType, LabelType.初始化, PageIndex, VendorName, EquName);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            BindTaskList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                BindTaskList = new ObservableCollection<print_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }

        public void SelectAll()
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                foreach (var item in BindTaskList)
                {
                    item.IsSelected = _isSelectAll;
                }
                this.RaisePropertyChanged(() => BindTaskList);
            });
        }
        public override void Cleanup()
        {
            base.Cleanup();
            resetEvent.Set();
            cWsServiceToken?.Cancel();
            wsConn?.Close();
        }
        #endregion

        #region tcp method

        public CancellationTokenSource cWsServiceToken;
        public Task taskWsService;
        public WebSocket wsConn;
        private ManualResetEvent resetUhf = new ManualResetEvent(true);
        private string tmpEpc = "";
        public void InitWs()
        {
            if (taskWsService == null)
            {
                cWsServiceToken = new CancellationTokenSource();
                taskWsService = new Task(() =>
                 {
                     wsConn = new WebSocket("ws://127.0.0.1:8081");
                     while (!cWsServiceToken.IsCancellationRequested)
                     {
                         try
                         {
                             // 已连接的不处理
                             if (wsConn.IsAlive)
                             {
                             }
                             else
                             {
                                 // 接收数据
                                 wsConn.OnMessage += (sender, e) =>
                                      {
                                          ReciveWsMsg(e.Data);
                                      };
                                 // 服务关闭
                                 wsConn.OnClose += (sender, e) =>
                                      {
                                          UiMessage = $"状态：服务已断开，重连中";
                                          MsgColor = "Red";
                                          BindButton = false;
                                      };

                                 wsConn.OnOpen += (sender, e) =>
                                 {
                                     UiMessage = $"状态：正在查询设备状态";
                                     MsgColor = "Green";
                                     BindButton = true;
                                 };

                                 // 服务连接
                                 wsConn.Connect();
                             }

                         }
                         catch (System.Exception ex)
                         {
                             UiMessage = $"状态：初始化设备连接失败";
                             MsgColor = "Red";
                             BindButton = false;
                             Log.ErrorLog(ex.ToString(), this.GetType().Name);
                         }
                         if (resetEvent.WaitOne(3000)) { break; }
                     }

                 });
                taskWsService.Start();
            }
        }
        private void ReciveWsMsg(string msg)
        {
            var cmdInfo = JsonConvert.DeserializeObject<InitializeCmdInfo>(msg);
            switch (cmdInfo.CmdType)
            {
                case JmpUhfService.InitializeCmdType.Busy:
                    UiMessage = $"状态：设备正忙，请检查设备是否被占用";
                    MsgColor = "Red";
                    BindButton = false;
                    resetUhf.Set();
                    break;
                case JmpUhfService.InitializeCmdType.Initialize:
                    if (msg.Contains("成功"))
                    {
                        UiMessage = $"状态：数据绑定成功";
                        MsgColor = "Green";
                        resetUhf.Set();

                        BindButton = true;
                        //更新状态
                        UpdateEpcStateByEpc(cmdInfo.Content.Replace("成功", "").Replace(" ", ""), true);
                    }
                    else
                    {
                        BindButton = true;
                        UiMessage = $"状态：{cmdInfo.Content}";
                        MsgColor = "Red";
                        resetUhf.Set();
                    }
                    break;
                case JmpUhfService.InitializeCmdType.Linked:
                    UiMessage = $"状态：初始化设备已连接";
                    MsgColor = "Green";
                    resetUhf.Set();
                    BindButton = true;
                    break;
                case JmpUhfService.InitializeCmdType.ErrorMsg:
                    UiMessage = $"状态：{cmdInfo.Content}";
                    MsgColor = "Red";
                    resetUhf.Set();
                    BindButton = false;
                    break;
                case JmpUhfService.InitializeCmdType.ReadInventorySingle:
                    tmpEpc = cmdInfo.Content;
                    resetUhf.Set();
                    BindButton = false;
                    break;
                case JmpUhfService.InitializeCmdType.ReadInventorySingleError:
                    UiMessage = $"状态：{cmdInfo.Content}";
                    MsgColor = "Red";
                    resetUhf.Set();
                    BindButton = true;
                    break;
                default:
                    resetUhf.Set();
                    break;
            }

        }
        private void UpdateEpcStateByEpc(string epc, bool apply = false)
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                var item = BindTaskList.FirstOrDefault(t => t.epc.Contains(epc));
                if (item != null)
                {
                    item.state = 1;
                    Tuple<bool, string> flagData = new Tuple<bool, string>(true, "");
                    if (apply)
                    {
                        if (item.isUnboxingLabel)
                        {
                            var res = HttpHelper.GenerateInventory(new recode_info
                            {
                                sizeId = item.sizeId,
                                equId = item.productId,
                                epc = item.epc,
                                supplierId = item.supplierId,
                                warehouseId = item.warehouseId,
                                productTime = Convert.ToDateTime(item.productTime),
                                useTime = Convert.ToDateTime(item.useTime),
                                warrantyCycle = Convert.ToInt32(item.warrantyCycle),
                                price = Convert.ToSingle(item.price),
                                repairCycle = Convert.ToInt32(item.repairCycle),
                                IsUnboxingLabel = item.isUnboxingLabel
                            }, out string msg);
                            flagData = new Tuple<bool, string>(res, msg);
                        }
                        else
                        {
                            flagData = HttpHelper.UpdateEpc(item.id);
                        }
                    }
                    if (flagData.Item1)
                    {
                        BindTaskList.Remove(item);
                        LiteDbHelper.DeleteByEpc(item.epc);
                        RaisePropertyChanged(() => BindTaskList);
                        TotalRecord -= 1;

                        if (BindTaskList.Count == 0)
                        {
                            PageIndex = 1;
                            OnPageChange();
                        }

                    }
                    else
                    {
                        //EPC状态更新失败
                        UiMessage = flagData.Item2;
                        MsgColor = "Red";
                    }
                }
            });
        }
        public async void OnInitialTag(print_info entity)
        {
            try
            {
                BindButton = false;
                UiMessage = "状态：绑定中";
                MsgColor = "Green";

                await Dispatcher.Yield();
                if (ReadInventorySingle())
                {
                    resetUhf.Reset();
                    resetUhf.WaitOne(3000);

                    //判断epc是否已被绑过装备
                    if (!string.IsNullOrEmpty(tmpEpc))
                    {
                        if (HttpHelper.CheckEpcIsInstantiation(tmpEpc, out string msg))
                        {
                            if (SendInitialMsg(entity.epc))
                            {
                                resetUhf.Reset();
                                resetUhf.WaitOne(3000);
                            }
                        }
                        else
                        {
                            BindButton = true;
                            UiMessage = "状态：绑定失败，" + msg;
                            MsgColor = "Red";
                        }
                        tmpEpc = "";
                    }
                }
                else
                {
                    BindButton = true;
                    UiMessage = "状态：绑定失败，设备异常";
                    MsgColor = "Red";
                }
            }
            catch (Exception ex)
            {
                BindButton = true;
                tmpEpc = "";
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }

        private bool ReadInventorySingle()
        {
            try
            {
                var json = JsonConvert.SerializeObject(new
                {
                    CmdType = 7,
                    Content = ""
                });

                if (wsConn?.IsAlive ?? false)
                {
                    wsConn.Send(json);
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
                return false;
            }
        }
        private bool SendInitialMsg(string epc, ushort len = 17, ushort offset = 1, string password = "00000000")
        {
            try
            {
                var epc_data = JsonConvert.SerializeObject(new
                {
                    Epc = epc,
                    Len = len,
                    Offset = offset,
                    Password = password
                });
                var json = JsonConvert.SerializeObject(new
                {
                    CmdType = 8,
                    Content = epc_data
                });

                if (wsConn?.IsAlive ?? false)
                {
                    wsConn.Send(json);
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
                return false;
            }
        }
        #endregion
    }

}
