﻿using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;
using JmpZbPrint.Model;
using JmpZbPrint.PagePartial;
using JmpZbPrint.UsControl;
using MaterialDesignThemes.Wpf;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Threading;

namespace JmpZbPrint.ViewModel
{
    public class PrintLogWindowViewModel : ViewModelBase
    {
        public PrintLogWindowViewModel()
        {
            OnQueryCommand = new RelayCommand(OnQuery);
            OnPageChangeCmd = new RelayCommand(OnPageChange);
            OnWindowLoadCmd = new RelayCommand(OnWindowLoad);
        }

        #region filed
        private List<PrintLog> PrintInfoDataList = new List<PrintLog>();
        private ObservableCollection<PrintLog> _printInfoList = new ObservableCollection<PrintLog>();
        public ObservableCollection<PrintLog> UiPrintInfoList
        {
            get { return _printInfoList; }
            set
            {
                //PageTotal = GetPageTotal(value.Where(t => t.Status == "未打印").Count());
                //TotalRecord = value.Count;

                _printInfoList = value;
                RaisePropertyChanged();

            }
        }

        private WaitDialog waitDialog = default;

        private int _total = 0;
        public int TotalRecord
        {
            get { return _total; }
            set
            {
                _total = value;
                RaisePropertyChanged();
            }
        }
        private int _page = 0;
        public int PageIndex
        {
            get { return _page; }
            set
            {
                _page = value;
                RaisePropertyChanged();
            }
        }

        private int _pageTotal = 0;
        public int PageTotal
        {
            get { return _pageTotal; }
            set
            {
                _pageTotal = value;
                RaisePropertyChanged();
            }
        }

        private int _pageSize = 20;
        public int PageSize
        {
            get { return _pageSize; }
            set
            {
                _pageSize = value;
                RaisePropertyChanged();
            }
        }

        private int _saveLogCount = 1000;
        #endregion

        #region cmd attr
        public RelayCommand OnWindowLoadCmd { get; set; }
        public RelayCommand OnQueryCommand { get; set; }
        public RelayCommand OnPageChangeCmd { get; set; }
        #endregion

        #region method
        public void OnWindowLoad()
        {
            PrintInfoDataList = new List<PrintLog>();
            if (System.IO.File.Exists(AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "PrintLog.json"))
            {
                var arr = System.IO.File.ReadAllLines(AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "PrintLog.json", Encoding.UTF8);
                var count = 0;
                for (int i = arr.Length - 1; i >= 0; i--)
                {
                    string str = arr[i];
                    if (string.IsNullOrEmpty(str))
                    {
                        continue;
                    }
                    count++;
                    if (count > _saveLogCount)
                    {
                        //处理日志文件
                        System.IO.File.WriteAllLines(AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "PrintLog.json", arr.Skip(arr.Length - _saveLogCount), Encoding.UTF8);
                        break;
                    }
                    try
                    {
                        PrintInfoDataList.Add(JsonConvert.DeserializeObject<PrintLog>(str));
                    }
                    catch (Exception)
                    {
                        //转换错误，过滤
                        continue;
                    }
                    
                }
            }

            OnQuery();
        }
        public void OnWindowClosing()
        {

        }
        private void OnQuery()
        {
            PageIndex = 1;
            UiPrintInfoList.Clear();

            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "PrintLogDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        
                        var tmp = PrintInfoDataList;
                        TotalRecord = tmp?.Count ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            UiPrintInfoList?.Clear();
                            if (tmp != null && tmp.Count > 0)
                            {
                                UiPrintInfoList = new ObservableCollection<PrintLog>(PrintInfoDataList.Skip((PageIndex - 1) * PageSize).Take(PageSize));
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }
        private void OnPageChange()
        {
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "PrintLogDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        
                        var tmp = PrintInfoDataList;
                        TotalRecord = tmp?.Count ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            UiPrintInfoList?.Clear();
                            if (tmp != null && tmp.Count > 0)
                            {
                                UiPrintInfoList = new ObservableCollection<PrintLog>(PrintInfoDataList.Skip((PageIndex - 1) * PageSize).Take(PageSize));
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }


        #endregion
    }

}
