﻿using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;
using JmpZbModel;
using JmpZbPrint.Common;
using JmpZbPrint.Model;
using JmpZbPrint.PagePartial;
using JmpZbPrint.UsControl;
using MaterialDesignThemes.Wpf;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Threading;
using WebSocketSharp;

namespace JmpZbPrint.ViewModel
{
    public class IntBindViewModel : ViewModelBase
    {
        public IntBindViewModel()
        {
            OnGenCommand = new RelayCommand(OnGenBind);
            OnQueryCommand = new RelayCommand(OnQuery);
            OnPageChangeCmd = new RelayCommand(OnPageChange);
            OnWindowLoadCmd = new RelayCommand(OnWindowLoad);
            OnInitialTagCmd = new RelayCommand<recode_info>(OnInitialTag);
            OnDeleteTagCmd = new RelayCommand(OnDeleteTag);
            OnBoxingCmd = new RelayCommand(OnBoxing);
        }

        #region command
        public RelayCommand OnWindowLoadCmd { get; set; }
        public RelayCommand OnGenCommand { get; set; }
        public RelayCommand OnQueryCommand { get; set; }
        public RelayCommand OnGridLoadedCmd { get; set; }
        public RelayCommand<recode_info> OnInitialTagCmd { get; set; }
        public RelayCommand OnDeleteTagCmd { get; set; }
        public RelayCommand OnPageChangeCmd { get; set; }
        public RelayCommand OnBoxingCmd { get; set; }
        #endregion

        #region filed
        private ObservableCollection<recode_info> _printList = new ObservableCollection<recode_info>();
        public ObservableCollection<recode_info> BindTaskList
        {
            get { return _printList; }
            set
            {
                _printList = value;
                RaisePropertyChanged();
            }
        }
        public AutoResetEvent resetEvent = new AutoResetEvent(false);

        private string _equName;
        public string EquName
        {
            get { return _equName; }
            set
            {
                _equName = value;
                RaisePropertyChanged();
            }
        }
        private string _vendorName;
        public string VendorName
        {
            get { return _vendorName; }
            set
            {
                _vendorName = value;
                RaisePropertyChanged();
            }
        }
        private string _message = "状态：初始化设备连接准备中";
        public string UiMessage
        {
            get { return _message; }
            set
            {
                _message = value;
                RaisePropertyChanged();
            }
        }

        private string _msgccolor = "Green";
        public string MsgColor
        {
            get { return _msgccolor; }
            set
            {
                _msgccolor = value;
                RaisePropertyChanged();
            }
        }

        private bool _bindButton = false;
        public bool BindButton
        {
            get { return _bindButton; }
            set
            {
                _bindButton = value;
                RaisePropertyChanged();
            }
        }
        private int _total = 0;
        public int TotalRecord
        {
            get { return _total; }
            set
            {
                _total = value;
                RaisePropertyChanged();
            }
        }
        private int _page = 0;
        public int PageIndex
        {
            get { return _page; }
            set
            {
                _page = value;
                RaisePropertyChanged();
            }
        }

        private int _pageTotal = 0;
        public int PageTotal
        {
            get { return _pageTotal; }
            set
            {
                _pageTotal = value;
                RaisePropertyChanged();
            }
        }

        private int _pageSize = 50;
        public int PageSize
        {
            get { return _pageSize; }
            set
            {
                _pageSize = value;
                RaisePropertyChanged();
            }
        }
        private bool _isSelectAll = false;
        public bool IsSelectAll
        {
            get { return _isSelectAll; }
            set
            {
                _isSelectAll = value;
                RaisePropertyChanged();
                SelectAll();
            }
        }
        #endregion

        #region attr
        #endregion

        #region method

        /// <summary>
        /// 装箱
        /// </summary>
        private void OnBoxing()
        {
            var seled = BindTaskList.Where(t => t.IsSelected == true).ToList();
            if (seled.Count > 0)
            {
                if (MessageBox.Show("确认装箱选中的记录？", "确认装箱", MessageBoxButton.OKCancel, MessageBoxImage.Question) ==
                    MessageBoxResult.OK)
                {
                    //判断物资一致性
                    var info = seled.First();
                    if (seled.Any(x => x.equId != info.equId))
                    {
                        MessageBox.Show("物资类型不一致，无法装箱");
                        return;
                    }
                    if (seled.Any(x => x.sizeId != info.sizeId))
                    {
                        MessageBox.Show("物资型号不一致，无法装箱");
                        return;
                    }
                    if (seled.Any(x => x.supplierId != info.supplierId))
                    {
                        MessageBox.Show("供应商不一致，无法装箱");
                        return;
                    }
                    if (seled.Any(x => x.warehouseId != info.warehouseId))
                    {
                        MessageBox.Show("入库仓库不一致，无法装箱");
                        return;
                    }

                    //创建箱标epc
                    var boxRequest = new request_int_info()
                    {
                        labelType = "箱标",
                        equCode = info.equCode,
                        productTime = info.productTime,
                        sizeCode = info.sizeCode,
                        oneBoxNum = seled.Count,
                        quantity = 1,
                        supplierCode = info.suppilerCode,
                        warrantyCycle = info.warrantyCycle
                    };
                    var boxRes = HttpHelper.GenerateIntTagEpc(boxRequest, out string boxMsg);
                    if (!boxRes.Item1)
                    {
                        MessageBox.Show($"[{info.equName}-{info.sizeName}] 箱标生成失败，原因：{boxMsg}", "提示", MessageBoxButton.OK, MessageBoxImage.Error);
                        return;
                    }
                    var xbEpc = boxRes.Item2.First().epc;

                    var res = HttpHelper.BoxingInventory(xbEpc, seled, out string msg);
                    if (res)
                    {
                        var _batch_no = DateTime.Now.ToString("yyyyMMddHHmmssfff");

                        foreach (var obj in seled)
                        {
                            LiteDbHelper.Delete(obj.id);
                        }

                        LiteDbHelper.AddRange(new List<recode_info>()
                    {
                        new recode_info()
                        {
                            LabelType = "箱标",
                            orgId = info.orgId,
                            batchNo = _batch_no,
                            epc = xbEpc,
                            num = 1,
                            equCode = info.equCode,
                            equId = info.equId,
                            sizeCode = info.sizeCode,
                            equName = info.equName,
                            isdelete = false,
                            oneBoxNum = seled.Count,
                            needNum = 1,
                            price = info.price,
                            productTime = info.productTime,
                            repairCycle = info.repairCycle,
                            sizeId = info.sizeId,
                            sizeName = info.sizeName,
                            suppilerCode = info.suppilerCode,
                            supplierId = info.supplierId,
                            suppilerName = info.suppilerName,
                            type = 0, //打印
                            useTime = info.useTime,
                            warehouseId = info.warehouseId,
                            warehouseName = info.warehouseName,
                            warrantyCycle = info.warrantyCycle,
                            createTime = DateTime.Now,
                            IsReloadBoxing = true,
                            epcListJson = JsonConvert.SerializeObject(seled.Select(x => x.epc))
                        }
                    });
                    }
                    else
                    {
                        MessageBox.Show(msg);
                    }
                    OnQuery();
                }
            }
        }

        private void OnRefreshGridSrc()
        {
            OnQuery();
        }
        private WaitDialog waitDialog = default;
        public void OnGenBind()
        {
            var gen = new IntGenEpcWindow(1);
            gen.OnRefreshGrid += OnRefreshGridSrc;
            gen.ShowDialog();
        }
        public void OnWindowLoad()
        {
            InitWs();
            OnQuery();
        }
        public void OnWindowClosing()
        {

        }
        private void OnQuery()
        {
            IsSelectAll = false;
            BindTaskList.Clear();
            PageIndex = 1;
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = LiteDbHelper.GetPage(PageIndex, PageSize, t => t.isdelete == false
                         && t.type == 1
                         && (string.IsNullOrEmpty(EquName) || t.equName.Contains(EquName))
                         && (string.IsNullOrEmpty(VendorName) || t.suppilerName.Contains(VendorName))
                         && t.orgId == CaChe.UserInfo.baseJpOrganization.id);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            BindTaskList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                BindTaskList = new ObservableCollection<recode_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }
        private void OnPageChange()
        {
            IsSelectAll = false;
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = LiteDbHelper.GetPage(PageIndex, PageSize, t => t.isdelete == false
                         && t.type == 1
                         && (string.IsNullOrEmpty(EquName) || t.equName.Contains(EquName))
                         && (string.IsNullOrEmpty(VendorName) || t.suppilerName.Contains(VendorName))
                         && t.orgId == CaChe.UserInfo.baseJpOrganization.id);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            BindTaskList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                BindTaskList = new ObservableCollection<recode_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }
        public override void Cleanup()
        {
            base.Cleanup();
            resetEvent.Set();
            cWsServiceToken?.Cancel();
            wsConn?.Close();
        }
        public void SelectAll()
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                foreach (var item in BindTaskList)
                {
                    item.IsSelected = _isSelectAll;
                }
                this.RaisePropertyChanged(() => BindTaskList);
            });
        }

        private void OnDeleteTag()
        {
            var seled = BindTaskList.Where(t => t.IsSelected == true).ToList();
            if (seled.Count() > 0)
            {
                if (MessageBox.Show("确认删除选中的条记录？", "确认删除", MessageBoxButton.OKCancel, MessageBoxImage.Question) == MessageBoxResult.OK)
                {
                    seled.ForEach(s =>
                    {
                        if (s.IsUnboxingLabel)
                        {
                            //拆箱生成标签直接报废记录
                            if (!HttpHelper.DeleteEpc(s.epc, out string msg))
                            {
                                MessageBox.Show(msg);
                            }
                        }
                        LiteDbHelper.Delete(s.id);
                        BindTaskList.Remove(s);
                    });

                    if (BindTaskList.Count == 0)
                    {
                        OnQuery();
                    }
                    IsSelectAll = false;
                }
            }
        }
        #endregion

        #region ws server
        public CancellationTokenSource cWsServiceToken;
        public Task taskWsService;
        public WebSocket wsConn;
        private ManualResetEvent resetUhf = new ManualResetEvent(true);
        private string tmpEpc = "";
        public void InitWs()
        {
            if (taskWsService == null)
            {
                cWsServiceToken = new CancellationTokenSource();
                taskWsService = new Task(() =>
                {
                    wsConn = new WebSocket("ws://127.0.0.1:8081");
                    while (!cWsServiceToken.IsCancellationRequested)
                    {
                        try
                        {
                            // 已连接的不处理
                            if (wsConn.IsAlive)
                            {
                            }
                            else
                            {
                                // 接收数据
                                wsConn.OnMessage += (sender, e) =>
                                {
                                    ReciveWsMsg(e.Data);
                                };
                                // 服务关闭
                                wsConn.OnClose += (sender, e) =>
                                {
                                    UiMessage = $"状态：服务已断开，重连中";
                                    MsgColor = "Red";
                                    BindButton = false;
                                };

                                wsConn.OnOpen += (sender, e) =>
                                {
                                    UiMessage = $"状态：正在查询设备状态";
                                    MsgColor = "Green";
                                    BindButton = true;
                                };

                                // 服务连接
                                wsConn.Connect();
                            }

                        }
                        catch (System.Exception ex)
                        {
                            UiMessage = $"状态：初始化设备连接失败";
                            MsgColor = "Red";
                            BindButton = false;
                            Log.ErrorLog(ex.ToString(), this.GetType().Name);
                        }
                        if (resetEvent.WaitOne(3000)) { break; }
                    }

                });
                taskWsService.Start();
            }
        }
        private void ReciveWsMsg(string msg)
        {
            var cmdInfo = JsonConvert.DeserializeObject<InitializeCmdInfo>(msg);
            switch (cmdInfo.CmdType)
            {
                case JmpUhfService.InitializeCmdType.Busy:
                    UiMessage = $"状态：设备正忙，请检查设备是否被占用";
                    MsgColor = "Red";
                    BindButton = false;
                    resetUhf.Set();
                    break;
                case JmpUhfService.InitializeCmdType.Initialize:
                    if (msg.Contains("成功"))
                    {
                        UiMessage = $"状态：数据绑定成功";
                        MsgColor = "Green";
                        resetUhf.Set();

                        BindButton = true;
                        //更新状态
                        UpdateEpcStateByEpc(cmdInfo.Content.Replace("成功", "").Replace(" ", ""), true);
                    }
                    else
                    {
                        BindButton = true;
                        UiMessage = $"状态：{cmdInfo.Content}";
                        MsgColor = "Red";
                        resetUhf.Set();
                    }
                    break;
                case JmpUhfService.InitializeCmdType.Linked:
                    UiMessage = $"状态：初始化设备已连接";
                    MsgColor = "Green";
                    resetUhf.Set();
                    BindButton = true;
                    break;
                case JmpUhfService.InitializeCmdType.ErrorMsg:
                    UiMessage = $"状态：{cmdInfo.Content}";
                    MsgColor = "Red";
                    resetUhf.Set();
                    BindButton = false;
                    break;
                case JmpUhfService.InitializeCmdType.ReadInventorySingle:
                    tmpEpc = cmdInfo.Content;
                    resetUhf.Set();
                    BindButton = false;
                    break;
                case JmpUhfService.InitializeCmdType.ReadInventorySingleError:
                    UiMessage = $"状态：{cmdInfo.Content}";
                    MsgColor = "Red";
                    resetUhf.Set();
                    BindButton = true;
                    break;
                default:
                    resetUhf.Set();
                    break;
            }

        }
        private void UpdateEpcStateByEpc(string epc, bool apply = false)
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                var item = BindTaskList.FirstOrDefault(t => t.epc.Contains(epc));
                if (item != null)
                {
                    item.isdelete = true;
                    var flag = true;
                    if (apply)
                    {
                        var res = HttpHelper.GenerateInventory(item, out string msg);
                        if (!res)
                        {
                            MsgColor = "Red";
                            UiMessage = "状态：写入入库记录失败:" + msg;
                            flag = false;
                        }
                        else
                        {
                            flag = LiteDbHelper.Update(epc);
                        }
                    }
                    if (flag)
                    {
                        BindTaskList.Remove(item);
                        RaisePropertyChanged(() => BindTaskList);
                        TotalRecord -= 1;

                        if (BindTaskList.Count == 0)
                        {
                            PageIndex = 1;
                            OnPageChange();
                        }

                    }
                }
            });
        }
        public async void OnInitialTag(recode_info entity)
        {
            try
            {
                BindButton = false;
                UiMessage = "状态：绑定中";
                MsgColor = "Green";

                await Dispatcher.Yield();
                if (ReadInventorySingle())
                {
                    resetUhf.Reset();
                    resetUhf.WaitOne(3000);

                    //判断epc是否已被绑过装备
                    if (!string.IsNullOrEmpty(tmpEpc))
                    {
                        if (HttpHelper.CheckEpcIsInstantiation(tmpEpc, out string msg))
                        {
                            if (SendInitialMsg(entity.epc))
                            {
                                resetUhf.Reset();
                                resetUhf.WaitOne(3000);
                            }
                        }
                        else
                        {
                            BindButton = true;
                            UiMessage = "状态：绑定失败，" + msg;
                            MsgColor = "Red";
                        }
                        tmpEpc = "";
                    }
                }
                else
                {
                    BindButton = true;
                    UiMessage = "状态：绑定失败，设备异常";
                    MsgColor = "Red";
                }
            }
            catch (Exception ex)
            {
                BindButton = true;
                tmpEpc = "";
                Log.ErrorLog(ex.ToString());
            }
        }
        private bool ReadInventorySingle()
        {
            try
            {
                var json = JsonConvert.SerializeObject(new
                {
                    CmdType = 7,
                    Content = ""
                });

                if (wsConn?.IsAlive ?? false)
                {
                    wsConn.Send(json);
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
                return false;
            }
        }
        private bool SendInitialMsg(string epc, ushort len = 17, ushort offset = 1, string password = "00000000")
        {
            try
            {
                var epc_data = JsonConvert.SerializeObject(new
                {
                    Epc = epc,
                    Len = len,
                    Offset = offset,
                    Password = password
                });
                var json = JsonConvert.SerializeObject(new
                {
                    CmdType = 8,
                    Content = epc_data
                });

                if (wsConn?.IsAlive ?? false)
                {
                    wsConn.Send(json);
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString());
                return false;
            }
        }

        #endregion
    }
}
