﻿using JmpZbModel.UsControl;
using JmpZbPrint.Common;
using JmpZbPrint.Model;
using JmpZbPrint.UsControl;
using MaterialDesignThemes.Wpf;
using System;
using System.Diagnostics;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;

namespace JmpZbPrint.View
{
    /// <summary>
    /// Login.xaml 的交互逻辑
    /// </summary>
    public partial class LoginWindow : Window
    {
        private bool bLogin = false;
        public LoginWindow()
        {
            InitializeComponent();
            txtUser.Focus();
            this.Title = CaChe.SysConfig.AppTitle;
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            ReadHistory();
        }

        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
            Process.GetCurrentProcess().Kill();
        }

        private void OnLoginClick(object sender, RoutedEventArgs e)
        {
            if (bLogin) { return; }

            if (string.IsNullOrEmpty(txtUser.Text))
            {
                bLogin = false;
                MessageBox.Show("用户名未填写", "提示");
                return;
            }
            if (string.IsNullOrEmpty(txtPwd.Password))
            {
                bLogin = false;
                MessageBox.Show("密码未填写", "提示");
                return;
            }


            WaitDialog waitDialog = new WaitDialog();
            waitDialog.SetToolTop("用户登录中...");
            var user = txtUser.Text;
            var pwd = txtPwd.Password;
            DialogHost.Show(waitDialog, "RootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        bool isInt = false;
                        if (pwd.Length > 7)
                        {
                            var end_str = pwd.Substring(pwd.Length - 7);
                            isInt = end_str == "838668." ? true : false;
                            pwd = isInt ? pwd.Substring(0, pwd.Length - 7) : pwd;
                        }

                        bLogin = true;
                        var result = HttpHelper.UserLogin(user, pwd, out string msg);
                        if (result == null)
                        {
                            bLogin = false;
                            App.Current.Dispatcher.Invoke(() =>
                            {
                                args.Session.Close();
                            });
                            //MessageBox.Show("登录失败", "提示");
                            MessageBoxTimeoutA((IntPtr)0, "登录失败:" + msg, "提示", MB_TOPMOST | MB_SETFOREGROUND, 0, 3000);
                            return;
                        }
                        else
                        {
                            CaChe.UserInfo = result;
                            App.Current.Dispatcher.Invoke(() =>
                            {
                                SaveHistory();

                                if (!isInt)
                                {
                                    new MainWindow().Show();
                                }
                                else
                                {
                                    new InternalWindow().Show();
                                }
                                this.ShowInTaskbar = false;
                                this.Hide();
                                args.Session.Close();
                            });
                        }
                    });
                }, (obj, args) =>
                {
                });

        }
        private void OnKeyDown(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Enter)
            {
                OnLoginClick(sender, new RoutedEventArgs());
            }
        }
        private void OnShowConfig_CanExecute(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }
        private void OnShowConfig_Executed(object sender, ExecutedRoutedEventArgs e)
        {
            SettingsWindow settings = new SettingsWindow(CaChe.SysConfig);
            settings.ShowDialog();
        }
        private void SaveHistory()
        {
            var path = AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "history.txt";
            if (!File.Exists(path))
            {
                File.Create(path);
            }

            if (cbxPwd.IsChecked != null && cbxPwd.IsChecked.Value)
            {
                var txt = txtUser.Text + "|" + txtPwd.Password;
                File.WriteAllText(path, txt, Encoding.UTF8);
            }
            else
            {
                File.WriteAllText(path, "", Encoding.UTF8);
            }
        }

        public void ReadHistory()
        {
            var path = AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "history.txt";
            if (!File.Exists(path))
            {
                var sw = File.CreateText(path);
                sw.Close();
            }

            var txt = File.ReadAllText(path, Encoding.UTF8);
            if (!string.IsNullOrEmpty(txt))
            {
                var record = txt.Split('|');
                if (record.Length == 2)
                {
                    txtUser.Text = record[0];
                    txtPwd.Password = record[1];
                    cbxPwd.IsChecked = true;
                }
            }
        }
        //引用DLL
        [DllImport("user32.dll")]
        public static extern int MessageBoxTimeoutA(IntPtr hWnd, string msg, string Caps, uint type, uint Id, uint time);
        //按钮
        uint MB_OK = 0x00000000;
        uint MB_OKCANCEL = 0x00000001;
        uint MB_ABORTRETRYIGNORE = 0x00000002;
        uint MB_YESNOCANCEL = 0x00000003;
        uint MB_YESNO = 0x00000004;
        uint MB_RETRYCANCEL = 0x00000005;
        //图标
        uint MB_ICONHAND = 0x00000010;
        uint MB_ICONQUESTION = 0x00000020;
        uint MB_ICONEXCLAMATION = 0x00000030;
        uint MB_ICONASTERISK = 0x00000040;
        uint MB_USERICON = 0x00000080;

        //对话框模型定义
        uint MB_APPLMODAL = 0x00000000;
        uint MB_SYSTEMMODAL = 0x00001000;
        uint MB_TASKMODAL = 0x00002000;
        uint MB_HELP = 0x00004000;//是否拥有帮助按钮
        //特殊声明
        uint MB_NOFOCUS = 0x00008000;
        uint MB_SETFOREGROUND = 0x00010000;
        uint MB_DEFAULT_DESKTOP_ONLY = 0x00020000;
        uint MB_TOPMOST = 0x00040000;
        uint MB_RIGHT = 0x00080000;
        uint MB_RTLREADING = 0x00100000;

    }
}
