﻿using JmpZbPrint.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace JmpZbPrint.Dialog
{
    /// <summary>
    /// SupplierWin.xaml 的交互逻辑
    /// </summary>
    public partial class SupplierWindow : Window
    {
        public Supplier Supplier { get; set; }
        public List<Supplier> SupplierList { get; set; }
        public SupplierWindow()
        {
            InitializeComponent();
            SupplierList = HttpHelper.GetAllSupplier(); 
            g_vender.ItemsSource = SupplierList?.Take(30);
            txt_vendor.Focus();
        }
        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
        }

        private void OnQueryClick(object sender, RoutedEventArgs e)
        {
            if (string.IsNullOrEmpty(txt_vendor.Text))
            {
                g_vender.ItemsSource = SupplierList;
            }
            else
            {
                g_vender.ItemsSource = SupplierList?.Where(t=>t.name.Contains(txt_vendor.Text));
            }
        }

        private void OnSelectItemClick(object sender, RoutedEventArgs e)
        {
            Supplier = g_vender.SelectedValue as Supplier;
            this.Close();
        }
    }
}
