﻿using JmpZbPrint.Model;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;
using JmpZbModel;
using JmpZbPrint.Common;
using Newtonsoft.Json;
using WebSocketSharp;

namespace JmpZbPrint.Dialog
{
    /// <summary>
    /// SupplierWin.xaml 的交互逻辑
    /// </summary>
    public partial class SelectBoxEpc : Window
    {
        private class UiMessageData : INotifyPropertyChanged
        {
            private string _UiMessage = "状态：初始化设备连接准备中";
            private string _MsgColor = "Green";
            private bool _BindButton = false;
            private Visibility _Visibility = Visibility.Collapsed;

            public string UiMessage
            {
                get => _UiMessage;
                set
                {
                    _UiMessage = value;
                    OnPropertyChanged("UiMessage");
                }
            }

            public string MsgColor
            {
                get => _MsgColor;
                set
                {
                    _MsgColor = value;
                    OnPropertyChanged("MsgColor");
                }
            }
            public bool BindButton
            {
                get => _BindButton;
                set
                {
                    _BindButton = value;
                    OnPropertyChanged("BindButton");
                }
            }
            public Visibility Visibility
            {
                get => _Visibility;
                set
                {
                    _Visibility = value;
                    OnPropertyChanged("Visibility");
                }
            }

            public event PropertyChangedEventHandler PropertyChanged;
            private void OnPropertyChanged(string strPropertyInfo)
            {
                if (PropertyChanged != null)
                {
                    PropertyChanged(this, new PropertyChangedEventArgs(strPropertyInfo));
                }
            }
        }

        private UiMessageData uiMessageData = new UiMessageData();

        private AutoResetEvent resetEvent = new AutoResetEvent(false);

        public List<respone_boxMark> infoList { get; set; } = new List<respone_boxMark>();

        public SelectBoxEpc(bool isInternal = false)
        {
            InitializeComponent();
            uiMessageData.Visibility = isInternal ? Visibility.Visible : Visibility.Collapsed;

            infoList = HttpHelper.GetBoxMarkList(CaChe.UserInfo.baseJpOrganization.id, "", out string msg).Item2;
            g_equ.ItemsSource = infoList;
            txt_vendor.Focus();
            InitWs();
            this.DataContext = uiMessageData;
        }
        public respone_boxMark RecodeInfo { get; set; }
        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
        }

        private void OnQueryClick(object sender, RoutedEventArgs e)
        {
            infoList = HttpHelper.GetBoxMarkList(CaChe.UserInfo.baseJpOrganization.id, "", out string msg).Item2;
            if (string.IsNullOrEmpty(txt_vendor.Text))
            {
                g_equ.ItemsSource = infoList;
            }
            else
            {
                g_equ.ItemsSource = infoList?.Where(t => t.epc.Contains(txt_vendor.Text) || t.oldEpc == txt_vendor.Text).ToList();
            }
        }

        private void OnClearQueryClick(object sender, RoutedEventArgs e)
        {
            txt_vendor.Text = "";
            OnQueryClick(null, null);
        }

        private void OnSelectItemClick(object sender, RoutedEventArgs e)
        {
            var info = g_equ.SelectedValue as respone_boxMark;
            if (MessageBox.Show($"确认拆箱:{info.epc}？", "提示", MessageBoxButton.YesNo, MessageBoxImage.Question) ==
                MessageBoxResult.Yes)
            {
                RecodeInfo = info;
                this.Close();
            }
        }

        private void OnScrapBoxClick(object sender, RoutedEventArgs e)
        {
            var info = g_equ.SelectedValue as respone_boxMark;
            if (MessageBox.Show($"确认报废:{info.epc}？该操作无法撤销", "警告", MessageBoxButton.YesNo, MessageBoxImage.Question) ==
                MessageBoxResult.Yes)
            {
                //报废该箱标对应物资
                var res = HttpHelper.DeleteEpcList(info.epc, out string msg);
                if (!res)
                {
                    MessageBox.Show("报废失败：" + msg);
                    return;
                }
                //全部报废成功，删除箱标
                LiteDbHelper.DeleteByEpc(info.epc);
                MessageBox.Show("报废成功");
                OnQueryClick(null, null);
            }
        }


        private void OnReadClick(object sender, RoutedEventArgs e)
        {
            SendInitialMsg();
        }
        private void ImportOldDataClick(object sender, RoutedEventArgs e)
        {
            if (MessageBox.Show($"是否导入旧箱标数据？", "警告", MessageBoxButton.YesNo, MessageBoxImage.Question) ==
                MessageBoxResult.Yes)
            {
                var list = LiteDbHelper.GetPage(1, 9999,
                    x => x.LabelType == "箱标" && x.epc.Length == 24 && x.IsImported != true)?.record;

                if (list == null || list.Count == 0)
                {
                    MessageBox.Show("无需导入的数据");
                }
                else
                {
                    var res = HttpHelper.ImportOldBoxMark(list, out string msg);
                    if (res.Item1)
                    {
                        foreach (var successDetail in res.Item2.successList)
                        {
                            var data = LiteDbHelper.GetSingleByEpc(successDetail.epc);
                            data.IsImported = true;
                            LiteDbHelper.Update(data);
                        }
                    }
                    MessageBox.Show(msg);

                }
            }
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            wsConn.Close();
            cWsServiceToken.Cancel();
        }
        #region tcp method

        private CancellationTokenSource cWsServiceToken;
        private Task taskWsService;
        private WebSocket wsConn;
        private ManualResetEvent resetUhf = new ManualResetEvent(true);
        private void InitWs()
        {
            if (taskWsService == null)
            {
                cWsServiceToken = new CancellationTokenSource();
                taskWsService = new Task(() =>
                {
                    wsConn = new WebSocket("ws://127.0.0.1:8081");
                    while (!cWsServiceToken.IsCancellationRequested)
                    {
                        try
                        {
                            // 已连接的不处理
                            if (wsConn.IsAlive)
                            {
                            }
                            else
                            {
                                // 接收数据
                                wsConn.OnMessage += (sender, e) =>
                                {
                                    ReciveWsMsg(e.Data);
                                };
                                // 服务关闭
                                wsConn.OnClose += (sender, e) =>
                                {
                                    uiMessageData.UiMessage = $"状态：服务已断开，重连中";
                                    uiMessageData.MsgColor = "Red";
                                    uiMessageData.BindButton = false;
                                };

                                wsConn.OnOpen += (sender, e) =>
                                {
                                    uiMessageData.UiMessage = $"状态：正在查询设备状态";
                                    uiMessageData.MsgColor = "Green";
                                    uiMessageData.BindButton = true;
                                };

                                // 服务连接
                                wsConn.Connect();
                            }

                        }
                        catch (System.Exception ex)
                        {
                            uiMessageData.UiMessage = $"状态：初始化设备连接失败";
                            uiMessageData.MsgColor = "Red";
                            uiMessageData.BindButton = false;
                            Log.ErrorLog(ex.ToString(), this.GetType().Name);
                        }
                        if (resetEvent.WaitOne(3000)) { break; }
                    }

                });
                taskWsService.Start();
            }
        }
        private void ReciveWsMsg(string msg)
        {
            var cmdInfo = JsonConvert.DeserializeObject<InitializeCmdInfo>(msg);
            switch (cmdInfo.CmdType)
            {
                case JmpUhfService.InitializeCmdType.Busy:
                    uiMessageData.UiMessage = $"状态：设备正忙，请检查设备是否被占用";
                    uiMessageData.MsgColor = "Red";
                    uiMessageData.BindButton = false;
                    resetUhf.Set();
                    break;
                //case JmpUhfService.InitializeCmdType.Initialize:
                //    if (msg.Contains("成功"))
                //    {
                //        //绑定
                //    }
                //    else
                //    {
                //        BindButton = true;
                //        UiMessage = $"状态：{cmdInfo.Content}";
                //        MsgColor = "Red";
                //        resetUhf.Set();
                //    }
                //    break;
                case JmpUhfService.InitializeCmdType.InventoryInfo:
                    {
                        Application.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            txt_vendor.Text = cmdInfo.Content;
                            OnQueryClick(null, null);
                        });

                        uiMessageData.UiMessage = $"状态：读取EPC成功";
                        uiMessageData.MsgColor = "Green";
                        resetUhf.Set();
                        uiMessageData.BindButton = true;
                        break;
                    }
                case JmpUhfService.InitializeCmdType.Linked:
                    uiMessageData.UiMessage = $"状态：初始化设备已连接";
                    uiMessageData.MsgColor = "Green";
                    resetUhf.Set();
                    uiMessageData.BindButton = true;
                    break;
                case JmpUhfService.InitializeCmdType.ErrorMsg:
                    uiMessageData.UiMessage = $"状态：{cmdInfo.Content}";
                    uiMessageData.MsgColor = "Red";
                    resetUhf.Set();
                    uiMessageData.BindButton = false;
                    break;
                default:
                    resetUhf.Set();
                    break;
            }
        }
        private void SendInitialMsg()
        {
            try
            {
                var json = JsonConvert.SerializeObject(new
                {
                    CmdType = 0,
                    Content = ""
                });
                if (wsConn?.IsAlive ?? false)
                {
                    uiMessageData.UiMessage = $"状态：读取EPC中";
                    uiMessageData.MsgColor = "DarkOrange";
                    resetUhf.Set();
                    uiMessageData.BindButton = false;

                    wsConn.Send(json);
                    Task.Run(() =>
                    {
                        Thread.Sleep(1000);
                        wsConn.Send(JsonConvert.SerializeObject(new
                        {
                            CmdType = 1,
                            Content = ""
                        }));
                        if (uiMessageData.UiMessage == "状态：读取EPC中")
                        {
                            uiMessageData.UiMessage = $"状态：未读取到EPC";
                            uiMessageData.MsgColor = "Red";
                            resetUhf.Set();
                            uiMessageData.BindButton = true;
                        }
                    });
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }
        #endregion

    }
}
