﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace JmpZbPrint.Common
{
    public class ProductEpc
    {
        ProductEpc196 pro196 = new ProductEpc196();


        #region 属性

        public int Index { get; set; }
        public int ListIndex { get; set; }

        /// <summary>
        /// 有效EPC
        /// </summary>
        public string StrSubEpc { get; set; }

        /// <summary>
        /// 标签EPC长度
        /// </summary>
        private int iTagLength = 42;

        private string strCopyright = "00";
        /// <summary>
        /// EPC中的版本号 2位十六进制 00-FF，FF保留
        /// </summary>
        public string StrCopyright
        {
            get { return strCopyright; }
            set { strCopyright = value; }
        }
        /// <summary>
        /// 数据库中的版本号 十进制
        /// </summary>
        public int ICopyright
        {
            get;
            set;
            //get { return Convert.ToInt32(StrCopyright, 16); }
            //set { StrCopyright = Convert.ToString(value, 16).PadLeft(2, '0'); }
        }


        private String strTagType = "";
        /// <summary>
        /// EPC中标签类型 1位十六进制  0-F  0-单品物资标签，1-箱标签，2-托盘标签，3-货架标签，4-批物资标签
        /// </summary>
        public String StrTagType
        {
            get { return strTagType; }
            set { strTagType = value; }
        }

        private String strSCCSNo = "";
        /// <summary>
        /// EPC中对应生产企业代码 6位十六进制  000000-FFFFFF
        /// </summary>
        public String StrSCCSNo
        {
            get { return strSCCSNo; }
            set { strSCCSNo = value; }
        }
        private string strSccsCode = "";
        /// <summary>
        /// 数据库中生产企业代码
        /// </summary>
        public string StrSccsCode
        {
            get { return strSccsCode; }
            set { strSccsCode = value; }
        }


        private String strSCCSName = "";
        /// <summary>
        /// 生产企业名称 
        /// </summary>
        public String StrSCCSName
        {
            get { return strSCCSName; }
            set { strSCCSName = value; }
        }

        private String strBzType = "1";
        /// <summary>
        /// EPC中包装类型　1位十六进制  0-F 1-外包装，2-中包装，3-内包装，F-零头配箱
        /// </summary>
        public String StrBzType
        {
            get { return strBzType; }
            set { strBzType = value; }
        }

        private string strWzLsm = "0";
        /// <summary>
        /// EPC中物资代码，LSM 8位十六进制 00000000-FFFFFFFF
        /// </summary>
        public string StrWzLsm
        {
            get { return strWzLsm; }
            set { strWzLsm = value; }
        }
        /// <summary>
        /// 数据库中物资代码 LSM
        /// </summary>
        public Int64 IWzLsm
        {
            get { return Convert.ToInt64(StrWzLsm, 16); }
            set { StrWzLsm = Convert.ToString(value, 16); }
        }

        private string strWzNo = "0";
        /// <summary>
        /// EPC中物资代码 52码 9位十六进制  000000000-FFFFFFFFF
        /// </summary>
        public string StrWzNo
        {
            get { return strWzNo; }
            set { strWzNo = value; }
        }
        private Int64 iWzNo = 0;
        /// <summary>
        /// 数据库中物资代码  52码
        /// </summary>
        public Int64 IWzNo
        {
            //get;
            //set;
            get { return Convert.ToInt64(StrWzNo, 16); }
            set { StrWzNo = Convert.ToString(value, 16); }
        }

        private String strWzName = "";
        /// <summary>
        /// 物资名称
        /// </summary>
        public String StrWzName
        {
            get { return strWzName; }
            set { strWzName = value; }
        }

        private String strWZHXName = "";
        /// <summary>
        /// 号型名称
        /// </summary>
        public String StrWZHXName
        {
            get { return strWZHXName; }
            set { strWZHXName = value; }
        }

        private String strScrq = "";
        /// <summary>
        /// EPC中生产日期 6位十六进制  YYMMDD
        /// </summary>
        public String StrScrq
        {
            get { return strScrq; }
            set { strScrq = value; }
        }
        /// <summary>
        /// 数据库中生产日期 DateTime
        /// </summary>
        public DateTime DtScrq
        {
            get;
            set;
        }

        private string strXjbzsl = "";
        /// <summary>
        /// EPC中下级包装数量 2位十六进制 00-FF
        /// </summary>
        public string StrXjbzsl
        {
            get { return strXjbzsl; }
            set { strXjbzsl = value; }
        }
        /// <summary>
        /// 数据库中下级包装数量
        /// </summary>
        public int IXjbzsl
        {
            get { return Convert.ToInt32(StrXjbzsl, 16); }
            set { StrXjbzsl = Convert.ToString(value, 16); }
        }

        private string strNum = "";
        /// <summary>
        /// EPC中产品总数量 3位十六进制  000-FFF
        /// </summary>
        public string StrNum
        {
            get { return strNum; }
            set { strNum = value; }
        }
        /// <summary>
        /// 数据库中产品总数量
        /// </summary>
        public int INum
        {
            get { return Convert.ToInt32(StrNum, 16); }
            set { StrNum = Convert.ToString(value, 16); }
        }

        private string strScxNo = "0";
        /// <summary>
        /// EPC中企业生产线序号 1位十六进制 0-F 十六进制 0-E表示生产线序列号，F表示军需仓库打印的标签
        /// </summary>
        public string StrScxNo
        {
            get { return strScxNo; }
            set { strScxNo = value; }
        }
        /// <summary>
        /// 数据库中 十进制企业生产线序号
        /// </summary>
        public int IScxNo
        {
            get { return Convert.ToInt32(StrScxNo, 16) + 1; }
            set { StrScxNo = Convert.ToString(value - 1, 16); }
        }

        private string strXiangNo = "0";
        /// <summary>
        /// EPC中包装箱序号 3位十六进制 000-FFF
        /// </summary>
        public string StrXiangNo
        {
            get { return strXiangNo; }
            set { strXiangNo = value; }
        }
        /// <summary>
        /// 数据库中 十进制包装箱序列号
        /// </summary>
        public int IXiangNo
        {
            get { return Convert.ToInt32(StrXiangNo, 16); }
            set { StrXiangNo = Convert.ToString(value, 16); }
        }

        private string strXSerialNo = "0";
        /// <summary>
        /// EPC中 箱序列号  生产线序号+包装箱序号   0|1
        /// </summary>
        public string StrXSerialNo
        {
            get { return strXSerialNo; }// IScxNo.ToString() + '|' + IXiangNo.ToString(); }
            set
            {
                strXSerialNo = value;
                //StrScxNo = value.Substring(0, 1);
                //StrXiangNo = value.Substring(1);
            }
        }

        private string strZbhm = "0";
        /// <summary>
        /// EPC中的组别号码 1位十六进制 0-F
        /// </summary>
        public string StrZbhm
        {
            get { return strZbhm; }
            set { strZbhm = value; }
        }

        /// <summary>
        /// 相同EPC组别中共有几个
        /// </summary>
        public int IZbAll
        {
            get;
            set;
        }

        /// <summary>
        /// 相同epc组别中第几个
        /// </summary>
        public int IZbNo
        {
            get;
            set;
        }

        private string strJiaoYan = "0";
        /// <summary>
        /// EPC中检验码 1位十六进制 
        /// </summary>
        public string StrJiaoYan
        {
            get { return strJiaoYan; }
            set { strJiaoYan = value; }
        }

        private string strXnSerialno = "00";
        /// <summary>
        /// EPC中箱内序号 2位 00-FF
        /// </summary>
        public string StrXnSerialno
        {
            get { return strXnSerialno; }
            set { strXnSerialno = value; }
        }
        /// <summary>
        /// 数据库中箱内序号
        /// </summary>
        public int IXnSerialno
        {
            get { return Convert.ToInt32(StrXnSerialno, 16); }
            set { StrXnSerialno = Convert.ToString(value, 16); }
        }

        private String strEPC = "";
        /// <summary>
        /// 读取的EPC 
        /// </summary>
        public String StrEPC
        {
            get { return strEPC; }
            set
            {
                iTagLength = value.Length;
                strEPC = value;
            }
        }

        /// <summary>
        /// 起始箱号
        /// </summary>
        public int iStartXNo = 0;

        #endregion

        #region 方法
        public void getInfoFormEpc()
        {
            try
            {
                pro196.UnPackEpc(strEPC.Substring(0, 49));

                this.StrSubEpc = strEPC.Substring(0, 41) + strEPC.Substring(43, 6);
                this.StrCopyright = pro196.getStrHexVersion();
                this.StrTagType = pro196.getStrHexTagType();
                this.StrSccsCode = pro196.getStrOrgCode().TrimStart('0');
                this.StrBzType = pro196.getStrHexPacktype();
                this.StrWzLsm = pro196.getStrHexProductCode();
                this.StrScrq = pro196.getStrHexScrq();
                this.DtScrq = pro196.DtScrq;
                this.StrXjbzsl = pro196.getStrHexInsidePackNum();
                this.StrNum = pro196.getStrHexProductNum();
                this.StrScxNo = pro196.getStrHexProductLine();
                this.StrXiangNo = pro196.getStrHexPackSerialNo();
                this.StrXSerialNo = this.IScxNo.ToString() + "/" + this.IXiangNo.ToString();
                this.StrZbhm = pro196.getStrHexGroupNo();
                this.IZbAll = pro196.IZbAll;
                this.IZbNo = pro196.IZbNo;
                this.StrJiaoYan = pro196.getStrHexCRCCode();
            }
            catch { }
        }

        public bool IsSameBox(string epc)
        {
            if (epc.Length == 52)
            {
                string temp = epc.Substring(0, 41) + epc.Substring(43, 6);
                if (this.StrSubEpc.Equals(temp))
                {
                    return true;
                }
            }
            return false;
        }
        #endregion
    }

    public class ProductEpc196
    {

        #region 属性
        /// <summary>
        /// 标头信息 十六进制   //被装专业固定"05"
        /// </summary>
        static String CONSTHEADERINFO = "05";
        /// <summary>
        /// 标头信息 二进制
        /// </summary>
        static String CONSTHEADERINFOBIN = "00000101";
        /// <summary>
        /// 版本号 十六进制
        /// </summary>
        static String CONSTVERSION = "11";
        /// <summary>
        /// 版本号 二进制
        /// </summary>
        static String CONSTVERSIONBIN = "00010001";
        /// <summary>
        ///静态发行机构标志 //部队发布
        /// </summary>
        static String CONSTMILITARYPUBLISHFLAG = "000001";
        /// <summary>
        ///静态发行机构标志 //国家发布
        /// </summary>
        static String CONSTNATIONPUBLISHFLAG = "000010";
        /// <summary>
        ///静态发行机构标志 //北约发布
        /// </summary>
        static String CONSTNATOPUBLISHFLAG = "000011";


        //无源标签6位字段对应表
        //String[] KeyWords = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z" };
        /// <summary>
        /// 无源标签6位字段对应表
        /// </summary>
        String strKeyWords = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";



        /// <summary>
        /// 1、标头信息   十六进制 2位   被装专业专用05
        /// </summary>
        String strHexHeaderInfo = ProductEpc196.CONSTHEADERINFO;
        /// <summary>
        /// 1、标头信息   二进制 8位   被装专业专用05 
        /// </summary>
        String strBinHeaderInfo = ProductEpc196.CONSTHEADERINFOBIN;	//2进制


        /// <summary>
        /// 2、发行机构标识    6位  军队组织机构代码为000001
        /// </summary>
        String strBinPublishFlag = ProductEpc196.CONSTMILITARYPUBLISHFLAG;	//2进制

        //
        /// <summary>
        /// 3、组织机构代码  8位  
        /// 正常组织机构代码
        /// </summary>
        String strOrgCode = "";
        /// <summary>
        /// 3、组织机构代码  54位  每6位代表一个数字或字母，位数不够时用每一个字母使用"0"填充
        /// 2进制组织机构代码
        /// </summary>			
        String strBinOrgCode = "";


        /// <summary>
        /// 4、品种代码指示长度  十六进制    指示物资代码长度 N*6 = 物资代码长度，默认为6 
        /// </summary>
        String strHexProductCodeLength = "6";	//16进制
        /// <summary>
        /// 4、品种代码指示长度  二进制 4位    指示物资代码长度 N*6 = 物资代码长度，默认为6 
        /// </summary>
        String strBinProductcodeLength = "0110";//2进制


        /// <summary>
        /// 5、物资代码 十六进制 9位，军事物流信息系统物资代码，转换为十进制后存储。我部使用时占用36位 
        /// </summary>
        String strHexProductCode = "000000000";			//16进制
        /// <summary>
        /// 5、物资代码 二进制  36位 6-48位，军事物流信息系统物资代码，转换为十进制后存储。我部使用时占用36位 
        /// </summary>
        String strBinProductCode = "000000000000000000000000000000000000";			//2进制


        /// <summary>
        /// 6、序列号长度   十六进制    N*6,现固定为A 
        /// </summary>
        String strHexSerialLength = "A";
        /// <summary>
        /// 6、序列号长度   二进制    ,现固定为1010 
        /// </summary>
        String strBinSerialLength = "1010";


        /// <summary>
        /// 7、版本号	十六进制 2位 当前版本为"11"
        /// </summary>
        String strHexVersion = ProductEpc196.CONSTVERSION;
        /// <summary>
        /// //7、版本号	二进制 8位 当前版本为"00010001"
        /// </summary>
        String strBinVersion = ProductEpc196.CONSTVERSIONBIN;


        /// <summary>
        /// 8、标签类型  十六进制 1位  1 - 箱标签
        /// </summary>
        private String strHexTagType = "1";
        /// <summary>
        /// 8、标签类型  二进制 4位  0001 - 箱标签
        /// </summary>
        private String strBinTagType = "0001";


        /// <summary>
        /// 9、包装类型	十六进制 1位 （1-外包装，2-中包装，3-内包装，F-零头配箱）
        /// </summary>
        private String strHexPacktype = "1";
        /// <summary>
        /// 9、包装类型	二进制 4位 （1-外包装，2-中包装，3-内包装，F-零头配箱）
        /// </summary>
        private String strBinPacktype = "0001";


        //private int iInsidePackNum = 0;
        /// <summary>
        /// 10、下级包装数量 十六进制 2位 最大255
        /// </summary>
        private String strHexInsidePackNum = "00";
        /// <summary>
        /// 10、下级包装数量 二进制 8位 最大255
        /// </summary>
        private String strBinInsidePackNum = "00000000";


        //private int iProductNum = 0;
        /// <summary>
        /// 11、产品总数量 十六进制 3位 最大4095
        /// </summary>
        private String strHexProductNum = "000";
        /// <summary>
        /// 11、产品总数量 二进制 12位 最大4095
        /// </summary>
        private String strBinProductNum = "000000000000";


        //private int iProductLine = 0;
        /// <summary>
        /// 12、生产线序列号  十六进制 1位  0-E表示生产组序列号  F表示军需仓库打印的标签
        /// </summary>
        private String strHexProductLine = "0";
        /// <summary>
        /// 12、生产线序列号  二进制 4位  0-E表示生产组序列号  F表示军需仓库打印的标签
        /// </summary>
        private String strBinProductLine = "0000";


        //private int iPackSerialNo = 0;
        /// <summary>
        /// 13、产品箱序列号 十六进制 3位 
        /// </summary>
        private String strHexPackSerialNo = "000";
        /// <summary>
        /// 13、产品箱序列号 二进制 12位 
        /// </summary>
        private String strBinPackSerialNo = "000000000000";


        /// <summary>
        /// 组别号码 十六进制 1位
        /// </summary>
        private String strHexGroupNo = "0";
        /// <summary>
        /// 组别号码 二进制 4位
        /// </summary>
        private String strBinGroupNo = "0000";
        /// <summary>
        /// 相同EPC组别中共有几个
        /// </summary>
        public int IZbAll
        {
            get
            {
                int izb = 0;
                switch (Convert.ToInt32(strHexGroupNo, 16))
                {
                    case 0:
                        {
                            izb = 1;
                            break;
                        }
                    case 4:
                        {
                            izb = 2;
                            break;
                        }
                    case 5:
                        {
                            izb = 2;
                            break;
                        }
                    case 8:
                        {
                            izb = 4;
                            break;
                        }
                    case 9:
                        {
                            izb = 4;
                            break;
                        }
                    case 10:
                        {
                            izb = 4;
                            break;
                        }
                    case 11:
                        {
                            izb = 4;
                            break;
                        }
                }
                return izb;
            }
        }
        /// <summary>
        /// 相同epc组别中第几个
        /// </summary>
        public int IZbNo
        {
            get
            {
                int izb = 0;
                switch (Convert.ToInt32(strHexGroupNo, 16))
                {
                    case 0:
                        {
                            izb = 1;
                            break;
                        }
                    case 4:
                        {
                            izb = 1;
                            break;
                        }
                    case 5:
                        {
                            izb = 2;
                            break;
                        }
                    case 8:
                        {
                            izb = 1;
                            break;
                        }
                    case 9:
                        {
                            izb = 2;
                            break;
                        }
                    case 10:
                        {
                            izb = 3;
                            break;
                        }
                    case 11:
                        {
                            izb = 4;
                            break;
                        }
                }
                return izb;
            }
        }

        //private int iCRCCode = 0;
        /// <summary>
        /// 校验码 十六进制 1位
        /// </summary>
        private String strHexCRCCode = "0";
        /// <summary>
        /// 校验码 二进制 4位
        /// </summary>
        private String strBinCRCCode = "0000";


        //private Date dtScrq;
        /// <summary>
        /// 生产日期 十六进制 6位
        /// </summary>
        private String strHexScrq = "120101";
        /// <summary>
        /// 生产日期 二进制 24位 
        /// </summary>
        private String strBinScrq = "000100100000000100000001";
        /// <summary>
        /// 生产日期 DateTime 
        /// </summary>
        public DateTime DtScrq
        {
            get
            {
                string year = "20" + strHexScrq.Substring(0, 2);
                string morth = strHexScrq.Substring(2, 2);
                string day = strHexScrq.Substring(4, 2);
                return DateTime.Parse(year + "-" + morth.ToString() + "-" + day.ToString());
            }
        }
        /// <summary>
        /// 有效期，共4位；前两位数值，后两位单位
        /// </summary>
        public string strBinYxq = "0000000000000000";

        #endregion 属性

        #region 方法

        /// <summary>
        /// * 1、取得16进制标头信息
        /// * 位数：2位
        /// * 表示方式：0-FF
        /// * 说明：被装专业专用为00000101，即为05
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexHeaderInfo()
        {
            return strHexHeaderInfo;
        }

        /// <summary>
        /// * 1、取得2进制标头信息
        /// * 位数：8位
        /// * 表示方式：0-FF
        /// * 说明：被装专业专用为00000101，即为05
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinHeaderInfo()
        {
            return strBinHeaderInfo;
        }


        /// <summary>
        /// * 2、取得2进制发行机构标识
        /// * 位数：6位
        /// * 说明：军队组织机构代码为000001
        /// * @return         
        /// </summary>
        /// <returns></returns>
        public String getStrBinPublishFlag()
        {
            return strBinPublishFlag;
        }


        /// <summary>
        /// * 3、取得组织机构代码
        /// * 位数：54位
        /// * 说明：每6位代表一个数字或字母，位数不够时前面用0填充
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrOrgCode()
        {
            return strOrgCode;
        }


        /// <summary>
        /// * 3、设置组织机构代码
        /// * 位数：54位
        /// * 说明：每6位代表一个数字或字母，位数不够时前面用0填充
        /// * @param strOrgCode
        /// </summary>
        /// <param name="strOrgCode"></param>
        public void setStrOrgCode(String strOrgCode)
        {
            this.strOrgCode = strOrgCode;
        }

        /// <summary>
        /// * 3、取得2进制组织机构代码
        /// * 位数：54位
        /// * 说明：每6位代表一个数字或字母，位数不够时前面用0填充
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinOrgCode()
        {
            return strBinOrgCode;
        }


        /// <summary>
        /// * 3、设置2进制组织机构代码
        /// * @param strBinOrgCode
        /// </summary>
        /// <param name="strBinOrgCode"></param>
        public void setStrBinOrgCode(String strBinOrgCode)
        {
            this.strBinOrgCode = strBinOrgCode;
        }


        /// <summary>
        /// * 4、取得16进制品种代码指示长度
        /// * 位数：1位
        /// * 说明：指示物资代码长度，N * 6 = 物资代码长度位数
        /// * 默认值：6
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexProductCodeLength()
        {
            return strHexProductCodeLength;
        }


        /// <summary>
        /// * 4、设置16进制品种代码指示长度
        /// * 位数：1位
        /// * 说明：指示物资代码长度，N * 6 = 物资代码长度位数
        /// * 默认值：6
        /// * @param strHexProductCodeLength
        /// </summary>
        /// <param name="strHexProductCodeLength"></param>
        public void setStrHexProductCodeLength(String strHexProductCodeLength)
        {
            this.strHexProductCodeLength = strHexProductCodeLength;
        }


        /// <summary>
        /// * 4、取得2进制品种代码指示长度
        /// * 位数：4位
        /// * 说明：指示物资代码长度，N * 6 = 物资代码长度位数
        /// * 默认值：6
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinProductcodeLength()
        {
            return strBinProductcodeLength;
        }


        /// <summary>
        /// * 4、设置2进制品种代码指示长度
        /// * 位数：4位
        /// * 说明：指示物资代码长度，N * 6 = 物资代码长度位数
        /// * 默认值：6
        /// * @return
        /// </summary>
        /// <param name="strBinProductcodeLength"></param>
        public void setStrBinProductcodeLength(String strBinProductcodeLength)
        {
            this.strBinProductcodeLength = strBinProductcodeLength;
        }


        /// <summary>
        /// * 5、取得16进制物资代码
        /// * 位数：9位
        /// * 说明：军事物流信息系统物资代码，转换为十六进制后存储。 
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexProductCode()
        {
            return strHexProductCode;
        }


        /// <summary>
        /// * 5、设置16进制物资代码
        /// * 位数：9位
        /// * 说明：6 - 48位。军事物流信息系统物资代码，转换为十六进制后存储。 我部使用时占用36位
        /// * @return
        /// </summary>
        /// <param name="strHexProductCode"></param>
        public void setStrHexProductCode(String strHexProductCode)
        {
            this.strHexProductCode = strHexProductCode;
        }


        /// <summary>
        /// * 5、取得2进制物资代码
        /// * 位数：36位
        /// * 说明：6 - 48位。军事物流信息系统物资代码，转换为十六进制后存储。 我部使用时占用36位
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinProductCode()
        {
            return strBinProductCode;
        }


        /// <summary>
        /// * 5、设置2进制物资代码
        /// * 位数：36位
        /// * 说明：6 - 48位。军事物流信息系统物资代码，转换为十六进制后存储。 我部使用时占用36位
        /// * @return
        /// </summary>
        /// <param name="strBinProductCode"></param>
        public void setStrBinProductCode(String strBinProductCode)
        {
            this.strBinProductCode = strBinProductCode;
        }


        /// <summary>
        /// * 6、取得16进制序列号长度
        /// * 位数：1位
        /// * 说明：N * 6 
        /// * 默认：A（十进制为10）
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexSerialLength()
        {
            return strHexSerialLength;
        }


        /// <summary>
        /// * 6、设置16进制序列号长度
        /// * 位数：1位
        /// * 说明：N * 6 
        /// * 默认：A（十进制为10）
        /// * @return
        /// </summary>
        /// <param name="strHexSerialLength"></param>
        public void setStrHexSerialLength(String strHexSerialLength)
        {
            this.strHexSerialLength = strHexSerialLength;
        }

        /// <summary>
        /// * 6、设置2进制序列号长度
        /// * 位数：4位
        /// * 说明：N * 6 
        /// * 默认：A（十进制为10）
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinSerialLength()
        {
            return strBinSerialLength;
        }


        /// <summary>
        /// * 6、取得2进制序列号长度
        /// * 位数：4位
        /// * 说明：N * 6 
        /// * 默认：A（十进制为10）
        /// * @return
        /// </summary>
        /// <param name="strBinSerialLength"></param>
        public void setStrBinSerialLength(String strBinSerialLength)
        {
            this.strBinSerialLength = strBinSerialLength;
        }


        /// <summary>
        /// * 7、取得16进制版本号
        /// * 位数：2位
        /// * 说明：版本号 
        /// * 默认：当前版本号为11
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexVersion()
        {
            return strHexVersion;
        }

        /// <summary>
        /// * 7、设置16进制版本号
        /// * 位数：2位
        /// * 说明：版本号 
        /// * 默认：当前版本号为11
        /// * @return
        /// </summary>
        /// <param name="strHexVersion"></param>
        public void setStrHexVersion(String strHexVersion)
        {
            this.strHexVersion = strHexVersion;
        }

        /// <summary>
        /// * 7、取得2进制版本号
        /// * 位数：8位
        /// * 说明：版本号 
        /// * 默认：当前版本号为00010001
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinVersion()
        {
            return strBinVersion;
        }


        /// <summary>
        /// * 7、设置2进制版本号
        /// * 位数：8位
        /// * 说明：版本号 
        /// * 默认：当前版本号为00010001
        /// * @return
        /// </summary>
        /// <param name="strBinVersion"></param>
        public void setStrBinVersion(String strBinVersion)
        {
            this.strBinVersion = strBinVersion;
        }


        /// <summary>
        /// * 8、取得16进制标签类型
        /// * 位数：1位
        /// * 默认：1 箱标签
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexTagType()
        {
            return strHexTagType;
        }


        /// <summary>
        /// * 8、设置16进制标签类型
        /// * 位数：1位
        /// * 默认：1 箱标签
        /// * @return
        /// </summary>
        /// <param name="strHexTagType"></param>
        public void setStrHexTagType(String strHexTagType)
        {
            this.strHexTagType = strHexTagType;
        }


        /// <summary>
        /// * 8、取得2进制标签类型
        /// * 位数：4位
        /// * 默认：1 箱标签
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinTagType()
        {
            return strBinTagType;
        }


        /// <summary>
        /// * 8、设置2进制标签类型
        /// * 位数：4位
        /// * 默认：1 箱标签
        /// * @return
        /// </summary>
        /// <param name="strBinTagType"></param>
        public void setStrBinTagType(String strBinTagType)
        {
            this.strBinTagType = strBinTagType;
        }


        /// <summary>
        /// * 9、取得16进制包装类型
        /// * 位数：1位
        /// * 默认：1为外包装， F为零头配箱
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexPacktype()
        {
            return strHexPacktype;
        }


        /// <summary>
        /// * 9、设置16进制包装类型
        /// * 位数：1位
        /// * 默认：1为外包装， F为零头配箱
        /// * @return
        /// </summary>
        /// <param name="strHexPacktype"></param>
        public void setStrHexPacktype(String strHexPacktype)
        {
            this.strHexPacktype = strHexPacktype;
        }


        /// <summary>
        /// * 9、取得2进制包装类型
        /// * 位数：4位
        /// * 默认：1为外包装， F为零头配箱
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinPacktype()
        {
            return strBinPacktype;
        }

        /// <summary>
        /// * 9、设置2进制包装类型
        /// * 位数：4位
        /// * 默认：1为外包装， F为零头配箱
        /// * @param strBinPacktype
        /// </summary>
        /// <param name="strBinPacktype"></param>
        public void setStrBinPacktype(String strBinPacktype)
        {
            this.strBinPacktype = strBinPacktype;
        }


        /// <summary>
        /// * 10、取得16进制下级包装数
        /// * 位数：2位
        /// * 默认：0
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexInsidePackNum()
        {
            return strHexInsidePackNum;
        }


        /// <summary>
        /// * 10、设置16进制下级包装数
        /// * 位数：2位
        /// * 默认：0
        /// * @param strHexInsidePackNum
        /// </summary>
        /// <param name="strHexInsidePackNum"></param>
        public void setStrHexInsidePackNum(String strHexInsidePackNum)
        {
            this.strHexInsidePackNum = strHexInsidePackNum;
        }

        /// <summary>
        /// * 10、取得2进制下级包装数
        /// * 位数：8位
        /// * 默认：0
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinInsidePackNum()
        {
            return strBinInsidePackNum;
        }

        /// <summary>
        /// * 10、设置2进制下级包装数
        /// * 位数：8位
        /// * 默认：0
        /// * @param strBinInsidePackNum
        /// </summary>
        /// <param name="strBinInsidePackNum"></param>
        public void setStrBinInsidePackNum(String strBinInsidePackNum)
        {
            this.strBinInsidePackNum = strBinInsidePackNum;
        }


        /// <summary>
        /// * 11、取得十六进制产品总数量
        /// * 位数：3位
        /// * 最大：4096
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexProductNum()
        {
            return strHexProductNum;
        }

        /// <summary>
        /// * 11、设置十六进制产品总数量
        /// * 位数：3位
        /// * 最大：4096
        /// * @param strHexProductNum
        /// </summary>
        /// <param name="strHexProductNum"></param>
        public void setStrHexProductNum(String strHexProductNum)
        {
            this.strHexProductNum = strHexProductNum;
        }

        /// <summary>
        /// * 11、取得2进制产品总数量
        /// * 位数：12位
        /// * 最大：4096
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinProductNum()
        {
            return strBinProductNum;
        }

        /// <summary>
        /// * 11、设置2进制产品总数量
        /// * 位数：12位
        /// * 最大：4096
        /// * @param strBinProductNum
        /// </summary>
        /// <param name="strBinProductNum"></param>
        public void setStrBinProductNum(String strBinProductNum)
        {
            this.strBinProductNum = strBinProductNum;
        }


        /// <summary>
        /// * 12、取得16进制生产线序列号
        /// * 位数：1位
        /// * 说明：0 - E表示生产线序列号，F表示军需仓库打印的标签
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexProductLine()
        {
            return strHexProductLine;
        }

        /// <summary>
        /// * 12、设置16进制生产线序列号
        /// * 位数：1位
        /// * 说明：0 - E表示生产线序列号，F表示军需仓库打印的标签
        /// * @param strHexProductLine
        /// </summary>
        /// <param name="strHexProductLine"></param>
        public void setStrHexProductLine(String strHexProductLine)
        {
            this.strHexProductLine = strHexProductLine;
        }

        /// <summary>
        /// * 12、取得2进制生产线序列号
        /// * 位数：4位
        /// * 说明：0 - E表示生产线序列号，F表示军需仓库打印的标签
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinProductLine()
        {
            return strBinProductLine;
        }

        /// <summary>
        /// * 12、设置2进制生产线序列号
        /// * 位数：4位
        /// * 说明：0 - E表示生产线序列号，F表示军需仓库打印的标签
        /// * @param strBinProductLine
        /// </summary>
        /// <param name="strBinProductLine"></param>
        public void setStrBinProductLine(String strBinProductLine)
        {
            this.strBinProductLine = strBinProductLine;
        }


        /// <summary>
        /// * 取得16进制产品箱序列号
        /// * 位数：3位
        /// * 说明：顺序码，最大4095
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexPackSerialNo()
        {
            return strHexPackSerialNo;
        }

        /// <summary>
        /// * 设置16进制产品箱序列号
        /// * 位数：3位
        /// * 说明：顺序码，最大4095
        /// * @param strHexPackSerialNo
        /// </summary>
        /// <param name="strHexPackSerialNo"></param>
        public void setStrHexPackSerialNo(String strHexPackSerialNo)
        {
            this.strHexPackSerialNo = strHexPackSerialNo;
        }

        /// <summary>
        /// * 取得2进制产品箱序列号
        /// * 位数：12位
        /// * 说明：顺序码，最大4095
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinPackSerialNo()
        {
            return strBinPackSerialNo;
        }

        /// <summary>
        /// * 设置2进制产品箱序列号
        /// * 位数：12位
        /// * 说明：顺序码，最大4095
        /// * @param strBinPackSerialNo
        /// </summary>
        /// <param name="strBinPackSerialNo"></param>
        public void setStrBinPackSerialNo(String strBinPackSerialNo)
        {
            this.strBinPackSerialNo = strBinPackSerialNo;
        }


        /// <summary>
        /// * 取得16进制级别号码
        /// * 位数：1位
        /// * 说明：	0表示1张标签
        /// * 		4表示2张标签中的第一张， 5表示第二张
        /// * 		8表示4张标签中的第一张， 9表示第二张， 10表示第三张， 11表示第四张
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexGroupNo()
        {
            return strHexGroupNo;
        }

        /// <summary>
        /// * 设置16进制级别号码
        /// * 位数：1位
        /// * 说明：	0表示1张标签
        /// * 		4表示2张标签中的第一张， 5表示第二张
        /// * 		8表示4张标签中的第一张， 9表示第二张， 10表示第三张， 11表示第四张
        /// * @param strHexGroupNo
        /// </summary>
        /// <param name="strHexGroupNo"></param>
        public void setStrHexGroupNo(String strHexGroupNo)
        {
            this.strHexGroupNo = strHexGroupNo;
        }

        /// <summary>
        /// * 取得2进制级别号码
        /// * 位数：4位
        /// * 说明：	0000表示1张标签
        /// * 		0100表示2张标签中的第一张， 0101表示第二张
        /// * 		1000表示4张标签中的第一张， 1001表示第二张， 1010表示第三张， 1011表示第四张
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinGroupNo()
        {
            return strBinGroupNo;
        }

        /// <summary>
        /// * 设置2进制级别号码
        /// * 位数：4位
        /// * 说明：	0000表示1张标签
        /// * 		0100表示2张标签中的第一张， 0101表示第二张
        /// * 		1000表示4张标签中的第一张， 1001表示第二张， 1010表示第三张， 1011表示第四张
        /// * @param strBinGroupNo
        /// </summary>
        /// <param name="strBinGroupNo"></param>
        public void setStrBinGroupNo(String strBinGroupNo)
        {
            this.strBinGroupNo = strBinGroupNo;
        }


        /// <summary>
        /// * 取得16进制CRC校验码
        /// * 位数：1位
        /// * 说明：CRC校验
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexCRCCode()
        {
            return strHexCRCCode;
        }

        /// <summary>
        /// * 设置16进制CRC校验码
        /// * 位数：1位
        /// * 说明：CRC校验
        /// * @param strHexCRCCode
        /// </summary>
        /// <param name="strHexCRCCode"></param>
        public void setStrHexCRCCode(String strHexCRCCode)
        {
            this.strHexCRCCode = strHexCRCCode;
        }

        /// <summary>
        /// * 取得2进制CRC校验码
        /// * 位数：4位
        /// * 说明:CRC校验
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinCRCCode()
        {
            return strBinCRCCode;
        }

        /// <summary>
        /// * 设置2进制CRC校验码
        /// * 位数：4位
        /// * 说明:CRC校验
        /// * @param strBinCRCCode
        /// </summary>
        /// <param name="strBinCRCCode"></param>
        public void setStrBinCRCCode(String strBinCRCCode)
        {
            this.strBinCRCCode = strBinCRCCode;
        }


        /// <summary>
        /// * 取得16进制生产日期
        /// * 位数：6位
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrHexScrq()
        {
            return strHexScrq;
        }

        /// <summary>
        /// * 取得2进制生产日期
        /// * 位数：24位
        /// * @return
        /// </summary>
        /// <returns></returns>
        public String getStrBinScrq()
        {
            return strBinScrq;
        }

        /// <summary>
        /// * 取得2进制有效期
        /// * 位数：4位
        /// * @return
        /// </summary>
        /// <returns></returns>
        public string getStrBinYxq()
        {
            return strBinYxq;
        }


        /// <summary>
        /// * 设置2进制生产日期
        /// * 位数：24位
        /// * @param strScrq
        /// </summary>
        /// <param name="strBinScrq"></param>
        public void setStrBinScrq(String strBinScrq)
        {
            this.strBinScrq = strBinScrq;
        }


        /// <summary>
        /// * 设置16进制生产日期
        /// * 位数：6位
        /// * @param strHexScrq
        /// </summary>
        /// <param name="strHexScrq"></param>
        public void setStrHexScrq(String strHexScrq)
        {
            this.strHexScrq = strHexScrq;
        }


        /// <summary>
        ///  * 16进制转为2进制
        /// * @param hexString
        /// * @return
        /// </summary>
        /// <param name="hexString"></param>
        /// <returns></returns>
        public String HexString2BinString(String hexString)
        {
            String binString = "";
            if (hexString.Length > 0)
            {
                for (int i = 1; i < hexString.Length + 1; i++)
                {
                    String tempString = "";
                    //取中间16进制中的一位，转为10进制后，再转为2进制,前导补足4个0
                    tempString = Convert.ToString(Convert.ToInt64(hexString.Substring(i - 1, 1), 16), 2).PadLeft(4, '0');
                    binString += tempString;// tempString.Length - 4;
                }
            }
            return binString;
        }


        /// <summary>
        /// * 2进制转为16进制
        /// * @param binString
        /// * @return
        /// </summary>
        /// <param name="binString"></param>
        /// <returns></returns>
        public String BinString2HexString(String binString)
        {
            String hexString = "";
            int hexLength = (int)Math.Ceiling(binString.Length / 4.0);
            binString = "0000" + binString;
            binString = binString.Substring(binString.Length - (hexLength * 4));
            if (binString.Length > 0)
            {
                for (int i = 0; i < hexLength; i++)
                {
                    String tempString = "";
                    tempString = binString.Substring(i * 4, 4);
                    hexString += Convert.ToString(Convert.ToInt32(tempString, 2), 16);
                }
            }
            return hexString;
        }


        /// <summary>
        /// * 取得字符串
        /// * 说明：每6位代表一个数字或字母，转换为字符串
        /// * @param str6Bin
        /// * @return
        /// </summary>
        /// <param name="str6Bin"></param>
        /// <returns></returns>
        public String Transform6Bin2Character(String str6Bin)
        {
            String characterString = "";
            int characterLength = (int)Math.Ceiling(str6Bin.Length / 6.0);
            str6Bin = "000000" + str6Bin;
            str6Bin = str6Bin.Substring(str6Bin.Length - (characterLength * 6));
            if (str6Bin.Length > 0)
            {
                for (int i = 0; i < characterLength; i++)
                {
                    String tempString = "";
                    tempString = str6Bin.Substring(i * 6, 6);
                    characterString += strKeyWords.Substring(Convert.ToInt32(tempString, 2), 1);
                }
            }
            return characterString;
        }

        public String TransformCharacter26Bin(String strCharacterString)
        {
            //转为大写
            strCharacterString = strCharacterString.ToUpper();

            String str6BinString = "";
            if (strCharacterString.Length > 0)
            {
                for (int i = 1; i < strCharacterString.Length + 1; i++)
                {
                    String tempString = strCharacterString.Substring(i - 1, 1);
                    //前面加000000，并在字符串找到字符，转为2进制
                    tempString = "000000" +
                        Convert.ToString(
                        strKeyWords.IndexOf(tempString), 2);
                    tempString = tempString.Substring(tempString.Length - 6);
                    str6BinString += tempString;
                }
            }
            return str6BinString;
        }

        #endregion 方法

        #region 生成epc  解析epc

        /// <summary>
        /// 根据实际EPC分解物资信息
        /// </summary>
        /// <param name="strHexEpc">十六进制的EPC</param>
        public void UnPackEpc(String strHexEpc)
        {
            //将Epc转为2进制Epc编码
            String strBinEpc = this.HexString2BinString(strHexEpc);




            //1、取得标头信息
            this.strBinHeaderInfo = strBinEpc.Substring(0, 8);
            this.strHexHeaderInfo = this.BinString2HexString(this.strBinHeaderInfo);

            //被装专用标头信息05
            if (this.strBinHeaderInfo.Equals(ProductEpc196.CONSTHEADERINFOBIN))
            {

                //2、发行机构标识
                this.strBinPublishFlag = strBinEpc.Substring(8, 6);

                //3、组织机构代码
                this.strBinOrgCode = strBinEpc.Substring(14, 54);
                this.strOrgCode = this.Transform6Bin2Character(this.strBinOrgCode);

                //4、品种代码指示长度
                this.strBinProductcodeLength = strBinEpc.Substring(68, 4);
                this.strHexProductCodeLength = this.BinString2HexString(this.strBinProductcodeLength);
                //转成10进制长度
                int iProductCodeLength = Convert.ToInt32(this.strHexProductCodeLength, 16);
                //下一位截取操作的起始位


                //5、物资代码
                // 修改，根据品种代码指示长度，确定物资代码长度
                this.strBinProductCode = strBinEpc.Substring(72, iProductCodeLength * 6);
                this.strHexProductCode = this.BinString2HexString(this.strBinProductCode);

                //6、序列号长度
                int iSubStart = 72 + iProductCodeLength * 6;
                this.strBinSerialLength = strBinEpc.Substring(iSubStart, 4);
                this.strHexSerialLength = this.BinString2HexString(this.strBinSerialLength);
                //转为10进制长度
                int iSerialLength = Convert.ToInt32(this.strHexSerialLength, 16);

                //具体序列号内容
                String strSerial = strBinEpc.Substring(iSubStart + 4, iSerialLength * 6);

                //7、版本号
                this.strBinVersion = strSerial.Substring(0, 8);
                this.strHexVersion = this.BinString2HexString(this.strBinVersion);

                //根据版本号来判断，进行不同版本的解析
                if (strHexVersion.Equals("11"))
                {
                    //8、标签类型
                    this.strBinTagType = strSerial.Substring(8, 4);
                    this.strHexTagType = this.BinString2HexString(this.strBinTagType);

                    //判断当前标签是不是箱标签
                    if (this.strHexTagType.Equals("1"))
                    {
                        //9、包装类型
                        this.strBinPacktype = strSerial.Substring(12, 4);
                        this.strHexPacktype = this.BinString2HexString(this.strBinPacktype);

                        //10、下级包装数
                        this.strBinInsidePackNum = strSerial.Substring(16, 8);
                        this.strHexInsidePackNum = this.BinString2HexString(this.strBinInsidePackNum);

                        //11、产品总数量
                        this.strBinProductNum = strSerial.Substring(24, 12);
                        this.strHexProductNum = this.BinString2HexString(this.strBinProductNum);

                        //12、生产线序列号
                        this.strBinProductLine = strSerial.Substring(36, 4);
                        this.strHexProductLine = this.BinString2HexString(this.strBinProductLine);

                        //13、产品箱序列号
                        this.strBinPackSerialNo = strSerial.Substring(40, 12);
                        this.strHexPackSerialNo = this.BinString2HexString(this.strBinPackSerialNo);

                        //14、级别号码
                        this.strBinGroupNo = strSerial.Substring(52, 4);
                        this.strHexGroupNo = this.BinString2HexString(this.strBinGroupNo);

                        //15、校验码
                        this.strBinCRCCode = strSerial.Substring(56);

                        //16、生产日期
                        this.strBinScrq = strBinEpc.Substring(iSubStart + 4 + iSerialLength * 6);
                        this.strHexScrq = this.BinString2HexString(this.strBinScrq);

                    }
                    else //托盘标签
                    {


                    }

                }
            }

        }

        /// <summary>
        /// 根据物资实际信息生成EPC
        /// </summary>
        /// <returns></returns>
        public String PackEpc()
        {
            String sb = "";
            //1、标头信息
            sb += this.strBinHeaderInfo;
            //2、发行机构标识
            sb += this.strBinPublishFlag;
            //3、组织机构代码
            //this.setStrOrgCode("000000000" + this.getStrOrgCode());
            //this.setStrOrgCode(getStrOrgCode().PadLeft(8, '0')/*/*this.getStrOrgCode().Substring(this.getStrOrgCode().Length - 9)*/*/);
            this.setStrBinOrgCode(this.TransformCharacter26Bin(this.getStrOrgCode().PadLeft(9, '0')));
            sb += this.getStrBinOrgCode();

            //4、物资代码指示长度
            sb += this.getStrBinProductcodeLength();
            //5、物资代码 
            //this.setStrHexProductCode("000000000" + this.getStrHexProductCode());
            //this.setStrHexProductCode(getStrHexProductCode().PadLeft(9, '0')/*this.getStrHexProductCode().Substring(this.getStrHexProductCode().Length - 9)*/);
            this.setStrBinProductCode(this.HexString2BinString(this.getStrHexProductCode().PadLeft(9, '0')));
            sb += this.getStrBinProductCode();

            //6、序列号长度
            sb += this.getStrBinSerialLength();
            //7、版本号
            sb += this.getStrBinVersion();
            //8、标签类型
            sb += this.getStrBinTagType();
            //9、包装类型
            sb += this.getStrBinPacktype();

            //生产日期
            ////this.setStrHexScrq("000000" + this.getStrHexScrq());
            //this.setStrHexScrq(this.getStrHexScrq().Substring(this.getStrHexScrq().Length - 6));
            this.setStrBinScrq(this.HexString2BinString(this.getStrHexScrq().PadLeft(6, '0')));
            sb += this.getStrBinScrq();

            //有效期
            this.setStrBinScrq(this.HexString2BinString(this.getStrBinYxq().PadLeft(4, '0')));
            sb += this.getStrBinYxq();

            //10、下级包装数
            this.setStrHexInsidePackNum("00" + this.getStrHexInsidePackNum());
            this.setStrHexInsidePackNum(this.getStrHexInsidePackNum().Substring(this.getStrHexInsidePackNum().Length - 2));
            this.setStrBinInsidePackNum(this.HexString2BinString(this.getStrHexInsidePackNum()));
            sb += this.getStrBinInsidePackNum();
            //11、产品总数量
            this.setStrHexProductNum("000" + this.getStrHexProductNum());
            this.setStrHexProductNum(this.getStrHexProductNum().Substring(this.getStrHexProductNum().Length - 3));
            this.setStrBinProductNum(this.HexString2BinString(this.getStrHexProductNum()));
            sb += this.getStrBinProductNum();
            //12、生产线序列号
            this.setStrHexProductLine("0" + this.getStrHexProductLine());
            this.setStrHexProductLine(this.getStrHexProductLine().Substring(this.getStrHexProductLine().Length - 1));
            this.setStrBinProductLine(this.HexString2BinString(this.getStrHexProductLine()));
            sb += this.getStrBinProductLine();
            //13、产品箱序列号
            this.setStrHexPackSerialNo("000" + this.getStrHexPackSerialNo());
            this.setStrHexPackSerialNo(this.getStrHexPackSerialNo().Substring(this.getStrHexPackSerialNo().Length - 3));
            this.setStrBinPackSerialNo(this.HexString2BinString(this.getStrHexPackSerialNo()));
            sb += this.getStrBinPackSerialNo();
            //14、组别号码
            this.setStrHexGroupNo("0" + this.getStrHexGroupNo());
            this.setStrHexGroupNo(this.getStrHexGroupNo().Substring(this.getStrHexGroupNo().Length - 1));
            this.setStrBinGroupNo(this.HexString2BinString(this.getStrHexGroupNo()));
            sb += this.getStrBinGroupNo();

            //取得校验位
            String rsstr = GetCRCCode(sb);
            //增加校验码
            sb += rsstr;

            String strRet = "";
            if (sb.Length == 196)
            {
                //System.out.print(sb.toString());
                strRet = this.BinString2HexString(sb);
            }

            return strRet;
        }

        public static String GetCRCCode(String sb)
        {
            String tempEpc = sb.ToString();
            //取得2进制长度
            int sourcecodelength = tempEpc.Length;
            //定义取得临时变量
            String rsstr = "";
            //定义数组，长度为被校验位长度
            int[] b = new int[sourcecodelength];
            for (int i = 1; i < sourcecodelength + 1; i++)
            {
                b[i - 1] = int.Parse(tempEpc.Substring(i - 1, 1));
            }
            MyCRC myCRC = new MyCRC();
            int[] rs = myCRC.makeCRCCodes(b, myCRC.index);
            for (int i = 0; i < rs.Length; i++)
            {
                rsstr = rsstr + rs[i];
            }
            return rsstr.Substring(rsstr.Length - 4);
        }

        #endregion
    }

    class MyCRC
    {

        public int[] index = new int[] { 4, 3, 0 };

        public int[] makeCRCCodes(int[] sourceCodes, int[] multinomial)
        {
            int sourceLength = sourceCodes.Length;
            int codesLength = sourceLength + 4;
            int[] crcCodes = new int[codesLength];
            System.Array.Copy(sourceCodes, 0, crcCodes, 0, sourceLength);
            int temp, pos;
            // Division system. 除法器。
            for (int i = 0; i < sourceLength; i++)
            {
                // Count value of the input adding the first register.
                // 用第i位原码和第一个寄存器值模二加。
                temp = (crcCodes[sourceLength] + sourceCodes[i]) % 2;
                // Move registers forwards from (1, length) to (0, length - 1).
                // 第二个寄存器及以后的所有寄存器值前移1位。
                System.Array.Copy(crcCodes, sourceLength + 1, crcCodes,
                        sourceLength, 3);
                // Set the last register with counted value.
                // 最后一个寄存器值存放计算好的输入值。
                crcCodes[codesLength - 1] = temp;
                // Count other registers. 按生成多项式的值算出位置，模二加出该寄存器的值。
                for (int j = index.Length - 2; j > 0; j--)
                {
                    pos = codesLength - multinomial[j] - 1;
                    crcCodes[pos] = (crcCodes[pos] + temp) % 2;
                }
            }
            return crcCodes;
        }

        public bool checkCRC(int[] crccodes)
        {

            int checkindex = 0;
            for (checkindex = 0; checkindex < crccodes.Length - 4; checkindex++)
            {
                if (crccodes[checkindex] == 0)
                {
                    ;
                }
                else break;
            }
            for (; checkindex < crccodes.Length - 4; checkindex++)
            {


                crccodes[checkindex] = 0;
                crccodes[checkindex + 1] = (crccodes[checkindex + 1] + 1) % 2;
                crccodes[checkindex + 4] = (crccodes[checkindex + 4] + 1) % 2;
                for (int j = checkindex; j < crccodes.Length - 4; j++)
                {
                    if (crccodes[j] == 0)
                    {
                        checkindex = j;
                    }
                    else break;
                }
            }

            for (int i = 0; i < crccodes.Length; i++)
            {
                if (crccodes[i] == 1)
                    return false;
            }

            return true;
        }
    }

}
