﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;

namespace JmpZbPrint.Common
{
    public class PrintTypeConvert : IValueConverter
    {
        //当值从绑定源传播给绑定目标时，调用方法Convert
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value == null)
                return DependencyProperty.UnsetValue;
            int.TryParse(value.ToString(), out int type);
            if (type == 0)
            {
                return "打印";
            }
            else
            {
                return "初始化";
            }
        }
        //当值从绑定目标传播给绑定源时，调用此方法ConvertBack
        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string str = value as string;
            if (int.TryParse(str, out int type))
            {
                return type;
            }
            return DependencyProperty.UnsetValue;
        }
    }

}
