﻿using JmpZbPrint.Model;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Reflection;
using System.Security.Cryptography;
using System.Text;
using JmpZbPrint.Common;

namespace JmpZbPrint
{
    /// <summary>
    /// 接口调用类
    /// </summary>
    public class HttpHelper
    {

        public static string GetHttpRqst(string strUrl, string json = "")
        {
            try
            {
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(strUrl);
                request.Method = "POST";
                request.ContentType = "application/json";
                if (!string.IsNullOrEmpty(json))
                {
                    byte[] data = Encoding.UTF8.GetBytes(json);
                    request.ContentLength = data.Length;
                    using (Stream reqStream = request.GetRequestStream())
                    {
                        reqStream.Write(data, 0, data.Length);
                        reqStream.Close();
                    }
                }
                else
                {
                    request.ContentLength = 0;
                }

                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                Stream responseStream = response.GetResponseStream();
                StreamReader streamReader = new StreamReader(responseStream, Encoding.UTF8);
                string retString = streamReader.ReadToEnd();
                streamReader.Close();
                responseStream.Close();
                response.Close();
                return retString;

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n" + strUrl, MethodBase.GetCurrentMethod().Name);
                return string.Empty;
            }
        }

        public static string PostUrlencoded(string strUrl, List<KeyValuePair<string, string>> pushData)
        {
            try
            {
                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(strUrl);
                request.Method = "POST";
                request.ContentType = "application/x-www-form-urlencoded; charset=UTF-8";
                if (pushData.Count > 0)
                {
                    using (Stream reqStream = request.GetRequestStream())
                    {
                        new FormUrlEncodedContent(pushData).CopyToAsync(reqStream).Wait();
                        reqStream.Close();
                    }
                }
                else
                {
                    request.ContentLength = 0;
                }

                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                Stream responseStream = response.GetResponseStream();
                StreamReader streamReader = new StreamReader(responseStream, Encoding.UTF8);
                string retString = streamReader.ReadToEnd();
                streamReader.Close();
                responseStream.Close();
                response.Close();
                return retString;

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n" + strUrl, MethodBase.GetCurrentMethod().Name);
                return string.Empty;
            }
        }

        /// <summary>
        /// 用户登录
        /// </summary>
        /// <param name="userName"></param>
        /// <param name="userPwd"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static respone_user UserLogin(string userName, string userPwd, out string msg)
        {
            try
            {
                var param = JsonConvert.SerializeObject(new { username = userName, password = userPwd });
                Log.ErrorLog("UserLogin:" + CaChe.SysConfig.UserLogin + " param:" + param);
                var json = GetHttpRqst(CaChe.SysConfig.UserLogin, param);
                if (string.IsNullOrEmpty(json))
                {
                    msg = "登录失败";
                    return default;
                }
                else
                {
                    var res_data = JObject.Parse(json);

                    var jobj = JObject.Parse(json);
                    if (!jobj.HasValues)
                    {
                        msg = "登录异常";
                        return default;
                    }
                    else
                    {
                        msg = "登录成功";
                        var user = JsonConvert.DeserializeObject<respone_user>(json);
                        return user;

                    }
                }

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = "请求异常";
                return default;
            }

        }

        /// <summary>
        /// 获取更新信息
        /// </summary>
        /// <param name="appCode"></param>
        /// <returns></returns>
        public static respone_update GetUpdate(string appCode)
        {
            var parame = JsonConvert.SerializeObject(new
            {
                appCode = appCode
            });
            var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.SoftUpdate, parame);
            if (string.IsNullOrEmpty(json))
            {
                Log.DebugLog("获取更新信息失败", "更新失败");
                return default;
            }
            else
            {
                var res_data = JsonConvert.DeserializeObject<respone_head<respone_update>>(json);
                if (res_data == null || res_data.code != 10000)
                {
                    Log.DebugLog("获取更新信息失败", "更新失败");
                    return default;
                }
                else
                {
                    Log.DebugLog("获取更新信息成功", "更新成功");
                    return res_data.data;
                }
            }

        }

        /// <summary>
        /// 供应商获取
        /// </summary>
        /// <returns></returns>
        public static List<Supplier> GetAllSupplier()
        {
            try
            {
                var body_par = string.Empty;
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return null;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GetAllSupplier, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("供应商列表获取失败", "请求失败");
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<respone_supplier>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {
                            Log.DebugLog("供应商列表获取失败", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return res_data.data.record;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                return default;
            }

        }

        /// <summary>
        /// 装备列表获取
        /// </summary>
        /// <returns></returns>
        public static List<EquInfo> GetAllEqu()
        {
            try
            {
                var body_par = string.Empty;
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return null;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GetAllEqu, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("装备列表获取失败", "请求失败");
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<List<EquInfo>>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {
                            Log.DebugLog("装备列表获取失败", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return res_data.data;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                return default;
            }

        }

        /// <summary>
        /// 装备属性获取
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static EquAttr GetEquInfoById(string id)
        {
            try
            {
                var body_par = JsonConvert.SerializeObject(new
                {
                    id = id
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return null;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GetEquInfo, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("装备属性获取失败", "请求失败");
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<EquAttr>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {
                            Log.DebugLog("装备属性获取失败", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return res_data.data;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                return default;
            }

        }

        /// <summary>
        /// 仓库列表获取
        /// </summary>
        /// <returns></returns>
        public static List<WarehouseInfo> GetWarehouse()
        {
            try
            {
                var body_par = JsonConvert.SerializeObject(new
                {
                    orgizationId = CaChe.UserInfo.baseJpOrganization.id
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return null;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GetWarehouse, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("仓库获取失败", "请求失败");
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<List<WarehouseInfo>>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {
                            Log.DebugLog("仓库获取失败", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return res_data.data;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                return default;
            }

        }

        /// <summary>
        /// 根据仓库id获取货架
        /// </summary>
        /// <param name="warehouseId"></param>
        /// <returns></returns>
        public static List<ShelfInfo> GetShelfByWarehouseId(string warehouseId)
        {
            try
            {
                var body_par = JsonConvert.SerializeObject(new
                {
                    warehouseId = warehouseId
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return null;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GetListShelf, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("货架获取失败", "请求失败");
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<List<ShelfInfo>>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {
                            Log.DebugLog("货架获取失败", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return res_data.data;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                return default;
            }

        }

        /// <summary>
        /// 获取指定物资类型存放位置
        /// </summary>
        /// <param name="warehouseId"></param>
        /// <param name="equipmentDetailId"></param>
        /// <param name="sizeId"></param>
        /// <returns></returns>
        public static List<ShelfInfo> GetListEquipmentShelfPosition(string warehouseId, string equipmentDetailId, string sizeId)
        {
            try
            {
                var body_par = JsonConvert.SerializeObject(new
                {
                    warehouseId = warehouseId,
                    equipmentDetailId = equipmentDetailId,
                    sizeId = sizeId,
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return null;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GetListEquipmentShelfPosition, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("装备存放货架位置获取失败", "请求失败");
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<List<ShelfInfo>>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {
                            Log.DebugLog("装备存放货架位置获取失败", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return res_data.data;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                return default;
            }

        }


        /// <summary>
        /// 获取打印任务
        /// </summary>
        /// <param name="epcType">epc类型 0:全部 1：件标 2：箱标</param>
        /// <param name="labelType"></param>
        /// <param name="pageIndex"></param>
        /// <param name="vendorName"></param>
        /// <param name="productName"></param>
        /// <returns></returns>
        public static respone_print GetPrintList(int epcType, LabelType labelType, int pageIndex = 1, string vendorName = "", string productName = "")
        {
            try
            {
                var body_par = JsonConvert.SerializeObject(new
                {
                    epcType = epcType,
                    orgId = CaChe.UserInfo.baseJpOrganization.id,
                    printState = 0,
                    labelType = (int)labelType,
                    vendorName,
                    productName,
                    page = pageIndex - 1,
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return null;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GetPrintList, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("打印任务获取失败", "请求失败");
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<respone_print>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {
                            Log.DebugLog("打印任务获取失败", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return res_data.data;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                return default;
            }
        }

        /// <summary>
        /// 订单列表获取
        /// </summary>
        /// <param name="_orderCode"></param>
        /// <param name="_equName"></param>
        /// <returns></returns>
        public static respone_order GetOrderList(string _orderCode, string _equName)
        {
            try
            {
                var body_par = JsonConvert.SerializeObject(new
                {
                    orgId = CaChe.UserInfo.baseJpOrganization.id,
                    orderCode = _orderCode,
                    equName = _equName
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return null;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.OrderList, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("订单列表获取失败", "请求失败");
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<respone_order>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {
                            Log.DebugLog("订单列表获取失败", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return res_data.data;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                return default;
            }

        }

        /// <summary>
        /// EPC判断是否已经被打印/绑定过
        /// </summary>
        /// <param name="epc"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static bool CheckEpcIsInstantiation(string epc, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    epc = epc
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return false;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.CheckEpcIsInstantiation, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("网络异常", "请求失败");
                        msg = "网络异常";
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<object>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data.msg;
                            Log.DebugLog($"绑定失败,{msg}", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return true;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return false;
            }
        }

        /// <summary>
        /// 根据采购单信息生成EPC
        /// </summary>
        /// <param name="infos"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static bool GenerateExtTagEpc(request_ext_info infos, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(infos);
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return false;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GenExtTagEpc, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("网络异常", "请求失败");
                        msg = "网络异常";
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<object>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data.msg;
                            Log.DebugLog($"EPC生成失败,{msg}", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return true;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return false;
            }
        }

        /// <summary>
        /// EPC状态更新
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static Tuple<bool, string> UpdateEpc(string id)
        {
            try
            {
                var body_par = JsonConvert.SerializeObject(new
                {
                    id = id,
                    isDirectEntryStock = CaChe.SysConfig.IsDirectEntryStock
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return new Tuple<bool, string>(false, "签名值生成失败");
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.UpdateEpc, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("EPC状态更新失败", "请求失败");
                        return new Tuple<bool, string>(false, "请求失败，网络异常");
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<string>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {
                            Log.DebugLog(res_data?.msg, "请求失败");
                            return new Tuple<bool, string>(false, res_data?.msg);
                        }
                        else
                        {
                            Log.DebugLog("EPC状态更新成功", "请求成功");
                            return new Tuple<bool, string>(true, "EPC状态更新成功");
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                return new Tuple<bool, string>(false, "EPC状态更新异常");
            }

        }

        /// <summary>
        /// 直接创建装备
        /// </summary>
        /// <param name="recode"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static bool GenerateInventory(recode_info recode, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    sizeId = recode.sizeId,
                    equId = recode.equId,
                    epc = recode.epc,
                    supplierId = recode.supplierId,
                    warehouseId = recode.warehouseId,
                    productTime = recode.productTime,
                    useTime = recode.useTime,
                    warrantyCycle = recode.warrantyCycle,
                    price = recode.price,
                    repairCycle = recode.repairCycle,
                    isUnboxingLabel = recode.IsUnboxingLabel,
                    shelfId = recode.ShelfId,
                    shelfRange = recode.ShelfRange,
                    shelfRow = recode.ShelfRow,
                    shelfColumn = recode.ShelfColumn,
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return false;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GenInventory, param);

                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("写入库存失败:网络异常", "请求失败");
                        msg = "网络异常";
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<respone_order>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data?.msg;
                            Log.DebugLog($"写入库存失败,{msg}", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return true;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return false;
            }
        }

        /// <summary>
        /// 直接创建装备(批量)
        /// </summary>
        /// <param name="recode"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static bool GenerateRangeInventory(recode_info recode, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    epc = recode.epc,
                    sizeId = recode.sizeId,
                    equId = recode.equId,
                    epcListJson = recode.epcListJson,
                    supplierId = recode.supplierId,
                    warehouseId = recode.warehouseId,
                    productTime = recode.productTime,
                    useTime = recode.useTime,
                    warrantyCycle = recode.warrantyCycle,
                    price = recode.price,
                    repairCycle = recode.repairCycle,
                    isReloadBoxing = recode.IsReloadBoxing,
                    shelfId = recode.ShelfId,
                    shelfRange = recode.ShelfRange,
                    shelfRow = recode.ShelfRow,
                    shelfColumn = recode.ShelfColumn,

                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return false;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GenRangeInventory, param);

                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("写入库存失败", "请求失败");
                        msg = "网络异常";
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<respone_order>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data?.msg;
                            Log.DebugLog($"写入库存失败,{msg}", "请求失败");
                            return default;
                        }
                        else
                        {
                            msg = res_data.msg;
                            Log.WorkLog(json, "[JSON]");
                            return true;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return false;
            }
        }

        /// <summary>
        /// 物资装箱（后台版）
        /// </summary>
        /// <param name="boxMarkEpc"></param>
        /// <param name="infos"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static bool BoxingInventory(string boxMarkEpc, List<recode_info> infos, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    boxMarkEpc = boxMarkEpc,
                    invList = infos.Select(x => new
                    {
                        sizeId = x.sizeId,
                        equId = x.equId,
                        epc = x.epc,
                        supplierId = x.supplierId,
                        warehouseId = x.warehouseId,
                        productTime = x.productTime,
                        warrantyCycle = x.warrantyCycle,
                        price = x.price,
                        useTime = x.useTime,
                        repairCycle = x.repairCycle,
                        isUnboxingLabel = x.IsUnboxingLabel,
                        shelfId = x.ShelfId,
                        shelfRange = x.ShelfRange,
                        shelfRow = x.ShelfRow,
                        shelfColumn = x.ShelfColumn,
                    })
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return false;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.BoxingInventory, param);

                    if (string.IsNullOrEmpty(json))
                    {
                        msg = "网络异常";
                        Log.DebugLog("写入库存失败", "请求失败");
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<respone_order>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data.msg;
                            Log.DebugLog($"写入库存失败,{msg}", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return true;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return false;
            }
        }

        /// <summary>
        /// 物资装箱（一般版）
        /// </summary>
        /// <param name="boxMarkEpc"></param>
        /// <param name="infos"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static bool BoxingInventoryNormalVersion(string boxMarkEpc, List<print_info> infos, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    boxMarkEpc = boxMarkEpc,
                    policeId = CaChe.UserInfo.policeman?.id ?? "",
                    invList = infos.Select(x => new
                    {
                        sizeId = x.sizeId,
                        equId = x.productId,
                        epc = x.epc,
                        supplierId = x.supplierId,
                        warehouseId = x.warehouseId,
                        productTime = x.productTime,
                        warrantyCycle = x.warrantyCycle,
                        price = x.price,
                        useTime = x.useTime,
                        repairCycle = x.repairCycle,
                        isUnboxingLabel = x.isUnboxingLabel
                    })
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return false;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.BoxingInventoryNormalVersion, param);

                    if (string.IsNullOrEmpty(json))
                    {
                        msg = "网络异常";
                        Log.DebugLog("写入库存失败", "请求失败");
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<respone_order>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data.msg;
                            Log.DebugLog($"写入库存失败,{msg}", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return true;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return false;
            }
        }

        /// <summary>
        /// 物资拆箱
        /// </summary>
        /// <param name="boxMarkEpc"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static bool UnpackRangeInventory(string boxMarkEpc, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    epc = boxMarkEpc,
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    Log.WorkLog("签名值生成失败。");
                    return false;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.UnpackRangeInventory, param);

                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("写入库存失败", "请求失败");
                        msg = "网络异常";
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<respone_order>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data.msg;
                            Log.DebugLog($"写入库存失败,{msg}", "请求失败");
                            return default;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return true;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return false;
            }
        }

        /// <summary>
        /// 直接报废EPC（删除）
        /// </summary>
        /// <param name="epc"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static bool DeleteEpc(string epc, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    epc = epc,
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    msg = "签名值生成失败";
                    Log.WorkLog("签名值生成失败。");
                    return false;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.DelEpc, param);

                    if (string.IsNullOrEmpty(json))
                    {
                        msg = "网络异常";
                        Log.DebugLog("删除库存失败", "删除失败");
                        return default;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<respone_order>>(json);
                        if (res_data != null && res_data.msg.Contains("无效EPC"))
                        {
                            Log.WorkLog("EPC不在库中，删除本地库的EPC");
                            return true;
                        }
                        else if (res_data != null && res_data.code == 10000)
                        {
                            Log.WorkLog(json, "[JSON]");
                            return true;

                        }
                        else
                        {
                            msg = res_data.msg;
                            Log.DebugLog($"删除库存失败,{msg}", "请求失败");
                            return default;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return false;
            }
        }

        /// <summary>
        /// 直接报废箱标EPC（包括箱内物资）
        /// </summary>
        /// <param name="boxMarkEpc"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static bool DeleteEpcList(string boxMarkEpc, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    boxMarkEpc = boxMarkEpc,
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    msg = "签名值生成失败";
                    Log.WorkLog("签名值生成失败。");
                    return false;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.DelEpcList, param);

                    if (string.IsNullOrEmpty(json))
                    {
                        msg = "网络异常";
                        Log.DebugLog("删除库存失败", "删除失败");
                        return false;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<respone_order>>(json);
                        if (res_data != null && res_data.msg.Contains("无效EPC"))
                        {
                            Log.WorkLog("EPC不在库中，删除本地库的EPC");
                            return true;
                        }
                        else if (res_data != null && res_data.code == 10000)
                        {
                            Log.WorkLog(json, "[JSON]");
                            return true;

                        }
                        else
                        {
                            msg = res_data.msg;
                            Log.DebugLog($"删除库存失败,{msg}", "请求失败");
                            return false;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return false;
            }
        }

        /// <summary>
        /// 导入旧版箱标物资（废弃）
        /// </summary>
        /// <param name="infos"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static Tuple<bool, respone_import_old_data> ImportOldBoxMark(List<recode_info> infos, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    dataList = infos.Select(x => new
                    {
                        boxMarkEpc = x.epc,
                        epcListJson = x.epcListJson
                    })
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    msg = "签名值生成失败";
                    Log.WorkLog("签名值生成失败。");
                    return new Tuple<bool, respone_import_old_data>(false, null);
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.ImportOldBoxMark, param);

                    if (string.IsNullOrEmpty(json))
                    {
                        msg = "网络异常";
                        Log.DebugLog("导入旧箱标数据失败", "操作失败");
                        return new Tuple<bool, respone_import_old_data>(false, null);
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<respone_import_old_data>>(json);
                        if (res_data != null && res_data.code == 10000)
                        {
                            msg = $"导入成功{res_data.data.successList.Count}条，失败{res_data.data.failList.Count}条";
                            if (res_data.data.failList.Count > 0)
                            {
                                foreach (var obj in res_data.data.failList)
                                {
                                    msg += $"\nepc:{obj.epc} 失败原因：{obj.message}";
                                }
                            }
                            return new Tuple<bool, respone_import_old_data>(true, res_data.data);
                        }
                        else
                        {
                            msg = res_data.msg;
                            Log.DebugLog($"导入旧箱标数据失败,{msg} json:{json}", "请求失败");
                            return new Tuple<bool, respone_import_old_data>(false, null);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return new Tuple<bool, respone_import_old_data>(false, null);
            }
        }

        /// <summary>
        /// 直接生成EPC(只生成EPC)
        /// </summary>
        /// <param name="infos"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static Tuple<bool, List<respone_epc>> GenerateIntTagEpc(request_int_info infos, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(infos);
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    msg = "签名值生成失败";
                    Log.WorkLog("签名值生成失败。");
                    return new Tuple<bool, List<respone_epc>>(false, default);
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GenIntTagEpc, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("EPC生成失败", "请求失败");
                        msg = "网络异常";
                        return new Tuple<bool, List<respone_epc>>(false, default);
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<List<respone_epc>>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data.msg;
                            Log.DebugLog($"EPC生成失败,{msg}", "请求失败");
                            return new Tuple<bool, List<respone_epc>>(false, default);
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return new Tuple<bool, List<respone_epc>>(true, res_data.data);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return new Tuple<bool, List<respone_epc>>(false, default);
            }
        }

        /// <summary>
        /// 通过箱标epc获取件标详细信息
        /// </summary>
        /// <param name="boxMarkEpc"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static Tuple<bool, List<respone_inventory>> GetInventoryListByBoxMarkEpc(string boxMarkEpc, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    epc = boxMarkEpc
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    msg = "签名值生成失败";
                    Log.WorkLog("签名值生成失败。");
                    return new Tuple<bool, List<respone_inventory>>(false, default);
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GetInventoryListByBoxMarkEpc, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("物资获取失败", "请求失败");
                        return new Tuple<bool, List<respone_inventory>>(false, default);
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<List<respone_inventory>>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data.msg;
                            Log.DebugLog($"物资获取失败,{msg}", "请求失败");
                            return new Tuple<bool, List<respone_inventory>>(false, default);
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return new Tuple<bool, List<respone_inventory>>(true, res_data.data);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return new Tuple<bool, List<respone_inventory>>(false, default);
            }
        }

        /// <summary>
        /// 获取箱标列表
        /// </summary>
        /// <param name="orgId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static Tuple<bool, List<respone_boxMark>> GetBoxMarkList(string orgId, string warehouseId, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    orgId = orgId,
                    warehouseId = warehouseId
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    msg = "签名值生成失败";
                    Log.WorkLog("签名值生成失败。");
                    return new Tuple<bool, List<respone_boxMark>>(false, default);
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GetBoxMarkList, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("订单列表获取失败", "请求失败");
                        return new Tuple<bool, List<respone_boxMark>>(false, default);
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<List<respone_boxMark>>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data.msg;
                            Log.DebugLog($"EPC生成失败,{msg}", "请求失败");
                            return new Tuple<bool, List<respone_boxMark>>(false, default);
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return new Tuple<bool, List<respone_boxMark>>(true, res_data.data);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return new Tuple<bool, List<respone_boxMark>>(false, default);
            }
        }

        /// <summary>
        /// 获取箱标打印任务
        /// </summary>
        /// <param name="orgId"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static Tuple<bool, List<respone_boxMark>> GetNeedPrintBoxMarkList(string orgId, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    orgId = orgId
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    msg = "签名值生成失败";
                    Log.WorkLog("签名值生成失败。");
                    return new Tuple<bool, List<respone_boxMark>>(false, default);
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GetNeedPrintBoxMarkList, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("订单列表获取失败", "请求失败");
                        return new Tuple<bool, List<respone_boxMark>>(false, default);
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<List<respone_boxMark>>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data.msg;
                            Log.DebugLog($"EPC生成失败,{msg}", "请求失败");
                            return new Tuple<bool, List<respone_boxMark>>(false, default);
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return new Tuple<bool, List<respone_boxMark>>(true, res_data.data);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return new Tuple<bool, List<respone_boxMark>>(false, default);
            }
        }

        /// <summary>
        /// 获取装备包打印任务
        /// </summary>
        /// <param name="orgId"></param>
        /// <param name="bagName"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static Tuple<bool, List<respone_bagInventory>> GetPrintBagList(string orgId, string bagName, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    orgId = orgId,
                    bagName = bagName
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    msg = "签名值生成失败";
                    Log.WorkLog("签名值生成失败。");
                    return new Tuple<bool, List<respone_bagInventory>>(false, default);
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.GetPrintBagList, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("订单列表获取失败", "请求失败");
                        return new Tuple<bool, List<respone_bagInventory>>(false, default);
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<List<respone_bagInventory>>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data.msg;
                            Log.DebugLog($"EPC生成失败,{msg}", "请求失败");
                            return new Tuple<bool, List<respone_bagInventory>>(false, default);
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return new Tuple<bool, List<respone_bagInventory>>(true, res_data.data);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return new Tuple<bool, List<respone_bagInventory>>(false, default);
            }
        }

        /// <summary>
        /// 装备包EPC状态更新
        /// </summary>
        /// <param name="id"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static bool UpdateBagState(string id, out string msg)
        {
            try
            {
                msg = string.Empty;
                var body_par = JsonConvert.SerializeObject(new
                {
                    id
                });
                var body_result = GetBody(body_par);
                if (body_result == null)
                {
                    msg = "签名值生成失败";
                    Log.WorkLog("签名值生成失败。");
                    return false;
                }
                else
                {
                    var param = JsonConvert.SerializeObject(new request_sign
                    {
                        appKey = CaChe.SysConfig.AppKey,
                        body = body_result.Item1,
                        sign = body_result.Item2,
                        timestamp = body_result.Item3,
                        version = CaChe.SysConfig.ApiVersion,
                        orgId = CaChe.UserInfo?.baseJpOrganization?.id ?? "",
                    });
                    var json = GetHttpRqst(CaChe.SysConfig.DomainUrl + UrlConfig.UpdateBagState, param);
                    if (string.IsNullOrEmpty(json))
                    {
                        Log.DebugLog("更新失败", "请求失败");
                        return false;
                    }
                    else
                    {
                        var res_data = JsonConvert.DeserializeObject<respone_head<List<respone_bagInventory>>>(json);
                        if (res_data == null || res_data.code != 10000)
                        {

                            msg = res_data.msg;
                            Log.DebugLog($"更新失败,{msg}", "请求失败");
                            return false;
                        }
                        else
                        {
                            Log.WorkLog(json, "[JSON]");
                            return true;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString() + "\r\n", MethodBase.GetCurrentMethod().Name);
                msg = ex.InnerException?.Message ?? ex.Message ?? "";
                return false;
            }
        }

        /// <summary>
        /// http下载文件
        /// </summary>
        /// <param name="url">下载文件地址</param>
        /// <param name="path">文件存放地址，包含文件名</param>
        /// <returns></returns>
        public static bool HttpDownload(string url, string path)
        {
            string tempPath = System.IO.Path.GetDirectoryName(path) + @"\temp";
            System.IO.Directory.CreateDirectory(tempPath);  //创建临时文件目录
            string tempFile = tempPath + @"\" + System.IO.Path.GetFileName(path) + ".temp"; //临时文件
            if (System.IO.File.Exists(tempFile))
            {
                System.IO.File.Delete(tempFile);    //存在则删除
            }
            try
            {
                FileStream fs = new FileStream(tempFile, FileMode.Append, FileAccess.Write, FileShare.ReadWrite);
                // 设置参数
                HttpWebRequest request = WebRequest.Create(url) as HttpWebRequest;
                //发送请求并获取相应回应数据
                HttpWebResponse response = request.GetResponse() as HttpWebResponse;
                //直到request.GetResponse()程序才开始向目标网页发送Post请求
                Stream responseStream = response.GetResponseStream();
                //创建本地文件写入流
                //Stream stream = new FileStream(tempFile, FileMode.Create);
                byte[] bArr = new byte[1024];
                int size = responseStream.Read(bArr, 0, (int)bArr.Length);
                while (size > 0)
                {
                    //stream.Write(bArr, 0, size);
                    fs.Write(bArr, 0, size);
                    size = responseStream.Read(bArr, 0, (int)bArr.Length);
                }
                //stream.Close();
                fs.Close();
                responseStream.Close();
                System.IO.File.Move(tempFile, path);
                return true;
            }
            catch (Exception ex)
            {
                return false;
            }
        }

        /// <summary>
        /// 获取文件的MD5码
        /// </summary>
        /// <param name="fileName">传入的文件名（含路径及后缀名）</param>
        /// <returns></returns>
        public static string GetMD5HashFromFile(string fileName)
        {
            try
            {
                FileStream file = new FileStream(fileName, System.IO.FileMode.Open);
                MD5 md5 = new MD5CryptoServiceProvider();
                byte[] retVal = md5.ComputeHash(file);
                file.Close();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < retVal.Length; i++)
                {
                    sb.Append(retVal[i].ToString("x2"));
                }
                return sb.ToString();
            }
            catch (Exception ex)
            {
                throw new Exception("GetMD5HashFromFile() fail,error:" + ex.Message);
            }
        }

        private static Tuple<string, string, string> GetBody(string json)
        {
            try
            {
                var timespan = GetTimeStamp();
                var body = System.Web.HttpUtility.UrlEncode(json);
                var content = $"{CaChe.SysConfig.SecretKey}{timespan}{CaChe.SysConfig.ApiVersion}{body}";
                var sign = GetMd5(content);
                return new Tuple<string, string, string>(body, sign, timespan);
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString());
                return null;
            }
        }
        private static string GetMd5(string txt)
        {
            //初始化MD5对象
            using (MD5 md5 = MD5.Create())
            {
                //将源字符串转化为byte数组
                byte[] soucebyte = Encoding.UTF8.GetBytes(txt);
                //soucebyte转化为mf5的byte数组
                byte[] md5bytes = md5.ComputeHash(soucebyte);
                //将md5的byte数组再转化为MD5数组
                StringBuilder sb = new StringBuilder();
                foreach (byte b in md5bytes)
                {
                    //x表示16进制，2表示2位
                    sb.Append(b.ToString("x2"));
                }
                return sb.ToString();
            }
        }
        private static string GetTimeStamp()
        {
            TimeSpan ts = DateTime.UtcNow - new DateTime(1970, 1, 1, 0, 0, 0, 0);
            return Convert.ToInt64(ts.TotalSeconds).ToString();
        }

    }

}
