﻿using System;
using System.Diagnostics;
using System.Reflection;
using System.Windows;
using JmpZbPrint.Common;
using JmpZbPrint.View;

namespace JmpZbPrint
{
    /// <summary>
    /// App.xaml 的交互逻辑
    /// </summary>
    public partial class App : Application
    {
        private void Application_Startup(object sender, StartupEventArgs e)
        {
            // 获取当前活动进程的模块名称
            string moduleName = Process.GetCurrentProcess().MainModule.ModuleName;
            //返回指定路径字符串的文件名
            string processName = System.IO.Path.GetFileNameWithoutExtension(moduleName);
            //根据文件名创建进程资源数组
            Process[] processes = Process.GetProcessesByName(processName);
            //如果该数组长度大于1，说明多次运行
            if (processes.Length > 1)
            {
                MessageBox.Show("已有另一个程序在运行！", "提示", MessageBoxButton.OK, MessageBoxImage.Information);//弹出提示信息
                Process.GetCurrentProcess().Kill();
            }
            else
            {
                CaChe.SysConfig = CaChe.LoadSystemStep();
                if (CaChe.SysConfig == null)
                {
                    //MessageBox.Show("配置文件加载失败，请检查", "文件错误", MessageBoxButton.OK, MessageBoxImage.Error);
                    //Process.GetCurrentProcess().Kill();
                    MessageBox.Show("配置文件加载失败，创建默认配置文件");
                    CaChe.SysConfig = new Config();
                    CaChe.SaveSystemStep(CaChe.SysConfig);
                }
                else
                {
                    var _update = HttpHelper.GetUpdate(CaChe.SysConfig?.AppCode ?? "");
                    if (_update == null)
                    {
                        return;
                    }
                    else
                    {
                        if (Version.TryParse(_update.version2, out var version) && version > new Version(CaChe.SysConfig.AppVersion))
                        {
                            if (MessageBox.Show("检测到新版本，是否更新？", "更新提示", MessageBoxButton.YesNo, MessageBoxImage.Question) == MessageBoxResult.Yes)
                            {
                                System.Diagnostics.Process.Start("explorer.exe", CaChe.SysConfig.DomainUrl.TrimEnd('/') + "/" + _update.address.TrimStart('/'));
                                Process.GetCurrentProcess().Kill();
                            }
                            else { }
                        }
                    }

                    //获取供应商
                    //CaChe.Suppliers = HttpHelper.GetAllSupplier();
                }
            }
        }

        private void Application_DispatcherUnhandledException(object sender, System.Windows.Threading.DispatcherUnhandledExceptionEventArgs e)
        {
            Log.ErrorLog(e.Exception.ToString(), MethodBase.GetCurrentMethod().Name);
        }
    }
}
