﻿using Fleck;
using JmpRfidLp;
using JmpZbModel;
using Newtonsoft.Json;
//using rfidLink.Extend;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration;
using System.Data;
using System.Diagnostics;
using System.Globalization;
using System.IO;
using System.IO.Ports;
using System.Linq;
using System.Reflection;
using System.Runtime.Remoting.Messaging;
using System.ServiceProcess;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Markup;
using System.Windows.Shell;

namespace JmpUhfService
{
    public partial class JmpUhfService : ServiceBase
    {
        public JmpUhfService()
        {
            InitializeComponent();
        }

        //private LinkageExtend link = new LinkageExtend();
        //private List<rfidLink.Extend.RadioInformation> radios;
        private IReaderHelper reader;
        private JmpRfidLpReaderHelper reader1;
        private USBRFIDReaderHelper reader2;
        private Task taskDevice;
        private CancellationTokenSource cDeviceToken;
        private WebSocketServer server;
        private Dictionary<string, LinkInfo> dic_client = new Dictionary<string, LinkInfo>();
        private List<string> epcList = new List<string>();
        private object syncObj = new object();
        private DeviceStatus deviceStatus = DeviceStatus.未连接;
        private AutoResetEvent resetEvent = new AutoResetEvent(false);
        private string used_client = string.Empty;
        protected override void OnStart(string[] args)
        {
            try
            {
                StartWs();

                //建立轮询线程
                cDeviceToken = new CancellationTokenSource();
                taskDevice = new Task(LinkDevice);
                taskDevice.Start();

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }

        }
        public void TestService()
        {
            OnStart(default);
        }
        protected override void OnStop()
        {
            try
            {
                resetEvent.Set();
                cDeviceToken?.Cancel();
                StopInv();
                server?.Dispose();
                if (reader?.IsOpen() ?? false)
                {
                    reader?.Close();
                }
                reader = null;
                Process.GetCurrentProcess().Kill();
            }
            catch { }
        }
        protected override void OnShutdown()
        {
            try
            {
                resetEvent.Set();
                cDeviceToken?.Cancel();
                StopInv();
                server?.Dispose();
                if (reader?.IsOpen() ?? false)
                {
                    reader?.Close();
                }
                reader = null;
                Process.GetCurrentProcess().Kill();
            }
            catch { }
        }

        #region ws server method
        protected void OnSendMsg(string client, InitializeCmdType cmdType, string msg)
        {
            try
            {
                if (dic_client.ContainsKey(client))
                {
                    var ws_connection = dic_client[client];
                    if (ws_connection != null)
                    {
                        InitializeCmdInfo cmdInfo = new InitializeCmdInfo()
                        {
                            CmdType = cmdType,
                            Content = msg
                        };
                        ws_connection.Connection.Send(JsonConvert.SerializeObject(cmdInfo));
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }
        protected void OnSendMsg(IWebSocketConnection client, InitializeCmdType cmdType, string msg)
        {
            try
            {
                if (client != null)
                {
                    InitializeCmdInfo cmdInfo = new InitializeCmdInfo()
                    {
                        CmdType = cmdType,
                        Content = msg
                    };
                    client.Send(JsonConvert.SerializeObject(cmdInfo));
                }

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }
        protected void OnSendBusy(IWebSocketConnection client)
        {
            try
            {
                if (client != null)
                {
                    InitializeCmdInfo cmdInfo = new InitializeCmdInfo()
                    {
                        CmdType = InitializeCmdType.Busy,
                        Content = "设备正忙，请检查设备是否被占用"
                    };
                    client.Send(JsonConvert.SerializeObject(cmdInfo));
                }

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }

        /// <summary>
        /// 接受客户端数据
        /// </summary>
        /// <param name="client"></param>
        /// <param name="message"></param>
        protected void OnReciveData(string client, string message, IWebSocketConnection connection)
        {
            try
            {
                if (client == used_client)
                {
                    InitializeCmdInfo cmd = JsonConvert.DeserializeObject<InitializeCmdInfo>(message);
                    if (cmd == null)
                    {
                        OnSendMsg(client, InitializeCmdType.Initialize, "操作失败，不正确的指令");
                    }
                    else if (deviceStatus == DeviceStatus.未连接)
                    {
                        OnSendMsg(client, InitializeCmdType.Initialize, "操作失败，设备未连接");
                    }
                    else
                    {
                        switch (cmd.CmdType)
                        {
                            case InitializeCmdType.StartInventory:
                                StartInv(client);
                                break;
                            case InitializeCmdType.StopInventory:
                                StopInv();
                                break;
                            case InitializeCmdType.Initialize:
                                InitializeEpc(client, cmd.Content);
                                break;
                            case InitializeCmdType.ReadInventorySingle:
                                ReadInventorySingle(client);
                                break;
                            case InitializeCmdType.InitializeV2:
                                InitializeEpcV2(client, cmd.Content);
                                break;
                        }
                    }
                }
                else
                {
                    OnSendBusy(connection);
                }

            }
            catch (Exception ex)
            {
                SendLinkError(client);
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }

        /// <summary>
        /// 启动Ws服务
        /// </summary>
        /// <param name="strPort"></param>
        protected void StartWs(string strPort = "8081")
        {
            server = new WebSocketServer($"ws://0.0.0.0:{strPort}");
            server.Start(socket =>
            {
                socket.OnOpen = () =>
                {
                    OnNewConnection($"{socket.ConnectionInfo.ClientIpAddress}:{socket.ConnectionInfo.ClientPort}", socket);
                };
                socket.OnClose = () =>
                {
                    OnDisConnection($"{socket.ConnectionInfo.ClientIpAddress}:{socket.ConnectionInfo.ClientPort}");
                };
                socket.OnMessage = message =>
                {
                    OnReciveData($"{socket.ConnectionInfo.ClientIpAddress}:{socket.ConnectionInfo.ClientPort}", message, socket);
                };
            });
        }
        /// <summary>
        ///客户端连入
        /// </summary>
        /// <param name="client"></param>
        /// <param name="connectionInfo"></param>
        protected void OnNewConnection(string client, IWebSocketConnection connectionInfo)
        {
            if (used_client == string.Empty || dic_client.Count == 0)
            {
                used_client = client;
                dic_client.Add(client, new LinkInfo { Connection = connectionInfo, LinkDate = DateTime.Now });
                if (deviceStatus == DeviceStatus.已连接)
                {
                    SendLinked(used_client);
                }
                else
                {
                    SendLinkError(client);
                }
            }
            else
            {
                if (!dic_client.ContainsKey(client))
                {
                    dic_client.Add(client, new LinkInfo { Connection = connectionInfo, LinkDate = DateTime.Now });
                }
                OnSendBusy(connectionInfo);
            }
        }

        /// <summary>
        /// 客户端断开
        /// </summary>
        /// <param name="client"></param>
        protected void OnDisConnection(string client)
        {
            if (dic_client.ContainsKey(client))
            {
                dic_client.Remove(client);
            }

            if (!string.IsNullOrEmpty(used_client) && client == used_client)
            {
                StopInv();
                used_client = string.Empty;
                var next_client = dic_client.ToList().OrderBy(t => t.Value.LinkDate).FirstOrDefault();
                if (next_client.Value?.Connection != null)
                {
                    used_client = next_client.Value.Connection.ConnectionInfo.ClientIpAddress + ":" + next_client.Value.Connection.ConnectionInfo.ClientPort;
                    if (deviceStatus == DeviceStatus.已连接)
                    {
                        SendLinked(used_client);
                    }
                    else
                    {
                        SendLinkError(used_client);
                    }
                }
            }

        }

        #endregion

        #region epc initialize method
        protected void InitializeEpc(string client, string json)
        {
            if (deviceStatus == DeviceStatus.已连接)
            {
                var data = JsonConvert.DeserializeObject<InitializeModel>(json);
                if (data == null)
                {
                    OnSendMsg(client, InitializeCmdType.Initialize, "绑定失败，非法数据");
                }
                else
                {
                    //将EPC长度改成位字符串
                    //48/6400
                    //24/3400
                    //64/8000

                    //先停止盘点，否则会卡死。
                    reader.InventoryStop();

                    //单次盘点，确认无其他标签
                    var tmpList = new List<TagInfoData>();
                    for (int i = 0; i < 4; i++)
                    {
                        reader.InventorySingle().ForEach(s =>
                        {
                            if (!tmpList.Any(t => t.EPC == s.EPC))
                            {
                                tmpList.Add(s);
                            }
                        });
                    }

                    if (tmpList.Count > 1)
                    {
                        OnSendMsg(client, InitializeCmdType.Initialize, "绑定失败，存在其他标签");
                    }
                    else if (tmpList.Count == 0)
                    {
                        OnSendMsg(client, InitializeCmdType.Initialize, "绑定失败，标签未放置");
                    }
                    //else if (tmpList.FirstOrDefault().EPC.Length == 64)
                    //{
                    //    OnSendMsg(client, InitializeCmdType.Initialize, "绑定失败，标签已被初始化");
                    //}
                    else
                    {
                        var _oper = new OperatingData()
                        {
                            EPC = "",
                            DATA = "8000" + data.Epc,
                            Offset = data.Offset,
                            Length = data.Len,
                            Bank = RfidBankType.EPC,
                            Access = "00000000"
                        };

                        var res = reader.WriteTag(_oper);
                        if (res.Item1 == 0)
                        {
                            OnSendMsg(client, InitializeCmdType.Initialize, "成功" + data.Epc);
                        }
                        else
                        {
                            OnSendMsg(client, InitializeCmdType.Initialize, "绑定失败，写入异常");
                        }
                    }
                }
            }
            else
            {
                deviceStatus = DeviceStatus.未连接;
                OnSendMsg(client, InitializeCmdType.ErrorMsg, "设备未连接");
            }

        }

        protected void InitializeEpcV2(string client, string json)
        {
            if (deviceStatus == DeviceStatus.已连接)
            {
                var data = JsonConvert.DeserializeObject<InitializeModel>(json);
                if (data == null)
                {
                    OnSendMsg(client, InitializeCmdType.Initialize, "绑定失败，非法数据");
                }
                else
                {
                    var tid = "";
                    //读取tid
                    var tag = new OperatingData()
                    {
                        Offset = 0,
                        Length = 6,
                        Bank = RfidBankType.TID,
                        Access = "00000000"
                    };
                    if (reader.ReadTag(ref tag).Item1 == 0)
                    {
                        tid = tag.DATA;
                    }
                    else
                    {
                        OnSendMsg(client, InitializeCmdType.ReadInventorySingleError, "TID读取失败");
                        return;
                    }


                    //将EPC长度改成位字符串
                    //48/6400
                    //24/3400
                    //64/8000

                    //先停止盘点，否则会卡死。
                    reader.InventoryStop();

                    //不进行盘点，认为无其他标签（调用之前自行判断是否能写入）
                    var _oper = new OperatingData()
                    {
                        EPC = "",
                        DATA = "8000" + data.Epc,
                        Offset = data.Offset,
                        Length = data.Len,
                        Bank = RfidBankType.EPC,
                        Access = "00000000"
                    };

                    var res = reader.WriteTag(_oper);
                    if (res.Item1 == 0)//成功
                    {
                        OnSendMsg(client, InitializeCmdType.Initialize, "成功" + data.Epc + "|" + tid);
                    }
                    else
                    {
                        OnSendMsg(client, InitializeCmdType.Initialize, "绑定失败，写入异常");
                    }
                }
            }
            else
            {
                deviceStatus = DeviceStatus.未连接;
                OnSendMsg(client, InitializeCmdType.ErrorMsg, "设备未连接");
            }

        }

        protected void ReadInventorySingle(string client)
        {
            var tmpList = new List<TagInfoData>();
            for (int i = 0; i < 4; i++)
            {
                reader.InventorySingle().ForEach(s =>
                {
                    if (tmpList.All(t => t.EPC != s.EPC))
                    {
                        tmpList.Add(s);
                    }
                });
            }

            if (tmpList.Count > 1)
            {
                OnSendMsg(client, InitializeCmdType.ReadInventorySingleError, "存在其他标签");
            }
            else if (tmpList.Count == 0)
            {
                OnSendMsg(client, InitializeCmdType.ReadInventorySingleError, "标签未放置");
            }
            else
            {
                OnSendMsg(client, InitializeCmdType.ReadInventorySingle, tmpList.First().EPC);
            }
        }
        #endregion

        #region uhf inventory method
        private void ConnectReader(int type = 0)
        {
            try
            {
                //钧普读写器
                reader1 ??= new JmpRfidLpReaderHelper("COM4");

                //索力得读写器
                reader2 ??= new USBRFIDReaderHelper();

                var state = type == 0 ? reader1.Open() : reader2.Open();
                deviceStatus = state ? DeviceStatus.已连接 : DeviceStatus.未连接;
                if (state)
                {
                    reader = type == 0 ? reader1 : reader2;
                    reader.InventoryStop();

                    var config = new ReaderConfig
                    {
                        PALevel = 2,
                        Power = 24
                    };
                    var fileName = new FileInfo(Assembly.GetEntryAssembly()?.Location ?? "").Directory + "/ReaderConfig.json";
                    if (!File.Exists(fileName))
                    {
                        File.WriteAllText(fileName, JsonConvert.SerializeObject(config));
                    }
                    else
                    {
                        config = JsonConvert.DeserializeObject<ReaderConfig>(File.ReadAllText(fileName));
                    }
                    reader.SetPALevel((byte)config.PALevel);
                    reader.SetTxPower(0, true, config.Power);

                    reader.OnInventory += OnRadioInventory;

                    SendLinked(used_client);
                }
            }
            catch (Exception ex)
            {
                reader = null;
                SendLinkError(used_client);
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }
        private void OnRadioInventory(TagInfoData args)
        {
            if (!epcList.Contains(args.EPC))
            {
                epcList.Add(args.EPC);
                OnSendMsg(used_client, InitializeCmdType.InventoryInfo, args.EPC);
            }
        }
        private void StartInv(string client)
        {
            lock (syncObj)
            {
                epcList.Clear();
                if (reader?.IsOpen() == true)
                {
                    reader.InventoryStart();
                }
                else
                {
                    deviceStatus = DeviceStatus.未连接;
                    OnSendMsg(client, InitializeCmdType.ErrorMsg, "设备未连接");
                }
            }
        }
        private void StopInv()
        {
            lock (syncObj)
            {
                reader?.InventoryStop();
                deviceStatus = DeviceStatus.已连接;
            }
        }
        private void LinkDevice()
        {
            while (!cDeviceToken.IsCancellationRequested)
            {
                try
                {
                    if (deviceStatus == DeviceStatus.未连接)
                    {
                        //需要连接读写器
                        if (SerialPort.GetPortNames().Any(t => t.ToLower().Contains("com4")))
                        {
                            //钧普读写器
                            ConnectReader(0);
                        }
                        else
                        {
                            //尝试连接索力得读写器
                            ConnectReader(1);
                        }

                        if (reader == null)
                        {
                            //都连接失败，放弃
                            SendLinkError(used_client);
                        }
                    }
                    else
                    {
                        //已连接，检查是否掉线
                        if (reader?.IsOpen() != true)
                        {
                            SendLinkError(used_client);
                            reader?.InventoryStop();
                            reader?.Close();
                            reader = null;
                        }
                    }

                    if (resetEvent.WaitOne(5000))
                    {
                        break;
                    }
                }
                catch (Exception ex)
                {
                    SendLinkError(used_client);
                    reader?.Close();
                    Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
                }
            }
        }
        private void SendLinkError(string client)
        {
            deviceStatus = DeviceStatus.未连接;
            OnSendMsg(client, InitializeCmdType.ErrorMsg, "初始化设备未连接");

        }
        private void SendLinked(string client)
        {
            deviceStatus = DeviceStatus.已连接;
            OnSendMsg(client, InitializeCmdType.Linked, "初始化设备已连接");

        }
        #endregion
    }
    public enum DeviceStatus
    {
        未连接,
        已连接
    }
    public class LinkInfo
    {
        public IWebSocketConnection Connection { get; set; }
        public DateTime LinkDate { get; set; }
    }

    public class ReaderConfig
    {
        /// <summary>
        /// 天线使能
        /// </summary>
        public int PALevel { get; set; }
        /// <summary>
        /// 功率
        /// </summary>
        public int Power { get; set; }
    }

}
