﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Management;
using System.Net;
using System.Net.Sockets;
using System.Runtime.InteropServices;
using System.Security.Cryptography;
using System.ServiceProcess;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using LibUsbDotNet;
using LibUsbDotNet.DeviceNotify;
using LibUsbDotNet.DeviceNotify.Linux;
using LibUsbDotNet.Main;
using LibUsbDotNet.LibUsb;
using Newtonsoft.Json;
using LibUsbDotNet.Info;
using System.Threading;
using static System.Windows.Forms.VisualStyles.VisualStyleElement.TaskbarClock;

namespace LocalPrint
{
    public partial class Service1 : ServiceBase
    {
        private Dictionary<string, Session> SessionPool = new Dictionary<string, Session>();
        private Dictionary<string, string> MsgPool = new Dictionary<string, string>();
        public UsbRegDeviceList mRegDevices;
        public Service1(string[] args)
        {
            InitializeComponent();
            //if (Environment.UserInteractive)
            //{
            //    Service1 service1 = new Service1(args);
            //    service1.TestStartupAndStop(args);
            //}
            //else
            //{
            //    Put the body of your old Main method here.
            //}
        }
        private IntPtr myHidPtr = new IntPtr();
        protected override void OnStart(string[] args)
        {

            this.WriteLog("Junmp客户端数据同步服务：【服务启动】");
            try
            {
                start(8080);///与WebSocket建立通讯
                USBPrint Usb = new USBPrint();
                bool InitRes= Usb.Init();
                int QRCount = 0;
                string QRCode = QRHelper.GenByZXingNet("BZWBZQR|07女绒背心|180/92:20|1|20190514|依翎公司");
                string sSendText =
                               //"~DGR:abc.GRF," +QRCount + ",020," + QRCode  +
                               QRCode+
                               "^XA" +
                               "^SEE:GB18030.DAT^FS" +
                               "^CWZ,E:SIMSUN.FNT" +
                               "^CI26" +
                               "^JMB^LL200^PW680^MD10^RP2^PON^LRN^LH0,0" +
                               "^FO5,10" +
                               "^AZN,35,35" +
                               "^FD01女绒背心 180/92 依翎公司^FS" +
                               "^FO80,25^XGR:ZLOGO.GRF,1,1^FS " +
                               "^PQ1"+
                               "^FO30,180^BY2," +
                               "^BCN,80,Y,N,N" +
                               "^FD868471268^FS" +
                               "^XZ";
                string sSendText1 =
                               //"~DGR:abc.GRF," +QRCount + ",020," + QRCode  +
                               "^XA" +
                               "^SEE:GB18030.DAT^FS" +
                               "^CWZ,E:SIMSUN.FNT" +
                               "^CI26" +
                               "^JMB^LL200^PW680^MD10^RP2^PON^LRN^LH0,0" +
                               "^FO5,10" +
                               "^AZN,35,35" +
                               "^FD01女绒背心 180/92 依翎公司^FS" +                          
                               "^PQ1" +
                               "^FO30,40^BY2," +
                               "^BCN,80,Y,N,N" +
                               "^FD868471268^FS" +

                                "^FO5,150" +
                               "^AZN,35,35" +
                               "^FD01女绒背心 180/92 依翎公司^FS" +
                               "^PQ1" +
                               "^FO30,180^BY2," +
                               "^BCN,80,Y,N,N" +
                               "^FD868471268^FS" +
                               "^XZ";
                string ZPL = "~HS";
                if (InitRes)
                {
                    //Usb.SetReadFlag();
                    //Thread Read = new Thread(Usb.StartRead);
                    //Read.Start();

                    bool reesult1 = Usb.SendMsg(ZPL);

                    //Thread.Sleep(2000);
                    bool Reesult= Usb.SendMsg(sSendText1);
                }

                Thread.Sleep(5000);
                Usb.StopPrint();
        
            }
            catch (Exception ex)
            {

                //ShowMsg("Error:" + ex.Message);
            }
        }

        public void GetMsgInfo()
        {
            while (USBPrint.ReadFlag==1)
            {
                if (USBPrint.PrintMsg.Count>0)
                {
                   string newMsg= USBPrint.PrintMsg.Dequeue();
                    byte[] msgBuffer= PackageServerData(newMsg);
                    Session currentClient = SessionPool[IP];
                    currentClient.SockeClient.Send(msgBuffer, msgBuffer.Length, SocketFlags.None);
                }
            }
        }
        private Hid myHid = new Hid();
       


        private static void OnDeviceNotify(object sender, DeviceNotifyEventArgs e)
        {
            Console.WriteLine($"插入设备的 Pid {e.Device.IdProduct} vid {e.Device.IdVendor}");
        }
        protected override void OnStop()
        {
            this.WriteLog("Junmp客户端数据同步服务：【服务停止】");
        }
        protected override void OnShutdown()
        {
            this.WriteLog("Junmp客户端数据同步服务：【计算机关闭】");
        }

        internal void TestStartupAndStop(string[] args)
        {
            this.OnStart(args);
            Console.ReadLine();
            this.OnStop();
        }


        #region 启动WebSocket服务
        /// <summary>
        /// 启动WebSocket服务
        /// </summary>  
        public void start(int port)
        {
            Socket SockeServer = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
            SockeServer.Bind(new IPEndPoint(IPAddress.Any, port));
            SockeServer.Listen(20);
            SockeServer.BeginAccept(new AsyncCallback(Accept), SockeServer);

        }

        #region 处理客户端连接请求
        /// <summary>
        /// 处理客户端连接请求
        /// </summary>
        /// <param name="result"></param>
        private void Accept(IAsyncResult socket)
        {
            // 还原传入的原始套接字
            Socket SockeServer = (Socket)socket.AsyncState;
            // 在原始套接字上调用EndAccept方法，返回新的套接字
            Socket SockeClient = SockeServer.EndAccept(socket);
            byte[] buffer = new byte[4096];
            try
            {
                //接收客户端的数据
                SockeClient.BeginReceive(buffer, 0, buffer.Length, SocketFlags.None, new AsyncCallback(Recieve), SockeClient);
                //保存登录的客户端
                Session session = new Session();
                session.SockeClient = SockeClient;
                session.IP = SockeClient.RemoteEndPoint.ToString();
                session.buffer = buffer;
                lock (SessionPool)
                {
                    if (SessionPool.ContainsKey(session.IP))
                    {
                        this.SessionPool.Remove(session.IP);
                    }
                    this.SessionPool.Add(session.IP, session);
                }
                //准备接受下一个客户端
                SockeServer.BeginAccept(new AsyncCallback(Accept), SockeServer);
            }
            catch (Exception ex)
            {

            }
        }
        #endregion
        #endregion
        #region 打包请求连接数据
        /// <summary>
        /// 打包请求连接数据
        /// </summary>
        /// <param name="handShakeBytes"></param>
        /// <param name="length"></param>
        /// <returns></returns>
        private byte[] PackageHandShakeData(byte[] handShakeBytes, int length)
        {
            string handShakeText = Encoding.UTF8.GetString(handShakeBytes, 0, length);
            string key = string.Empty;
            Regex reg = new Regex(@"Sec\-WebSocket\-Key:(.*?)\r\n");
            Match m = reg.Match(handShakeText);
            if (m.Value != "")
            {
                key = Regex.Replace(m.Value, @"Sec\-WebSocket\-Key:(.*?)\r\n", "$1").Trim();
            }
            byte[] secKeyBytes = SHA1.Create().ComputeHash(Encoding.ASCII.GetBytes(key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11"));
            string secKey = Convert.ToBase64String(secKeyBytes);
            var responseBuilder = new StringBuilder();
            responseBuilder.Append("HTTP/1.1 101 Switching Protocols" + "\r\n");
            responseBuilder.Append("Upgrade: websocket" + "\r\n");
            responseBuilder.Append("Connection: Upgrade" + "\r\n");
            responseBuilder.Append("Sec-WebSocket-Accept: " + secKey + "\r\n\r\n");
            return Encoding.UTF8.GetBytes(responseBuilder.ToString());
        }
        #endregion
        #region 处理接收的数据
        public string IP = string.Empty;
        /// <summary>
        /// 处理接受的数据
        /// </summary>
        /// <param name="socket"></param>
        private void Recieve(IAsyncResult socket)
        {
            Socket SockeClient = (Socket)socket.AsyncState;
            IP = SockeClient.RemoteEndPoint.ToString();
            if (SockeClient == null || !SessionPool.ContainsKey(IP))
            {
                return;
            }
            try
            {
                int length = SockeClient.EndReceive(socket);
                byte[] buffer = SessionPool[IP].buffer;
                SockeClient.BeginReceive(buffer, 0, buffer.Length, SocketFlags.None, new AsyncCallback(Recieve), SockeClient);
                string msg = Encoding.UTF8.GetString(buffer, 0, length);
                //  websocket建立连接的时候，除了TCP连接的三次握手，websocket协议中客户端与服务器想建立连接需要一次额外的握手动作
                if (msg.Contains("Sec-WebSocket-Key"))
                {
                    SockeClient.Send(PackageHandShakeData(buffer, length));
                    SessionPool[IP].isWeb = true;
                    return;
                }
                if (SessionPool[IP].isWeb)
                {
                    msg = AnalyzeClientData(buffer, length);
                }

                if (msg.Equals(1))//测试打印程序
                {

                }
                byte[] msgBuffer = PackageServerData(msg);
                //foreach (Session se in SessionPool.Values)
                //{
                //    se.SockeClient.Send(msgBuffer, msgBuffer.Length, SocketFlags.None);
                //}
                Session currentClient = SessionPool[IP];
                currentClient.SockeClient.Send(msgBuffer, msgBuffer.Length, SocketFlags.None);
            }
            catch
            {
                //SockeClient.Disconnect(true);
                SessionPool.Remove(IP);
            }
        }

        #endregion

        /// <summary>
        /// 把发送给客户端消息打包处理（拼接上谁什么时候发的什么消息）
        /// </summary>
        /// <returns>The data.</returns>
        /// <param name="message">Message.</param>
        private byte[] PackageServerData(string msg)
        {
            byte[] content = null;
            object oj = new { States = 0, Count = 0 }; // 0:没有通知，1:有通知  
            oj = new { States = 0 }; // 0:没有通知，1:有通知  
            if (!string.IsNullOrWhiteSpace(msg))
            {

                oj = new
                {
                    States = 1,
                    NContent = "您有新消息"+ msg, //消息内容
                    PublisherName = "Admin", //发布消息的人
                    PublisherImage = "/Upload/Images/20180131/测试.png",  //发布消息人头像
                };
            }
            string json = JsonConvert.SerializeObject(oj);
            byte[] temp = Encoding.UTF8.GetBytes(json);
            if (temp.Length < 126)
            {
                content = new byte[temp.Length + 2];
                content[0] = 0x81;
                content[1] = (byte)temp.Length;
                Buffer.BlockCopy(temp, 0, content, 2, temp.Length);
            }
            else if (temp.Length < 0xFFFF)
            {
                content = new byte[temp.Length + 4];
                content[0] = 0x81;
                content[1] = 126;
                content[2] = (byte)(temp.Length >> 8 & 0xFF);
                content[3] = (byte)(temp.Length & 0xFF);
                Buffer.BlockCopy(temp, 0, content, 4, temp.Length);
            }
            return content;
        }
        /// <summary>
        /// 处理接收的数据
        /// </summary>
        /// <param name="recBytes"></param>
        /// <param name="length"></param>
        /// <returns></returns>
        private string AnalyzeClientData(byte[] recBytes, int length)
        {
            int start = 0;
            // 如果有数据则至少包括3位
            if (length < 2) return "";
            // 判断是否为结束针
            bool IsEof = (recBytes[start] >> 7) > 0;
            // 暂不处理超过一帧的数据
            if (!IsEof) return "";
            start++;
            // 是否包含掩码
            bool hasMask = (recBytes[start] >> 7) > 0;
            // 不包含掩码的暂不处理
            if (!hasMask) return "";
            // 获取数据长度
            UInt64 mPackageLength = (UInt64)recBytes[start] & 0x7F;
            start++;
            // 存储4位掩码值
            byte[] Masking_key = new byte[4];
            // 存储数据
            byte[] mDataPackage;
            if (mPackageLength == 126)
            {
                // 等于126 随后的两个字节16位表示数据长度
                mPackageLength = (UInt64)(recBytes[start] << 8 | recBytes[start + 1]);
                start += 2;
            }
            if (mPackageLength == 127)
            {
                // 等于127 随后的八个字节64位表示数据长度
                mPackageLength = (UInt64)(recBytes[start] << (8 * 7) | recBytes[start] << (8 * 6) | recBytes[start] << (8 * 5) | recBytes[start] << (8 * 4) | recBytes[start] << (8 * 3) | recBytes[start] << (8 * 2) | recBytes[start] << 8 | recBytes[start + 1]);
                start += 8;
            }
            mDataPackage = new byte[mPackageLength];
            for (UInt64 i = 0; i < mPackageLength; i++)
            {
                mDataPackage[i] = recBytes[i + (UInt64)start + 4];
            }
            Buffer.BlockCopy(recBytes, start, Masking_key, 0, 4);
            for (UInt64 i = 0; i < mPackageLength; i++)
            {
                mDataPackage[i] = (byte)(mDataPackage[i] ^ Masking_key[i % 4]);
            }
            return Encoding.UTF8.GetString(mDataPackage);
        }

        public class Session
        {
            public Socket SockeClient{get;set;}
            public string IP { get; set; }
            public byte[] buffer { get; set; }
            public bool isWeb { get; set; }
        }
        #region 记录日志
        /// <summary>
        /// 记录日志
        /// </summary>
        /// <param name="msg"></param>
        private void WriteLog(string msg)
        {

            //string path = @"C:\log.txt";

            //该日志文件会存在windows服务程序目录下
            string path = AppDomain.CurrentDomain.BaseDirectory + "\\log.txt";
            FileInfo file = new FileInfo(path);
            if (!file.Exists)
            {
                FileStream fs;
                fs = File.Create(path);
                fs.Close();
            }

            using (FileStream fs = new FileStream(path, FileMode.Append, FileAccess.Write))
            {
                using (StreamWriter sw = new StreamWriter(fs))
                {
                    sw.WriteLine(DateTime.Now.ToString() + "   " + msg);
                }
            }
        }
        #endregion
    
        }
}
