﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LocalPrint
{
   public class QRHelper
    {
        public static List<string> listNo1 = new List<string>() { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?" };
        /// <summary>
        /// 图像二值化1：取图片的平均灰度作为阈值，低于该值的全都为0，高于该值的全都为255
        /// </summary>
        /// <param name="bmp">原图</param>
        /// <param name="nType">放到倍数</param>
        /// <returns></returns>
        public static Byte[] ConvertTo1Bpp1(Bitmap bmp, int nType)
        {
            byte[] b = new byte[(bmp.Width * bmp.Height)];

            for (int i = 0; i < bmp.Width; i++)
            {
                for (int j = 0; j < bmp.Height; j++)
                {
                    //获取该点的像素的RGB的颜色
                    Color color = bmp.GetPixel(i, j);
                    //Color newColor = value > average ? Color.FromArgb(0, 0, 0) : Color.FromArgb(255, 255, 255);
                    b[j * bmp.Width + i] = (new byte[] { color.R, color.G, color.B }).Max() > 60 ? (byte)0 : (byte)1;
                    //bmp.SetPixel(i, j, newColor);
                }
            }
            return b;
        }
        /// <summary>
        /// 生成二维码图片
        /// </summary>
        /// <param name="strMessage">要生成二维码的字符串</param>
        /// <param name="width">二维码图片宽度</param>
        /// <param name="height">二维码图片高度</param>
        /// <returns></returns>
        public static string GenByZXingNet(string msg,int hight,int Width)
        {
            string strInfo = "";
            //设置QR二维码的规格  
            QrCodeEncodingOptions qrEncodeOption = new QrCodeEncodingOptions();
            //设置编码格式，否则中文乱码  
            qrEncodeOption.CharacterSet = "UTF-8";
            //设置宽和高  
            qrEncodeOption.Height = hight;
            qrEncodeOption.Width = Width;
            //设置周围空白边距  
            qrEncodeOption.Margin = 1;
            BarcodeWriter wr = new BarcodeWriter();
            //二维码  
            wr.Format = BarcodeFormat.QR_CODE;
            wr.Options = qrEncodeOption;
            //生成二维码  
            Bitmap img = wr.Write(msg);

            StringBuilder sb = new StringBuilder();
            int b = 0;

            long n = 0;

            long clr;
            sb.Append("~DGR:ZLOGO.GRF,");
            BarcodeWriter writer = new BarcodeWriter();
            writer.Format = BarcodeFormat.QR_CODE;
            writer.Options.Hints.Add(EncodeHintType.CHARACTER_SET, "UTF-8");//编码问题
            writer.Options.Hints.Add(
                EncodeHintType.ERROR_CORRECTION,
                ZXing.QrCode.Internal.ErrorCorrectionLevel.H
            );
            //const int codeSizeInPixels = hight;   //设置图片长宽
            writer.Options.Height = writer.Options.Width = hight;
            writer.Options.Margin = 0;//设置边框
            ZXing.Common.BitMatrix bm = writer.Encode(msg);
            //Bitmap img = writer.Write(bm);
            int w = ((img.Size.Width / 8 + ((img.Size.Width % 8 == 0) ? 0 : 1)) * img.Size.Height);

            int h = (img.Size.Width / 8 + ((img.Size.Width % 8 == 0) ? 0 : 1));
            sb.Append(w.ToString().PadLeft(5, '0') + "," + h.ToString().PadLeft(3, '0') + ",\n");

            using (Bitmap bmp = new Bitmap(img.Size.Width, img.Size.Height))

            {

                for (int y = 0; y < img.Size.Height; y++)

                {

                    for (int x = 0; x < img.Size.Width; x++)

                    {

                        b = b * 2;

                        clr = img.GetPixel(x, y).ToArgb();

                        string s = clr.ToString("X");



                        if (s.Substring(s.Length - 6, 6).CompareTo("BBBBBB") < 0)

                        {

                            bmp.SetPixel(x, y, img.GetPixel(x, y));

                            b++;

                        }

                        n++;

                        if (x == (img.Size.Width - 1))

                        {

                            if (n < 8)

                            {

                                b = b * (2 ^ (8 - (int)n));



                                sb.Append(b.ToString("X").PadLeft(2, '0'));

                                b = 0;

                                n = 0;

                            }

                        }

                        if (n >= 8)

                        {

                            sb.Append(b.ToString("X").PadLeft(2, '0'));

                            b = 0;

                            n = 0;

                        }

                    }

                }

                sb.Append(string.Format("^FO{0},{1}^XGR:ZLOGO.GRF,2,2^FS", 20, 60));

            }

            return sb.ToString();
            
        }
        public static string PhotoImageInsert(string QRtext,ref int Count)
        {
            string strInfo = "";
            //设置QR二维码的规格  
            QrCodeEncodingOptions qrEncodeOption = new QrCodeEncodingOptions();
            //设置编码格式，否则中文乱码  
            qrEncodeOption.CharacterSet = "UTF-8";
            //设置宽和高  
            qrEncodeOption.Height = 330;
            qrEncodeOption.Width = 330;
            //设置周围空白边距  
            qrEncodeOption.Margin = 1;
            BarcodeWriter wr = new BarcodeWriter();
            //二维码  
            wr.Format = BarcodeFormat.QR_CODE;
            wr.Options = qrEncodeOption;
            //生成二维码  
            Bitmap image = wr.Write(QRtext);
            byte[] byte1 = ConvertTo1Bpp1(image, 1);

            string s = "";
            int n = 0;
            //打印机图片点阵宽度
            int d = ((image.Width + 7) / 8) * 8;
            for (int j = 0; j < image.Height; j++)
            {
                for (int i = 0; i < d; i++)
                {
                    if (i >= image.Width)
                    {
                        s += "0";
                    }
                    else
                    {
                        s += byte1[j * image.Width + i].ToString();
                    }
                    if (n == 3)
                    {
                        int xjDenary = Convert.ToInt32(s, 2);
                        strInfo += listNo1[xjDenary];
                        n = 0;
                        s = "";
                    }
                    else
                    {
                        n++;
                    }
                }
            }
           Count = strInfo.Length;

            return strInfo;
        }
    }
}
