﻿using JmpZbService.Basic;
using System;
using System.Drawing;
using System.IO;

namespace JmpZbService.Model
{
    public static class ToshibaTemplate
    {
        public static int Version { get; set; } = 2;

        /// <summary>
        /// 供应商列最大字数
        /// </summary>
        private static int TitleMaxWord { get; set; } = 17;

        /// <summary>
        /// 单个字间隔
        /// </summary>
        private static int TitleWordLen { get; set; } = 55;

        private static string PieceImgString { get; set; }
        private static string BoxImgString { get; set; }


        /// <summary>
        /// RFID物料命令
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="entity"></param>
        /// <param name="strModelType"></param>
        /// <returns></returns>
        public static string GetRfidPrintCmd<T>(T entity, string strModelType)
        {
            string strTemplate = Properties.Resource.ResourceManager.GetString(strModelType);
            if (strTemplate==null)
            {
                //未找到模板
                return null;
            }
            var property = typeof(T);
            foreach (var property_item in property.GetProperties())
            {
                var property_value = property_item.GetValue(entity)?.ToString() ?? "";
                strTemplate = strTemplate.Replace(property_item.Name, property_value);
            }
            return strTemplate;
        }

        /// <summary>
        /// 读当前标签的EPC信息
        /// </summary>
        public static string ReadTagTID()
        {
            string sCommand = string.Empty;//"{C|}"+ "{WF;T24,I2|}";

            if (Version == 1)//东芝打印机B-SX5T旧版本
            {
                sCommand += "{C|}{WF;T24,I1|}";
            }
            if (Version == 2)//东芝打印机B-EX4T1-G新版本
            {
                sCommand += "{C|}{WF;A000,T24,I4,U1|}";
            }

            return sCommand;
        }

        /// <summary>
        /// 读当前标签的EPC信息
        /// </summary>
        public static string ReadTagEpc()
        {
            return "{C|}{WF;T24,I2|}";
        }

        /// <summary>
        /// 写EPC信息,不使用碳带 {D0580,1000,0500|}{C|}{@003;+0000|}{XB00;0000,0000,r,T24,G2,V1,B01=" + epc + "|}{XS;I,0001,0002C5301|}
        /// </summary>
        /// <param name="epc"></param>
        public static string WriteTag(string epc)
        {
            string sCommand = "{D0580,1000,0500|}"
                            + "{C|}"
                            + "{@003;+0000|}"
                            + "{XB00;0000,0000,r,T24,G2,V1,B01=" + epc + "|}"
                            + "{XS;I,0001,0002C5301|}";

            return epc;
        }

        private static string GetTitleMarginLeft(string strValue)
        {
            var str_len = strValue.Length;
            var total_margin = TitleMaxWord - str_len;
            if (total_margin <= 0) { return "0"; }
            else
            {
                return $"{total_margin / 2 * TitleWordLen}";
            }
        }

        private static string GetPieceImageString()
        {
            if (string.IsNullOrEmpty(PieceImgString))
            {
                PieceImgString = CommonHelper.Image2String((Bitmap)Image.FromFile(AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "piece_logo.jpg"));
            }
            return PieceImgString;
        }

        private static string GetBoxImageString()
        {
            if (string.IsNullOrEmpty(BoxImgString))
            {
                BoxImgString = CommonHelper.Image2String((Bitmap)Image.FromFile(AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "box_logo.jpg"));
            }
            return BoxImgString;
        }

    }
}
