﻿using LibUsbDotNet;
using LibUsbDotNet.DeviceNotify;
using LibUsbDotNet.Main;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace JmpPrintService.Basic
{
    public class UsbConnect : ConnectBase
    {
        private Dictionary<string, ushort> dic_device = new Dictionary<string, ushort>();
        private UsbDeviceFinder usbFinder;
        private UsbDevice usbDevice;
        private UsbEndpointWriter writer;
        private UsbEndpointReader reader;
        private Action<byte[]> onAnalysisReciveMsg;
        public IDeviceNotifier notifier = DeviceNotifier.OpenDeviceNotifier();
        public UsbConnect(Action<byte[]> onAnalysisReciveMsg = null)
        {
            this.onAnalysisReciveMsg = onAnalysisReciveMsg;
        }

        protected void OnDataReceived(object sender, EndpointDataEventArgs e)
        {
            try
            {
                if (onAnalysisReciveMsg == null)
                {
                }
                else
                {
                    onAnalysisReciveMsg?.BeginInvoke(e.Buffer, default, default);
                }

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }

        /// <summary>
        /// 初始化打印程序
        /// </summary>
        /// <returns></returns>
        public override bool Connection()
        {
            try
            {
                UsbRegistry usbRegistry = default;
                foreach (UsbRegistry item in UsbDevice.AllLibUsbDevices)
                {
                    //东芝打印机设备标志
                    if (item.Device.Info.Descriptor.VendorID == 2214 && item.Device.Info.Descriptor.ProductID == 83)
                    {
                        usbRegistry = item;
                        break;
                    }
                }
                if (usbRegistry == null)
                {
                    return false;
                }
                else
                {
                    //尝试连接打印机
                    usbRegistry.Open(out UsbDevice usbDevice);
                    IUsbDevice wholeUsbDevice = usbDevice as IUsbDevice;
                    if (wholeUsbDevice != null)
                    {
                        //这是一个“完整的”USB设备。在使用之前，
                        //必须选择所需的配置和接口。
                        //选择config #1
                        wholeUsbDevice.SetConfiguration(1);

                        // 接口地址重置 #0
                        wholeUsbDevice.ClaimInterface(0);
                    }
                    if (usbDevice != null)
                    {
                        writer = usbDevice.OpenEndpointWriter(WriteEndpointID.Ep01);
                        reader = usbDevice.OpenEndpointReader(ReadEndpointID.Ep02);

                        reader.DataReceivedEnabled = true;
                        reader.DataReceived += OnDataReceived; ;
                        return usbDevice.Open();
                    }
                    else
                    {
                        return false;
                    }
                }

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
                return false;
            }
        }

        /// <summary>
        /// 发送打印机指令
        /// </summary>
        /// <param name="strMsg"></param>
        /// <returns></returns>
        public override bool SendMsg(string strMsg)
        {
            try
            {
                byte[] temp = System.Text.Encoding.GetEncoding("GB18030").GetBytes(strMsg);
                ErrorCode ec = ErrorCode.None;
                ec = writer?.Write(temp, 20000, out int transferLength) ?? ErrorCode.UnknownError;
                if (ec != ErrorCode.None)
                {
                    return false;
                }
                else
                {
                    return true;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
                return false;
            }
        }

        /// <summary>
        /// 停止打印程序
        /// </summary>
        public override bool DisConnection()
        {

            if (usbDevice != null)
            {
                if (usbDevice?.IsOpen ?? false)
                {
                    writer.Abort();
                    reader.Abort();
                    usbDevice?.Close();
                    return true;
                }
                return false;
            }
            else
            {
                return true;
            }

        }

    }
}
