﻿using GalaSoft.MvvmLight;
using JmpZbModel;
using JmpZbPrint.Model;
using JmpZbPrint.UsControl;
using MaterialDesignThemes.Wpf;
using NetworkCommsDotNet;
using NetworkCommsDotNet.Connections;
using NetworkCommsDotNet.Connections.TCP;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Threading;
using GalaSoft.MvvmLight.CommandWpf;
using JmpZbPrint.Common;
using JmpZbPrint.View;
using RelayCommand = GalaSoft.MvvmLight.Command.RelayCommand;

namespace JmpZbPrint.ViewModel
{
    public class TagPrinViewModel : ViewModelBase
    {
        private MainWindow _window;
        public TagPrinViewModel(MainWindow window)
        {
            _window = window;

            OnStartPrintItemsCmd = new RelayCommand(OnPrintStart);
            OnStopPrintItemsCmd = new RelayCommand(OnPrintStop);

            OnQueryCommand = new RelayCommand(OnQuery);
            OnPageChangeCmd = new RelayCommand(OnPageChange);
            OnGenTagCmd = new RelayCommand(OnGenTag);
            OnWindowLoadCmd = new RelayCommand(OnWindowLoad);

            OnBoxingCmd = new RelayCommand(OnBoxing);
        }

        #region filed
        private WaitDialog waitDialog = default;
        private bool isStop = false;
        private ObservableCollection<print_info> _printList = new ObservableCollection<print_info>();
        public ObservableCollection<print_info> UiPrintList
        {
            get { return _printList; }
            set
            {
                _printList = value;
                RaisePropertyChanged();
            }
        }

        private string _equName;
        public string EquName
        {
            get { return _equName; }
            set
            {
                _equName = value;
                RaisePropertyChanged();
            }
        }
        private string _vendorName;
        public string VendorName
        {
            get { return _vendorName; }
            set
            {
                _vendorName = value;
                RaisePropertyChanged();
            }
        }
        private int _epcType;
        public int EpcType
        {
            get { return _epcType; }
            set
            {
                _epcType = value;
                RaisePropertyChanged();
            }
        }

        private string _message = "状态：打印机初始化中";
        public string UiMessage
        {
            get { return _message; }
            set
            {
                _message = value;
                RaisePropertyChanged();
            }
        }

        private string _msgccolor = "Green";
        public string MsgColor
        {
            get { return _msgccolor; }
            set
            {
                _msgccolor = value;
                RaisePropertyChanged();
            }
        }

        private bool _bindButton = false;
        public bool BindButton
        {
            get { return _bindButton; }
            set
            {
                _bindButton = value;
                RaisePropertyChanged();
            }
        }
        private int _total = 0;
        public int TotalRecord
        {
            get { return _total; }
            set
            {
                _total = value;
                RaisePropertyChanged();
            }
        }
        private int _page = 0;
        public int PageIndex
        {
            get { return _page; }
            set
            {
                _page = value;
                RaisePropertyChanged();
            }
        }

        private int _pageTotal = 0;
        public int PageTotal
        {
            get { return _pageTotal; }
            set
            {
                _pageTotal = value;
                RaisePropertyChanged();
            }
        }

        private int _pageSize = 50;
        public int PageSize
        {
            get { return _pageSize; }
            set
            {
                _pageSize = value;
                RaisePropertyChanged();
            }
        }
        private bool _startEnable = false;
        public bool StartEnable
        {
            get { return _startEnable; }
            set
            {
                _startEnable = value;
                RaisePropertyChanged();
            }
        }
        private bool _stopEnable = false;
        public bool StopEnable
        {
            get { return _stopEnable; }
            set
            {
                _stopEnable = value;
                RaisePropertyChanged();
            }
        }
        private bool _isSelectAll = false;
        public bool IsSelectAll
        {
            get { return _isSelectAll; }
            set
            {
                _isSelectAll = value;
                RaisePropertyChanged();
                SelectAll();
            }
        }
        #endregion

        #region cmd attr
        public RelayCommand OnStartPrintItemsCmd { get; set; }
        public RelayCommand OnStopPrintItemsCmd { get; set; }
        public RelayCommand OnWindowLoadCmd { get; set; }
        public RelayCommand OnQueryCommand { get; set; }
        public RelayCommand OnPageChangeCmd { get; set; }
        public RelayCommand OnGenTagCmd { get; set; }
        public RelayCommand OnWindowClosingCmd { get; set; }

        public RelayCommand OnBoxingCmd { get; set; }

        #endregion

        #region method

        /// <summary>
        /// 装箱
        /// </summary>
        private void OnBoxing()
        {
            var seled = UiPrintList.Where(t => t.IsSelected == true).ToList();
            if (seled.Count > 0)
            {
                if (seled.Any(x => x.LabelType == "箱标"))
                {
                    MessageBox.Show("禁止箱标装箱");
                    return;
                }

                var havePurchaseLabel = seled.Any(x => x.isUnboxingLabel == false);
                if (MessageBox.Show("确认装箱选中的记录？" + (havePurchaseLabel ? "存在采购件标，将直接录入主平台。" : ""), "确认装箱", MessageBoxButton.OKCancel, MessageBoxImage.Question) ==
                    MessageBoxResult.OK)
                {
                    //判断物资一致性
                    var info = seled.First();
                    if (seled.Any(x => x.productId != info.productId))
                    {
                        MessageBox.Show("物资类型不一致，无法装箱");
                        return;
                    }
                    if (seled.Any(x => x.sizeId != info.sizeId))
                    {
                        MessageBox.Show("物资型号不一致，无法装箱");
                        return;
                    }
                    if (seled.Any(x => x.supplierId != info.supplierId))
                    {
                        MessageBox.Show("供应商不一致，无法装箱");
                        return;
                    }
                    if (seled.Any(x => x.warehouseId != info.warehouseId))
                    {
                        MessageBox.Show("入库仓库不一致，无法装箱");
                        return;
                    }

                    //创建箱标epc
                    var boxRequest = new request_int_info()
                    {
                        labelType = "箱标",
                        equCode = info.productNo,
                        productTime = Convert.ToDateTime(info.productTime),
                        sizeCode = info.sizeCode,
                        oneBoxNum = seled.Count,
                        quantity = 1,
                        supplierCode = info.supplierCode,
                        warrantyCycle = Convert.ToInt32(info.warrantyCycle)
                    };
                    var boxRes = HttpHelper.GenerateIntTagEpc(boxRequest, out string boxMsg);
                    if (!boxRes.Item1)
                    {
                        MessageBox.Show($"[{info.productName}-{info.sizeName}] 箱标生成失败，原因：{boxMsg}", "提示", MessageBoxButton.OK, MessageBoxImage.Error);
                        return;
                    }
                    var xbEpc = boxRes.Item2.First().epc;

                    var res = HttpHelper.BoxingInventoryNormalVersion(xbEpc, seled, out string msg);
                    if (res)
                    {
                        var _batch_no = DateTime.Now.ToString("yyyyMMddHHmmssfff");

                        foreach (var obj in seled)
                        {
                            LiteDbHelper.DeleteByEpc(obj.epc);
                        }
                        //不添加箱标记录进litedb
                    }
                    else
                    {
                        MessageBox.Show(msg);
                    }
                    OnQuery();
                }
            }
        }

        public void OnWindowLoad()
        {
            OnQuery();
            _window.printServerHelper.EnableControlEvent += EnableControl;
            _window.printServerHelper.Init();
        }
        private void OnQuery()
        {
            PageIndex = 1;
            IsSelectAll = false;
            UiPrintList.Clear();
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = HttpHelper.GetPrintList(EpcType, LabelType.打印, PageIndex, VendorName, EquName);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            UiPrintList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                UiPrintList = new ObservableCollection<print_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });

        }
        private void OnPageChange()
        {
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = HttpHelper.GetPrintList(EpcType, LabelType.打印, PageIndex, VendorName, EquName);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            UiPrintList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                UiPrintList = new ObservableCollection<print_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }
        private void OnGenTag()
        {
        }
        private void OnPrintStart()
        {

            isStop = false;
            StopEnable = true;
            StartEnable = false;

            var print = UiPrintList.Where(t => t.IsSelected == true).ToList();

            Task.Run(() =>
            {
                foreach (var tsk_item in print)
                {
                    if (isStop)
                    {
                        break;
                    }
                    else
                    {
                        //tmp_id = tsk_item.Id;
                        var res = _window.printServerHelper.SendPrintCmd(new SingleInfo()
                        {
                            Info1 = tsk_item.productName,
                            Info2 = tsk_item.sizeName,
                            Info3 = tsk_item.supplierName,
                            Info4 = tsk_item.pieceNo ?? "1",
                            Info5 = tsk_item.productTime,
                            Info9 = tsk_item.epc.Replace(" ", ""),
                            ModelType = "piece"
                        });

                        //保存打印记录进文件
                        var json = JsonConvert.SerializeObject(new PrintLog
                        {
                            CreateTime = DateTime.Now,
                            IsSuccess = res,
                            epc = tsk_item.epc,
                            id = tsk_item.id,
                            orderCode = tsk_item.orderCode,
                            warehouseName = tsk_item.warehouseName,
                            productName = tsk_item.productName,
                            sizeName = tsk_item.sizeName,
                            productTime = tsk_item.productTime,
                            useTime = tsk_item.useTime,
                            pieceNo = tsk_item.pieceNo,
                            warrantyCycle = tsk_item.warrantyCycle,
                            repairCycle = tsk_item.repairCycle,
                            price = tsk_item.price,
                            supplierName = tsk_item.supplierName,
                            isBoxMark = false

                        });
                        System.IO.File.AppendAllText(AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "PrintLog.json", json + "\r\n", Encoding.UTF8);

                        if (res)
                        {
                            UpdateEpcStateById(tsk_item.id.Replace(" ", ""), true);
                        }
                        //打印机异常，不继续发指令
                        else if (!res) { break; }
                        else { }
                    }
                }
                OnPrintStop();
            });
        }
        public void OnPrintStop()
        {
            StopEnable = false;
            StartEnable = true;
            isStop = true;
        }
        private void UpdateEpcStateById(string id, bool apply = false)
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                var item = UiPrintList.FirstOrDefault(t => t.id.Contains(id));
                if (item != null)
                {
                    item.state = 1;
                    Tuple<bool, string> flagData = new Tuple<bool, string>(true, "");
                    if (apply)
                    {
                        if (item.isUnboxingLabel)
                        {
                            var res = HttpHelper.GenerateInventory(new recode_info
                            {
                                sizeId = item.sizeId,
                                equId = item.productId,
                                epc = item.epc,
                                supplierId = item.supplierId,
                                warehouseId = item.warehouseId,
                                productTime = Convert.ToDateTime(item.productTime),
                                useTime = Convert.ToDateTime(item.useTime),
                                warrantyCycle = Convert.ToInt32(item.warrantyCycle),
                                price = Convert.ToSingle(item.price),
                                repairCycle = Convert.ToInt32(item.repairCycle),
                                IsUnboxingLabel = item.isUnboxingLabel
                            }, out string msg);
                            flagData = new Tuple<bool, string>(res, msg);
                        }
                        else
                        {
                            flagData = HttpHelper.UpdateEpc(item.id);
                        }
                    }
                    if (flagData.Item1)
                    {
                        UiPrintList.Remove(item);
                        LiteDbHelper.DeleteByEpc(item.epc);
                        TotalRecord -= 1;

                        if (UiPrintList.Count == 0)
                        {
                            PageIndex = 1;
                            OnPageChange();
                        }
                    }
                    else
                    {
                        //EPC状态更新失败
                        UiMessage = flagData.Item2;
                        MsgColor = "Red";
                    }
                }
            });


        }
        public void EnableControl(bool flag, bool startEnable, bool stopEnable, string msg = "")
        {
            StartEnable = startEnable;
            StopEnable = stopEnable;

            if (!string.IsNullOrEmpty(msg))
            {
                UiMessage = "状态：" + msg;
                MsgColor = flag ? "Green" : "Red";
            }
        }
        public void SelectAll()
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                foreach (var item in UiPrintList)
                {
                    item.IsSelected = _isSelectAll;
                }
                this.RaisePropertyChanged(() => UiPrintList);
            });
        }
        public override void Cleanup()
        {
            base.Cleanup();
            isStop = true;
            _window.printServerHelper.EnableControlEvent -= EnableControl;
            NetworkComms.Shutdown();
        }
        #endregion

    }

}
