﻿using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;
using JmpZbModel;
using JmpZbPrint.Model;
using JmpZbPrint.UsControl;
using MaterialDesignThemes.Wpf;
using NetworkCommsDotNet;
using NetworkCommsDotNet.Connections;
using NetworkCommsDotNet.Connections.TCP;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Threading;
using JmpZbPrint.Common;
using JmpZbPrint.Dialog;
using JmpZbPrint.View;

namespace JmpZbPrint.ViewModel
{
    public class TagBoxPrinViewModel : ViewModelBase
    {
        private MainWindow _window;
        public TagBoxPrinViewModel(MainWindow window)
        {
            _window = window;

            OnStartPrintItemsCmd = new RelayCommand(OnPrintStart);
            OnStopPrintItemsCmd = new RelayCommand(OnPrintStop);

            OnQueryCommand = new RelayCommand(OnQuery);
            OnPageChangeCmd = new RelayCommand(OnPageChange);
            OnGenTagCmd = new RelayCommand(OnGenTag);
            OnWindowLoadCmd = new RelayCommand(OnWindowLoad);

            OnUnboxingCmd = new RelayCommand(OnUnboxing);
        }

        #region filed
        private WaitDialog waitDialog = default;
        private bool isStop = false;
        private ObservableCollection<print_info> _printList = new ObservableCollection<print_info>();
        public ObservableCollection<print_info> UiPrintList
        {
            get { return _printList; }
            set
            {
                _printList = value;
                RaisePropertyChanged();
            }
        }

        private string _equName;
        public string EquName
        {
            get { return _equName; }
            set
            {
                _equName = value;
                RaisePropertyChanged();
            }
        }
        private string _vendorName;
        public string VendorName
        {
            get { return _vendorName; }
            set
            {
                _vendorName = value;
                RaisePropertyChanged();
            }
        }
        private int _epcType;
        public int EpcType
        {
            get { return _epcType; }
            set
            {
                _epcType = value;
                RaisePropertyChanged();
            }
        }

        private string _message = "状态：打印机初始化中";
        public string UiMessage
        {
            get { return _message; }
            set
            {
                _message = value;
                RaisePropertyChanged();
            }
        }

        private string _msgccolor = "Green";
        public string MsgColor
        {
            get { return _msgccolor; }
            set
            {
                _msgccolor = value;
                RaisePropertyChanged();
            }
        }

        private bool _bindButton = false;
        public bool BindButton
        {
            get { return _bindButton; }
            set
            {
                _bindButton = value;
                RaisePropertyChanged();
            }
        }
        private int _total = 0;
        public int TotalRecord
        {
            get { return _total; }
            set
            {
                _total = value;
                RaisePropertyChanged();
            }
        }
        private int _page = 0;
        public int PageIndex
        {
            get { return _page; }
            set
            {
                _page = value;
                RaisePropertyChanged();
            }
        }

        private int _pageTotal = 0;
        public int PageTotal
        {
            get { return _pageTotal; }
            set
            {
                _pageTotal = value;
                RaisePropertyChanged();
            }
        }

        private int _pageSize = 50;
        public int PageSize
        {
            get { return _pageSize; }
            set
            {
                _pageSize = value;
                RaisePropertyChanged();
            }
        }
        private bool _startEnable = false;
        public bool StartEnable
        {
            get { return _startEnable; }
            set
            {
                _startEnable = value;
                RaisePropertyChanged();
            }
        }
        private bool _stopEnable = false;
        public bool StopEnable
        {
            get { return _stopEnable; }
            set
            {
                _stopEnable = value;
                RaisePropertyChanged();
            }
        }
        private bool _isSelectAll = false;
        public bool IsSelectAll
        {
            get { return _isSelectAll; }
            set
            {
                _isSelectAll = value;
                RaisePropertyChanged();
                SelectAll();
            }
        }
        #endregion

        #region cmd attr
        public RelayCommand OnStartPrintItemsCmd { get; set; }
        public RelayCommand OnStopPrintItemsCmd { get; set; }
        public RelayCommand OnWindowLoadCmd { get; set; }
        public RelayCommand OnQueryCommand { get; set; }
        public RelayCommand OnPageChangeCmd { get; set; }
        public RelayCommand OnGenTagCmd { get; set; }
        public RelayCommand OnWindowClosingCmd { get; set; }

        public RelayCommand OnUnboxingCmd { get; set; }

        #endregion

        #region method

        /// <summary>
        /// 拆箱
        /// </summary>
        private void OnUnboxing()
        {
            var selectBox = new SelectBoxEpc();
            selectBox.ShowDialog();
            var info = selectBox.RecodeInfo;
            if (info != null)
            {
                //拆箱
                List<recode_info> epc_record = new List<recode_info>();
                var epcListRes = HttpHelper.GetInventoryListByBoxMarkEpc(info.epc, out var msg);
                if (!epcListRes.Item1)
                {
                    MessageBox.Show("获取件标失败：" + msg);
                    return;
                }
                var invList = epcListRes.Item2;
                var _batch_no = DateTime.Now.ToString("yyyyMMddHHmmssfff");
                for (var i = 0; i < invList.Count; i++)
                {
                    epc_record.Add(new recode_info()
                    {
                        LabelType = "件标",
                        orgId = invList[i].orgizationId,
                        batchNo = _batch_no,
                        epc = invList[i].epc,
                        num = i + 1,
                        equCode = invList[i].equipmentDetailCode,
                        equId = invList[i].equipmentDetailId,
                        sizeCode = invList[i].sizeCode,
                        equName = invList[i].equipmentDetailName,
                        isdelete = false,
                        needNum = 1,
                        price = Convert.ToSingle(invList[i].price),
                        productTime = invList[i].productTime,
                        repairCycle = invList[i].repairCycle,
                        sizeId = invList[i].sizeId,
                        sizeName = invList[i].sizeName,
                        suppilerCode = invList[i].supplierCode,
                        supplierId = invList[i].supplierId,
                        suppilerName = invList[i].supplierName,
                        type = invList[i].sizeEpcType,
                        useTime = invList[i].useTime,
                        warehouseId = invList[i].warehouseId,
                        warehouseName = invList[i].warehouseName,
                        warrantyCycle = invList[i].warrantyCycle,
                        createTime = DateTime.Now,
                        IsUnboxingLabel = true
                    });
                }
                //更新inbox状态
                var res = HttpHelper.UnpackRangeInventory(info.epc, out msg);

                if (res)
                {
                    //不录入本地数据库
                    //LiteDbHelper.AddRange(epc_record);
                    LiteDbHelper.DeleteByEpc(info.epc);
                    OnQuery();
                }
                else
                {
                    MessageBox.Show("更新状态失败：" + msg);
                }
            }
        }

        public void OnWindowLoad()
        {
            OnQuery();
            _window.printServerHelper.EnableControlEvent += EnableControl;
            _window.printServerHelper.Init();
        }
        private void OnQuery()
        {
            PageIndex = 1;
            IsSelectAll = false;
            UiPrintList.Clear();
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = HttpHelper.GetNeedPrintBoxMarkList(CaChe.UserInfo.baseJpOrganization.id, out string msg);
                        //TotalRecord = tmp?.total ?? 0;
                        //PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            UiPrintList?.Clear();
                            //if (tmp?.record != null && tmp?.record.Count > 0)
                            if (tmp.Item1 && tmp.Item2.Count > 0)
                            {
                                var list = tmp.Item2;
                                if (!string.IsNullOrEmpty(EquName))
                                {
                                    list = list.Where(x => x.equipmentDetailName.Contains(EquName)).ToList();
                                }
                                if (!string.IsNullOrEmpty(VendorName))
                                {
                                    list = list.Where(x => x.supplierName.Contains(VendorName)).ToList();
                                }
                                UiPrintList = new ObservableCollection<print_info>(new List<print_info>(
                                    list.Select(x => new print_info()
                                    {
                                        LabelType = "箱标",
                                        epc = x.epc,
                                        id = x.id,
                                        warehouseName = x.warehouseName,
                                        warehouseId = x.warehouseId,
                                        productName = x.equipmentDetailName,
                                        productId = x.equipmentDetailId,
                                        sizeName = x.sizeName,
                                        sizeId = x.sizeId,
                                        productTime = x.productTime,
                                        useTime = x.useTime,
                                        pieceNo = "1",
                                        warrantyCycle = x.warrantyCycle,
                                        repairCycle = x.repairCycle,
                                        price = x.price,
                                        supplierName = x.supplierName,
                                        supplierId = x.supplierId,
                                        oneBoxNum = x.oneBoxNum,
                                        epcListJson = JsonConvert.SerializeObject(x.epcList)
                                    })));
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });

        }
        private void OnPageChange()
        {
            return;
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = HttpHelper.GetPrintList(EpcType, LabelType.打印, PageIndex, VendorName, EquName);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            UiPrintList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                UiPrintList = new ObservableCollection<print_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }
        private void OnGenTag()
        {
        }
        private void OnPrintStart()
        {

            isStop = false;
            StopEnable = true;
            StartEnable = false;

            var print = UiPrintList.Where(t => t.IsSelected == true).ToList();

            Task.Run(() =>
            {
                foreach (var tsk_item in print)
                {
                    if (isStop)
                    {
                        break;
                    }
                    else
                    {
                        //tmp_id = tsk_item.Id;
                        var res = _window.printServerHelper.SendPrintCmd(new SingleInfo()
                        {
                            Info1 = tsk_item.productName,
                            Info2 = tsk_item.sizeName,
                            Info3 = tsk_item.supplierName,
                            Info4 = tsk_item.oneBoxNum.ToString(),
                            Info5 = tsk_item.pieceNo.ToString(),
                            Info6 = DateTime.Now.ToString("yyyy-MM-dd"),
                            Info9 = tsk_item.epc.Replace(" ", ""),
                            ModelType = "pieceXB"
                        });

                        //保存打印记录进文件
                        var json = JsonConvert.SerializeObject(new PrintLog
                        {
                            CreateTime = DateTime.Now,
                            IsSuccess = res,
                            epc = tsk_item.epc,
                            id = tsk_item.id,
                            orderCode = tsk_item.orderCode,
                            warehouseName = tsk_item.warehouseName,
                            productName = tsk_item.productName,
                            sizeName = tsk_item.sizeName,
                            productTime = tsk_item.productTime,
                            useTime = tsk_item.useTime,
                            pieceNo = tsk_item.pieceNo,
                            warrantyCycle = tsk_item.warrantyCycle,
                            repairCycle = tsk_item.repairCycle,
                            price = tsk_item.price,
                            supplierName = tsk_item.supplierName,
                            isBoxMark = true,
                            oneBoxNum = tsk_item.oneBoxNum
                        });
                        System.IO.File.AppendAllText(AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "PrintLog.json", json + "\r\n", Encoding.UTF8);


                        if (res)
                        {
                            UpdateEpcStateById(tsk_item.id.Replace(" ", ""), true);
                        }
                        //打印机异常，不继续发指令
                        else if (!res) { break; }
                        else { }
                    }
                }
                OnPrintStop();
            });
        }
        public void OnPrintStop()
        {
            StopEnable = false;
            StartEnable = true;
            isStop = true;
        }
        private void UpdateEpcStateById(string id, bool apply = false)
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                var item = UiPrintList.FirstOrDefault(t => t.id.Contains(id));
                if (item != null)
                {
                    item.state = 1;
                    Tuple<bool, string> flagData = new Tuple<bool, string>(true, "");
                    if (apply)
                    {
                        //箱标创建多个物品
                        var res = HttpHelper.GenerateRangeInventory(new recode_info
                        {
                            epc = item.epc,
                            sizeId = item.sizeId,
                            equId = item.productId,
                            epcListJson = item.epcListJson,
                            supplierId = item.supplierId,
                            warehouseId = item.warehouseId,
                            productTime = Convert.ToDateTime(item.productTime),
                            useTime = Convert.ToDateTime(item.useTime),
                            warrantyCycle = Convert.ToInt32(item.warrantyCycle),
                            price = Convert.ToSingle(item.price),
                            repairCycle = Convert.ToInt32(item.repairCycle),
                            IsReloadBoxing = true
                        }, out string msg);
                        flagData = new Tuple<bool, string>(res, msg);
                    }
                    if (flagData.Item1)
                    {
                        UiPrintList.Remove(item);
                        LiteDbHelper.DeleteByEpc(item.epc);
                        TotalRecord -= 1;

                        if (UiPrintList.Count == 0)
                        {
                            PageIndex = 1;
                            OnPageChange();
                        }
                    }
                    else
                    {
                        //EPC状态更新失败
                        UiMessage = flagData.Item2;
                        MsgColor = "Red";
                    }
                }
            });


        }
        public void EnableControl(bool flag, bool startEnable, bool stopEnable, string msg = "")
        {
            StartEnable = startEnable;
            StopEnable = stopEnable;

            if (!string.IsNullOrEmpty(msg))
            {
                UiMessage = "状态：" + msg;
                MsgColor = flag ? "Green" : "Red";
            }
        }
        public void SelectAll()
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                foreach (var item in UiPrintList)
                {
                    item.IsSelected = _isSelectAll;
                }
                this.RaisePropertyChanged(() => UiPrintList);
            });
        }
        public override void Cleanup()
        {
            base.Cleanup();
            isStop = true;
            _window.printServerHelper.EnableControlEvent -= EnableControl;
            NetworkComms.Shutdown();
        }
        #endregion

    }

}
