﻿using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;
using JmpZbModel;
using JmpZbPrint.Common;
using JmpZbPrint.Model;
using JmpZbPrint.PagePartial;
using JmpZbPrint.UsControl;
using MaterialDesignThemes.Wpf;
using NetworkCommsDotNet;
using NetworkCommsDotNet.Connections;
using NetworkCommsDotNet.Connections.TCP;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Threading;
using JmpZbPrint.Dialog;
using JmpZbPrint.View;

namespace JmpZbPrint.ViewModel
{
    public class IntPrintViewModel : ViewModelBase
    {
        private InternalWindow _window;
        public IntPrintViewModel(InternalWindow window)
        {
            _window = window;

            OnStartPrintItemsCmd = new RelayCommand(OnPrintStart);
            OnStopPrintItemsCmd = new RelayCommand(OnPrintStop);

            OnQueryCommand = new RelayCommand(OnQuery);
            OnPageChangeCmd = new RelayCommand(OnPageChange);
            OnWindowLoadCmd = new RelayCommand(OnWindowLoad);
            OnGenCommand = new RelayCommand(OnGenPrint);
            OnDeleteTagCmd = new RelayCommand(OnDeleteTag);

            OnBoxingCmd = new RelayCommand(OnBoxing);
            OnUnboxingCmd = new RelayCommand(OnUnboxing);
        }

        #region filed
        private WaitDialog waitDialog = default;
        private bool isStop = false;
        private ObservableCollection<recode_info> _printList = new ObservableCollection<recode_info>();
        public ObservableCollection<recode_info> UiPrintList
        {
            get { return _printList; }
            set
            {
                _printList = value;
                RaisePropertyChanged();
            }
        }

        private string _equName = string.Empty;
        public string EquName
        {
            get { return _equName; }
            set
            {
                _equName = value;
                RaisePropertyChanged();
            }
        }
        private string _vendorName = string.Empty;
        public string VendorName
        {
            get { return _vendorName; }
            set
            {
                _vendorName = value;
                RaisePropertyChanged();
            }
        }
        private string _message = "状态：初始化设备连接准备中";
        public string UiMessage
        {
            get { return _message; }
            set
            {
                _message = value;
                RaisePropertyChanged();
            }
        }

        private string _msgccolor = "Green";
        public string MsgColor
        {
            get { return _msgccolor; }
            set
            {
                _msgccolor = value;
                RaisePropertyChanged();
            }
        }

        private bool _bindButton = false;
        public bool BindButton
        {
            get { return _bindButton; }
            set
            {
                _bindButton = value;
                RaisePropertyChanged();
            }
        }
        private int _total = 0;
        public int TotalRecord
        {
            get { return _total; }
            set
            {
                _total = value;
                RaisePropertyChanged();
            }
        }
        private int _page = 0;
        public int PageIndex
        {
            get { return _page; }
            set
            {
                _page = value;
                RaisePropertyChanged();
            }
        }

        private int _pageTotal = 0;
        public int PageTotal
        {
            get { return _pageTotal; }
            set
            {
                _pageTotal = value;
                RaisePropertyChanged();
            }
        }

        private int _pageSize = 50;
        public int PageSize
        {
            get { return _pageSize; }
            set
            {
                _pageSize = value;
                RaisePropertyChanged();
            }
        }
        private bool _startEnable = false;
        public bool StartEnable
        {
            get { return _startEnable; }
            set
            {
                _startEnable = value;
                RaisePropertyChanged();
            }
        }
        private bool _stopEnable = false;
        public bool StopEnable
        {
            get { return _stopEnable; }
            set
            {
                _stopEnable = value;
                RaisePropertyChanged();
            }
        }
        private bool _isSelectAll = false;
        public bool IsSelectAll
        {
            get { return _isSelectAll; }
            set
            {
                _isSelectAll = value;
                RaisePropertyChanged();
                SelectAll();
            }
        }
        #endregion

        #region command
        public RelayCommand OnGenCommand { get; set; }
        public RelayCommand OnStartPrintItemsCmd { get; set; }
        public RelayCommand OnStopPrintItemsCmd { get; set; }
        public RelayCommand OnWindowLoadCmd { get; set; }
        public RelayCommand OnQueryCommand { get; set; }
        public RelayCommand OnPageChangeCmd { get; set; }
        public RelayCommand OnDeleteTagCmd { get; set; }
        public RelayCommand OnBoxingCmd { get; set; }
        public RelayCommand OnUnboxingCmd { get; set; }

        #endregion

        #region method

        /// <summary>
        /// 装箱
        /// </summary>
        private void OnBoxing()
        {
            var seled = UiPrintList.Where(t => t.IsSelected == true).ToList();
            if (seled.Count > 0)
            {
                if (seled.Any(x => x.LabelType == "箱标"))
                {
                    MessageBox.Show("禁止箱标装箱");
                    return;
                }
                if (MessageBox.Show("确认装箱选中的记录？", "确认装箱", MessageBoxButton.OKCancel, MessageBoxImage.Question) ==
                    MessageBoxResult.OK)
                {
                    //判断物资一致性
                    var info = seled.First();
                    if (seled.Any(x => x.equId != info.equId))
                    {
                        MessageBox.Show("物资类型不一致，无法装箱");
                        return;
                    }
                    if (seled.Any(x => x.sizeId != info.sizeId))
                    {
                        MessageBox.Show("物资型号不一致，无法装箱");
                        return;
                    }
                    if (seled.Any(x => x.supplierId != info.supplierId))
                    {
                        MessageBox.Show("供应商不一致，无法装箱");
                        return;
                    }
                    if (seled.Any(x => x.warehouseId != info.warehouseId))
                    {
                        MessageBox.Show("入库仓库不一致，无法装箱");
                        return;
                    }

                    //创建箱标epc
                    var boxRequest = new request_int_info()
                    {
                        labelType = "箱标",
                        equCode = info.equCode,
                        productTime = info.productTime,
                        sizeCode = info.sizeCode,
                        oneBoxNum = seled.Count,
                        quantity = 1,
                        supplierCode = info.suppilerCode,
                        warrantyCycle = info.warrantyCycle
                    };
                    var boxRes = HttpHelper.GenerateIntTagEpc(boxRequest, out string boxMsg);
                    if (!boxRes.Item1)
                    {
                        MessageBox.Show($"[{info.equName}-{info.sizeName}] 箱标生成失败，原因：{boxMsg}", "提示", MessageBoxButton.OK, MessageBoxImage.Error);
                        return;
                    }
                    var xbEpc = boxRes.Item2.First().epc;

                    var res = HttpHelper.BoxingInventory(xbEpc, seled, out string msg);
                    if (res)
                    {
                        var _batch_no = DateTime.Now.ToString("yyyyMMddHHmmssfff");

                        foreach (var obj in seled)
                        {
                            LiteDbHelper.Delete(obj.id);
                        }

                        LiteDbHelper.AddRange(new List<recode_info>()
                    {
                        new recode_info()
                        {
                            LabelType = "箱标",
                            orgId = info.orgId,
                            batchNo = _batch_no,
                            epc = xbEpc,
                            num = 1,
                            equCode = info.equCode,
                            equId = info.equId,
                            sizeCode = info.sizeCode,
                            equName = info.equName,
                            isdelete = false,
                            oneBoxNum = seled.Count,
                            needNum = 1,
                            price = info.price,
                            productTime = info.productTime,
                            repairCycle = info.repairCycle,
                            sizeId = info.sizeId,
                            sizeName = info.sizeName,
                            suppilerCode = info.suppilerCode,
                            supplierId = info.supplierId,
                            suppilerName = info.suppilerName,
                            type = 0, //打印
                            useTime = info.useTime,
                            warehouseId = info.warehouseId,
                            warehouseName = info.warehouseName,
                            warrantyCycle = info.warrantyCycle,
                            createTime = DateTime.Now,
                            IsReloadBoxing = true,
                            epcListJson = JsonConvert.SerializeObject(seled.Select(x => x.epc))
                        }
                    });
                    }
                    else
                    {
                        MessageBox.Show(msg);
                    }
                    OnQuery();
                }
            }
        }

        /// <summary>
        /// 拆箱
        /// </summary>
        private void OnUnboxing()
        {
            var selectBox = new SelectBoxEpc(true);
            selectBox.ShowDialog();
            var info = selectBox.RecodeInfo;
            if (info != null)
            {
                //拆箱
                List<recode_info> epc_record = new List<recode_info>();
                var epcListRes = HttpHelper.GetInventoryListByBoxMarkEpc(info.epc, out var msg);
                if (!epcListRes.Item1)
                {
                    MessageBox.Show("获取件标失败：" + msg);
                }
                var invList = epcListRes.Item2;
                var _batch_no = DateTime.Now.ToString("yyyyMMddHHmmssfff");
                for (var i = 0; i < invList.Count; i++)
                {
                    epc_record.Add(new recode_info()
                    {
                        LabelType = "件标",
                        orgId = invList[i].orgizationId,
                        batchNo = _batch_no,
                        epc = invList[i].epc,
                        num = i + 1,
                        equCode = invList[i].equipmentDetailCode,
                        equId = invList[i].equipmentDetailId,
                        sizeCode = invList[i].sizeCode,
                        equName = invList[i].equipmentDetailName,
                        isdelete = false,
                        needNum = 1,
                        price = Convert.ToSingle(invList[i].price),
                        productTime = invList[i].productTime,
                        repairCycle = invList[i].repairCycle,
                        sizeId = invList[i].sizeId,
                        sizeName = invList[i].sizeName,
                        suppilerCode = invList[i].supplierCode,
                        supplierId = invList[i].supplierId,
                        suppilerName = invList[i].supplierName,
                        type = invList[i].sizeEpcType,
                        useTime = invList[i].useTime,
                        warehouseId = invList[i].warehouseId,
                        warehouseName = invList[i].warehouseName,
                        warrantyCycle = invList[i].warrantyCycle,
                        createTime = DateTime.Now,
                        IsUnboxingLabel = true,
                        ShelfId = invList[i].shelfId,
                        ShelfRange = invList[i].shelfRange ?? 0,
                        ShelfRow = invList[i].shelfRow ?? 0,
                        ShelfColumn = invList[i].shelfColumn ?? 0,
                    });
                }
                //更新inbox状态
                var res = HttpHelper.UnpackRangeInventory(info.epc, out msg);

                if (res)
                {
                    LiteDbHelper.AddRange(epc_record);
                    LiteDbHelper.DeleteByEpc(info.epc);
                    OnQuery();
                }
                else
                {
                    MessageBox.Show("更新状态失败：" + msg);
                }
            }
        }
        private void OnGenPrint()
        {
            var gen = new IntGenEpcWindow(0);
            gen.OnRefreshGrid += OnRefreshGridSrc;
            gen.ShowDialog();
        }
        private void OnDeleteTag()
        {
            var seled = UiPrintList.Where(t => t.IsSelected == true).ToList();
            if (seled.Count() > 0)
            {
                if (seled.Any(x => x.IsReloadBoxing))
                {
                    MessageBox.Show("存在再装箱标签，禁止删除");
                    return;
                }
                if (MessageBox.Show("确认删除选中的条记录？", "确认删除", MessageBoxButton.OKCancel, MessageBoxImage.Question) == MessageBoxResult.OK)
                {
                    seled.ForEach(s =>
                    {
                        if (s.IsUnboxingLabel)
                        {
                            //拆箱生成标签直接报废记录
                            if (!HttpHelper.DeleteEpc(s.epc, out string msg))
                            {
                                MessageBox.Show(msg);
                                return;
                            }
                        }
                        LiteDbHelper.Delete(s.id);
                        UiPrintList.Remove(s);
                    });

                    if (UiPrintList.Count == 0)
                    {
                        OnQuery();
                    }
                    IsSelectAll = false;
                }
            }
        }
        private void OnRefreshGridSrc()
        {
            OnQuery();
        }
        public void OnWindowLoad()
        {
            OnQuery();
            _window.printServerHelper.EnableControlEvent += EnableControl;
            _window.printServerHelper.Init();
        }
        public void OnWindowClosing()
        {

        }
        private void OnQuery()
        {
            PageIndex = 1;
            IsSelectAll = false;
            UiPrintList.Clear();
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = LiteDbHelper.GetPage(PageIndex, PageSize, t => t.isdelete == false
                         && t.type == 0
                         && (string.IsNullOrEmpty(EquName) || t.equName.Contains(EquName))
                         && (string.IsNullOrEmpty(VendorName) || t.suppilerName.Contains(VendorName))
                         && t.orgId == CaChe.UserInfo.baseJpOrganization.id);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            UiPrintList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                UiPrintList = new ObservableCollection<recode_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });

        }
        private void OnPageChange()
        {
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = LiteDbHelper.GetPage(PageIndex, PageSize, t => t.isdelete == false
                           && t.type == 0
                           && (string.IsNullOrEmpty(EquName) || t.equName.Contains(EquName))
                           && (string.IsNullOrEmpty(VendorName) || t.suppilerName.Contains(VendorName))
                           && t.orgId == CaChe.UserInfo.baseJpOrganization.id);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            UiPrintList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                UiPrintList = new ObservableCollection<recode_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }
        private void OnPrintStart()
        {

            isStop = false;
            StopEnable = true;
            StartEnable = false;

            var print = UiPrintList.Where(t => t.IsSelected == true).ToList();

            Task.Run(() =>
            {
                foreach (var tsk_item in print)
                {
                    if (isStop)
                    {
                        break;
                    }
                    else
                    {
                        var res = false;
                        if (tsk_item.LabelType == "箱标")
                        {
                            //箱标
                            res = _window.printServerHelper.SendPrintCmd(new SingleInfo()
                            {
                                Info1 = tsk_item.equName,
                                Info2 = tsk_item.sizeName,
                                Info3 = tsk_item.suppilerName,
                                Info4 = tsk_item.oneBoxNum.ToString(),
                                Info5 = tsk_item.num.ToString(),
                                Info6 = DateTime.Now.ToString("yyyy-MM-dd"),
                                Info9 = tsk_item.epc.Replace(" ", ""),
                                ModelType = "pieceXB"
                            });
                        }
                        else
                        {
                            //件标
                            res = _window.printServerHelper.SendPrintCmd(new SingleInfo()
                            {
                                Info1 = tsk_item.equName,
                                Info2 = tsk_item.sizeName,
                                Info3 = tsk_item.suppilerName,
                                Info4 = tsk_item.num.ToString(),
                                Info5 = tsk_item.productTime?.ToString("yyyy-MM-dd"),
                                Info9 = tsk_item.epc.Replace(" ", ""),
                                ModelType = "piece"
                            });
                        }

                        if (res)
                        {
                            UpdateEpcStateById(tsk_item.id, true);
                        }
                        //打印机异常，不继续发指令
                        else if (!res) { break; }
                        else { }
                    }
                }
                OnPrintStop();
            });
        }
        public void OnPrintStop()
        {
            StopEnable = false;
            StartEnable = true;
            isStop = true;
            IsSelectAll = false;
            if (MsgColor == "Green")
            {
                //未出现异常
                UiMessage = "状态：打印结束";
            }
        }
        /// <summary>
        /// 打印成功创建物品进入数据库
        /// </summary>
        /// <param name="id"></param>
        /// <param name="apply"></param>
        private void UpdateEpcStateById(int id, bool apply = false)
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                var item = UiPrintList.FirstOrDefault(t => t.id == id);
                if (item != null)
                {
                    item.isdelete = true;
                    var flag = true;
                    if (apply)
                    {
                        if (item.LabelType == "箱标")
                        {
                            //箱标创建多个物品
                            var res = HttpHelper.GenerateRangeInventory(item, out string msg);
                            if (!res)
                            {
                                MsgColor = "Red";
                                UiMessage = msg;
                                flag = false;
                            }
                            else
                            {
                                if (msg != "操作成功")
                                {
                                    MsgColor = "Green";
                                    UiMessage = msg;
                                }
                                flag = LiteDbHelper.Update(item.id);
                            }
                        }
                        else
                        {
                            //件标
                            var res = HttpHelper.GenerateInventory(item, out string msg);
                            if (!res)
                            {
                                MsgColor = "Red";
                                UiMessage = "写入入库记录失败:" + msg;
                                flag = false;
                            }
                            else
                            {
                                flag = LiteDbHelper.Update(item.id);
                            }
                        }
                    }
                    if (flag)
                    {
                        UiPrintList.Remove(item);
                        TotalRecord -= 1;

                        if (UiPrintList.Count == 0)
                        {
                            PageIndex = 1;
                            OnPageChange();
                        }
                    }
                }
            });
        }
        public void EnableControl(bool flag, bool startEnable, bool stopEnable, string msg = "")
        {
            StartEnable = startEnable;
            StopEnable = stopEnable;

            if (!string.IsNullOrEmpty(msg))
            {
                UiMessage = "状态：" + msg;
                MsgColor = flag ? "Green" : "Red";
            }
        }
        public void SelectAll()
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                foreach (var item in UiPrintList)
                {
                    item.IsSelected = _isSelectAll;
                }
                this.RaisePropertyChanged(() => UiPrintList);
            });
        }
        public override void Cleanup()
        {
            base.Cleanup();
            isStop = true;
            _window.printServerHelper.EnableControlEvent -= EnableControl;
            NetworkComms.Shutdown();
        }
        #endregion

    }
}
