﻿using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;
using JmpZbPrint.Common;
using JmpZbPrint.Model;
using JmpZbPrint.UsControl;
using MaterialDesignThemes.Wpf;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Threading;

namespace JmpZbPrint.ViewModel
{
    public class IntHistoryViewModel : ViewModelBase
    {

        public IntHistoryViewModel()
        {
            OnQueryCommand = new RelayCommand(OnQuery);
            OnPageChangeCmd = new RelayCommand(OnPageChange);
            OnWindowLoadCmd = new RelayCommand(OnWindowLoad);
            OnScrapCmd = new RelayCommand<recode_info>(OnScrap);
            OnScrapAllCmd = new RelayCommand(OnScrapAll);
        }

        #region command
        public RelayCommand OnWindowLoadCmd { get; set; }
        public RelayCommand OnQueryCommand { get; set; }
        public RelayCommand OnGridLoadedCmd { get; set; }
        public RelayCommand<recode_info> OnScrapCmd { get; set; }
        public RelayCommand OnPageChangeCmd { get; set; }
        public RelayCommand OnScrapAllCmd { get; set; }
        #endregion

        #region filed
        private ObservableCollection<recode_info> _printList = new ObservableCollection<recode_info>();
        public ObservableCollection<recode_info> BindTaskList
        {
            get { return _printList; }
            set
            {
                _printList = value;
                RaisePropertyChanged();
            }
        }
        private AutoResetEvent resetEvent = new AutoResetEvent(false);

        private string _equName;
        public string EquName
        {
            get { return _equName; }
            set
            {
                _equName = value;
                RaisePropertyChanged();
            }
        }
        private string _vendorName;
        public string VendorName
        {
            get { return _vendorName; }
            set
            {
                _vendorName = value;
                RaisePropertyChanged();
            }
        }

        private int _total = 0;
        public int TotalRecord
        {
            get { return _total; }
            set
            {
                _total = value;
                RaisePropertyChanged();
            }
        }
        private int _page = 0;
        public int PageIndex
        {
            get { return _page; }
            set
            {
                _page = value;
                RaisePropertyChanged();
            }
        }

        private int _pageTotal = 0;
        public int PageTotal
        {
            get { return _pageTotal; }
            set
            {
                _pageTotal = value;
                RaisePropertyChanged();
            }
        }

        private int _pageSize = 50;
        public int PageSize
        {
            get { return _pageSize; }
            set
            {
                _pageSize = value;
                RaisePropertyChanged();
            }
        }
        private bool _isSelectAll = false;
        public bool IsSelectAll
        {
            get { return _isSelectAll; }
            set
            {
                _isSelectAll = value;
                RaisePropertyChanged();
                SelectAll();
            }
        }
        #endregion

        #region attr
        #endregion

        #region method
        private WaitDialog waitDialog = default;
        public void OnWindowLoad()
        {
            OnQuery();
        }
        public void OnWindowClosing()
        {

        }
        private void OnQuery()
        {
            IsSelectAll = false;
            BindTaskList.Clear();
            PageIndex = 1;
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = LiteDbHelper.GetPage(PageIndex, PageSize, t => t.isdelete == true
                         && t.LabelType == "件标"
                         && (string.IsNullOrEmpty(EquName) || t.equName.Contains(EquName))
                         && (string.IsNullOrEmpty(VendorName) || t.suppilerName.Contains(VendorName))
                         && t.orgId == CaChe.UserInfo.baseJpOrganization.id);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            BindTaskList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                BindTaskList = new ObservableCollection<recode_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }
        private void OnPageChange()
        {
            IsSelectAll = false;
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = LiteDbHelper.GetPage(PageIndex, PageSize, t => t.isdelete == true
                         && t.LabelType == "件标"
                         && (string.IsNullOrEmpty(EquName) || t.equName.Contains(EquName))
                         && (string.IsNullOrEmpty(VendorName) || t.suppilerName.Contains(VendorName))
                         && t.orgId == CaChe.UserInfo.baseJpOrganization.id);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            BindTaskList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                BindTaskList = new ObservableCollection<recode_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }
        public override void Cleanup()
        {
            base.Cleanup();
            resetEvent.Set();
        }
        public void SelectAll()
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                foreach (var item in BindTaskList)
                {
                    item.IsSelected = _isSelectAll;
                }
                this.RaisePropertyChanged(() => BindTaskList);
            });
        }
        private void OnScrapAll()
        {
            var seled = BindTaskList.Where(t => t.IsSelected == true).ToList();
            if (seled.Count() > 0)
            {
                if (MessageBox.Show("确认删除选中的库存记录？", "确认删除", MessageBoxButton.OKCancel, MessageBoxImage.Question) == MessageBoxResult.OK)
                {
                    foreach (var item in seled)
                    {
                        //请求http报废接口
                        var res = HttpHelper.DeleteEpc(item.epc, out string msg);
                        if (res)
                        {
                            LiteDbHelper.Delete(item.id);
                            BindTaskList.Remove(item);
                        }
                        else
                        {
                            MessageBox.Show($"删除失败，原因：{msg}", "提示", MessageBoxButton.OK, MessageBoxImage.Error);
                            break;
                        }
                    }
                    if (BindTaskList.Count == 0)
                    {
                        OnQuery();
                    }
                    IsSelectAll = false;
                }
            }
        }
        private void OnScrap(recode_info entity)
        {
            if (entity != null)
            {
                if (MessageBox.Show("确认删除此条库存记录？", "确认删除", MessageBoxButton.OKCancel, MessageBoxImage.Question) == MessageBoxResult.OK)
                {
                    //请求http报废接口
                    var res = HttpHelper.DeleteEpc(entity.epc, out string msg);
                    if (res)
                    {
                        //请求成功，删除记录
                        LiteDbHelper.Delete(entity.id);
                        BindTaskList.Remove(entity);

                        if (BindTaskList.Count == 0)
                        {
                            OnQuery();
                        }
                        IsSelectAll = false;
                    }
                    else
                    {
                        MessageBox.Show($"删除失败，原因：{msg}", "提示", MessageBoxButton.OK, MessageBoxImage.Error);
                    }
                }
            }

        }
        #endregion
    }
}
