﻿using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;
using JmpZbPrint.Model;
using JmpZbPrint.PagePartial;
using JmpZbPrint.UsControl;
using MaterialDesignThemes.Wpf;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Threading;

namespace JmpZbPrint.ViewModel
{
    public class GenEpcViewModel : ViewModelBase
    {
        public GenEpcViewModel()
        {
            OnQueryCommand = new RelayCommand(OnQuery);
            OnPageChangeCmd = new RelayCommand(OnPageChange);
            OnGenTagCmd = new RelayCommand<order_info>(OnGenTag);
            OnWindowLoadCmd = new RelayCommand(OnWindowLoad);
        }

        #region filed
        private ObservableCollection<order_info> _printList = new ObservableCollection<order_info>();
        public ObservableCollection<order_info> UiGenList
        {
            get { return _printList; }
            set
            {
                //PageTotal = GetPageTotal(value.Where(t => t.Status == "未打印").Count());
                //TotalRecord = value.Count;

                _printList = value;
                RaisePropertyChanged();

            }
        }
        private string _orderCode;
        public string OrderCode
        {
            get { return _orderCode; }
            set
            {
                _orderCode = value;
                RaisePropertyChanged();
            }
        }
        private string _equName;
        public string EquName
        {
            get { return _equName; }
            set
            {
                _equName = value;
                RaisePropertyChanged();
            }
        }
        //private DateTime _createTime=DateTime.Now;
        //public DateTime CreateTime
        //{
        //    get { return _createTime; }
        //    set
        //    {
        //        _createTime = value;
        //        RaisePropertyChanged();
        //    }
        //}
        private bool _isSelectAll = false;
        private WaitDialog waitDialog = default;
        public bool IsSelectAll
        {

            get { return _isSelectAll; }
            set
            {
                _isSelectAll = value;
                RaisePropertyChanged(() => IsSelectAll);
                SelectAll();
            }
        }
        private int _total = 0;
        public int TotalRecord
        {
            get { return _total; }
            set
            {
                _total = value;
                RaisePropertyChanged();
            }
        }
        private int _page = 0;
        public int PageIndex
        {
            get { return _page; }
            set
            {
                _page = value;
                RaisePropertyChanged();
            }
        }

        private int _pageTotal = 0;
        public int PageTotal
        {
            get { return _pageTotal; }
            set
            {
                _pageTotal = value;
                RaisePropertyChanged();
            }
        }

        private int _pageSize = 50;
        public int PageSize
        {
            get { return _pageSize; }
            set
            {
                _pageSize = value;
                RaisePropertyChanged();
            }
        }
        #endregion

        #region cmd attr
        public RelayCommand OnWindowLoadCmd { get; set; }
        public RelayCommand OnQueryCommand { get; set; }
        public RelayCommand OnPageChangeCmd { get; set; }
        public RelayCommand<order_info> OnGenTagCmd { get; set; }
        #endregion

        #region method
        public void OnWindowLoad()
        {
            OnQuery();
        }
        public void OnWindowClosing()
        {

        }
        private void OnQuery()
        {
            PageIndex = 1;
            IsSelectAll = false;
            UiGenList.Clear();

            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = HttpHelper.GetOrderList(OrderCode, EquName);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            UiGenList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                UiGenList = new ObservableCollection<order_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }
        private void OnPageChange()
        {
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = HttpHelper.GetOrderList(OrderCode, EquName);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            UiGenList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                UiGenList = new ObservableCollection<order_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }
        private void OnGenTag(order_info order)
        {
            var orders = UiGenList.Where(s => s.IsSelected == true).ToList();
            if (orders == null || orders.Count() == 0)
            {
                new SetBasicInfo(new List<order_info>() { order }).ShowDialog();
            }
            else
            {
                new SetBasicInfo(orders).ShowDialog();
            }

            OnQuery();
        }
        public void SelectAll()
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                foreach (var item in UiGenList)
                {
                    item.IsSelected = _isSelectAll;
                }
                this.RaisePropertyChanged(() => UiGenList);
            });
        }
        #endregion
    }

}
