﻿using JmpZbPrint.Dialog;
using JmpZbPrint.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Markup;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace JmpZbPrint.View
{
    /// <summary>
    /// SupplierWin.xaml 的交互逻辑
    /// </summary>
    public partial class SetGenInfoV2 : Window
    {
        private readonly string _type;
        public event Action<recode_info> OnRefreshGrid;
        public recode_info record { get; set; }
        public List<Supplier> SupplierList { get; set; } = new List<Supplier>();
        public List<WarehouseInfo> WarehouseList { get; set; } = new List<WarehouseInfo>();
        public SetGenInfoV2(string type)
        {
            InitializeComponent();
            _type = type;
            record = new recode_info();
            WarehouseList = HttpHelper.GetWarehouse();

            //修正界面
            if (_type == "件标")
            {
                this.Height = 755;
                txtTitle.Text = "创建件标";
                spOneBoxNum.Visibility = Visibility.Collapsed;
                spNum.Visibility = Visibility.Visible;

                spBoxNum.Visibility = Visibility.Collapsed;
                Grid.RowDefinitions[10].Height = new GridLength(0);
            }
        }
        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
        }

        private void OnSelectVendor_Click(object sender, RoutedEventArgs e)
        {
            var win = new SupplierWindow();
            win.ShowDialog();
            if (win.Supplier != null)
            {
                if (!SupplierList.Any(t => t.id == win.Supplier.id))
                {
                    SupplierList.Insert(0, win.Supplier);
                    cboSupplier.ItemsSource = null;
                    cboSupplier.ItemsSource = SupplierList;
                    cboSupplier.DisplayMemberPath = "name";
                    cboSupplier.SelectedValuePath = "id";
                    cboSupplier.SelectedIndex = 0;
                }
            }
        }
        private void OnSelectEqu_Click(object sender, RoutedEventArgs e)
        {
            var equ = new SelectEqu();
            equ.ShowDialog();
            if (equ.EquInfo != null)
            {
                txtEquName.Text = equ.EquInfo.name;
                record = new recode_info();
                record.equCode = equ.EquInfo.code;
                record.equId = equ.EquInfo.id;
                record.equName = equ.EquInfo.name;

                //查询号型
                var equ_attr = HttpHelper.GetEquInfoById(equ.EquInfo.id);
                if (equ_attr != null)
                {
                    SupplierList = equ_attr.suppliers;
                    cboSupplier.ItemsSource = null;
                    cboSupplier.ItemsSource = SupplierList;
                    cboSupplier.DisplayMemberPath = "name";
                    cboSupplier.SelectedValuePath = "id";
                    cboSupplier.SelectedIndex = 0;

                    cboSize.ItemsSource = equ_attr.sizes;
                    cboSize.DisplayMemberPath = "name";
                    cboSize.SelectedValuePath = "id";
                    cboSize.SelectedIndex = 0;
                    cboSize_SelectionChanged(null, null);
                }

            }
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            cboWarehouse.ItemsSource = WarehouseList;
            cboWarehouse.DisplayMemberPath = "name";
            cboWarehouse.SelectedValuePath = "id";
            cboWarehouse.SelectedIndex = 0;

            if (cboWarehouse.SelectedItem != null)
            {
                var warehouse = cboWarehouse.SelectedItem as WarehouseInfo;
                var shelfList = HttpHelper.GetShelfByWarehouseId(warehouse.id) ?? new List<ShelfInfo>();
                shelfList.Insert(0, new ShelfInfo
                {
                    id = "",
                    name = "（未指定）"
                });
                cboShelf.ItemsSource = shelfList;
                cboShelf.DisplayMemberPath = "name";
                cboShelf.SelectedValuePath = "id";
                cboShelf.SelectedIndex = 0;
            }
            spShelfData.IsEnabled = false;
            spMessage.Visibility = Visibility.Hidden;

            dtUseDate.Language=XmlLanguage.GetLanguage("en-CA");
            dtProductDate.Language=XmlLanguage.GetLanguage("en-CA");
            dtProductDate.SelectedDate = DateTime.Now.AddDays(-7);
            dtUseDate.SelectedDate = DateTime.Now;
        }

        private void OnSave_Click(object sender, RoutedEventArgs e)
        {
            int oneBoxNum = 0;
            int boxNum = 0;
            int genNum = 0;
            if (string.IsNullOrEmpty(record.equId))
            {
                MessageBox.Show("装备未选择", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (cboSize.SelectedItem == null)
            {
                MessageBox.Show("号型未选择", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (cboWarehouse.SelectedItem == null)
            {
                MessageBox.Show("入库仓库未选择", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (cboSupplier.SelectedItem == null)
            {
                MessageBox.Show("供应商未选择", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (dtUseDate.SelectedDate == null)
            {
                MessageBox.Show("使用日期未选择", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (dtProductDate.SelectedDate == null)
            {
                MessageBox.Show("生产日期未选择", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (string.IsNullOrEmpty(txtPrice.Text)
                || !decimal.TryParse(txtPrice.Text, out decimal price)
                || price <= 0)
            {
                MessageBox.Show("单价输入不正确", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (string.IsNullOrEmpty(txtZbq.Text)
               || !int.TryParse(txtZbq.Text, out int warrantyCycle)
               || warrantyCycle < 0)
            {
                MessageBox.Show("质保周期输入不正确", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (string.IsNullOrEmpty(txtWxzq.Text)
              || !int.TryParse(txtWxzq.Text, out int repairCycle)
              || repairCycle <= 0)
            {
                MessageBox.Show("维保周期输入不正确", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (_type == "件标" && (string.IsNullOrEmpty(txtNum.Text)
                                       || !int.TryParse(txtNum.Text, out genNum)
                                       || genNum <= 0))
            {
                MessageBox.Show("数量输入不正确", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (_type == "箱标" && (string.IsNullOrEmpty(txtOneBoxNum.Text)
                                       || !int.TryParse(txtOneBoxNum.Text, out oneBoxNum)
                                       || oneBoxNum <= 0))
            {
                MessageBox.Show("数量/箱输入不正确", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (_type == "箱标" && (string.IsNullOrEmpty(txtBoxNum.Text)
                                       || !int.TryParse(txtBoxNum.Text, out boxNum)
                                       || boxNum <= 0))
            {
                MessageBox.Show("箱数输入不正确", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else
            {
                var size = cboSize.SelectedItem as EquSizeInfo;
                var supplier = cboSupplier.SelectedItem as Supplier;
                var warehouse = cboWarehouse.SelectedItem as WarehouseInfo;
                var shelf = cboShelf.SelectedItem as ShelfInfo;

                record.sizeCode = size.code;
                record.sizeId = size.id;
                record.sizeName = size.name;

                record.suppilerCode = supplier.code;
                record.supplierId = supplier.id;
                record.suppilerName = supplier.name;

                record.warehouseId = warehouse.id;
                record.warehouseName = warehouse.name;

                record.useTime = dtUseDate.SelectedDate;
                record.productTime = dtProductDate.SelectedDate;

                record.repairCycle = repairCycle;
                record.warrantyCycle = warrantyCycle;
                record.price = (float)price;

                record.ShelfId = shelf?.id;
                record.ShelfName = string.IsNullOrEmpty(record.ShelfId) ? "" : shelf?.name;
                record.ShelfRange = cboShelfRange.SelectedIndex > 0 && !string.IsNullOrEmpty(record.ShelfId) ? cboShelfRange.SelectedIndex : 0;
                record.ShelfColumn = cboShelfColumn.SelectedIndex > 0 && record.ShelfRange > 0 ? cboShelfColumn.SelectedIndex : 0;
                record.ShelfRow = cboShelfRow.SelectedIndex > 0 && record.ShelfColumn > 0 ? cboShelfRow.SelectedIndex : 0;

                if (_type == "箱标")
                {
                    record.needNum = boxNum;
                    record.oneBoxNum = oneBoxNum;
                }
                else
                {
                    record.needNum = genNum;
                }

                record.LabelType = _type;

                OnRefreshGrid?.Invoke(record);
            }
        }

        private void OnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void cboWarehouse_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            //切换仓库
            if (e.RemovedItems.Count > 0)
            {
                //事件响应
                var warehouse = cboWarehouse.SelectedItem as WarehouseInfo;
                if (warehouse == null)
                {
                    return;
                }
                var shelfList = HttpHelper.GetShelfByWarehouseId(warehouse.id) ?? new List<ShelfInfo>();
                shelfList.Insert(0, new ShelfInfo
                {
                    id = "",
                    name = "（未指定）"
                });
                cboShelf.SelectionChanged -= cboShelf_SelectionChanged;
                cboShelf.ItemsSource = null;
                cboShelf.ItemsSource = shelfList;
                cboShelf.DisplayMemberPath = "name";
                cboShelf.SelectedValuePath = "id";
                cboShelf.SelectedIndex = 0;
                cboShelf.SelectionChanged += cboShelf_SelectionChanged;

                cboShelfRange.ItemsSource = null;
                cboShelfRow.ItemsSource = null;
                cboShelfColumn.ItemsSource = null;
                spShelfData.IsEnabled = false;
                spMessage.Visibility = Visibility.Hidden;
                cboSize_SelectionChanged(null, null);
            }
        }
        private void cboShelf_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            //切换货架
            if (e.RemovedItems.Count > 0)
            {
                //事件响应
                var shelf = cboShelf.SelectedItem as ShelfInfo;
                if (!string.IsNullOrEmpty(shelf?.id))
                {
                    cboShelfRange.ItemsSource = CreateSelectList(Convert.ToInt32(shelf.range));
                    cboShelfRange.SelectedIndex = 0;
                    cboShelfRow.ItemsSource = CreateSelectList(Convert.ToInt32(shelf.row));
                    cboShelfRow.SelectedIndex = 0;
                    cboShelfColumn.ItemsSource = CreateSelectList(Convert.ToInt32(shelf.column));
                    cboShelfColumn.SelectedIndex = 0;
                    spShelfData.IsEnabled = true;
                }
                else
                {
                    cboShelfRange.ItemsSource = null;
                    cboShelfRow.ItemsSource = null;
                    cboShelfColumn.ItemsSource = null;
                    spShelfData.IsEnabled = false;
                }
            }
        }

        private List<string> CreateSelectList(int count)
        {
            var list = new List<string>();
            list.Add("（未指定）");
            for (int i = 1; i <= count; i++)
            {
                list.Add(i.ToString());
            }
            return list;
        }

        private void cboSize_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            //切换号型
            if (e == null || e.RemovedItems.Count > 0)
            {
                if (cboSize.SelectedItem is EquSizeInfo size)
                {
                    txtPrice.Text = size.price?.ToString() ?? "";

                    var warehouse = cboWarehouse.SelectedItem as WarehouseInfo;
                    if (warehouse == null)
                    {
                        return;
                    }
                    var shelfList = HttpHelper.GetListEquipmentShelfPosition(warehouse.id, record.equId, size.id) ?? new List<ShelfInfo>();
                    if (shelfList.Count > 0)
                    {
                        spMessage.Visibility = Visibility.Visible;
                        tbMessage.Text = string.Join("\r\n", shelfList.Take(3).Select(x => x.name +
                            (
                                string.IsNullOrEmpty(x.range) ? "" : "-" + x.range +
                                (
                                    string.IsNullOrEmpty(x.column) ? "" : "-" + x.column +
                                    (
                                        string.IsNullOrEmpty(x.row) ? "" : "-" + x.row
                                    )
                                )
                            )
                            ));
                        if (shelfList.Count > 3)
                        {
                            tbMessage.Text += " 等";
                        }
                        //装填第一条信息
                        var shelf = shelfList.First();
                        cboShelf.SelectedIndex = cboShelf.ItemsSource.OfType<ShelfInfo>().ToList()
                            .FindIndex(x => x.id == shelf.id);
                        cboShelfRange.SelectedIndex = Convert.ToInt32(shelf.range);
                        cboShelfColumn.SelectedIndex = Convert.ToInt32(shelf.column);
                        cboShelfRow.SelectedIndex = Convert.ToInt32(shelf.row);
                    }
                    else
                    {
                        spMessage.Visibility = Visibility.Hidden;
                    }
                }
                else
                {
                    spMessage.Visibility = Visibility.Hidden;
                }
            }
        }
    }
}
