﻿using JmpZbPrint.PagePartial;
//using rfidLink.Extend;
using System;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using JmpZbPrint.Common;
using JmpZbPrint.ViewModel;

namespace JmpZbPrint.View
{
    /// <summary>
    /// MainWindow.xaml 的交互逻辑
    /// </summary>
    public partial class MainWindow : Window
    {
        private bool isLoad = false;
        private GenEpcWindow genWindow;
        private TagPrintWindow printWindow;
        private TagBindWindow bindWindow;
        private TagBoxPrintWindow printxbWindow;
        private TagBagPrintWindow printBagWindow;

        public IPrintServerHelper printServerHelper;
        public MainWindow()
        {
            try
            {
                InitializeComponent();
                this.txtTitle.Text = CaChe.SysConfig?.AppTitle ?? "";
                this.Title = CaChe.SysConfig?.AppTitle ?? "";
                var card_only = CaChe.SysConfig?.CardOnly ?? false;
                tbi_print.Visibility = card_only ? Visibility.Collapsed : Visibility.Visible;

                switch (CaChe.SysConfig?.PrintType)
                {
                    case 0:
                        {
                            printServerHelper = new ToShiBaPrintServerHelper();
                            break;
                        }
                    case 1:
                        {
                            printServerHelper = new PostekPrintServerHelper();
                            break;
                        }
                    default:
                        {
                            //默认东芝
                            printServerHelper = new ToShiBaPrintServerHelper();
                            break;
                        }
                }

                genWindow = new GenEpcWindow();
                printWindow = new TagPrintWindow(this);
                bindWindow = new TagBindWindow();
                printxbWindow = new TagBoxPrintWindow(this);
                printBagWindow = new TagBagPrintWindow(this);

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }

            //检查软件更新
            if (CaChe.SysConfig?.IsAutoUpdate == true)
            {
                var date = DateTime.Now.Date;
                Task.Run(() =>
                {
                    while (true)
                    {
                        try
                        {
                            if (DateTime.Now.Date > date && DateTime.Now.Hour == CaChe.SysConfig?.AutoUpdateTime)
                            {
                                //检查更新
                                var update = HttpHelper.GetUpdate(CaChe.SysConfig?.AppCode ?? "");
                                if (update == null)
                                {
                                    Log.ErrorLog("获取更新信息失败 AppCode=" + CaChe.SysConfig?.AppCode);
                                }
                                else
                                {
                                    if (Version.TryParse(update.autoUpdateVersion2, out var version) && version > new Version(CaChe.SysConfig.AppVersion))
                                    {
                                        var fullFile = AppDomain.CurrentDomain.BaseDirectory + update.autoUpdateAddress.TrimStart('/').Replace('/', '\\');

                                        if (!File.Exists(fullFile))
                                        {
                                            //下载新版本
                                            var downloadRes = HttpHelper.HttpDownload(
                                                CaChe.SysConfig.DomainUrl.TrimEnd('/') + "/" +
                                                update.autoUpdateAddress.TrimStart('/'), fullFile);
                                            if (!downloadRes)
                                            {
                                                //下载失败，60秒后重试
                                                Thread.Sleep(60000);
                                                continue;
                                            }
                                        }
                                        //比较md5确认下载完整
                                        if (update.autoUpdateFileMd5 == HttpHelper.GetMD5HashFromFile(fullFile))
                                        {
                                            //成功之后再更新日期
                                            date = DateTime.Now.Date;
                                            App.Current.Dispatcher.Invoke(() =>
                                            {
                                                new AutoClosingMessageBox(this, "新版本下载完毕，是否更新？", "版本更新提示", 10, () =>
                                                {
                                                    //var proc = new ProcessStartInfo(fullFile);
                                                    //proc.UseShellExecute = true;
                                                    //proc.Verb = "runas";
                                                    System.Diagnostics.Process.Start(fullFile);
                                                    Process.GetCurrentProcess().Kill();

                                                }).ShowDialog();
                                            });
                                        }
                                        else
                                        {
                                            //文件错误，删除
                                            File.Delete(fullFile);
                                        }

                                    }
                                }

                            }
                        }
                        catch (Exception e)
                        {
                            Log.ErrorLog(e.Message);
                        }
                        //60s检查一次
                        Thread.Sleep(60000);
                    }
                });
            }

        }


        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
        }

        private object syncObj = new object();
        private void OnDataGridLoadingRow(object sender, DataGridRowEventArgs e)
        {
            lock (syncObj)
            {
                e.Row.Header = e.Row.GetIndex() + 1;
            }
        }

        private void OnTabSelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (isLoad)
            {
                switch (tb_ctrl.SelectedIndex)
                {
                    case 0:
                        {
                            //genWindow.DataContext = genModel;
                            //ContentControl.Content = genWindow;
                            //ContentControl.DataContext = genModel;
                            gen_control.Visibility = Visibility.Visible;
                            bin_control.Visibility = Visibility.Collapsed;
                            if (bindWindow.DataContext is TagBindViewModel model)
                            {
                                model.resetEvent.Set();
                                model.cWsServiceToken?.Cancel();
                                model.wsConn?.Close();
                            }
                            pri_control.Visibility = Visibility.Collapsed;
                            prixb_control.Visibility = Visibility.Collapsed;
                            priBag_control.Visibility = Visibility.Collapsed;
                            break;
                        }
                    case 1:
                        {
                            //printWindow.DataContext = printModel;
                            gen_control.Visibility = Visibility.Collapsed;
                            bin_control.Visibility = Visibility.Collapsed;
                            if (bindWindow.DataContext is TagBindViewModel model)
                            {
                                model.resetEvent.Set();
                                model.cWsServiceToken?.Cancel();
                                model.wsConn?.Close();
                            }
                            pri_control.Visibility = Visibility.Visible;
                            prixb_control.Visibility = Visibility.Collapsed;
                            priBag_control.Visibility = Visibility.Collapsed;
                            break;
                        }
                    case 2:
                        {
                            //bindWindow.DataContext = bindModel;
                            gen_control.Visibility = Visibility.Collapsed;
                            bin_control.Visibility = Visibility.Visible;
                            if (bindWindow.DataContext is TagBindViewModel model)
                            {
                                if (model.taskWsService != null)
                                {
                                    model.taskWsService.Dispose();
                                    model.taskWsService = null;
                                    model.InitWs();
                                }
                            }
                            pri_control.Visibility = Visibility.Collapsed;
                            prixb_control.Visibility = Visibility.Collapsed;
                            priBag_control.Visibility = Visibility.Collapsed;
                            break;
                        }
                    case 3:
                        {
                            //bindWindow.DataContext = bindModel;
                            gen_control.Visibility = Visibility.Collapsed;
                            bin_control.Visibility = Visibility.Collapsed;
                            if (bindWindow.DataContext is TagBindViewModel model)
                            {
                                model.resetEvent.Set();
                                model.cWsServiceToken?.Cancel();
                                model.wsConn?.Close();
                            }
                            pri_control.Visibility = Visibility.Collapsed;
                            prixb_control.Visibility = Visibility.Visible;
                            priBag_control.Visibility = Visibility.Collapsed;
                            break;
                        }
                    case 4:
                        {
                            //bindWindow.DataContext = bindModel;
                            gen_control.Visibility = Visibility.Collapsed;
                            bin_control.Visibility = Visibility.Collapsed;
                            if (bindWindow.DataContext is TagBindViewModel model)
                            {
                                model.resetEvent.Set();
                                model.cWsServiceToken?.Cancel();
                                model.wsConn?.Close();
                            }
                            pri_control.Visibility = Visibility.Collapsed;
                            prixb_control.Visibility = Visibility.Collapsed;
                            priBag_control.Visibility = Visibility.Visible;
                            break;
                        }
                    default:
                        break;
                }

            }
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            isLoad = true;
            tb_ctrl.SelectedIndex = 0;
            gen_control.Visibility = Visibility.Visible;
            gen_control.Content = genWindow;
            pri_control.Content = printWindow;
            bin_control.Content = bindWindow;
            prixb_control.Content = printxbWindow;
            priBag_control.Content = printBagWindow;
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            printWindow.Clearup();
            printxbWindow.Clearup();
            printBagWindow.Clearup();
            bindWindow.Clearup();
            printServerHelper.Dispose();
            Process.GetCurrentProcess().Kill();
        }
    }
}
