﻿using JmpZbPrint.Dialog;
using JmpZbPrint.Model;
using JmpZbPrint.ViewModel;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using JmpZbPrint.View;

namespace JmpZbPrint.PagePartial
{
    /// <summary>
    /// TagBagPrintWindow.xaml 的交互逻辑
    /// </summary>
    public partial class TagBagPrintWindow : UserControl
    {
        private TagBagPrinViewModel vm;
        private MainWindow _window;
        public TagBagPrintWindow(MainWindow window)
        {
            InitializeComponent();
            _window = window;
            vm = new TagBagPrinViewModel(window);
            this.DataContext = vm;
            chk_pri.DataContext = vm;
        }
        private object syncObj = new object();
        private void OnDataGridLoadingRow(object sender, DataGridRowEventArgs e)
        {
            lock (syncObj)
            {
                e.Row.Header = e.Row.GetIndex() + 1;
            }
        }
        public void Clearup()
        {
            vm.Cleanup();
        }
        private void pri_win_IsVisibleChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            if (!IsVisible)
            {
                _window.printServerHelper.EnableControlEvent -= vm.EnableControl;
            }
        }
    }
}
