﻿using GalaSoft.MvvmLight;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace JmpZbPrint.Model
{
    public class recode_info : ViewModelBase
    {
        /// <summary>
        /// 标签类型
        /// 箱标
        /// 件标
        /// </summary>
        public string LabelType { get; set; }

        [JsonIgnore]
        public int id { get; set; }
        public string equId { get; set; }
        public string equName { get; set; }
        public string equCode { get; set; }
        public string sizeId { get; set; }
        public string sizeCode { get; set; }
        public string sizeName { get; set; }
        public string supplierId { get; set; }
        public string suppilerCode { get; set; }
        public string suppilerName { get; set; }
        public DateTime? productTime { get; set; } = DateTime.Now.AddDays(-7);
        public DateTime? useTime { get; set; } = DateTime.Now;
        public int warrantyCycle { get; set; }
        public int repairCycle { get; set; }
        public float price { get; set; }

        /// <summary>
        /// 物品数量（件标：个数  箱标：箱数）
        /// </summary>
        public int needNum { get; set; }
        /// <summary>
        /// 单箱装箱个数
        /// </summary>
        public int oneBoxNum { get; set; }

        public string warehouseId { get; set; }
        public string warehouseName { get; set; }

        /// <summary>
        /// 是否是拆箱生成的标签
        /// </summary>
        public bool IsUnboxingLabel { get; set; }
        /// <summary>
        /// 是否是重装箱
        /// </summary>
        public bool IsReloadBoxing { get; set; }

        /// <summary>
        /// 货架id
        /// </summary>
        public string ShelfId { get; set; }
        /// <summary>
        /// 货架名称
        /// </summary>
        public string ShelfName { get; set; }
        /// <summary>
        /// 货架排
        /// </summary>
        public int ShelfRange { get; set; }
        /// <summary>
        /// 货架行
        /// </summary>
        public int ShelfRow { get; set; }
        /// <summary>
        /// 货架列
        /// </summary>
        public int ShelfColumn { get; set; }
        /// <summary>
        /// 货架信息（拼接）
        /// </summary>
        [JsonIgnore]
        public string ShelfInfo
        {
            get
            {
                var str = ShelfName;
                if (ShelfRange != 0)
                {
                    str += "-" + ShelfRange;
                    if (ShelfColumn != 0)
                    {
                        str += "-" + ShelfColumn;
                        if (ShelfRow != 0)
                        {
                            str += "-" + ShelfRow;
                        }
                    }
                }
                return str;
            }

        }

        [JsonIgnore]
        public int num { get; set; }
        [JsonIgnore]
        public string epc { get; set; }
        [JsonIgnore]
        public string tid { get; set; }
        /// <summary>
        /// 箱标epcList（json）
        /// </summary>
        [JsonIgnore]
        public string epcListJson { get; set; }
        [JsonIgnore]
        public int type { get; set; }
        [JsonIgnore]
        public bool isdelete { get; set; } = false;
        [JsonIgnore]
        public bool _isSelected { get; set; }
        [JsonIgnore]
        public bool IsSelected
        {
            get
            {
                return _isSelected;

            }
            set
            {
                _isSelected = value;
                RaisePropertyChanged();
            }
        }
        [JsonIgnore]
        public DateTime? createTime { get; set; }
        [JsonIgnore]
        public string batchNo { get; set; }
        [JsonIgnore]
        public string orgId { get; set; }
        /// <summary>
        /// 标签打印时间
        /// </summary>
        [JsonIgnore]
        public DateTime PrintTime { get; set; }
        /// <summary>
        /// 是否为旧数据导入成功
        /// </summary>
        [JsonIgnore]
        public bool IsImported { get; set; }
    }
}
