﻿using GalaSoft.MvvmLight;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace JmpZbPrint.Model
{
    public class order_info : ViewModelBase
    {
        public string orderId { get; set; }
        public string detailId { get; set; }
        public string createTime { get; set; }
        public string equCode { get; set; }
        public string equName { get; set; }
        public string equId { get; set; }
        public string sizeId { get; set; }
        public string sizeCode { get; set; }
        public string sizeName { get; set; }
        public string orderCode { get; set; }
        public int genedNum { get; set; }
        public int totalNum { get; set; }
        public ObservableCollection<Supplier> suppilers { get; set; }
        public int reNum { get; set; }
        [Newtonsoft.Json.JsonIgnore]
        private bool _select = false;
        [Newtonsoft.Json.JsonIgnore]
        public bool IsSelected
        {
            get
            {
                return _select;
            }
            set
            {
                _select = value;
                this.RaisePropertyChanged(() => IsSelected);
            }
        }
        [Newtonsoft.Json.JsonIgnore]
        private string _supplierId = string.Empty;
        [Newtonsoft.Json.JsonIgnore]
        public string supplierId
        {
            get { return _supplierId; }
            set
            {
                _supplierId = value;
                RaisePropertyChanged();
            }
        }
        [Newtonsoft.Json.JsonIgnore]
        public string supplierCode
        {
            get; set;
        }
        [Newtonsoft.Json.JsonIgnore]
        public string supplierName
        {
            get; set;
        }
        public DateTime? productTime { get; set; } = DateTime.Now.AddDays(-7);
        public DateTime? useTime { get; set; } = DateTime.Now;
        public int warrantyCycle { get; set; }
        public int repairCycle { get; set; }
        public decimal price { get; set; }
        public int needNum { get; set; }
        [JsonIgnore]
        public int rowNum { get; set; }

        /// <summary>
        /// 仓库id
        /// </summary>
        public string warehouseId { get; set; }
        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouseName { get; set; }

        /// <summary>
        /// 货架id
        /// </summary>
        public string shelfId { get; set; }
        /// <summary>
        /// 货架名称
        /// </summary>
        public string shelfName { get; set; }
        /// <summary>
        /// 货架名称
        /// </summary>
        public string _shelfName { get; set; }
        /// <summary>
        /// 货架排
        /// </summary>
        public int shelfRange { get; set; }
        /// <summary>
        /// 货架行
        /// </summary>
        public int shelfRow { get; set; }
        /// <summary>
        /// 货架列
        /// </summary>
        public int shelfColumn { get; set; }
        /// <summary>
        /// 货架信息（拼接）
        /// </summary>
        [JsonIgnore]
        public string shelfInfo
        {
            get
            {
                var str = shelfName;
                if (shelfRange != 0)
                {
                    str += "-" + shelfRange;
                    if (shelfColumn != 0)
                    {
                        str += "-" + shelfColumn;
                        if (shelfRow != 0)
                        {
                            str += "-" + shelfRow;
                        }
                    }
                }
                return str;
            }
            set
            {
                RaisePropertyChanged();
            }

        }

    }

    public class EquSupplier
    {
        public string id { get; set; }
        public string name { get; set; }
        public int num { get; set; }
    }

    public class EquInfo
    {
        public string id { get; set; }
        public string name { get; set; }
        public string code { get; set; }
    }

    public class EquAttr
    {
        public List<Supplier> suppliers { get; set; }
        public List<EquSizeInfo> sizes { get; set; }
    }
    public class WarehouseInfo
    {
        public string id { get; set; }
        public string name { get; set; }
    }
    public class ShelfInfo
    {
        public string id { get; set; }
        public string name { get; set; }
        public string range { get; set; }
        public string row { get; set; }
        public string column { get; set; }
    }

    public class Supplier
    {
        public string id { get; set; }
        public string code { get; set; }
        public string name { get; set; }

    }

    public class EquSizeInfo
    {
        public string id { get; set; }
        public string code { get; set; }
        public string name { get; set; }
        /// <summary>
        /// 默认价格
        /// </summary>
        public decimal? price { get; set; }

    }


}
