﻿using JmpZbPrint.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace JmpZbPrint.Dialog
{
    /// <summary>
    /// ShelfWindow.xaml 的交互逻辑
    /// </summary>
    public partial class ShelfWindow : Window
    {
        public List<ShelfInfo> ShelfList { get; set; }
        public List<ShelfInfo> EquipmentShelfList { get; set; }
        public ShelfInfo Shelf { get; set; }
        public WarehouseInfo WarehouseInfo { get; set; }
        public ShelfWindow(WarehouseInfo warehouse, string equId, string sizeId)
        {
            InitializeComponent();
            WarehouseInfo = warehouse;
            ShelfList = HttpHelper.GetShelfByWarehouseId(warehouse.id) ?? new List<ShelfInfo>();
            ShelfList.Insert(0, new ShelfInfo
            {
                id = "",
                name = "（未指定）"
            });
            cboShelf.ItemsSource = ShelfList;
            cboShelf.DisplayMemberPath = "name";
            cboShelf.SelectedValuePath = "id";
            cboShelf.SelectedIndex = 0;

            tbWarehouse.Text = WarehouseInfo.name;

            EquipmentShelfList = HttpHelper.GetListEquipmentShelfPosition(WarehouseInfo.id, equId, sizeId) ?? new List<ShelfInfo>();
            InitEquipmentShelfMessage();
        }
        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
        }

        private void OnSelectItemClick(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void OnSave_Click(object sender, RoutedEventArgs e)
        {
            Shelf = new ShelfInfo()
            {
                id = (cboShelf.SelectionBoxItem as ShelfInfo)?.id ?? "",
                name = (cboShelf.SelectionBoxItem as ShelfInfo)?.name ?? "",
            };
            if (!string.IsNullOrEmpty(Shelf.id))
            {
                Shelf.range = cboShelfRange.SelectedIndex > 0 && !string.IsNullOrEmpty(Shelf.id) ? cboShelfRange.SelectedIndex.ToString() : "0";
                Shelf.column = cboShelfColumn.SelectedIndex > 0 && Convert.ToInt32(Shelf.range) > 0 ? cboShelfColumn.SelectedIndex.ToString() : "0";
                Shelf.row = cboShelfRow.SelectedIndex > 0 && Convert.ToInt32(Shelf.column) > 0 ? cboShelfRow.SelectedIndex.ToString() : " 0";

            }
            this.Close();
        }

        private void OnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void cboShelf_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            //切换货架
            if (e == null || e.RemovedItems.Count > 0)
            {
                var shelf = cboShelf.SelectedItem as ShelfInfo;
                if (!string.IsNullOrEmpty(shelf.id))
                {
                    cboShelfRange.ItemsSource = CreateSelectList(Convert.ToInt32(shelf.range));
                    cboShelfRange.SelectedIndex = 0;
                    cboShelfRow.ItemsSource = CreateSelectList(Convert.ToInt32(shelf.row));
                    cboShelfRow.SelectedIndex = 0;
                    cboShelfColumn.ItemsSource = CreateSelectList(Convert.ToInt32(shelf.column));
                    cboShelfColumn.SelectedIndex = 0;
                    spShelfData.IsEnabled = true;
                }
                else
                {
                    cboShelfRange.ItemsSource = null;
                    cboShelfRow.ItemsSource = null;
                    cboShelfColumn.ItemsSource = null;
                    spShelfData.IsEnabled = false;
                }
            }
        }
        private List<string> CreateSelectList(int count)
        {
            var list = new List<string>();
            list.Add("（未指定）");
            for (int i = 1; i <= count; i++)
            {
                list.Add(i.ToString());
            }
            return list;
        }
        private void InitEquipmentShelfMessage()
        {
            if (EquipmentShelfList.Count > 0)
            {
                spMessage.Visibility = Visibility.Visible;
                tbMessage.Text = string.Join("\r\n", EquipmentShelfList.Take(3).Select(x => x.name +
                    (
                        string.IsNullOrEmpty(x.range) ? "" : "-" + x.range +
                                                             (
                                                                 string.IsNullOrEmpty(x.column) ? "" : "-" + x.column +
                                                                     (
                                                                         string.IsNullOrEmpty(x.row) ? "" : "-" + x.row
                                                                     )
                                                             )
                    )
                ));
                if (EquipmentShelfList.Count > 3)
                {
                    tbMessage.Text += " 等";
                }
                //装填第一条信息
                var shelf = EquipmentShelfList.First();
                cboShelf.SelectedIndex = cboShelf.ItemsSource.OfType<ShelfInfo>().ToList()
                    .FindIndex(x => x.id == shelf.id);
                cboShelfRange.SelectedIndex = Convert.ToInt32(shelf.range);
                cboShelfColumn.SelectedIndex = Convert.ToInt32(shelf.column);
                cboShelfRow.SelectedIndex = Convert.ToInt32(shelf.row);
            }
            else
            {
                spMessage.Visibility = Visibility.Hidden;
            }
        }
    }
}
