﻿using System;
using System.Drawing;
using System.Drawing.Text;
using System.Windows.Media.Imaging;

namespace JmpZbPrint.Common
{
    public class PreviewImageHelper
    {
        public static BitmapImage GetEnterpriceBoxPreview(string strBoxNo, string strProductNo
            , string strSupplier, string strBoxSn, string strProductName, string strWzhx
            , string strBoxNum)
        {
            //企业箱标
            Bitmap bitmap = new Bitmap(640, 245);
            Graphics G = Graphics.FromImage(bitmap);
            G.FillRectangle(Brushes.White, new Rectangle(0, 0, 640, 245));
            G.TextRenderingHint = TextRenderingHint.AntiAlias;

            FontFamily fontFamily = new FontFamily("黑体");

            Font font = new Font(fontFamily, 20f, FontStyle.Regular, GraphicsUnit.Pixel);
            G.DrawString("装箱清单", font, Brushes.Black, 280, 20);
            G.DrawString($"装箱序列号：{strBoxNo}", font, Brushes.Black, 40, 50);
            G.DrawString($"产品代码：{strProductNo}", font, Brushes.Black, 40, 90);
            G.DrawString($"供应商：{strSupplier}", font, Brushes.Black, 40, 130);
            G.DrawString($"装箱码：{strBoxSn}", font, Brushes.Black, 40, 170);
            G.DrawString($"产品名称：{strProductName}", font, Brushes.Black, 40, 210);

            G.DrawString($"装箱号型：{strWzhx}", font, Brushes.Black, 400, 50);
            G.DrawString($"装箱数量：{strBoxNum}", font, Brushes.Black, 400, 90);

            return Bitmap2BitmapImage(bitmap);
        }
        public static BitmapImage GetPiecePreview(string strBoxNo, string strWzhx, string strSupplier, string strProductName)
        {
            //企业箱标
            Bitmap bitmap = new Bitmap(640, 245);
            Graphics G = Graphics.FromImage(bitmap);
            G.FillRectangle(Brushes.White, new Rectangle(0, 0, 640, 245));
            G.TextRenderingHint = TextRenderingHint.AntiAlias;

            FontFamily fontFamily = new FontFamily("黑体");

            Font font = new Font(fontFamily, 20f, FontStyle.Regular, GraphicsUnit.Pixel);
            G.DrawString($"供应商：{strSupplier}", font, Brushes.Black, 60, 50);
            G.DrawString($"品名：{strProductName}", font, Brushes.Black, 60, 90);
            G.DrawString($"号型：{strWzhx}", font, Brushes.Black, 60, 130);
            G.DrawString($"件序列号：{strBoxNo}", font, Brushes.Black, 60, 170);

            return Bitmap2BitmapImage(bitmap);
        }
        public static BitmapImage GetPerBoxPreview(string strSupplier, string strName, string strPoliceNo, string strBoxNum)
        {
            Bitmap bitmap = new Bitmap(640, 245);
            Bitmap qr = (Bitmap)Bitmap.FromFile(AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "qrcode.png");
            Graphics G = Graphics.FromImage(bitmap);
            G.FillRectangle(Brushes.White, new Rectangle(0, 0, 640, 245));
            G.TextRenderingHint = TextRenderingHint.AntiAlias;

            FontFamily fontFamily = new FontFamily("黑体");

            Font font = new Font(fontFamily, 20f, FontStyle.Regular, GraphicsUnit.Pixel);
            G.DrawString($"单位名称：{strSupplier}", font, Brushes.Black, 60, 50);
            G.DrawString($"姓名：{strName}", font, Brushes.Black, 60, 90);
            G.DrawString($"警号：{strPoliceNo}", font, Brushes.Black, 60, 130);
            G.DrawString($"数量：{strBoxNum}", font, Brushes.Black, 60, 170);
            G.DrawImage(qr, 460, 70, 150, 150);
            return Bitmap2BitmapImage(bitmap);
        }
        private static BitmapImage Bitmap2BitmapImage(System.Drawing.Bitmap bitmap)
        {
            //BitmapImage bitmapImage = new BitmapImage();
            //using (System.IO.MemoryStream ms = new System.IO.MemoryStream())
            //{
            //    bitmap.Save(ms, bitmap.RawFormat);
            //    bitmapImage.BeginInit();
            //    bitmapImage.StreamSource = ms;
            //    bitmapImage.CacheOption = BitmapCacheOption.OnLoad;
            //    bitmapImage.EndInit();
            //    bitmapImage.Freeze();
            //}
            //return bitmapImage;

            System.Drawing.Bitmap ImageOriginalBase = new Bitmap(bitmap);
            BitmapImage bitmapImage = new BitmapImage();
            using (System.IO.MemoryStream ms = new System.IO.MemoryStream())
            {
                //ImageOriginalBase.Save(ms, ImageOriginalBase.RawFormat);
                ImageOriginalBase.Save(ms, System.Drawing.Imaging.ImageFormat.Png);
                bitmapImage.BeginInit();
                bitmapImage.StreamSource = ms;
                bitmapImage.CacheOption = BitmapCacheOption.OnLoad;
                bitmapImage.EndInit();
                bitmapImage.Freeze();
            }
            return bitmapImage;
        }
    }
}
