﻿using JmpZbPrint.Model;
using JmpZbPrint.Model.DbModel;
using LiteDB;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;
using System.Threading.Tasks;

namespace JmpZbPrint.Common
{
    public class LiteDbHelper
    {
        public static bool AddRange(List<recode_info> recodes)
        {
            try
            {
                var path = AppDomain.CurrentDomain.SetupInformation.ApplicationBase;
                using (var db = new LiteDatabase($"{path}print.db"))
                {
                    var col = db.GetCollection<recode_info>("recode_info");
                    var res = col.InsertBulk(recodes);
                    return res > 0;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString());
                return default;
            }

        }
        public static bool Update(recode_info recode)
        {
            try
            {
                var path = AppDomain.CurrentDomain.SetupInformation.ApplicationBase;
                using (var db = new LiteDatabase($"{path}print.db"))
                {
                    var col = db.GetCollection<recode_info>("recode_info");
                    var res = col.Update(recode);
                    return res;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString());
                return default;
            }
        }
        public static bool Update(string epc, bool isdelete = true)
        {
            try
            {
                var path = AppDomain.CurrentDomain.SetupInformation.ApplicationBase;
                using (var db = new LiteDatabase($"{path}print.db"))
                {
                    var col = db.GetCollection<recode_info>("recode_info");
                    var recode = col.FindOne(t => t.epc == epc);
                    if (recode == null) { return false; }
                    else
                    {
                        recode.isdelete = isdelete;
                        return col.Update(recode);
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString());
                return default;
            }
        }

        public static bool Update(int id, bool isdelete = true)
        {
            try
            {
                var path = AppDomain.CurrentDomain.SetupInformation.ApplicationBase;
                using (var db = new LiteDatabase($"{path}print.db"))
                {
                    var col = db.GetCollection<recode_info>("recode_info");
                    var recode = col.FindOne(t => t.id == id);
                    if (recode == null) { return false; }
                    else
                    {
                        recode.PrintTime = DateTime.Now;
                        recode.isdelete = isdelete;
                        return col.Update(recode);
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString());
                return default;
            }
        }
        public static void Delete(int id)
        {
            try
            {
                var path = AppDomain.CurrentDomain.SetupInformation.ApplicationBase;
                using (var db = new LiteDatabase($"{path}print.db"))
                {
                    var col = db.GetCollection<recode_info>("recode_info");
                    var recode = col.FindOne(t => t.id == id);
                    if (recode == null) { return; }
                    else
                    {
                        col.Delete(recode.id);
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString());
                return;
            }
        }

        public static void DeleteByEpc(string epc)
        {
            try
            {
                var path = AppDomain.CurrentDomain.SetupInformation.ApplicationBase;
                using (var db = new LiteDatabase($"{path}print.db"))
                {
                    var col = db.GetCollection<recode_info>("recode_info");
                    var recode = col.FindOne(t => t.epc == epc);
                    if (recode == null) { return; }
                    else
                    {
                        col.Delete(recode.id);
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString());
                return;
            }
        }
        public static recode_info GetSingle(int id)
        {
            try
            {
                var path = AppDomain.CurrentDomain.SetupInformation.ApplicationBase;
                using (var db = new LiteDatabase($"{path}print.db"))
                {
                    var col = db.GetCollection<recode_info>("recode_info");
                    var res = col.FindOne(t => t.id == id);
                    return res;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString());
                return default;
            }
        }

        public static recode_info GetSingleByEpc(string epc)
        {
            try
            {
                var path = AppDomain.CurrentDomain.SetupInformation.ApplicationBase;
                using (var db = new LiteDatabase($"{path}print.db"))
                {
                    var col = db.GetCollection<recode_info>("recode_info");
                    var res = col.FindOne(t => t.epc == epc);
                    return res;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString());
                return default;
            }
        }

        public static db_page GetPage(int page, int size, Expression<Func<recode_info, bool>> @where)
        {
            try
            {
                page -= 1;
                var path = AppDomain.CurrentDomain.SetupInformation.ApplicationBase;
                using (var db = new LiteDatabase($"{path}print.db"))
                {
                    var col = db.GetCollection<recode_info>("recode_info");
                    var count = col.Find(@where).Count();
                    var data = new db_page
                    {
                        total = count,
                        record = col.Find(@where).ToList().OrderBy(t => t.epc)
                        .Skip(page * size).Take(size).ToList()
                    };
                    return data;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString());
                return default;
            }

        }
    }
}

