﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;

namespace JmpZbPrint.Common
{
    public class LabelTypeConvert : IValueConverter
    {
        //当值从绑定源传播给绑定目标时，调用方法Convert
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value == null)
                return DependencyProperty.UnsetValue;
            bool.TryParse(value.ToString(), out bool type);
            if (type == true)
            {
                return "箱标";
            }
            else
            {
                return "件标";
            }
        }
        //当值从绑定目标传播给绑定源时，调用此方法ConvertBack
        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string str = value as string;
            if (str== "箱标")
            {
                return true;
            }
            else
            {
                return false;
            }
            return DependencyProperty.UnsetValue;
        }
    }

}
