﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;

namespace JmpZbPrint.Common
{
    [ValueConversion(typeof(decimal), typeof(string))]
    public class FloatConverter : IValueConverter
    {
        //源属性传给目标属性时，调用此方法ConvertBack
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (decimal.TryParse((value ?? "").ToString(), out decimal val))
            {
                return val;
            }
            else
            {
                return 0.0;
            }
        }

        //目标属性传给源属性时，调用此方法ConvertBack
        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            string strValue = value as string;
            if (string.IsNullOrEmpty(strValue))
            {
                return 0;
            }
            else
            {
                if (strValue.IndexOf(".") == (strValue.Length - 1) && strValue.ToArray().Where(t => t == '.').Count() <= 1)
                {
                    return Binding.DoNothing;
                }
                else
                {
                    System.Text.RegularExpressions.Regex g = new System.Text.RegularExpressions.Regex(@"^[0-9].\d*$");
                    if (g.IsMatch(strValue))
                    {
                        decimal.TryParse(strValue, out decimal res);
                        return res;
                    }
                    else
                    {
                        var tmp = System.Text.RegularExpressions.Regex.Replace(strValue, @"[^\d.]*", "");
                        decimal.TryParse(tmp, out decimal res);
                        return res;
                    }
                }
            }
        }
    }
}
