﻿using JmpZbPrint.Common;
using JmpZbPrint.Model;
using Newtonsoft.Json;
using System;
using System.IO;
using System.Reflection;
using System.Text;

namespace JmpZbPrint
{
    public static class CaChe
    {
        //public static List<WarehouseInfo> WarehouseInfo { get; set; }
        public static respone_user UserInfo { get; set; }
        //public static List<Supplier> Suppliers { get; set; }
        //public static List<EquInfo> EquInfos { get; set; }
        public static Config SysConfig { get; set; }
        //public static UserInfo UserInfo { get; set; }
        //public static List<EquipmentInfo> WzList { get; set; }
        public static Config LoadSystemStep()
        {
            var v_path = AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "config.json";
            if (!File.Exists(v_path))
            {
                return null;
            }
            else
            {
                var v_json = File.ReadAllText(v_path, Encoding.UTF8);
                var des_str = JmpDes.Decrypt(v_json);
                if (string.IsNullOrEmpty(des_str))
                {
                    return null;
                }
                else
                {
                    var config = JsonConvert.DeserializeObject<Config>(des_str);
                    //预处理
                    if (config.DomainUrl == "http://41.204.7.134:18761/api/service")
                    {
                        config.DomainUrl = "http://41.190.20.132:18761/api/service";
                    }
                    if (config.UserLogin == "http://41.204.7.134:10004/auth/userLogin")
                    {
                        config.UserLogin = "http://41.190.20.132:10004/auth/userLogin";
                    }
                    return config;
                }
            }
        }
        public static bool SaveSystemStep(Config config)
        {
            try
            {
                if (config == null) { return false; }
                else
                {
                    var json = JsonConvert.SerializeObject(config, Formatting.Indented);
                    if (string.IsNullOrEmpty(json))
                    {
                        return false;
                    }
                    else
                    {
                        System.IO.File.WriteAllText(AppDomain.CurrentDomain.SetupInformation.ApplicationBase + "config.json", JmpDes.Encrypt(json), Encoding.UTF8);
                        return true;
                    }
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
                return false;
            }
        }
    }

}
