﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using JmpCommon;
using JmpModel.Model;
using JmpModel.Model.DataContext;
using JmpModel.Model.Repository;
using JunmpPoliceStation.Controllers;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;

namespace JunmpPoliceStation.Extensions
{
    public class CronJob
    {
        JunmppolicesqlContext _dbContext;
        HttpHelper _httpHelper;
        private IConfiguration Configuration;
        private ILogger<CronJob> _logger;
        public CronJob(JunmppolicesqlContext dbContext, IConfiguration configuration, ILogger<CronJob> logger, HttpHelper httpHelper)
        {
            _dbContext = dbContext;
            _httpHelper = httpHelper;
            Configuration = configuration;
            _logger = logger;
        }

        public void SyncEquipmentState()
        {
            try
            {
                var list = _dbContext.CommonJpEquipmentStates
                    .Include("CabinetIdIntoNavigation")
                    .Include("CabinetIdOutNavigation")
                    .Where(x => x.IsPush == 0)
                    .OrderBy(x => x.CreateTime)
                    .ToList();
                if (list.Count == 0)
                {
                    return;
                }

                for (int i = 0; i < list.Count; i += 100)
                {
                    var pushList = list.Skip(i).Take(100).ToList();

                    var pushdata = pushList.Select(x => new
                    {
                        id = x.Id,
                        eqiupmentId = x.EqiupmentId,
                        warehouseId = x.WarehouseId,
                        orgId = x.OrgId,
                        policeId = x.PoliceId,
                        picUrl = x.PicUrl,
                        note = x.Note,
                        orderCode = x.OrderCode,
                        cabinetIdIntoName = x.CabinetIdIntoNavigation?.CabinetNum,
                        cabinetIdOutName = x.CabinetIdOutNavigation?.CabinetNum,
                        outInState = x.OutInState,
                        state = x.State,
                        outTime = x.OutTime,
                        intoTime = x.IntoTime,
                        createTime = x.CreateTime,
                        actionState = x.ActionState,
                        historySafeLevel = x.HistorySafeLevel,
                    });
                    var res = _httpHelper.GetHtml(new HttpItem
                    {
                        URL = _httpHelper._centerServerAddress + "/api/Inventory/UploadInventoryInOutState",
                        Encoding = Encoding.UTF8,
                        Method = "POST",
                        ContentType = "application/json",
                        Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new { data = pushdata }))
                    });
                    if (string.IsNullOrEmpty(res.Html))
                    {
                        _logger.LogError("出入库数据上报失败");
                        return;
                    }

                    var obj = JsonConvert.DeserializeObject<respone<object>>(res.Html);
                    if (obj.code == 10000)
                    {
                        //操作成功
                        foreach (var state in pushList)
                        {
                            state.IsPush = 1;
                            _dbContext.CommonJpEquipmentStates.Update(state);
                        }
                        _dbContext.SaveChanges();
                    }
                    else
                    {
                        _logger.LogError("出入库数据上报失败" + obj.msg);
                        return;
                    }
                }
            }
            catch (Exception e)
            {
                _logger.LogError(e, "定时任务工作异常");
            }

        }

        public Tuple<string, string> SyncEquipmentData()
        {
            try
            {
                var res = _httpHelper.GetHtml(new HttpItem()
                {
                    URL = _httpHelper._centerServerAddress + "/api/EquipmentInfo/SyncEquipmentData",
                    Encoding = Encoding.UTF8,
                    Method = "POST",
                });
                if (string.IsNullOrEmpty(res.Html))
                {
                    return new Tuple<string, string>("10099", "远端上报数据失败");
                }
                var obj = JsonConvert.DeserializeObject<JmpBaseResponse<EquipmentDataObj>>(res.Html);
                if (obj.code != "10000")
                {
                    return new Tuple<string, string>(obj.code ?? "19999", obj.msg ?? "操作失败");
                }
                _dbContext.BulkSynchronize<JmpModel.Model.BaseJpEquipmentInfo>(obj.data.info.ToList());
                _dbContext.BulkSynchronize<JmpModel.Model.BaseJpEquipmentDetail>(obj.data.detail.ToList());
                _dbContext.BulkSynchronize<JmpModel.Model.BaseJpEquipmentSize>(obj.data.size.ToList());
                _dbContext.BulkSynchronize<JmpModel.Model.BaseJpSupplier>(obj.data.supplier.ToList());
                _dbContext.BulkSynchronize<JmpModel.Model.BaseJpSupplierEquipment>(obj.data.supplierEquipment.ToList());

                return new Tuple<string, string>("10000", "操作成功");
            }
            catch (Exception e)
            {
                _logger.LogError(e, "定时任务工作异常");
                return new Tuple<string, string>("19999", "操作失败");
            }
        }
    }

    public class respone<T>
    {
        public int code { get; set; }
        public string msg { get; set; }
        public T data { get; set; }
    }
}