﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class WarehouseController : ControllerBase
    {
        //private ICabinetRepository _CabinetRepository;
        private ILogger<WarehouseController> _logger;
        UnitOfWork _unitOfWork;
        public List<BaseJpOrganization> ListEq = new List<BaseJpOrganization>();

        public WarehouseController(ILogger<WarehouseController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取仓库列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgizationId":"组织机构ID",
        ///         "name":"仓库名称"
        ///         
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListWarehouse")]
        public async Task<HttpResponseMessage> GetListWarehouse([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationId = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgizationId))
                        {
                            orgizationId = entity.orgizationId;
                        }

                        dataList = GetClassID(orgizationId);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationId))).ToList();

                        Expression<Func<BaseJpWarehouse, bool>> expressionHouse = null;
                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            string Name = entity.name;
                            expressionHouse = t => dataList.Select(c => c.Id).Contains(t.OrgizationId) && t.Name.Contains(Name);
                        }
                        else
                        {
                            expressionHouse = t => dataList.Select(c => c.Id).Contains(t.OrgizationId);
                        }

                        var param = new string[] {
                       "Orgization"
                    };

                        List<BaseJpWarehouse> dataHouseList = _unitOfWork.WarehouseRepository.GetList(expressionHouse, t => t.UpdateTime, false, param).ToList();


                        var data = dataHouseList.Select(c => new
                        {
                            c.Id,
                            c.Sort,
                            c.Name,
                            c.Location,
                            c.LocationDetail,
                            c.OrgizationId,
                            OrgizationName = c.Orgization?.Name,
                            c.Phone,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            c.IsLocked,
                            c.CameraUrl
                        }
                        ).ToList();


                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 通过id获取对应仓库信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id":"仓库id"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetWarehouseById")]
        public async Task<HttpResponseMessage> GetWarehouseById([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string id = entity.id ?? "";
                        if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }

                        var warehouse = _unitOfWork.DbContext.BaseJpWarehouses
                                .Include(x => x.Orgization)
                                .FirstOrDefault(x => x.Id == id);

                        if (warehouse == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        return JsonManager.ReturnSuccessResponse(new
                        {
                            warehouse.Id,
                            warehouse.Sort,
                            warehouse.Name,
                            warehouse.Location,
                            warehouse.LocationDetail,
                            warehouse.OrgizationId,
                            gizationName = warehouse.Orgization?.Name,
                            warehouse.Phone,
                            warehouse.CreateTime,
                            warehouse.UpdateTime,
                            warehouse.UpdateUser,
                            warehouse.IsLocked,
                            warehouse.CameraUrl
                        });
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 获取上一级对应的所有仓库列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgizationId":"组织机构ID",
        ///         "name":"仓库名称"
        ///         
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListUpWarehouse")]
        public async Task<HttpResponseMessage> GetListUpWarehouse([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationId = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgizationId))
                        {
                            orgizationId = entity.orgizationId;
                            orgizationId = ListEq.Where(c => c.Id.Equals(orgizationId)).FirstOrDefault().ParentId;
                        }

                        dataList = GetClassID(orgizationId);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationId))).ToList();

                        Expression<Func<BaseJpWarehouse, bool>> expressionHouse = null;
                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            string Name = entity.name;
                            expressionHouse = t => dataList.Select(c => c.Id).Contains(t.OrgizationId) && t.Name.Contains(Name);
                        }
                        else
                        {
                            expressionHouse = t => dataList.Select(c => c.Id).Contains(t.OrgizationId);
                        }

                        var param = new string[] {
                       "Orgization"
                    };

                        List<BaseJpWarehouse> dataHouseList = _unitOfWork.WarehouseRepository.GetList(expressionHouse, t => t.UpdateTime, false, param).ToList();


                        var data = dataHouseList.Select(c => new
                        {
                            c.OrgizationId,
                            OrgizationName = c.Orgization?.Name
                        }
                        ).Distinct().ToList();


                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 保存通道读取装备设置（指定仓库）
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "warehouseId":"仓库ID",
        ///         "json":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("SaveChannelReadEquTypeJson")]
        //[NoSign]
        public async Task<HttpResponseMessage> SaveChannelReadEquTypeJson([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string warehouseId = entity.warehouseId ?? "";
                        string json = entity.json ?? "";

                        if (String.IsNullOrEmpty(entity.warehouseId))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }

                        var warehouse = _unitOfWork.WarehouseRepository.Get(warehouseId);
                        if (warehouse == null)
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }

                        warehouse.ChannelReadEquTypeJson = json;
                        if (_unitOfWork.WarehouseRepository.Update(warehouse))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取组织机构对应的本仓库列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgizationId":"组织机构ID"
        ///         
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListOrgWarehouse")]
        //[NoSign]
        public async Task<HttpResponseMessage> GetListOrgWarehouse([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.orgizationId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        string orgizationId = Guid.Empty.ToString();

                        if (!String.IsNullOrEmpty(entity.orgizationId))
                        {
                            orgizationId = entity.orgizationId;
                        }


                        Expression<Func<BaseJpWarehouse, bool>> expressionHouse = null;
                        expressionHouse = t => t.OrgizationId.Equals(orgizationId);

                        var param = new string[] {
                       "Orgization"
                    };

                        List<BaseJpWarehouse> dataHouseList = _unitOfWork.WarehouseRepository.GetArray(expressionHouse, t => t.UpdateTime, false, param).ToList();


                        var data = dataHouseList.Select(c => new
                        {
                            c.Id,
                            c.Sort,
                            c.Name,
                            c.Location,
                            c.LocationDetail,
                            c.OrgizationId,
                            OrgizationName = c.Orgization?.Name,
                            c.Phone,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            c.IsLocked,
                            c.CameraUrl,
                            c.IsEnableChannelReadEqu,
                            c.ChannelReadEquTypeJson
                        }
                        ).ToList();


                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }



        /// <summary>
        /// 九大类在库总量 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "warehouseCode":"5cc27665-91f3-47ef-9bab-4ea2f1754cbc"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetGroupByCount")]
        public async Task<HttpResponseMessage> GetGroupByCount([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        string warehouseCode = entity.warehouseCode;

                        if (String.IsNullOrEmpty(warehouseCode))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => t.WarehouseCode.Equals(warehouseCode);


                        IQueryable<CommonJpEquipmentInventory> inventoryList = _unitOfWork.EquipmentInventoryRepository.GetList(expression, t => t.WarehouseCode, false);



                        Expression<Func<ViewEquipmentCount, bool>> ViewEquipmentCountExpression = t => t.WarehouseCode.Equals(warehouseCode);

                        IQueryable<ViewEquipmentCount> ViewEquipmentCountList = _unitOfWork.ViewEquipmentCountRepository.GetList(ViewEquipmentCountExpression, t => t.WarehouseCode, false);

                        var groupList = ViewEquipmentCountList.GroupBy(c => c.ParentName).Select(g => new { item = g.Key, count = g.Sum(s => s.SizeCount) });


                        //在库数、出库数、报废数
                        int zkCount = 0;
                        int ckCount = 0;
                        int bfCount = 0;

                        //在库数
                        zkCount = inventoryList.Where(c => (c.CurrentState.Equals(0) || c.CurrentState.Equals(3)) && (!c.InventoryState.Equals("loss"))).Count();

                        //出库数
                        ckCount = inventoryList.Where(c => (!(c.CurrentState.Equals(0) || c.CurrentState.Equals(3) || c.CurrentState.Equals(6))) && (!c.InventoryState.Equals("loss"))).Count();

                        //报废数
                        bfCount = inventoryList.Where(c => (c.CurrentState.Equals(6)) && (!c.InventoryState.Equals("loss"))).Count();


                        JArray reData = new JArray();

                        reData.Add(new JObject() {
                                        new JProperty("item","在库数"),
                                        new JProperty("count",zkCount),
                                    });

                        reData.Add(new JObject() {
                                        new JProperty("item","出库数"),
                                        new JProperty("count",ckCount),
                                    });
                        reData.Add(new JObject() {
                                        new JProperty("item","报废数"),
                                        new JProperty("count",bfCount),
                                    });

                        var returnData = new { tjList = reData, typeList = groupList };

                        return JsonManager.ReturnSuccessResponse(returnData);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 获取仓库分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "orgizationId":"组织机构ID",
        ///         "name":"仓库名称",
        ///         "level":"是否本级"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageWarehouse")]
        public async Task<HttpResponseMessage> GetPageWarehouse([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationId = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgizationId))
                        {
                            orgizationId = entity.orgizationId;
                        }

                        dataList = GetClassID(orgizationId);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationId))).ToList();

                        Expression<Func<BaseJpWarehouse, bool>> expressionHouse = null;


                        if (!String.IsNullOrEmpty(entity.level))
                        {
                            if (entity.level == "本级")
                            {
                                expressionHouse = t => t.OrgizationId.Equals(orgizationId);
                            }
                            else
                            {
                                expressionHouse = t => dataList.Select(c => c.Id).Contains(t.OrgizationId);
                            }
                        }
                        else
                        {
                            expressionHouse = t => dataList.Select(c => c.Id).Contains(t.OrgizationId);
                        }

                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            string Name = entity.name;
                            expressionHouse = LambdaExtensions.AndAlso(expressionHouse, t => t.Name.Contains(Name));
                        }


                        var param = new string[] {
                       "Orgization"
                    };

                        PageData<BaseJpWarehouse> pagedata = _unitOfWork.WarehouseRepository.GetPage(expressionHouse, "-UpdateTime", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.Id,
                            c.Sort,
                            c.Name,
                            c.Location,
                            c.LocationDetail,
                            c.OrgizationId,
                            OrgizationName = c.Orgization?.Name,
                            c.Phone,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            c.IsLocked,
                            c.CameraUrl
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取全部仓库第三方使用
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "createTime": "时间",
        ///         "orgizationId":"组织机构ID"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetWarehouseDevelop")]
        //[NoSign]
        public async Task<HttpResponseMessage> GetWarehouseDevelop([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.orgizationId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;


                        string orgizationId = entity.orgizationId;
                        string createTime = entity.createTime;
                        if (string.IsNullOrEmpty(createTime))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }


                        Expression<Func<BaseJpWarehouse, bool>> expressionHouse = null;



                        expressionHouse = t => t.OrgizationId.Equals(orgizationId) && t.UpdateTime >= DateTime.Parse(createTime);



                        var param = new string[] {
                       "Orgization"
                    };

                        List<BaseJpWarehouse> pagedata = _unitOfWork.WarehouseRepository.GetList(expressionHouse, p => p.UpdateTime, false, param).ToList();

                        var data = pagedata.Select(c => new
                        {
                            c.Id,
                            c.Sort,
                            c.Name,
                            c.Location,
                            c.LocationDetail,
                            c.OrgizationId,
                            OrgizationName = c.Orgization?.Name,
                            c.Phone,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            c.CameraUrl
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = data.Count,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 添加或修改仓库信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号",
        ///        "name":"仓库名称",
        ///        "location":"仓库地址",
        ///        "locationDetail" : "仓库坐标",
        ///        "orgizationId" : "组织机构ID",
        ///        "phone" : "仓库联系电话",
        ///        "updateUser":"操作用户ID"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateWarehouse")]
        //[NoSign]
        public async Task<HttpResponseMessage> AddOrUpdateWarehouse([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.orgizationId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.name ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"Name is require");
                        }
                        else if (string.IsNullOrEmpty(entity.orgizationId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"OrgizationId is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            Expression<Func<BaseJpWarehouse, bool>> expression = t => t.Id.Equals(id);
                            BaseJpWarehouse updateObject = _unitOfWork.WarehouseRepository.Get(expression);
                            if (updateObject != null)
                            {
                                updateObject.Name = entity.name;
                                updateObject.Location = entity.location;
                                updateObject.LocationDetail = entity.locationDetail;
                                updateObject.OrgizationId = entity.orgizationId;
                                updateObject.Phone = entity.phone;
                                updateObject.UpdateTime = System.DateTime.Now;
                                updateObject.UpdateUser = entity.updateUser;
                                updateObject.CameraUrl = entity.cameraUrl;
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                            bool result = _unitOfWork.WarehouseRepository.Update(updateObject);

                            if (result)
                            {
                                return JsonManager.ReturnSuccessResponse(new
                                {
                                    id = updateObject.Id,
                                    name = updateObject.Name,
                                    orgizationId = updateObject.OrgizationId,
                                    location = updateObject.Location,
                                    phone = updateObject.Phone,
                                    cameraUrl= updateObject.CameraUrl
                                });
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {
                            //新增数据
                            BaseJpWarehouse addObject = new BaseJpWarehouse()
                            {
                                Id = Guid.NewGuid().ToString(),
                                Sort = null,
                                Name = entity.name,
                                Location = entity.location,
                                LocationDetail = entity.locationDetail,
                                OrgizationId = entity.orgizationId,
                                Phone = entity.phone,
                                CreateTime = System.DateTime.Now,
                                UpdateTime = System.DateTime.Now,
                                UpdateUser = entity.updateUser,
                                CameraUrl = entity.cameraUrl
                            };

                            bool result = _unitOfWork.WarehouseRepository.Insert(addObject);

                            if (result)
                            {
                                return JsonManager.ReturnSuccessResponse(new
                                {
                                    id = addObject.Id,
                                    name = addObject.Name,
                                    orgizationId = addObject.OrgizationId,
                                    location = addObject.Location,
                                    phone = addObject.Phone,
                                    cameraUrl = addObject.CameraUrl
                                });
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 开关启用通道读取指定类型装备
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "仓库id",
        ///        "enable" : "true"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("EnableChannelReadEquById")]
        //[NoSign]
        public async Task<HttpResponseMessage> EnableChannelReadEquById([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string id = entity?.id ?? "";
                        var bEnable = bool.TryParse(entity?.id, out bool enable);

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        if (!bEnable)
                        {
                            return JsonManager.SimpleCustResponse($"enable is require");
                        }

                        var warehouse = _unitOfWork.WarehouseRepository.Get(id);
                        if (warehouse == null)
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        warehouse.IsEnableChannelReadEqu = enable;
                        if (_unitOfWork.WarehouseRepository.Update(warehouse))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 删除仓库信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteWarehouse")]
        public async Task<HttpResponseMessage> DeleteWarehouse([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            Expression<Func<BaseJpWarehouse, bool>> expression = t => t.Id.Equals(id);
                            BaseJpWarehouse deleteObject = _unitOfWork.WarehouseRepository.Get(expression);
                            if (deleteObject != null)
                            {
                                bool result = _unitOfWork.WarehouseRepository.Delete(deleteObject);

                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {

                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }


        //递归取数据
        private List<BaseJpOrganization> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }



        /// <summary>
        /// 获取仓库对应资产库存(第三方使用)
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgizationId":"组织机构ID",
        ///         "warehouseId":"请求的仓库ID",
        ///         "equipmentId":"装备ID",
        ///         "updateTime":"更新时间"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetWarehouseEquipmentDevelop")]

        public async Task<HttpResponseMessage> GetWarehouseEquipmentDevelop([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.orgizationId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                            if (string.IsNullOrEmpty(entity.warehouseId)
                                || _unitOfWork.WarehouseRepository.Get(entity.warehouseId)?.OrgizationId != entity._PUSHORG.ToString()
                                )
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        if (String.IsNullOrEmpty(entity.orgizationId))
                        {
                            return JsonManager.SimpleCustResponse($"orgizationId is require");
                        }
                        if (String.IsNullOrEmpty(entity.warehouseId))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }
                        string warehouseId = entity.warehouseId;
                        string updateTime = entity.updateTime;

                        Expression<Func<BaseJpWarehouse, bool>> expressionHouse = null;


                        string EquipmentId = entity.equipmentId;

                        var param = new string[] {
                       "EquipmentCodeNavigation",
                       "EquipmentSizecodeNavigation",
                       "SupplierCodeNavigation"
                    };
                        Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => t.WarehouseCode.Equals(warehouseId);
                        if (!string.IsNullOrEmpty(updateTime))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.CreateTime >= DateTime.Parse(updateTime));
                        }
                        if (!string.IsNullOrEmpty(EquipmentId))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.EquipmentCode == EquipmentId);
                        }
                        List<CommonJpEquipmentInventory> pagedata = _unitOfWork.EquipmentInventoryRepository.GetList(expression, p => p.CreateTime, false, param).ToList();

                        var data = pagedata.Select(c => new
                        {
                            c.Id,
                            c.CreateTime,
                            c.Epc,
                            equipmentName = c.EquipmentCodeNavigation?.Name,
                            c.EquipmentCode,
                            c.EquipmentSizecode,
                            equipmentSizeName = c.EquipmentSizecodeNavigation?.SizeName,
                            c.Price,
                            c.RepairCycle,
                            c.SupplierCode,
                            supplyName = c.SupplierCodeNavigation?.Name,
                            c.WarrantyCycle,
                            c.Wzdm,
                            c.CurrentState,
                            c.Address
                        }
                        );

                        //var dataPage = new
                        //{
                        //    totalElements = data.Count,
                        //    content = data
                        //};

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 获取仓库对应资产库存分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "equipmentId":"资产Id",
        ///         "orgizationId":"组织机构ID",
        ///         "warehouseId":"请求的仓库ID",
        ///         "isCurrentLevel":"是否当前组织机构,true 是，false否"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageWarehouseEquipment")]
        //[NoSign]
        public async Task<HttpResponseMessage> GetPageWarehouseEquipment([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string isCurrentLevel = entity.isCurrentLevel;
                        if (string.IsNullOrEmpty(isCurrentLevel))
                        {
                            isCurrentLevel = "false";
                        }
                        if (size == 0)
                        {
                            size = 10;
                        }

                        if (String.IsNullOrEmpty(entity.equipmentId))
                        {
                            return JsonManager.SimpleCustResponse($"equipmentId is require");
                        }
                        string warehouseId = entity.warehouseId;
                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationId = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgizationId))
                        {
                            orgizationId = entity.orgizationId;
                        }

                        dataList = GetClassID(orgizationId);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationId))).ToList();


                        Expression<Func<BaseJpWarehouse, bool>> expressionHouse = null;


                        if (isCurrentLevel.Equals("true"))
                        {
                            expressionHouse = t => t.OrgizationId.Equals(orgizationId) && t.Id != warehouseId;
                        }
                        else if (isCurrentLevel.Equals("false"))
                        {
                            expressionHouse = t => dataList.Select(c => c.Id).Contains(t.OrgizationId) && t.Id != warehouseId;
                        }
                        string EquipmentId = entity.equipmentId;

                        var param = new string[] {
                       "Orgization",
                       "CommonJpEquipmentInventories"
                    };

                        PageData<BaseJpWarehouse> pagedata = _unitOfWork.WarehouseRepository.GetPage(expressionHouse, "UpdateTime", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.Id,
                            c.Name,
                            c.OrgizationId,
                            OrgizationName = c.Orgization?.Name,
                            equCount = c.CommonJpEquipmentInventories?.Where(t => t.CurrentState == 0 && t.EquipmentCode.Equals(EquipmentId)).Count(),
                            quantity = 0
                        }
                        ).Where(c => c.equCount != 0).ToList();

                        var dataPage = new
                        {
                            totalElements = data.Count,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

    }
}
