﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using JmpModel.Model.DataContext;
using JmpSqlServerModel;
using Microsoft.Extensions.Configuration;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class ThirdPartyInitController : ControllerBase
    {
        private ILogger<WarehouseDevController> _logger;
        private IConfiguration Configuration;

        JunmppolicesqlContext _mysqlContext;
        JmpSqlServerContext _sqlServerContext;


        private List<JmpSqlServerModel.BaseJpOrganization> _listEq = new List<JmpSqlServerModel.BaseJpOrganization>();

        public ThirdPartyInitController(ILogger<WarehouseDevController> logger, IConfiguration configuration)
        {
            _logger = logger;
            Configuration = configuration;

            var options = new DbContextOptionsBuilder<JunmppolicesqlContext>();
            options.UseMySQL(Configuration.GetConnectionString("MySqlConnection"));
            _mysqlContext = new JunmppolicesqlContext(options.Options);

            var options2 = new DbContextOptionsBuilder<JmpSqlServerContext>();
            options2.UseSqlServer(Configuration.GetConnectionString("SqlServerConnection"));
            _sqlServerContext = new JmpSqlServerContext(options2.Options);
        }

        /// <summary>
        /// 数据库初始化同步（只用一次）
        /// </summary>
        /// <returns></returns>
        [HttpPost("BasicDataInit")]
        public async Task<HttpResponseMessage> BasicDataInit()
        {
            return await Task.Run(() =>
            {
                try
                {
                    _listEq = _sqlServerContext.BaseJpOrganization
                        .Where(x => x.State == 1)
                        .OrderByDescending(x => x.Code)
                        .ToList();
                    var dataList = GetClassID(Configuration["ThirdConfig:OrganizationId"]);

                    dataList = dataList.Concat(_listEq.Where(c => c.Id.Equals(Configuration["ThirdConfig:OrganizationId"]))).ToList();
                    //替换顶层组织机构parentId为"00000000-0000-0000-0000-000000000000"
                    dataList.First(x => x.Id == Configuration["ThirdConfig:OrganizationId"]).ParentId = "00000000-0000-0000-0000-000000000000";

                    var orgList = dataList
                        .Select(x => x.Id)
                        .ToList();
                    //组织机构
                    _mysqlContext.BulkSynchronize<JmpModel.Model.BaseJpOrganization>(dataList);
                    //装备基础信息
                    _mysqlContext.BulkSynchronize<JmpModel.Model.BaseJpEquipmentInfo>(_sqlServerContext.BaseJpEquipmentInfo.ToList());
                    _mysqlContext.BulkSynchronize<JmpModel.Model.BaseJpEquipmentDetail>(_sqlServerContext.BaseJpEquipmentDetail.ToList());
                    _mysqlContext.BulkSynchronize<JmpModel.Model.BaseJpEquipmentSize>(_sqlServerContext.BaseJpEquipmentSize.ToList());
                    _mysqlContext.BulkSynchronize<JmpModel.Model.BaseJpSupplier>(_sqlServerContext.BaseJpSupplier.ToList());
                    _mysqlContext.BulkSynchronize<JmpModel.Model.BaseJpSupplierEquipment>(_sqlServerContext.BaseJpSupplierEquipment.ToList());
                    //单警柜
                    _mysqlContext.BulkSynchronize<JmpModel.Model.BaseJpCabinet>(_sqlServerContext.BaseJpCabinet.Where(x => orgList.Contains(x.OrganizationId)).ToList());
                    //警员信息
                    _mysqlContext.BulkSynchronize<JmpModel.Model.BaseJpPoliceman>(_sqlServerContext.BaseJpPoliceman.Where(x => orgList.Contains(x.OrgizationCode)).ToList());
                    //流程
                    _mysqlContext.BulkSynchronize<JmpModel.Model.BaseJpProcess>(_sqlServerContext.BaseJpProcess.ToList());
                    //仓库
                    _mysqlContext.BulkSynchronize<JmpModel.Model.BaseJpWarehouse>(_sqlServerContext.BaseJpWarehouse.Where(x => orgList.Contains(x.OrgizationId)).ToList());
                    //货架(00000000-0000-0000-0000-000000000001为报废区）
                    _mysqlContext.BulkSynchronize<JmpModel.Model.BaseJpShelfInfo>(_sqlServerContext.BaseJpShelfInfo.Include(x => x.Warehouse).Where(x => orgList.Contains(x.Warehouse.OrgizationId) || x.Id == "00000000-0000-0000-0000-000000000001").ToList());
                    //通道配置
                    _mysqlContext.BulkSynchronize<JmpModel.Model.CommonJpChannelCfgV2>(_sqlServerContext.CommonJpChannelCfgV2.Include(x => x.Warehouse).Where(x => orgList.Contains(x.Warehouse.OrgizationId)).ToList());
                    //装备
                    _mysqlContext.BulkSynchronize<JmpModel.Model.CommonJpEquipmentInventory>(_sqlServerContext.CommonJpEquipmentInventory.Include(x => x.WarehouseCodeNavigation).Where(x => orgList.Contains(x.WarehouseCodeNavigation.OrgizationId)).ToList());
                    //_unitOfWork.DbContext.BulkSynchronize<JmpModel.Model.CommonJpEquipmentState>(_sqlServerContext.CommonJpEquipmentState.Where(x => orgList.Contains(x.OrgId)).ToList());
                    //阈值
                    _mysqlContext.BulkSynchronize<JmpModel.Model.CommonJpEquipmentThreshold>(_sqlServerContext.CommonJpEquipmentThreshold.Where(x => orgList.Contains(x.OrgId)).ToList());
                    //用户
                    _mysqlContext.BulkSynchronize<JmpModel.Model.CommonJpUser>(
                        _sqlServerContext.CommonJpUser
                            .Where(x => orgList.Contains(x.OrganizationId))
                            .Select(x => new JmpModel.Model.CommonJpUser
                            {
                                Id = x.Id,
                                AvatarId = null,
                                Email = x.Email,
                                Enabled = x.Enabled,
                                Password = x.Password,
                                Username = x.Username,
                                DeptId = x.DeptId,
                                Phone = x.Phone,
                                JobId = x.JobId,
                                CreateTime = x.CreateTime,
                                LastPasswordResetTime = x.LastPasswordResetTime,
                                NickName = x.NickName,
                                Sex = x.Sex,
                                OrganizationId = x.OrganizationId,
                                Token = x.Token,
                                PoliceId = x.PoliceId,
                            })
                            .ToList());

                    var userList = _mysqlContext.CommonJpUsers.Select(y => y.Id).ToList();
                    _mysqlContext.BulkSynchronize<JmpModel.Model.UsersRole>(_sqlServerContext.UsersRoles.Where(x => userList.Contains(x.UserId)).ToList());

                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }



        private List<JmpSqlServerModel.BaseJpOrganization> GetClassID(string id)
        {
            var query = (from c in _listEq
                         where c.ParentId == id
                         select c)
                .ToList();
            return query.Concat(query.SelectMany(t => GetClassID(t.Id))).ToList();
        }
    }
}
