﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Linq.Expressions;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.DataContext;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JmpModel.Model.Repository.CommonRepository;
using JmpModel.Print;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Rextec.SOA.Infrastructure;

namespace JunmpPoliceStation.Controllers
{
    /// <summary>
    /// 打印模块
    /// </summary>
    [ApiController]
    [Route("api/[controller]")]
    public class PrintController : ControllerBase
    {
        private ILogger<PrintController> _logger;
        private InventoryController _inventoryController;
        private HttpHelper _httpHelper;
        UnitOfWork _unitOfWork;
        public List<BaseJpOrganization> ListEq = new List<BaseJpOrganization>();

        private readonly object pushLockObj = new object();
        private readonly object _createEpcLockObj = new object();
        private readonly object _insertLockObj = new object();

        public PrintController(ILogger<PrintController> logger, UnitOfWork unitOfWork, InventoryController inventoryController, HttpHelper httpHelper)
        {
            _logger = logger;
            _inventoryController = inventoryController;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
            _httpHelper = httpHelper;
        }

        /// <summary>
        /// 获取全部的装备信息
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        /// <remarks>
        ///        /// ## 例子
        /// 
        ///        {
        ///       
        ///        } 
        /// </remarks>  
        ///       
        ///         
        ///        
        ///    
        [HttpPost("GetAllEquipments")]
        public async Task<HttpResponseMessage> GetAllEquipments([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {



                    var EquipmentList = _unitOfWork.DbContext.BaseJpEquipmentDetails.Include(p => p.BaseJpEquipmentSizes).Include(p => p.BaseJpSupplierEquipments).ToList();

                    var SupplierList = _unitOfWork.DbContext.BaseJpSuppliers.ToList();
                    var SizeList = _unitOfWork.DbContext.BaseJpEquipmentSizes.ToList();
                    if (EquipmentList.Count > 0)
                    {
                        var data = EquipmentList?.Select(x => new
                        {
                            equipmentDetailID = x.Id,
                            equipmentDetailName = x.Name,
                            supplierList = x.BaseJpSupplierEquipments?.Select(g =>
                           new
                           {

                               supplierid = g.SupplierCode,
                               supplierName = SupplierList.FirstOrDefault(s => s.Id == g.SupplierCode)?.Name
                           }),
                            equipmentSizeList = x.BaseJpEquipmentSizes?.Select(e => new
                            {


                                sizeName = e.SizeName,
                                sizeId = e.Id,
                                sizeCode = e.SizeCode

                            })
                        });


                        return JsonManager.ReturnSuccessResponse(data);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);

                    }





                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增装备
        /// </summary>
        /// <remarks>
        ///         /// 
        ///         ## 例子
        /// 
        ///         {
        ///         "warehouseid": "123",
        ///         "orgid": "123"
        ///         "userid": "111",
        ///         "equipments": [{
        ///         "supplierid": "222",
        ///	        "equipmentid": "123",
        ///         "epc": "123",
        ///	        "equipmentsizeid": "123"
        ///
        ///          }]
        ///          }
        ///</remarks>
        /// 
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddEquipment")]
        public async Task<HttpResponseMessage> AddEquipment([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        Dictionary<string, dynamic> Equipments = JsonManager.GetAddEquipmentInfo(jdata);
                        List<CommonJpEquipmentInventory> EquipmentList = new List<CommonJpEquipmentInventory>();
                        List<CommonJpEquipmentState> StateDetailsList = new List<CommonJpEquipmentState>();
                        foreach (var item in Equipments["equipments"])
                        {
                            string EqId = Guid.NewGuid().ToString();
                            EquipmentList.Add(new CommonJpEquipmentInventory
                            {
                                WarehouseCode = Equipments["warehouseid"],
                                Id = EqId,

                                CreateUser = Equipments["userid"],
                                UpdateUser = Equipments["userid"],
                                SupplierCode = item["supplierid"],
                                Epc = item["epc"],
                                EquipmentCode = item["equipmentid"],
                                EquipmentSizecode = item["equipmentsizeid"],
                                EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.仓库,
                                CurrentState = (int)EquipmentInventoryEnum.CurrentState.库存内,

                                FixCount = 0,
                                CreateTime = DateTime.Now,



                            });
                            StateDetailsList.Add(new CommonJpEquipmentState
                            {
                                Id = Guid.NewGuid().ToString(),
                                EqiupmentId = EqId,
                                OutInState = 1,
                                ActionState = 1,
                                CreateTime = DateTime.Now,
                                IntoTime = DateTime.Now,
                                WarehouseId = Equipments["warehouseid"],
                                OrgId = Equipments["orgID"]

                            });
                            //EquipmentList.
                        }
                        bool result = _unitOfWork.EquipmentInventoryRepository.Insert(EquipmentList);
                        bool stateResult = _unitOfWork.EquipmentStateRepository.Insert(StateDetailsList);


                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取全部打印列表
        /// </summary>
        /// <remarks>
        ///          
        ///         ## 例子
        /// 
        ///         {
        ///           "orgId": "",
        ///           "labelType": ""
        ///           "labelType": ""
        ///           "vendorName": ""
        ///           "productName": ""
        ///           "epcType": "epc类型 0：全部 1：件标 2：箱标"
        ///         }
        ///</remarks>
        ///
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPrintList")]
        public async Task<HttpResponseMessage> GetPrintList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.orgId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        var bState = int.TryParse(entity?.printState ?? "", out int printState);
                        string orgid = entity?.orgId ?? "";
                        string labelType = entity?.labelType ?? "-1";
                        string vendorName = entity?.vendorName ?? "";
                        string productName = entity?.productName ?? "";

                        int.TryParse(entity?.page, out int page);
                        int.TryParse(entity?.size, out int size);

                        if (!int.TryParse(entity?.epcType, out int epcType))
                        {
                            //默认件标
                            epcType = 1;
                        }

                        if (size == 0)
                        {
                            size = 50;
                        }
                        if (string.IsNullOrEmpty(orgid))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }

                        //箱标任务（拆箱后未打印）
                        var xbInvQuery = _unitOfWork.DbContext.CommonJpEquipmentInventories
                            .Include(x => x.WarehouseCodeNavigation)
                            .Include(x => x.EquipmentSizecodeNavigation)
                            .Include(x => x.SupplierCodeNavigation)
                            .Include(x => x.EquipmentCodeNavigation)
                            .Where(x =>
                              x.IsInBox != true
                              && string.IsNullOrEmpty(x.BoxMarkId)
                              && x.InstantiationState == 1
                              && x.WarehouseCodeNavigation.OrgizationId == orgid
                            );
                        if (int.TryParse(labelType, out int tmpType) && tmpType >= 0)
                        {
                            xbInvQuery = xbInvQuery.Where(x => x.EquipmentSizecodeNavigation.EpcType == tmpType);
                        }
                        if (!string.IsNullOrEmpty(vendorName))
                        {
                            xbInvQuery = xbInvQuery.Where(x => x.SupplierCodeNavigation.Name.Contains(vendorName));
                        }
                        if (!string.IsNullOrEmpty(productName))
                        {
                            xbInvQuery = xbInvQuery.Where(x => x.EquipmentCodeNavigation.Name.Contains(productName));
                        }
                        var xbInvList = xbInvQuery.ToList();

                        //件标任务
                        Expression<Func<CommonJpPurchaseEpc, bool>> expression = t =>
                            (string.IsNullOrEmpty(t.Detail.Order.ProcessCurrentId) || t.Detail.Order.ProcessCurrent.FlowState == "true")
                            && t.Detail.Order.OrgId.Equals(orgid);

                        if (int.TryParse(labelType, out int tmpType2) && tmpType2 >= 0)
                        {
                            expression = LambdaExtensions.And(expression, t => t.Detail.Size.EpcType == tmpType2);
                        }
                        if (!string.IsNullOrEmpty(vendorName))
                        {
                            expression = LambdaExtensions.And(expression, t => t.Detail.Supplier.Name.Contains(vendorName));
                        }
                        if (!string.IsNullOrEmpty(productName))
                        {
                            expression = LambdaExtensions.And(expression, t => t.Detail.Equipment.Name.Contains(productName));
                        }
                        if (bState)
                        {
                            if (printState == 0)
                            {
                                expression = LambdaExtensions.And(expression, t => t.CurrentState == printState);
                            }
                            else
                            {
                                expression = LambdaExtensions.And(expression, t => t.CurrentState != 0);
                            }
                        }

                        string[] parame = new string[]
                        {
                                "Detail",
                                "Supplier",
                                "Detail.Order",
                                "Detail.Supplier",
                                "Detail.Size",
                                "Detail.Equipment",
                                "Detail.Order.Warehouse"
                        };

                        var printList = _unitOfWork.PurchaseEpcsRepository.GetList(expression, x => x.CreateTime, false, parame).ToList();

                        var dataJB = printList.Select(x => new
                        {
                            createTime = x.CreateTime,
                            orderCode = x.Detail.Order.OrderCode,
                            id = x.Id,
                            epc = x.Epc,
                            productName = x.Detail?.Equipment?.Name ?? "",
                            productId = x.Detail?.Equipment?.Id ?? "",
                            productNo = x.Detail?.Equipment?.Code,
                            quantity = x.Detail?.Quantity,
                            sizeName = x.Detail?.Size?.SizeName,
                            sizeId = x.Detail?.Size?.Id,
                            sizeCode = x.Detail?.Size?.SizeCode,
                            supplierName = x.SupplierName,
                            supplierId = x.SupplierId,
                            supplierCode = x.Supplier?.SupplierCode,
                            printType = x.Detail?.Size?.EpcType ?? 0,
                            price = x.Price?.ToString() ?? "",
                            productTime = x.ProductTime?.ToString("yyyy-MM-dd"),
                            repairCycle = x.RepairCycle.ToString() ?? "",
                            useTime = x.UseTime?.ToString("yyyy-MM-dd"),
                            warrantyCycle = x.WarrantyCycle?.ToString() ?? "",
                            pieceNo = x.Num,
                            warehouseName = x.Detail?.Order?.Warehouse?.Name ?? "",
                            warehouseId = x.Detail?.Order?.WarehouseId ?? ""
                        })
                                        .OrderBy(t => t.epc)
                                        .ToList();
                        var dataXB = xbInvList.Select(x => new
                        {
                            isUnboxingLabel = true,
                            orderCode = "",
                            id = x.Id,
                            epc = x.Epc,
                            productName = x.EquipmentCodeNavigation?.Name ?? "",
                            productId = x.EquipmentCodeNavigation?.Id ?? "",
                            productNo = x.EquipmentCodeNavigation?.Code,
                            quantity = 1,
                            sizeName = x.EquipmentSizecodeNavigation?.SizeName,
                            sizeId = x.EquipmentSizecodeNavigation?.Id,
                            sizeCode = x.EquipmentSizecodeNavigation?.SizeCode,
                            supplierName = x.SupplierCodeNavigation?.Name,
                            supplierId = x.SupplierCodeNavigation?.Id,
                            supplierCode = x.SupplierCodeNavigation?.SupplierCode,
                            printType = x.EquipmentSizecodeNavigation?.EpcType ?? 0,
                            price = x.Price?.ToString() ?? "",
                            productTime = x.ProductTime?.ToString("yyyy-MM-dd"),
                            repairCycle = x.RepairCycle.ToString() ?? "",
                            useTime = x.UseTime?.ToString("yyyy-MM-dd"),
                            warrantyCycle = x.WarrantyCycle?.ToString() ?? "",
                            pieceNo = 1,
                            warehouseName = x.WarehouseCodeNavigation?.Name ?? "",
                            warehouseId = x.WarehouseCodeNavigation?.Id ?? ""
                        })
                            .OrderBy(t => t.epc)
                            .ToList();

                        switch (epcType)
                        {
                            case 0:
                                {
                                    //全部

                                    var resList = new List<object>();
                                    //先显示箱标再显示件标
                                    resList.AddRange(dataXB);
                                    resList.AddRange(dataJB);
                                    return JsonManager.ReturnSuccessResponse(new
                                    {
                                        total = resList.Count,
                                        record = resList.Skip(page * size).Take(size)
                                    });
                                }
                            case 1:
                                {
                                    //件标

                                    return JsonManager.ReturnSuccessResponse(new
                                    {
                                        total = printList.Count,
                                        record = dataJB.Skip(page * size).Take(size)
                                    });
                                }
                            case 2:
                                {
                                    //箱标
                                    return JsonManager.ReturnSuccessResponse(new
                                    {
                                        total = xbInvList.Count,
                                        record = dataXB.Skip(page * size).Take(size)
                                    });
                                }
                            default: return JsonManager.SimpleCustResponse($"epcType is require");
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 获取装备包打印列表
        /// </summary>
        /// <remarks>
        ///          
        ///         ## 例子
        /// 
        ///         {
        ///           "orgId": "",
        ///           "bagName": ""
        ///         }
        ///</remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPrintBagList")]
        public async Task<HttpResponseMessage> GetPrintBagList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);


                        string orgid = entity?.orgId ?? "";
                        string bagName = entity?.bagName ?? "";


                        if (string.IsNullOrEmpty(orgid))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }

                        //件标任务
                        Expression<Func<CommonJpBagInventory, bool>> expression = x =>
                             x.Bag.OrgId.Equals(orgid)
                             && x.PrintState == 1
                             && x.IsDelete != true;

                        if (!string.IsNullOrEmpty(bagName))
                        {
                            expression = expression.And(x => x.Bag.Name.Contains(bagName));
                        }

                        string[] parame = new string[]
                        {
                            "Bag",
                            "CommonJpEquipmentInventories",
                            "CommonJpEquipmentInventories.EquipmentCodeNavigation",
                            "Warehouse",

                        };

                        var printList = _unitOfWork.BagInventoryRepository
                            .GetList(expression, x => x.CreateTime, false, parame).ToList();

                        var resList = printList.Select(x => new
                        {
                            id = x.Id,
                            epc = x.Epc,
                            createTime = x.CreateTime,
                            bagId = x.BagId,
                            number = x.Number,
                            oneBoxNum = x.NeedNumber,
                            warehouseId = x.WarehouseId,
                            warehouseName = x.Warehouse.Name,
                            organizationId = x.Bag.OrgId,
                            bagName = x.Bag.Name,
                            invInfo = string.Join(",", x.CommonJpEquipmentInventories.Select(y => y.EquipmentCodeNavigation.Name).Distinct())

                        })
                            .OrderBy(t => t.epc)
                            .ToList();
                        return JsonManager.ReturnSuccessResponse(resList);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 更新装备包打印状态
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        /// <remarks>
        ///        /// ## 例子
        /// 
        ///        {
        ///          "id":"xxxx",   
        ///        } 
        /// </remarks>
        [HttpPost("UpdateBagState")]
        //[NoSign]
        public async Task<HttpResponseMessage> UpdateBagState([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else
                        {
                            var epcs = _unitOfWork.DbContext.CommonJpBagInventories
                                .FirstOrDefault(
                                    t => t.Id == id && (t.PrintState == 1 || t.PrintState == 2) //允许重复执行打印绑定操作
                                );

                            if (epcs != null)
                            {
                                epcs.PrintState = 2;
                                bool result = _unitOfWork.BagInventoryRepository.Update(epcs);
                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                }
                            }
                            else
                            {
                                //将未查询到epcs记录的数据返回错误
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                            }
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 更新EPC打印状态
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        /// <remarks>
        ///        /// ## 例子
        /// 
        ///        {
        ///          "id":"xxxx",
        ///          "isDirectEntryStock":"false"     //是否需要直接采购入库
        ///        } 
        /// </remarks>
        [HttpPost("UpdateEpcState")]
        //[NoSign]
        public async Task<HttpResponseMessage> UpdateEpcState([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else
                        {
                            var epcs = _unitOfWork.DbContext.CommonJpPurchaseEpcs
                                .Include(x => x.Detail)
                                .Include(x => x.Detail.Order)
                                .Include(x => x.Detail.Order.Org)
                                .Include(x => x.Detail.Size)
                                .Include(x => x.Detail.Order.Warehouse)
                                .FirstOrDefault(t => t.Id == id
                                                     && (t.CurrentState == 0 || t.CurrentState == 1)    //允许重复执行打印绑定操作
                                );

                            if (epcs != null)
                            {
                                //if (epcs.Detail.Order.Warehouse.IsLocked == true)
                                //{
                                //    return JsonManager.SimpleCustResponse("写入入库记录失败，锁库中");
                                //}

                                epcs.CurrentState = 1;
                                bool result = _unitOfWork.PurchaseEpcsRepository.Update(epcs);
                                if (result)
                                {
                                    if (bool.TryParse(entity?.isDirectEntryStock, out bool isDirectEntryStock) && isDirectEntryStock)
                                    {
                                        var userData =
                                            _unitOfWork.DbContext.CommonJpUsers
                                                .Include(x => x.Police)
                                                .FirstOrDefault(x => x.Id == epcs.Detail.Order.ApplyId);
                                        var res = _inventoryController.UploadRFIDNew(JObject.Parse($@"
                                            {{
                                            	""orgId"": ""{epcs.Detail.Order.OrgId}"",
                                            	""warehouseId"": ""{epcs.Detail.Order.WarehouseId}"",
                                            	""policeId"": ""{userData?.PoliceId}"",
                                            	""currentState"": 1,
                                            	""picUrl"": """",
                                            	""RFIDList"": [{{
                                            		""RFID"": ""{epcs.Epc}""
                                            	}}]
                                            }}
                                        ")).Result;
                                        var resBody = res.Content.ReadAsStringAsync().Result;

                                        var obj = JObject.Parse(resBody);
                                        if (obj["code"]?.Value<int>() != 10000)
                                        {
                                            var type = epcs.Detail.Size.EpcType == 0 ? "打印" : "绑定";
                                            return JsonManager.SimpleCustResponse(type + "成功,入库失败,请手动入库");
                                        }
                                    }
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                }
                            }
                            else
                            {
                                //将未查询到epcs记录的数据返回错误
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                            }
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 获取装备号型、供应商
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        /// <remarks>
        ///        /// ## 例子
        /// 
        ///        {
        ///          "id":"xxxx"
        ///        } 
        /// </remarks>    
        [HttpPost("GetEquInfoById")]
        public async Task<HttpResponseMessage> GetEquInfoById([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else
                        {
                            var info = _unitOfWork.DbContext.BaseJpEquipmentDetails
                                .Include("BaseJpEquipmentSizes")
                                .Include("BaseJpSupplierEquipments")
                                .Include("BaseJpSupplierEquipments.SupplierCodeNavigation")
                                .FirstOrDefault(t => t.Id == id);
                            if (info == null)
                            {
                                return JsonManager.ReturnSuccessResponse(new { });
                            }
                            else
                            {
                                var data = new
                                {
                                    suppliers = info.BaseJpSupplierEquipments.Select(s => new
                                    {
                                        name = s.SupplierCodeNavigation.Name,
                                        code = s.SupplierCodeNavigation.SupplierCode,
                                        id = s.SupplierCode
                                    }).ToList(),
                                    sizes = info.BaseJpEquipmentSizes.Select(s => new
                                    {
                                        id = s.Id,
                                        name = s.SizeName,
                                        code = s.SizeCode
                                    }).ToList()
                                };
                                return JsonManager.ReturnSuccessResponse(data);
                            }
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 获取装备信息，打印程序用
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>  
        [HttpPost("GetAllEqu")]
        [NoSign]
        public async Task<HttpResponseMessage> GetAllEqu()
        {
            return await Task.Run(() =>
             {
                 try
                 {
                     var info = _unitOfWork.DbContext.BaseJpEquipmentDetails;

                     if (info == null)
                     {
                         return JsonManager.ReturnSuccessResponse(new { });
                     }
                     else
                     {
                         var data = (from v in info
                                     select new
                                     {
                                         id = v.Id,
                                         name = v.Name,
                                         code = v.Code
                                     }).ToList();
                         return JsonManager.ReturnSuccessResponse(data);
                     }


                 }
                 catch (Exception ex)
                 {

                     _logger.LogError(ex.ToString());
                     return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                 }
             });
        }

        /// <summary>
        /// 订单列表获取
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        /// <remarks>
        ///        /// ## 例子
        /// 
        ///        {
        ///          "orgId":"E05CC28D-C189-4389-8081-DD0D6E483B40"
        ///        } 
        /// </remarks>   
        [HttpPost("GetPrintOrder")]
        //[NoSign]
        public async Task<HttpResponseMessage> GetPrintOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string orgId = entity?.orgId ?? "";

                        DateTime.TryParse(entity?.createTime, out DateTime createTime);
                        string equName = entity?.equName ?? "";
                        string orderCode = entity?.orderCode ?? "";

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        if (size == 0)
                        {
                            size = 50;
                        }

                        if (string.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }

                        else
                        {
                            Expression<Func<CommonJpPurchaseDetail, bool>> where = t => t.Order.OrgId.Contains(orgId) && t.State != 2 && t.Quantity > t.CommonJpPurchaseEpcs.Count && t.Order.ProcessCurrent.FlowState == "true";
                            if (createTime != null && createTime != default)
                            {
                                where = LambdaExtensions.AndAlso(where, t => t.Order.CreateTime.Value.Date == createTime.Date);
                            }

                            if (!string.IsNullOrEmpty(equName))
                            {
                                where = LambdaExtensions.AndAlso(where, t => t.Equipment.Name.Contains(equName));
                            }
                            if (!string.IsNullOrEmpty(orderCode))
                            {
                                where = LambdaExtensions.AndAlso(where, t => t.Order.OrderCode.Contains(orderCode));
                            }

                            string[] parame = new string[]
                            {
                        "Order",
                        "Order.Warehouse",
                        "Size",
                        "Equipment",
                        "CommonJpPurchaseEpcs",
                        "Equipment.BaseJpSupplierEquipments",
                        "Equipment.BaseJpSupplierEquipments.SupplierCodeNavigation"
                            };

                            var details = _unitOfWork.PurchaseDetailRepository.GetPage(where, "-CreateTime", page, size, false, parame);
                            var data = from v in details.content
                                       select new
                                       {
                                           suppilers = v.Equipment.BaseJpSupplierEquipments.Select(s => new
                                           {
                                               id = s.SupplierCode,
                                               name = s.SupplierCodeNavigation?.Name,
                                               code = s.SupplierCodeNavigation?.SupplierCode
                                           }),
                                           orderId = v.Order.Id,
                                           detailId = v.Id,
                                           createTime = v.Order.CreateTime,
                                           equCode = v.Equipment.Code,
                                           equName = v.Equipment.Name,
                                           equId = v.Equipment.Id,
                                           sizeId = v.Size.Id,
                                           sizeCode = v.Size.SizeCode,
                                           sizeName = v.Size.SizeName,
                                           orderCode = v.Order.OrderCode,
                                           genedNum = v.CommonJpPurchaseEpcs.Count,
                                           totalNum = v.Quantity,
                                           reNum = v.Quantity - v.CommonJpPurchaseEpcs.Count,
                                           warehouseId = v.Order.WarehouseId,
                                           warehouseName = v.Order.Warehouse.Name,
                                       };

                            return JsonManager.ReturnSuccessResponse(new
                            {
                                total = details.totalElements,
                                record = data.ToList()
                            });

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取所有供应商，打印程序用
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllSupplier")]
        [NoSign]
        public async Task<HttpResponseMessage> GetAllSupplier()
        {
            return await Task.Run(() =>
            {
                try
                {
                    var suppliers = _unitOfWork.SupplierRepository.GetList(t => !string.IsNullOrEmpty(t.SupplierCode)).Select(s => new
                    {
                        id = s.Id,
                        code = s.SupplierCode,
                        name = s.Name
                    }).ToList();

                    return JsonManager.ReturnSuccessResponse(new
                    {
                        total = suppliers.Count,
                        record = suppliers.ToList()
                    });
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 根据采购单信息生成EPC
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>

        [HttpPost("GenerateExtTagEpc")]
        public async Task<HttpResponseMessage> GenerateExtTagEpc([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string supplierId = entity?.supplierId ?? "";
                            string detailId = entity?.detailId ?? "";
                            string sizeCode = entity?.sizeCode ?? "";
                            string equCode = entity?.equCode ?? "";
                            string supplierCode = entity?.supplierCode ?? "";
                            string supplierName = entity?.supplierName ?? "";

                            bool bQuantity = int.TryParse(entity?.quantity ?? "0", out int quantity);

                            bool bPrice = decimal.TryParse(entity?.price ?? "0", out decimal price);
                            bool bProduct = DateTime.TryParse(entity?.productTime ?? "", out DateTime productTime);
                            bool bUse = DateTime.TryParse(entity?.useTime ?? "", out DateTime useTime);

                            bool bRepair = int.TryParse(entity?.repairCycle ?? "0", out int repairCycle);
                            bool bWarranty = int.TryParse(entity?.warrantyCycle ?? "0", out int warrantyCycle);

                            string shelfId = entity?.shelfId ?? "";
                            bool bShelfRange = int.TryParse(entity?.shelfRange ?? "0", out int shelfRange);
                            bool bShelfRow = int.TryParse(entity?.shelfRow ?? "0", out int shelfRow);
                            bool bShelfColumn = int.TryParse(entity?.shelfColumn ?? "0", out int shelfColumn);

                            if (string.IsNullOrEmpty(detailId))
                            {
                                return JsonManager.SimpleCustResponse($"无效的明细代码");
                            }
                            else if (string.IsNullOrEmpty(supplierName))
                            {
                                return JsonManager.SimpleCustResponse($"无效的供应商名称");
                            }
                            else if (!ulong.TryParse(sizeCode, out ulong lSizeCode) || !_unitOfWork.EquipmentSizeRepository.Any(t => t.SizeCode == (int)lSizeCode))
                            {
                                return JsonManager.SimpleCustResponse($"无效的号型代码");
                            }
                            else if (!ulong.TryParse(equCode, out ulong lEquCode) || !_unitOfWork.EquipmentDetailRepository.Any(t => t.Code == equCode))
                            {
                                return JsonManager.SimpleCustResponse($"无效的物资代码");

                            }
                            else if (!bQuantity || quantity <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的装备数量");

                            }
                            else if (quantity > 4095)
                            {
                                return JsonManager.SimpleCustResponse($"数量不正确，应小于4095");
                            }
                            else if (!bRepair || repairCycle <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的维保周期");

                            }
                            else if (!bPrice || price <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的购入单价");

                            }
                            else if (!bWarranty || warrantyCycle < 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的质保周期");

                            }
                            else if (!bUse || useTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效使用日期");
                            }
                            else if (!bProduct || productTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效生产日期");
                            }
                            else if (string.IsNullOrEmpty(supplierCode) || supplierCode.Length != 9 || !_unitOfWork.SupplierRepository.Any(t => t.SupplierCode == supplierCode))
                            {
                                return JsonManager.SimpleCustResponse($"无效的供应商代码");
                            }
                            else if (string.IsNullOrEmpty(supplierId) || !_unitOfWork.SupplierRepository.Any(t => t.Id == supplierId))
                            {
                                return JsonManager.SimpleCustResponse($"无效的供应商ID");
                            }
                            else
                            {
                                List<EpcInfo> epcList = new List<EpcInfo>();
                                uint date = uint.Parse(productTime.Date.ToString("yyyyMMdd"));

                                var httpResult = _httpHelper.GetHtml(new HttpItem()
                                {
                                    URL = _httpHelper._centerServerAddress + "/api/Print/GenEpcs",
                                    Encoding = Encoding.UTF8,
                                    Method = "POST",
                                    ContentType = "application/json",
                                    Timeout = 5000,
                                    Postdata = JsonConvert.SerializeObject(new
                                    {
                                        type = "JB",
                                        serverNum = GlobalContext.ServerNum,
                                        equCode = lEquCode,
                                        supplierCode = supplierCode,
                                        sizeCode = lSizeCode,
                                        productTime = date,
                                        wzsl = quantity
                                    })
                                });
                                if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                {
                                    return JsonManager.SimpleCustResponse("远端上报数据失败");
                                }
                                var obj = JsonConvert.DeserializeObject<JmpBaseResponse<List<GenerateEpcNum.GenEpcInfo>>>(httpResult.Html);
                                if (obj.code != "10000")
                                {
                                    return JsonManager.SimpleCustResponse(obj.msg);
                                }
                                var epcs = obj.data;

                                if (epcs.Count == quantity)
                                {
                                    epcs.ForEach(s =>
                                    {
                                        epcList.Add(new EpcInfo()
                                        {
                                            detailId = detailId,
                                            supplierId = supplierId,
                                            epc = s.Epc,
                                            price = price,
                                            productTime = productTime,
                                            repairCycle = repairCycle,
                                            useTime = useTime,
                                            warrantyCycle = warrantyCycle,
                                            num = s.Num,
                                            supplierName = supplierName,
                                        });

                                        CommonJpPurchaseEpc insert = new CommonJpPurchaseEpc()
                                        {
                                            Id = Guid.NewGuid().ToString(),
                                            Num = s.Num,
                                            CreateTime = DateTime.Now,
                                            CurrentState = 0,
                                            DetailId = detailId,
                                            Epc = s.Epc,
                                            Price = price,
                                            ProductTime = productTime,
                                            RepairCycle = repairCycle,
                                            SupplierId = supplierId,
                                            UseDirection = 0,
                                            UseTime = useTime,
                                            WarrantyCycle = warrantyCycle,
                                            SupplierName = supplierName
                                        };
                                        if (!string.IsNullOrEmpty(shelfId))
                                        {
                                            insert.ShelfId = shelfId;
                                            insert.ShelfRange = shelfRange == 0 ? (int?)null : shelfRange;
                                            insert.ShelfRow = shelfRow == 0 ? (int?)null : shelfRow;
                                            insert.ShelfColumn = shelfColumn == 0 ? (int?)null : shelfColumn;
                                        }
                                        _unitOfWork.PurchaseEpcsRepository.Insert(insert, false);
                                    });

                                    var res = _unitOfWork.PurchaseEpcsRepository.SaveChanges() > 0;
                                    if (res)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleCustResponse("数据保存失败");
                                    }
                                }
                                else
                                {
                                    return JsonManager.SimpleCustResponse(obj.msg);
                                }
                            }

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 直接生成EPC
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GenerateIntTagEpc")]
        public async Task<HttpResponseMessage> GenerateIntTagEpc([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string sizeCode = entity?.sizeCode ?? "";
                            string equCode = entity?.equCode ?? "";
                            string supplierCode = entity?.supplierCode ?? "";
                            bool bQuantity = int.TryParse(entity?.quantity ?? "0", out int quantity);
                            bool bProduct = DateTime.TryParse(entity?.productTime ?? "", out DateTime productTime);
                            bool bWarranty = int.TryParse(entity?.warrantyCycle ?? "0", out int warrantyCycle);

                            string labelType = entity.labelType ?? "件标";
                            bool bOneBoxNum = uint.TryParse(entity.oneBoxNum, out uint oneBoxNum);

                            if (!ulong.TryParse(sizeCode, out ulong lSizeCode) || !_unitOfWork.EquipmentSizeRepository.Any(t => t.SizeCode == (int)lSizeCode))
                            {
                                return JsonManager.SimpleCustResponse($"无效的号型代码");
                            }
                            else if (!ulong.TryParse(equCode, out ulong lEquCode) || !_unitOfWork.EquipmentDetailRepository.Any(t => t.Code == equCode))
                            {
                                return JsonManager.SimpleCustResponse($"无效的物资代码");
                            }
                            else if (!bQuantity || quantity <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的装备数量");

                            }
                            else if (quantity > 4095)
                            {
                                return JsonManager.SimpleCustResponse($"数量不正确，应小于4095");
                            }
                            else if (!bWarranty || warrantyCycle < 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的质保周期");

                            }
                            else if (!bProduct || productTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效生产日期");
                            }
                            else if (string.IsNullOrEmpty(supplierCode) || supplierCode.Length != 9 || !_unitOfWork.SupplierRepository.Any(t => t.SupplierCode == supplierCode))
                            {
                                return JsonManager.SimpleCustResponse($"无效的供应商代码");
                            }
                            else
                            {
                                uint date = uint.Parse(productTime.Date.ToString("yyyyMMdd"));
                                var epcs = new List<GenerateEpcNum.GenEpcInfo>();
                                var msg = "";
                                switch (labelType)
                                {
                                    case "件标":
                                        {
                                            var httpResult = _httpHelper.GetHtml(new HttpItem()
                                            {
                                                URL = _httpHelper._centerServerAddress + "/api/Print/GenEpcs",
                                                Encoding = Encoding.UTF8,
                                                Method = "POST",
                                                ContentType = "application/json",
                                                Timeout = 5000,
                                                Postdata = JsonConvert.SerializeObject(new
                                                {
                                                    type = "JB",
                                                    serverNum = GlobalContext.ServerNum,
                                                    equCode = lEquCode,
                                                    supplierCode = supplierCode,
                                                    sizeCode = lSizeCode,
                                                    productTime = date,
                                                    wzsl = quantity
                                                })
                                            });
                                            if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                            {
                                                return JsonManager.SimpleCustResponse("远端上报数据失败");
                                            }
                                            var obj = JsonConvert.DeserializeObject<JmpBaseResponse<List<GenerateEpcNum.GenEpcInfo>>>(httpResult.Html);
                                            if (obj.code != "10000")
                                            {
                                                return JsonManager.SimpleCustResponse(obj.msg);
                                            }
                                            epcs = obj.data;
                                            break;
                                        }
                                    case "箱标":
                                        {
                                            if (!bOneBoxNum || oneBoxNum <= 0)
                                            {
                                                return JsonManager.SimpleCustResponse($"无效的箱内装备数量");
                                            }

                                            var httpResult = _httpHelper.GetHtml(new HttpItem()
                                            {
                                                URL = _httpHelper._centerServerAddress + "/api/Print/GenEpcs",
                                                Encoding = Encoding.UTF8,
                                                Method = "POST",
                                                ContentType = "application/json",
                                                Timeout = 5000,
                                                Postdata = JsonConvert.SerializeObject(new
                                                {
                                                    type = "XB",
                                                    serverNum = GlobalContext.ServerNum,
                                                    equCode = lEquCode,
                                                    supplierCode = supplierCode,
                                                    sizeCode = lSizeCode,
                                                    productTime = date,
                                                    wzsl = quantity,
                                                    oneBoxNum = oneBoxNum
                                                })
                                            });
                                            if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                            {
                                                return JsonManager.SimpleCustResponse("远端上报数据失败");
                                            }
                                            var obj = JsonConvert.DeserializeObject<JmpBaseResponse<List<GenerateEpcNum.GenEpcInfo>>>(httpResult.Html);
                                            if (obj.code != "10000")
                                            {
                                                return JsonManager.SimpleCustResponse(obj.msg);
                                            }
                                            epcs = obj.data;
                                            break;
                                        }
                                    default:
                                        {
                                            //其他作为件标
                                            var httpResult = _httpHelper.GetHtml(new HttpItem()
                                            {
                                                URL = _httpHelper._centerServerAddress + "/api/Print/GenEpcs",
                                                Encoding = Encoding.UTF8,
                                                Method = "POST",
                                                ContentType = "application/json",
                                                Timeout = 5000,
                                                Postdata = JsonConvert.SerializeObject(new
                                                {
                                                    type = "JB",
                                                    serverNum = GlobalContext.ServerNum,
                                                    equCode = lEquCode,
                                                    supplierCode = supplierCode,
                                                    sizeCode = lSizeCode,
                                                    productTime = date,
                                                    wzsl = quantity
                                                })
                                            });
                                            if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                            {
                                                return JsonManager.SimpleCustResponse("远端上报数据失败");
                                            }
                                            var obj = JsonConvert.DeserializeObject<JmpBaseResponse<List<GenerateEpcNum.GenEpcInfo>>>(httpResult.Html);
                                            if (obj.code != "10000")
                                            {
                                                return JsonManager.SimpleCustResponse(obj.msg);
                                            }
                                            epcs = obj.data;
                                            break;
                                        }
                                }
                                if (epcs.Count == quantity)
                                {
                                    var data = (from v in epcs
                                                select new
                                                {
                                                    epc = v.Epc,
                                                    num = v.Num
                                                });
                                    return JsonManager.ReturnSuccessResponse(data);
                                }
                                else
                                {
                                    return JsonManager.SimpleCustResponse(msg);
                                }
                            }

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 生成打印入库信息(打印程序内部使用）
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GenerateInventoryWithProgram")]
        public async Task<HttpResponseMessage> GenerateInventoryWithProgram([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                lock (_insertLockObj)
                {
                    try
                    {
                        if (jdata != null)
                        {
                            var entity = JsonManager.GetJsonEntity(jdata);
                            if (entity == null)
                            {
                                return JsonManager.SimpleCustResponse($"无效参数");
                            }

                            string sizeId = entity?.sizeId ?? "";
                            string equId = entity?.equId ?? "";
                            string epc = entity?.epc ?? "";
                            string supplierId = entity?.supplierId ?? "";
                            string warehouseId = entity?.warehouseId ?? "";

                            bool bProduct = DateTime.TryParse(entity?.productTime ?? "", out DateTime productTime);
                            bool bWarranty = int.TryParse(entity?.warrantyCycle ?? "0", out int warrantyCycle);
                            bool bPrice = decimal.TryParse(entity?.price ?? "0", out decimal price);
                            bool bUse = DateTime.TryParse(entity?.useTime ?? "", out DateTime useTime);
                            bool bRepair = int.TryParse(entity?.repairCycle ?? "0", out int repairCycle);

                            string shelfId = entity?.shelfId ?? "";
                            bool bShelfRange = int.TryParse(entity?.shelfRange ?? "0", out int shelfRange);
                            bool bShelfRow = int.TryParse(entity?.shelfRow ?? "0", out int shelfRow);
                            bool bShelfColumn = int.TryParse(entity?.shelfColumn ?? "0", out int shelfColumn);

                            bool.TryParse(entity.isUnboxingLabel, out bool isUnboxingLabel);

                            if (string.IsNullOrEmpty(sizeId))
                            {
                                return JsonManager.SimpleCustResponse($"无效号型");
                            }
                            else if (string.IsNullOrEmpty(equId))
                            {
                                return JsonManager.SimpleCustResponse($"无效装备");
                            }
                            else if (string.IsNullOrEmpty(epc))
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }
                            else if (!CheckEpc(epc, equId))
                            {
                                return JsonManager.SimpleCustResponse($"EPC与装备不匹配");
                            }
                            else if (string.IsNullOrEmpty(supplierId))
                            {
                                return JsonManager.SimpleCustResponse($"无效供应商");
                            }
                            else if (string.IsNullOrEmpty(warehouseId))
                            {
                                return JsonManager.SimpleCustResponse($"无效仓库");
                            }
                            else if (!bRepair || repairCycle <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的装维保周期");
                            }
                            else if (!bPrice || price <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的购入单价");
                            }
                            else if (!bWarranty || warrantyCycle < 0)   //质保周期可以为0
                            {
                                return JsonManager.SimpleCustResponse($"无效的质保周期");

                            }
                            else if (!bUse || useTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效使用日期");
                            }
                            else if (!bProduct || productTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效生产日期");
                            }
                            else if (isUnboxingLabel == false && _unitOfWork.EquipmentInventoryRepository.Any(t => t.Epc.ToUpper() == epc.ToUpper()))
                            {
                                return JsonManager.SimpleCustResponse($"生成库存失败，库存内已存在此EPC");
                            }
                            else
                            {
                                using (var scope = _unitOfWork.BeginTransaction())
                                {
                                    try
                                    {
                                        bool res = false;
                                        if (isUnboxingLabel)
                                        {
                                            var inv = _unitOfWork.EquipmentInventoryRepository.Get(t =>
                                                t.Epc.ToUpper() == epc.ToUpper());
                                            if (inv == null)
                                            {
                                                return JsonManager.SimpleCustResponse($"物资异常");
                                            }

                                            inv.InstantiationState = 2;
                                            res = _unitOfWork.EquipmentInventoryRepository.Update(inv);

                                            if (res)
                                            {
                                                //上报更新物资
                                                var httpResult = _httpHelper.GetHtml(new HttpItem()
                                                {
                                                    URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                                    Encoding = Encoding.UTF8,
                                                    Method = "POST",
                                                    ContentType = "application/json",
                                                    Timeout = 5000,
                                                    Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                                    {
                                                        data = new List<object>()
                                                        {
                                                            new
                                                            {
                                                                editType="UPDATE",
                                                                id = inv.Id,
                                                                policeCode=inv.PoliceCode,
                                                                warehouseCode=inv.WarehouseCode,
                                                                cabinetId=inv.CabinetId,
                                                                equipmentLocation=inv.EquipmentLocation,
                                                                currentState=inv.CurrentState,
                                                                warrantyCycle=inv.WarrantyCycle,
                                                                repairCycle=inv.RepairCycle,
                                                                productTime=inv.ProductTime,
                                                                useTime=inv.UseTime,
                                                                price=inv.Price,
                                                                isBorrowed=inv.IsBorrowed,
                                                                lostFlag=inv.LostFlag,
                                                                inventoryState = inv.InventoryState,
                                                                isInBox=inv.IsInBox,
                                                                boxMarkId=inv.BoxMarkId,
                                                                instantiationState=inv.InstantiationState,
                                                            }
                                                        }
                                                    }))
                                                });
                                                if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                                {
                                                    scope.Rollback();
                                                    return JsonManager.SimpleCustResponse("远端上报数据失败");
                                                }
                                                var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                                if (obj.code != "10000")
                                                {
                                                    scope.Rollback();
                                                    return JsonManager.SimpleCustResponse(obj.msg);
                                                }
                                            }
                                        }
                                        else
                                        {
                                            var ent = new CommonJpEquipmentInventory
                                            {
                                                Id = Guid.NewGuid().ToString(),
                                                Epc = epc,
                                                SupplierCode = supplierId,
                                                EquipmentCode = equId,
                                                WarehouseCode = warehouseId,
                                                EquipmentLocation = 0,
                                                CurrentState = 0,
                                                CreateTime = DateTime.Now,
                                                CreateUser = "internal",
                                                EquipmentSizecode = sizeId,
                                                UpdateUser = "internal",
                                                Price = price,
                                                ProductTime = productTime,
                                                UseTime = useTime,
                                                UseDirection = 0,
                                                WarrantyCycle = warrantyCycle,
                                                RepairCycle = repairCycle,
                                                IsBorrowed = false,
                                                InstantiationState = 2,
                                            };

                                            if (!string.IsNullOrEmpty(shelfId))
                                            {
                                                ent.ShelfId = shelfId;
                                                ent.ShelfRange = shelfRange == 0 ? (int?)null : shelfRange;
                                                ent.ShelfRow = shelfRow == 0 ? (int?)null : shelfRow;
                                                ent.ShelfColumn = shelfColumn == 0 ? (int?)null : shelfColumn;
                                            }

                                            //上报新增物资
                                            var httpResult = _httpHelper.GetHtml(new HttpItem()
                                            {
                                                URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                                Encoding = Encoding.UTF8,
                                                Method = "POST",
                                                ContentType = "application/json",
                                                Timeout = 5000,
                                                Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                                {
                                                    data = new List<object>()
                                                    {
                                                        new
                                                        {
                                                            editType = "ADD",
                                                            id = ent.Id,
                                                            supplierCode = ent.SupplierCode,
                                                            epc = ent.Epc,
                                                            policeCode = ent.PoliceCode,
                                                            equipmentCode = ent.EquipmentCode,
                                                            warehouseCode = ent.WarehouseCode,
                                                            cabinetId = ent.CabinetId,
                                                            equipmentSizecode = ent.EquipmentSizecode,
                                                            equipmentLocation = ent.EquipmentLocation,
                                                            currentState = ent.CurrentState,
                                                            createTime = ent.CreateTime,
                                                            warrantyCycle = ent.WarrantyCycle,
                                                            repairCycle = ent.RepairCycle,
                                                            productTime = ent.ProductTime,
                                                            useTime = ent.UseTime,
                                                            price = ent.Price,
                                                            isBorrowed = ent.IsBorrowed,
                                                            lostFlag = ent.LostFlag,
                                                            inventoryState = ent.InventoryState,
                                                            isInBox = ent.IsInBox,
                                                            boxMarkId = ent.BoxMarkId,
                                                            instantiationState = ent.InstantiationState,

                                                        }
                                                    }
                                                }))
                                            });
                                            if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse("远端上报数据失败");
                                            }
                                            var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                            if (obj.code != "10000")
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse(obj.msg);
                                            }

                                            res = _unitOfWork.EquipmentInventoryRepository.Insert(ent);
                                        }
                                        if (res)
                                        {
                                            scope.Commit();
                                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                        }
                                        else
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("数据写入失败");
                                        }
                                    }
                                    catch (Exception e)
                                    {
                                        scope.Rollback();
                                        throw;
                                    }
                                }
                            }
                        }
                        else
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                    }
                    catch (Exception ex)
                    {
                        _logger.LogError(ex.ToString());
                        if (ex.Message == "CRC校验失败")
                        {
                            return JsonManager.SimpleCustResponse($"EPC CRC校验失败");
                        }
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
            });
        }

        /// <summary>
        /// 生成打印入库信息(多个epc,箱标限定）
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GenerateRangeInventory")]
        public async Task<HttpResponseMessage> GenerateRangeInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string sizeId = entity?.sizeId ?? "";
                            string equId = entity?.equId ?? "";
                            string epcListJson = entity?.epcListJson ?? "";
                            string supplierId = entity?.supplierId ?? "";
                            string warehouseId = entity?.warehouseId ?? "";
                            string boxMarkEpc = entity?.epc ?? "";


                            bool.TryParse(entity.isReloadBoxing, out bool isReloadBoxing);


                            bool bProduct = DateTime.TryParse(entity?.productTime ?? "", out DateTime productTime);
                            bool bWarranty = int.TryParse(entity?.warrantyCycle ?? "0", out int warrantyCycle);
                            bool bPrice = decimal.TryParse(entity?.price ?? "0", out decimal price);
                            bool bUse = DateTime.TryParse(entity?.useTime ?? "", out DateTime useTime);
                            bool bRepair = int.TryParse(entity?.repairCycle ?? "0", out int repairCycle);

                            string shelfId = entity?.shelfId ?? "";
                            bool bShelfRange = int.TryParse(entity?.shelfRange ?? "0", out int shelfRange);
                            bool bShelfRow = int.TryParse(entity?.shelfRow ?? "0", out int shelfRow);
                            bool bShelfColumn = int.TryParse(entity?.shelfColumn ?? "0", out int shelfColumn);

                            if (string.IsNullOrEmpty(boxMarkEpc))
                            {
                                return JsonManager.SimpleCustResponse($"无效箱标epc");
                            }

                            if (string.IsNullOrEmpty(sizeId))
                            {
                                return JsonManager.SimpleCustResponse($"无效号型");
                            }
                            else if (string.IsNullOrEmpty(equId))
                            {
                                return JsonManager.SimpleCustResponse($"无效装备");
                            }
                            else if (string.IsNullOrEmpty(epcListJson))
                            {
                                return JsonManager.SimpleCustResponse($"无效EPCList");
                            }
                            else if (string.IsNullOrEmpty(supplierId))
                            {
                                return JsonManager.SimpleCustResponse($"无效供应商");
                            }
                            else if (string.IsNullOrEmpty(warehouseId))
                            {
                                return JsonManager.SimpleCustResponse($"无效仓库");
                            }
                            else if (!bRepair || repairCycle <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的装维保周期");
                            }
                            else if (!bPrice || price <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的购入单价");
                            }
                            else if (!bWarranty || warrantyCycle < 0)   //质保周期可以为0
                            {
                                return JsonManager.SimpleCustResponse($"无效的质保周期");

                            }
                            else if (!bUse || useTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效使用日期");
                            }
                            else if (!bProduct || productTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效生产日期");
                            }

                            var epcList = JsonConvert.DeserializeObject<List<string>>(epcListJson).Select(x => x.ToUpper()).ToList();

                            using (var scope = _unitOfWork.BeginTransaction())
                            {
                                //重装箱物资不做新增处理
                                if (isReloadBoxing)
                                {
                                    var boxMark = _unitOfWork.EquipmentBoxMarkRepository.Get(x => x.Epc == boxMarkEpc);
                                    if (boxMark == null)
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse($"无效箱标");
                                    }
                                    else if (boxMark.ReloadBoxingState != 1)
                                    {
                                        //检查是否重复打印
                                        var oldEpcList =
                                            _unitOfWork.EquipmentInventoryRepository.GetList(x =>
                                                x.BoxMarkId == boxMark.Id).Select(x => x.Epc).ToList();

                                        if (oldEpcList.Except(epcList).Any() || epcList.Except(oldEpcList).Any())
                                        {
                                            //有异常数据，提示
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse($"箱标已打印，但物资不匹配");
                                        }
                                        else
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse($"箱标重复打印,清除任务", "10000");
                                        }
                                    }

                                    boxMark.ReloadBoxingState = 2;

                                    if (_unitOfWork.EquipmentBoxMarkRepository.Update(boxMark))
                                    {
                                        //上报更新物资
                                        var httpResult = _httpHelper.GetHtml(new HttpItem()
                                        {
                                            URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                            Encoding = Encoding.UTF8,
                                            Method = "POST",
                                            ContentType = "application/json",
                                            Timeout = 5000,
                                            Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                            {
                                                xbdata = new List<object>()
                                                        {
                                                            new
                                                            {
                                                                editType="UPDATE",
                                                                id = boxMark.Id,
                                                                reloadBoxingState=boxMark.ReloadBoxingState,
                                                            }
                                                        }
                                            }))
                                        });
                                        if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("远端上报数据失败");
                                        }
                                        var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                        if (obj.code != "10000")
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse(obj.msg);
                                        }
                                        scope.Commit();
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse("数据写入失败");
                                    }
                                }


                                if (_unitOfWork.DbContext.CommonJpEquipmentInventories
                                    .Select(x => x.Epc.ToUpper())
                                    .Any(x => epcList.Any(y => y == x))
                                    )
                                {
                                    scope.Rollback();
                                    return JsonManager.SimpleCustResponse($"生成库存失败，库存内已存在此EPC");
                                }
                                else
                                {
                                    var boxMark = new CommonJpEquipmentBoxMark()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        CreateTime = DateTime.Now,
                                        Epc = boxMarkEpc,
                                        OneBoxNum = epcList.Count,
                                        EquipmentDetailId = equId,
                                        SizeId = sizeId,
                                        SupplierId = supplierId,
                                        CurrentState = 0,
                                        WarehouseId = warehouseId,
                                        ReloadBoxingState = 0,

                                    };
                                    _unitOfWork.EquipmentBoxMarkRepository.Insert(boxMark, false);

                                    var inventoryList = new List<CommonJpEquipmentInventory>();
                                    foreach (var epc in epcList)
                                    {
                                        var inv = new CommonJpEquipmentInventory
                                        {
                                            Id = Guid.NewGuid().ToString(),
                                            Epc = epc,
                                            SupplierCode = supplierId,
                                            EquipmentCode = equId,
                                            WarehouseCode = warehouseId,
                                            EquipmentLocation = 0,
                                            CurrentState = 0,
                                            CreateTime = DateTime.Now,
                                            CreateUser = "internal",
                                            EquipmentSizecode = sizeId,
                                            UpdateUser = "internal",
                                            Price = price,
                                            ProductTime = productTime,
                                            UseTime = useTime,
                                            UseDirection = 0,
                                            WarrantyCycle = warrantyCycle,
                                            RepairCycle = repairCycle,
                                            IsBorrowed = false,
                                            IsInBox = true,
                                            BoxMarkId = boxMark.Id,
                                            InstantiationState = 1,
                                        };
                                        if (!string.IsNullOrEmpty(shelfId))
                                        {
                                            inv.ShelfId = shelfId;
                                            inv.ShelfRange = shelfRange == 0 ? (int?)null : shelfRange;
                                            inv.ShelfRow = shelfRow == 0 ? (int?)null : shelfRow;
                                            inv.ShelfColumn = shelfColumn == 0 ? (int?)null : shelfColumn;
                                        }
                                        inventoryList.Add(inv);
                                    }
                                    var res = _unitOfWork.EquipmentInventoryRepository.Insert(inventoryList, true);

                                    if (res)
                                    {
                                        //上报新增数据
                                        var httpResult = _httpHelper.GetHtml(new HttpItem()
                                        {
                                            URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                            Encoding = Encoding.UTF8,
                                            Method = "POST",
                                            ContentType = "application/json",
                                            Timeout = 5000,
                                            Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                            {
                                                data = inventoryList.Select(x => new
                                                {
                                                    editType = "ADD",
                                                    id = x.Id,
                                                    supplierCode = x.SupplierCode,
                                                    epc = x.Epc,
                                                    policeCode = x.PoliceCode,
                                                    equipmentCode = x.EquipmentCode,
                                                    warehouseCode = x.WarehouseCode,
                                                    cabinetId = x.CabinetId,
                                                    equipmentSizecode = x.EquipmentSizecode,
                                                    equipmentLocation = x.EquipmentLocation,
                                                    currentState = x.CurrentState,
                                                    createTime = x.CreateTime,
                                                    warrantyCycle = x.WarrantyCycle,
                                                    repairCycle = x.RepairCycle,
                                                    productTime = x.ProductTime,
                                                    useTime = x.UseTime,
                                                    price = x.Price,
                                                    isBorrowed = x.IsBorrowed,
                                                    lostFlag = x.LostFlag,
                                                    inventoryState = x.InventoryState,
                                                    isInBox = x.IsInBox,
                                                    boxMarkId = x.BoxMarkId,
                                                    instantiationState = x.InstantiationState,
                                                }),
                                                xbdata = new List<object>()
                                                        {
                                                            new
                                                            {
                                                                editType="ADD",
                                                                id = boxMark.Id,
                                                                createTime = boxMark.CreateTime,
                                                                epc = boxMark.Epc,
                                                                oneBoxNum = boxMark.OneBoxNum,
                                                                equipmentDetailId = boxMark.EquipmentDetailId,
                                                                sizeId = boxMark.SizeId,
                                                                supplierId = boxMark.SupplierId,
                                                                currentState = boxMark.CurrentState,
                                                                warehouseId = boxMark.WarehouseId,
                                                                reloadBoxingState=boxMark.ReloadBoxingState,
                                                            }
                                                        }
                                            }))
                                        });
                                        if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("远端上报数据失败");
                                        }
                                        var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                        if (obj.code != "10000")
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse(obj.msg);
                                        }
                                        scope.Commit();
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleCustResponse("数据写入失败");
                                    }
                                }
                            }

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 装箱操作(内部版，箱标限定）
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("BoxingInventory")]
        public async Task<HttpResponseMessage> BoxingInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string boxMarkEpc = entity.boxMarkEpc ?? "";

                            if (string.IsNullOrEmpty(boxMarkEpc))
                            {
                                return JsonManager.SimpleCustResponse($"无效箱标");
                            }
                            var old = _unitOfWork.EquipmentBoxMarkRepository.Get(x => x.Epc == boxMarkEpc);
                            if (old != null)
                            {
                                return JsonManager.SimpleCustResponse($"箱标EPC已存在");
                            }

                            var list = new List<dynamic>(entity.invList);
                            int oneBoxNum = list.Count;
                            if (oneBoxNum == 0)
                            {
                                return JsonManager.SimpleCustResponse($"invList is require");
                            }

                            var first = list.FirstOrDefault();
                            string boxSizeId = first?.sizeId ?? "";
                            string boxEquId = first?.equId ?? "";
                            string boxSupplierId = first?.supplierId ?? "";
                            string boxWarehouseId = first?.warehouseId ?? "";

                            using (var scope = _unitOfWork.BeginTransaction())
                            {
                                try
                                {
                                    var boxMark = new CommonJpEquipmentBoxMark()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        CreateTime = DateTime.Now,
                                        Epc = boxMarkEpc,
                                        OneBoxNum = oneBoxNum,
                                        EquipmentDetailId = boxEquId,
                                        SizeId = boxSizeId,
                                        SupplierId = boxSupplierId,
                                        CurrentState = 0,
                                        WarehouseId = boxWarehouseId,
                                        ReloadBoxingState = 1
                                    };
                                    _unitOfWork.EquipmentBoxMarkRepository.Insert(boxMark, false);

                                    var addList = new List<CommonJpEquipmentInventory>();
                                    var updateList = new List<CommonJpEquipmentInventory>();
                                    foreach (var invInfo in entity.invList)
                                    {
                                        if (bool.TryParse(invInfo.isUnboxingLabel, out bool isUnboxingLabel) && isUnboxingLabel)
                                        {
                                            //拆箱生成标签
                                            string epc = invInfo.epc;
                                            var inventory = _unitOfWork.EquipmentInventoryRepository.Get(x => x.Epc == epc);
                                            if (inventory == null)
                                            {
                                                return JsonManager.SimpleCustResponse($"无效拆箱标签");
                                            }
                                            inventory.BoxMarkId = boxMark.Id;
                                            updateList.Add(inventory);
                                        }
                                        else
                                        {
                                            #region 创建新物资
                                            try
                                            {
                                                string sizeId = invInfo.sizeId ?? "";
                                                string equId = invInfo.equId ?? "";
                                                string epc = invInfo.epc ?? "";
                                                string supplierId = invInfo.supplierId ?? "";
                                                string warehouseId = invInfo.warehouseId ?? "";

                                                bool bProduct = DateTime.TryParse(invInfo.productTime ?? "", out DateTime productTime);
                                                bool bWarranty = int.TryParse(invInfo.warrantyCycle ?? "0", out int warrantyCycle);
                                                bool bPrice = decimal.TryParse(invInfo.price ?? "0", out decimal price);
                                                bool bUse = DateTime.TryParse(invInfo.useTime ?? "", out DateTime useTime);
                                                bool bRepair = int.TryParse(invInfo.repairCycle ?? "0", out int repairCycle);

                                                string shelfId = invInfo?.shelfId ?? "";
                                                bool bShelfRange = int.TryParse(invInfo.shelfRange ?? "0", out int shelfRange);
                                                bool bShelfRow = int.TryParse(invInfo?.shelfRow ?? "0", out int shelfRow);
                                                bool bShelfColumn = int.TryParse(invInfo?.shelfColumn ?? "0", out int shelfColumn);

                                                if (string.IsNullOrEmpty(sizeId))
                                                {
                                                    return JsonManager.SimpleCustResponse($"无效号型");
                                                }
                                                else if (string.IsNullOrEmpty(equId))
                                                {
                                                    return JsonManager.SimpleCustResponse($"无效装备");
                                                }
                                                else if (string.IsNullOrEmpty(epc))
                                                {
                                                    return JsonManager.SimpleCustResponse($"无效EPC");
                                                }
                                                else if (!CheckEpc(epc, equId))
                                                {
                                                    return JsonManager.SimpleCustResponse($"EPC与装备不匹配");
                                                }
                                                else if (string.IsNullOrEmpty(supplierId))
                                                {
                                                    return JsonManager.SimpleCustResponse($"无效供应商");
                                                }
                                                else if (string.IsNullOrEmpty(warehouseId))
                                                {
                                                    return JsonManager.SimpleCustResponse($"无效仓库");
                                                }
                                                else if (!bRepair || repairCycle <= 0)
                                                {
                                                    return JsonManager.SimpleCustResponse($"无效的装维保周期");
                                                }
                                                else if (!bPrice || price <= 0)
                                                {
                                                    return JsonManager.SimpleCustResponse($"无效的购入单价");
                                                }
                                                else if (!bWarranty || warrantyCycle < 0)   //质保周期可以为0
                                                {
                                                    return JsonManager.SimpleCustResponse($"无效的质保周期");

                                                }
                                                else if (!bUse || useTime == default)
                                                {
                                                    return JsonManager.SimpleCustResponse($"无效使用日期");
                                                }
                                                else if (!bProduct || productTime == default)
                                                {
                                                    return JsonManager.SimpleCustResponse($"无效生产日期");
                                                }
                                                else if (_unitOfWork.EquipmentInventoryRepository.Any(t => t.Epc.ToUpper() == epc.ToUpper()))
                                                {
                                                    return JsonManager.SimpleCustResponse($"生成库存失败，库存内已存在此EPC");
                                                }
                                                else
                                                {
                                                    var ent = new CommonJpEquipmentInventory
                                                    {
                                                        Id = Guid.NewGuid().ToString(),
                                                        Epc = epc,
                                                        SupplierCode = supplierId,
                                                        EquipmentCode = equId,
                                                        WarehouseCode = warehouseId,
                                                        EquipmentLocation = 0,
                                                        CurrentState = 0,
                                                        CreateTime = DateTime.Now,
                                                        CreateUser = "internal",
                                                        EquipmentSizecode = sizeId,
                                                        UpdateUser = "internal",
                                                        Price = price,
                                                        ProductTime = productTime,
                                                        UseTime = useTime,
                                                        UseDirection = 0,
                                                        WarrantyCycle = warrantyCycle,
                                                        RepairCycle = repairCycle,
                                                        IsBorrowed = false,
                                                        InstantiationState = 1,
                                                        BoxMarkId = boxMark.Id,
                                                        IsInBox = true
                                                    };
                                                    if (!string.IsNullOrEmpty(shelfId))
                                                    {
                                                        ent.ShelfId = shelfId;
                                                        ent.ShelfRange = shelfRange == 0 ? (int?)null : shelfRange;
                                                        ent.ShelfRow = shelfRow == 0 ? (int?)null : shelfRow;
                                                        ent.ShelfColumn = shelfColumn == 0 ? (int?)null : shelfColumn;
                                                    }
                                                    addList.Add(ent);
                                                }
                                            }
                                            catch (Exception ex)
                                            {
                                                _logger.LogError(ex.ToString());
                                                if (ex.Message == "CRC校验失败")
                                                {
                                                    return JsonManager.SimpleCustResponse($"EPC CRC校验失败");
                                                }
                                                return JsonManager.SimpleCustResponse("物资创建异常");
                                            }

                                            #endregion
                                        }
                                    }

                                    _unitOfWork.EquipmentInventoryRepository.Insert(addList, false);
                                    _unitOfWork.EquipmentInventoryRepository.Update(updateList, false);

                                    var newInvList = _unitOfWork.DbContext.ChangeTracker.Entries()
                                        .Where(x => x.Entity is CommonJpEquipmentInventory)
                                        .Select(x => x.Entity as CommonJpEquipmentInventory)
                                        .ToList();

                                    if (newInvList.Any(x => !string.IsNullOrEmpty(x.ShelfId)))
                                    {
                                        //全体覆盖货架位置
                                        var inv = newInvList.OrderBy(x => x.CreateTime).First(x => !string.IsNullOrEmpty(x.ShelfId));
                                        foreach (var inventory in newInvList)
                                        {
                                            inventory.ShelfId = inv.ShelfId;
                                            inventory.ShelfRange = inv.ShelfRange;
                                            inventory.ShelfRow = inv.ShelfRow;
                                            inventory.ShelfColumn = inv.ShelfColumn;
                                        }
                                    }

                                    if (_unitOfWork.SaveChanges() > 0)
                                    {
                                        //上报数据

                                        var pushData = new
                                        {
                                            data = new List<object>(),
                                            xbdata = new List<object>()
                                            {
                                                new
                                                {
                                                    editType = "ADD",
                                                    id = boxMark.Id,
                                                    createTime = boxMark.CreateTime,
                                                    epc = boxMark.Epc,
                                                    oneBoxNum = boxMark.OneBoxNum,
                                                    equipmentDetailId = boxMark.EquipmentDetailId,
                                                    sizeId = boxMark.SizeId,
                                                    supplierId = boxMark.SupplierId,
                                                    currentState = boxMark.CurrentState,
                                                    warehouseId = boxMark.WarehouseId,
                                                    reloadBoxingState = boxMark.ReloadBoxingState,
                                                }
                                            }
                                        };
                                        pushData.data.AddRange(addList.Select(x => new
                                        {
                                            editType = "ADD",
                                            id = x.Id,
                                            supplierCode = x.SupplierCode,
                                            epc = x.Epc,
                                            policeCode = x.PoliceCode,
                                            equipmentCode = x.EquipmentCode,
                                            warehouseCode = x.WarehouseCode,
                                            cabinetId = x.CabinetId,
                                            equipmentSizecode = x.EquipmentSizecode,
                                            equipmentLocation = x.EquipmentLocation,
                                            currentState = x.CurrentState,
                                            createTime = x.CreateTime,
                                            warrantyCycle = x.WarrantyCycle,
                                            repairCycle = x.RepairCycle,
                                            productTime = x.ProductTime,
                                            useTime = x.UseTime,
                                            price = x.Price,
                                            isBorrowed = x.IsBorrowed,
                                            lostFlag = x.LostFlag,
                                            inventoryState = x.InventoryState,
                                            isInBox = x.IsInBox,
                                            boxMarkId = x.BoxMarkId,
                                            instantiationState = x.InstantiationState,
                                        }));
                                        pushData.data.AddRange(updateList.Select(x => new
                                        {
                                            editType = "UPDATE",
                                            id = x.Id,
                                            supplierCode = x.SupplierCode,
                                            epc = x.Epc,
                                            policeCode = x.PoliceCode,
                                            equipmentCode = x.EquipmentCode,
                                            warehouseCode = x.WarehouseCode,
                                            cabinetId = x.CabinetId,
                                            equipmentSizecode = x.EquipmentSizecode,
                                            equipmentLocation = x.EquipmentLocation,
                                            currentState = x.CurrentState,
                                            createTime = x.CreateTime,
                                            warrantyCycle = x.WarrantyCycle,
                                            repairCycle = x.RepairCycle,
                                            productTime = x.ProductTime,
                                            useTime = x.UseTime,
                                            price = x.Price,
                                            isBorrowed = x.IsBorrowed,
                                            lostFlag = x.LostFlag,
                                            inventoryState = x.InventoryState,
                                            isInBox = x.IsInBox,
                                            boxMarkId = x.BoxMarkId,
                                            instantiationState = x.InstantiationState,
                                        }));

                                        var httpResult = _httpHelper.GetHtml(new HttpItem()
                                        {
                                            URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                            Encoding = Encoding.UTF8,
                                            Method = "POST",
                                            ContentType = "application/json",
                                            Timeout = 5000,
                                            Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(pushData))
                                        });
                                        if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("远端上报数据失败");
                                        }
                                        var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                        if (obj.code != "10000")
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse(obj.msg);
                                        }
                                        scope.Commit();
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                    }
                                }
                                catch (Exception e)
                                {
                                    scope.Rollback();
                                    throw;
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 装箱操作(用户版，箱标限定）
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("BoxingInventoryNormalVersion")]
        public async Task<HttpResponseMessage> BoxingInventoryNormalVersion([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string boxMarkEpc = entity.boxMarkEpc ?? "";

                            if (string.IsNullOrEmpty(boxMarkEpc))
                            {
                                return JsonManager.SimpleCustResponse($"无效箱标");
                            }
                            var old = _unitOfWork.EquipmentBoxMarkRepository.Get(x => x.Epc == boxMarkEpc);
                            if (old != null)
                            {
                                return JsonManager.SimpleCustResponse($"箱标EPC已存在");
                            }

                            string policeId = entity.policeId ?? "";
                            if (string.IsNullOrEmpty(policeId))
                            {
                                return JsonManager.SimpleCustResponse($"policeId is require");
                            }

                            var list = new List<dynamic>(entity.invList);
                            int oneBoxNum = list.Count;
                            if (oneBoxNum == 0)
                            {
                                return JsonManager.SimpleCustResponse($"invList is require");
                            }

                            var first = list.FirstOrDefault();
                            string boxSizeId = first?.sizeId ?? "";
                            string boxEquId = first?.equId ?? "";
                            string boxSupplierId = first?.supplierId ?? "";
                            string boxWarehouseId = first?.warehouseId ?? "";

                            using (var scope = _unitOfWork.BeginTransaction())
                            {
                                try
                                {
                                    var boxMark = new CommonJpEquipmentBoxMark()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        CreateTime = DateTime.Now,
                                        Epc = boxMarkEpc,
                                        OneBoxNum = oneBoxNum,
                                        EquipmentDetailId = boxEquId,
                                        SizeId = boxSizeId,
                                        SupplierId = boxSupplierId,
                                        CurrentState = 0,
                                        WarehouseId = boxWarehouseId,
                                        ReloadBoxingState = 1
                                    };
                                    _unitOfWork.EquipmentBoxMarkRepository.Insert(boxMark, false);

                                    var purchaseEpcList = new List<CommonJpPurchaseEpc>();
                                    var addList = new List<CommonJpEquipmentInventory>();
                                    var updateList = new List<CommonJpEquipmentInventory>();

                                    foreach (var invInfo in entity.invList)
                                    {
                                        if (bool.TryParse(invInfo.isUnboxingLabel, out bool isUnboxingLabel) && isUnboxingLabel)
                                        {
                                            //拆箱生成标签
                                            string epc = invInfo.epc;
                                            var inventory = _unitOfWork.EquipmentInventoryRepository.Get(x => x.Epc == epc);
                                            if (inventory == null)
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse($"无效拆箱标签");
                                            }
                                            inventory.IsInBox = true;
                                            inventory.BoxMarkId = boxMark.Id;
                                            updateList.Add(inventory);
                                        }
                                        else
                                        {

                                            string epc = invInfo.epc ?? "";
                                            var epcData = _unitOfWork.DbContext.CommonJpPurchaseEpcs
                                                .Include(x => x.Detail)
                                                .Include(x => x.Detail.Order)
                                                .Include(x => x.Detail.Order.Org)
                                                .Include(x => x.Detail.Size)
                                                .Include(x => x.Detail.Order.Warehouse)
                                                .FirstOrDefault(t => t.Epc == epc && t.CurrentState == 0);

                                            if (epcData == null)
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse($"无效打印标签");
                                            }
                                            purchaseEpcList.Add(epcData);
                                        }
                                    }


                                    //统一处理采购epc
                                    if (purchaseEpcList.Count > 0)
                                    {
                                        foreach (var group in purchaseEpcList.GroupBy(x => x.DetailId))
                                        {

                                            var detailObj = _unitOfWork.DbContext.CommonJpPurchaseDetails
                                                .Include(x => x.Order)
                                                .Include(x => x.CommonJpPurchaseEpcs)
                                                .FirstOrDefault(x => x.Id == group.Key);
                                            int purchaseCount = detailObj.RealCount ?? 0;
                                            foreach (var epcObj in group)
                                            {
                                                //创建物资
                                                List<CommonJpEquipmentState> state = new List<CommonJpEquipmentState>();
                                                state.Add(new CommonJpEquipmentState
                                                {
                                                    Id = Guid.NewGuid().ToString(),
                                                    PicUrl = "",
                                                    PurchaseId = epcObj.DetailId,
                                                    EqiupmentId = epcObj.Detail?.EquipmentId,
                                                    OutInState = 1,
                                                    State = 5,
                                                    OrderCode = epcObj.Detail?.Order?.OrderCode,
                                                    IntoTime = DateTime.Now,
                                                    PoliceId = policeId,
                                                    CreateTime = DateTime.Now,
                                                    ActionState = 1,
                                                    WarehouseId = epcObj.Detail?.Order?.WarehouseId,
                                                    OrgId = epcObj.Detail?.Order?.OrgId,
                                                });
                                                _unitOfWork.EquipmentInventoryRepository.Insert(new CommonJpEquipmentInventory
                                                {
                                                    Id = Guid.NewGuid().ToString(),
                                                    Epc = epcObj.Epc,
                                                    SupplierCode = epcObj.SupplierId,
                                                    EquipmentCode = epcObj.Detail?.EquipmentId,
                                                    WarehouseCode = epcObj.Detail?.Order?.WarehouseId,
                                                    EquipmentLocation = 0,
                                                    CurrentState = 0,
                                                    CreateTime = DateTime.Now,
                                                    CreateUser = policeId,
                                                    EquipmentSizecode = epcObj.Detail?.SizeId,
                                                    UpdateUser = policeId,
                                                    CommonJpEquipmentStates = state,
                                                    Price = epcObj.Price,
                                                    ProductTime = epcObj.ProductTime,
                                                    UseTime = epcObj.UseTime,
                                                    UseDirection = epcObj.UseDirection,
                                                    WarrantyCycle = epcObj.WarrantyCycle,
                                                    RepairCycle = epcObj.RepairCycle,
                                                    BoxMarkId = boxMark.Id,
                                                    IsInBox = true,
                                                    InstantiationState = 1,
                                                    ShelfId = epcObj.ShelfId,
                                                    ShelfRange = epcObj.ShelfRange,
                                                    ShelfRow = epcObj.ShelfRow,
                                                    ShelfColumn = epcObj.ShelfColumn,
                                                }, false);
                                                epcObj.CurrentState = 2;
                                                purchaseCount++;
                                            }
                                            detailObj.RealCount = purchaseCount;
                                            if (detailObj.CommonJpPurchaseEpcs.All(p => p.CurrentState == 2) && detailObj.State != 1)
                                            {
                                                //子单据完成
                                                detailObj.State = 1;
                                                if (detailObj.Order.CommonJpPurchaseDetails.Count(p => p.State.Equals(0) || p.State == null) <= 0)
                                                {
                                                    //总单据完成
                                                    detailObj.Order.CurrentState = 1;
                                                }
                                            }
                                            _unitOfWork.PurchaseDetailRepository.Update(detailObj, false);
                                        }
                                    }

                                    addList = _unitOfWork.DbContext.ChangeTracker.Entries()
                                        .Where(x => x.State == EntityState.Added && x.Entity is CommonJpEquipmentInventory)
                                        .Select(x => x.Entity as CommonJpEquipmentInventory)
                                        .ToList();
                                    var newInvList = _unitOfWork.DbContext.ChangeTracker.Entries()
                                        .Where(x => x.Entity is CommonJpEquipmentInventory)
                                        .Select(x => x.Entity as CommonJpEquipmentInventory)
                                        .ToList();

                                    if (newInvList.Any(x => !string.IsNullOrEmpty(x.ShelfId)))
                                    {
                                        //全体覆盖货架位置
                                        var inv = newInvList.OrderBy(x => x.CreateTime).First(x => !string.IsNullOrEmpty(x.ShelfId));
                                        foreach (var inventory in newInvList)
                                        {
                                            inventory.ShelfId = inv.ShelfId;
                                            inventory.ShelfRange = inv.ShelfRange;
                                            inventory.ShelfRow = inv.ShelfRow;
                                            inventory.ShelfColumn = inv.ShelfColumn;
                                        }
                                    }

                                    if (_unitOfWork.SaveChanges() > 0)
                                    {
                                        //上报数据
                                        var pushData = new
                                        {
                                            data = new List<object>(),
                                            xbdata = new List<object>()
                                            {
                                                new
                                                {
                                                    editType = "ADD",
                                                    id = boxMark.Id,
                                                    createTime = boxMark.CreateTime,
                                                    epc = boxMark.Epc,
                                                    oneBoxNum = boxMark.OneBoxNum,
                                                    equipmentDetailId = boxMark.EquipmentDetailId,
                                                    sizeId = boxMark.SizeId,
                                                    supplierId = boxMark.SupplierId,
                                                    currentState = boxMark.CurrentState,
                                                    warehouseId = boxMark.WarehouseId,
                                                    reloadBoxingState = boxMark.ReloadBoxingState,
                                                }
                                            }
                                        };
                                        pushData.data.AddRange(addList.Select(x => new
                                        {
                                            editType = "ADD",
                                            id = x.Id,
                                            supplierCode = x.SupplierCode,
                                            epc = x.Epc,
                                            policeCode = x.PoliceCode,
                                            equipmentCode = x.EquipmentCode,
                                            warehouseCode = x.WarehouseCode,
                                            cabinetId = x.CabinetId,
                                            equipmentSizecode = x.EquipmentSizecode,
                                            equipmentLocation = x.EquipmentLocation,
                                            currentState = x.CurrentState,
                                            createTime = x.CreateTime,
                                            warrantyCycle = x.WarrantyCycle,
                                            repairCycle = x.RepairCycle,
                                            productTime = x.ProductTime,
                                            useTime = x.UseTime,
                                            price = x.Price,
                                            isBorrowed = x.IsBorrowed,
                                            lostFlag = x.LostFlag,
                                            inventoryState = x.InventoryState,
                                            isInBox = x.IsInBox,
                                            boxMarkId = x.BoxMarkId,
                                            instantiationState = x.InstantiationState,
                                        }));
                                        pushData.data.AddRange(updateList.Select(x => new
                                        {
                                            editType = "UPDATE",
                                            id = x.Id,
                                            supplierCode = x.SupplierCode,
                                            epc = x.Epc,
                                            policeCode = x.PoliceCode,
                                            equipmentCode = x.EquipmentCode,
                                            warehouseCode = x.WarehouseCode,
                                            cabinetId = x.CabinetId,
                                            equipmentSizecode = x.EquipmentSizecode,
                                            equipmentLocation = x.EquipmentLocation,
                                            currentState = x.CurrentState,
                                            createTime = x.CreateTime,
                                            warrantyCycle = x.WarrantyCycle,
                                            repairCycle = x.RepairCycle,
                                            productTime = x.ProductTime,
                                            useTime = x.UseTime,
                                            price = x.Price,
                                            isBorrowed = x.IsBorrowed,
                                            lostFlag = x.LostFlag,
                                            inventoryState = x.InventoryState,
                                            isInBox = x.IsInBox,
                                            boxMarkId = x.BoxMarkId,
                                            instantiationState = x.InstantiationState,
                                        }));

                                        var httpResult = _httpHelper.GetHtml(new HttpItem()
                                        {
                                            URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                            Encoding = Encoding.UTF8,
                                            Method = "POST",
                                            ContentType = "application/json",
                                            Timeout = 5000,
                                            Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(pushData))
                                        });
                                        if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("远端上报数据失败");
                                        }
                                        var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                        if (obj.code != "10000")
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse(obj.msg);
                                        }
                                        scope.Commit();
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                    }
                                }
                                catch (Exception e)
                                {
                                    scope.Rollback();
                                    throw;
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 拆箱还原epc inbox状态(多个epc,箱标限定）
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UnpackRangeInventory")]
        public async Task<HttpResponseMessage> UnpackRangeInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string epc = entity?.epc ?? "";

                            if (string.IsNullOrEmpty(epc))
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }
                            var boxMark = _unitOfWork.EquipmentBoxMarkRepository.Get(x => x.Epc == epc);
                            if (boxMark == null)
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }

                            var dataList =
                                _unitOfWork.DbContext.CommonJpEquipmentInventories
                                    .Include(x => x.BoxMark)
                                    .Where(x => x.BoxMark.Epc == epc)
                                    .ToList();

                            if (dataList.Count == 0)
                            {
                                return JsonManager.SimpleCustResponse($"无对应物资，更新失败");
                            }
                            else
                            {
                                if (dataList.Count(x => x.CurrentState != 0) > 0)
                                {
                                    return JsonManager.SimpleCustResponse($"物资状态不是在库，更新失败");
                                }

                                foreach (var inventory in dataList)
                                {
                                    inventory.IsInBox = false;
                                    inventory.BoxMarkId = null;
                                }

                                using (var scope = _unitOfWork.BeginTransaction())
                                {
                                    try
                                    {
                                        _unitOfWork.EquipmentInventoryRepository.Update(dataList, false);

                                        var res = _unitOfWork.EquipmentBoxMarkRepository.Delete(boxMark, true);
                                        if (res)
                                        {
                                            //上报数据
                                            var pushData = new
                                            {
                                                data = dataList.Select(x => new
                                                {
                                                    editType = "UPDATE",
                                                    id = x.Id,
                                                    supplierCode = x.SupplierCode,
                                                    epc = x.Epc,
                                                    policeCode = x.PoliceCode,
                                                    equipmentCode = x.EquipmentCode,
                                                    warehouseCode = x.WarehouseCode,
                                                    cabinetId = x.CabinetId,
                                                    equipmentSizecode = x.EquipmentSizecode,
                                                    equipmentLocation = x.EquipmentLocation,
                                                    currentState = x.CurrentState,
                                                    createTime = x.CreateTime,
                                                    warrantyCycle = x.WarrantyCycle,
                                                    repairCycle = x.RepairCycle,
                                                    productTime = x.ProductTime,
                                                    useTime = x.UseTime,
                                                    price = x.Price,
                                                    isBorrowed = x.IsBorrowed,
                                                    lostFlag = x.LostFlag,
                                                    inventoryState = x.InventoryState,
                                                    isInBox = x.IsInBox,
                                                    boxMarkId = x.BoxMarkId,
                                                    instantiationState = x.InstantiationState,
                                                }),
                                                xbdata = new List<object>()
                                                {
                                                    new
                                                    {
                                                        editType = "DELETE",
                                                        id = boxMark.Id,
                                                    }
                                                }
                                            };

                                            var httpResult = _httpHelper.GetHtml(new HttpItem()
                                            {
                                                URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                                Encoding = Encoding.UTF8,
                                                Method = "POST",
                                                ContentType = "application/json",
                                                Timeout = 5000,
                                                Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(pushData))
                                            });
                                            if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse("远端上报数据失败");
                                            }
                                            var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                            if (obj.code != "10000")
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse(obj.msg);
                                            }
                                            scope.Commit();
                                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                        }
                                        else
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("数据写入失败");
                                        }
                                    }
                                    catch (Exception e)
                                    {
                                        scope.Rollback();
                                        throw;
                                    }
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 直接报废EPC
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteInventory")]
        public async Task<HttpResponseMessage> DeleteInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string epc = entity?.epc ?? "";
                            if (string.IsNullOrEmpty(epc))
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }
                            else
                            {
                                var _epc_info = _unitOfWork.DbContext.CommonJpEquipmentInventories
                                    .Include(t => t.CommonJpEquipmentStates)
                                    .FirstOrDefault(t => t.Epc == epc);
                                if (_epc_info == null)
                                {
                                    return JsonManager.SimpleCustResponse($"无效EPC");
                                }
                                else if (_epc_info.CommonJpEquipmentStates.Count > 0)
                                {
                                    return JsonManager.SimpleCustResponse($"存在出入库记录，无法删除");
                                }
                                else
                                {
                                    using (var scope = _unitOfWork.BeginTransaction())
                                    {
                                        try
                                        {
                                            var res = _unitOfWork.EquipmentInventoryRepository.Delete(_epc_info);
                                            if (res)
                                            {
                                                //上报数据
                                                var httpResult = _httpHelper.GetHtml(new HttpItem()
                                                {
                                                    URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                                    Encoding = Encoding.UTF8,
                                                    Method = "POST",
                                                    ContentType = "application/json",
                                                    Timeout = 5000,
                                                    Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                                    {
                                                        data = new List<object>()
                                                        {
                                                            new
                                                            {
                                                                editType = "DELETE",
                                                                id = _epc_info.Id,
                                                            }
                                                        }
                                                    }))
                                                });
                                                if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                                {
                                                    scope.Rollback();
                                                    return JsonManager.SimpleCustResponse("远端上报数据失败");
                                                }
                                                var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                                if (obj.code != "10000")
                                                {
                                                    scope.Rollback();
                                                    return JsonManager.SimpleCustResponse(obj.msg);
                                                }
                                                scope.Commit();
                                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                            }
                                            else
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse("数据更新失败");
                                            }
                                        }
                                        catch (Exception e)
                                        {
                                            scope.Rollback();
                                            throw;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 直接报废箱标EPC（包括箱内物资）
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// {
        ///     "epc":"箱标epc"
        /// }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteInventoryByEpcList")]
        public async Task<HttpResponseMessage> DeleteInventoryByEpcList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string epc = entity.boxMarkEpc;
                            if (string.IsNullOrEmpty(epc))
                            {
                                return JsonManager.SimpleCustResponse($"EPC is require");
                            }

                            var boxMark = _unitOfWork.DbContext.CommonJpEquipmentBoxMarks
                                .Include(x => x.CommonJpEquipmentInventories)
                                .FirstOrDefault(x => x.Epc == epc);
                            if (boxMark == null)
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }

                            var epcInfoList = _unitOfWork.DbContext.CommonJpEquipmentInventories
                                .Include(t => t.CommonJpEquipmentStates)
                                .Where(t => boxMark.CommonJpEquipmentInventories.Select(x => x.Epc).Contains(t.Epc))
                                .ToList();
                            if (epcInfoList.Count == 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }

                            foreach (var inventory in epcInfoList)
                            {
                                if (inventory.CommonJpEquipmentStates.Count > 0)
                                {
                                    return JsonManager.SimpleCustResponse($"epc:{inventory.Epc}存在出入库记录，无法删除");
                                }
                            }

                            using (var scope = _unitOfWork.BeginTransaction())
                            {
                                try
                                {
                                    _unitOfWork.EquipmentInventoryRepository.Delete(epcInfoList, false);
                                    //删除对应箱标
                                    var res = _unitOfWork.EquipmentBoxMarkRepository.Delete(boxMark, true);
                                    if (res)
                                    {
                                        //上报数据
                                        var httpResult = _httpHelper.GetHtml(new HttpItem()
                                        {
                                            URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                            Encoding = Encoding.UTF8,
                                            Method = "POST",
                                            ContentType = "application/json",
                                            Timeout = 5000,
                                            Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                            {
                                                data = epcInfoList.Select(x => new
                                                {
                                                    editType = "DELETE",
                                                    id = x.Id
                                                }),
                                                xbdata = new List<object>()
                                                {
                                                    new
                                                    {
                                                        editType = "DELETE",
                                                        id = boxMark.Id,
                                                    }
                                                }
                                            }))
                                        });
                                        if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("远端上报数据失败");
                                        }
                                        var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                        if (obj.code != "10000")
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse(obj.msg);
                                        }
                                        scope.Commit();
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleCustResponse("数据更新失败");
                                    }
                                }
                                catch (Exception e)
                                {
                                    scope.Rollback();
                                    throw;
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 更新资产基础信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "资产ID",
        ///        "repairCycle":"维保周期-数字型",
        ///        "price":"购入单价-数字型",
        ///        "warrantyCycle" : "质保周期-数字型",
        ///        "useTime":"使用日期-时间类型",
        ///        "productTime": "生产日期-时间类型",
        ///         "shelfId":"货架id",
        ///         "range":"货架排位置",
        ///         "row":"货架行位置",
        ///         "column":"货架列位置",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("updateInventory")]
        public async Task<HttpResponseMessage> updateInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else
                        {
                            bool bProduct = DateTime.TryParse(entity?.productTime ?? "", out DateTime productTime);
                            bool bWarranty = int.TryParse(entity?.warrantyCycle ?? "0", out int warrantyCycle);
                            bool bPrice = decimal.TryParse(entity?.price ?? "0", out decimal price);
                            bool bUse = DateTime.TryParse(entity?.useTime ?? "", out DateTime useTime);
                            bool bRepair = int.TryParse(entity?.repairCycle ?? "0", out int repairCycle);

                            Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => t.Id.Equals(id);
                            CommonJpEquipmentInventory updateObject = _unitOfWork.EquipmentInventoryRepository.Get(expression);
                            if (updateObject != null)
                            {

                                if (!(!bRepair || repairCycle <= 0))
                                {
                                    updateObject.RepairCycle = repairCycle;//装维保周期
                                }
                                if (!(!bPrice || price <= 0))
                                {
                                    updateObject.Price = price;             //购入单价
                                }
                                if (!(!bWarranty || warrantyCycle < 0))
                                {
                                    updateObject.WarrantyCycle = warrantyCycle; //质保周期
                                }
                                if (!(!bUse || useTime == default))
                                {
                                    updateObject.UseTime = useTime;           //使用日期
                                }
                                if (!(!bProduct || productTime == default))
                                {
                                    updateObject.ProductTime = productTime;   //生产日期
                                }

                                //updateObject.Address = entity.address;        //位置
                                //只有在库的能编辑位置信息
                                if (!string.IsNullOrEmpty(entity.shelfId) && updateObject.CurrentState == 0)
                                {
                                    string shelfId = entity.shelfId;
                                    var shelf = _unitOfWork.BaseJpShelfInfoRepository.Get(shelfId);
                                    if (shelf == null)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }

                                    if (int.TryParse(entity.range, out int range))
                                    {
                                        if (range > shelf.Range)
                                        {
                                            return JsonManager.SimpleCustResponse("排超过货架限制");
                                        }
                                        updateObject.ShelfRange = range;
                                    }
                                    else
                                    {
                                        updateObject.ShelfRange = null;
                                    }
                                    if (int.TryParse(entity.row, out int row))
                                    {
                                        if (row > shelf.Row)
                                        {
                                            return JsonManager.SimpleCustResponse("行超过货架限制");
                                        }
                                        updateObject.ShelfRow = row;
                                    }
                                    else
                                    {
                                        updateObject.ShelfRow = null;
                                    }
                                    if (int.TryParse(entity.column, out int column))
                                    {
                                        if (column > shelf.Column)
                                        {
                                            return JsonManager.SimpleCustResponse("列超过货架限制");
                                        }
                                        updateObject.ShelfColumn = column;
                                    }
                                    else
                                    {
                                        updateObject.ShelfColumn = null;
                                    }
                                    updateObject.ShelfId = shelf.Id;
                                }
                                else
                                {
                                    updateObject.ShelfId = null;
                                    updateObject.ShelfRange = null;
                                    updateObject.ShelfColumn = null;
                                    updateObject.ShelfRow = null;
                                }
                                //updateObject.CreateTime = System.DateTime.Now;
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                            using (var scope = _unitOfWork.BeginTransaction())
                            {
                                try
                                {
                                    bool result = _unitOfWork.EquipmentInventoryRepository.Update(updateObject);
                                    if (result)
                                    {
                                        //上报数据
                                        var httpResult = _httpHelper.GetHtml(new HttpItem()
                                        {
                                            URL = _httpHelper._centerServerAddress + "/api/Print/EditInventory",
                                            Encoding = Encoding.UTF8,
                                            Method = "POST",
                                            ContentType = "application/json",
                                            Timeout = 5000,
                                            Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(new
                                            {
                                                data = new List<object>()
                                                {
                                                    new
                                                    {
                                                        editType = "UPDATE",
                                                        id = updateObject.Id,
                                                        supplierCode = updateObject.SupplierCode,
                                                        epc = updateObject.Epc,
                                                        policeCode = updateObject.PoliceCode,
                                                        equipmentCode = updateObject.EquipmentCode,
                                                        warehouseCode = updateObject.WarehouseCode,
                                                        cabinetId = updateObject.CabinetId,
                                                        equipmentSizecode = updateObject.EquipmentSizecode,
                                                        equipmentLocation = updateObject.EquipmentLocation,
                                                        currentState = updateObject.CurrentState,
                                                        createTime = updateObject.CreateTime,
                                                        warrantyCycle = updateObject.WarrantyCycle,
                                                        repairCycle = updateObject.RepairCycle,
                                                        productTime = updateObject.ProductTime,
                                                        useTime = updateObject.UseTime,
                                                        price = updateObject.Price,
                                                        isBorrowed = updateObject.IsBorrowed,
                                                        lostFlag = updateObject.LostFlag,
                                                        inventoryState = updateObject.InventoryState,
                                                        isInBox = updateObject.IsInBox,
                                                        boxMarkId = updateObject.BoxMarkId,
                                                        instantiationState = updateObject.InstantiationState,
                                                    }
                                                }
                                            }))
                                        });
                                        if (httpResult.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(httpResult.Html))
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("远端上报数据失败");
                                        }
                                        var obj = JsonConvert.DeserializeObject<JmpBaseResponse<object>>(httpResult.Html);
                                        if (obj.code != "10000")
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse(obj.msg);
                                        }
                                        scope.Commit();
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }
                                }
                                catch (Exception e)
                                {
                                    scope.Rollback();
                                    throw;
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 检查epc是否符合epc生成规则
        /// </summary>
        /// <param name="epc"></param>
        /// <param name="equId"></param>
        /// <returns></returns>
        private bool CheckEpc(string epc, string equId)
        {
            var param = new string[] {
                "Equipment",
                "BaseJpSupplierEquipments"
            };

            var equInfos = _unitOfWork.EquipmentDetailRepository.GetList(x => true, t => t.UpdateTime, false, param).ToList();

            if (epc.Length == 64)
            {
                var buffer = EpcConvert.ToHexByte(epc);
                var epc_info = EpcConvert.EpcAnlysing(buffer);
                if (epc_info != null)
                {
                    var equ_info = equInfos.FirstOrDefault(t => t.Code == epc_info.Wzdm.ToString("X"));
                    if (equ_info != null && equ_info.Id == equId)
                    {
                        return true;
                    }
                }
            }
            return false;
        }
    }
    public class EpcInfo
    {
        public string supplierName { get; set; }
        public DateTime useTime { get; set; }
        public DateTime productTime { get; set; }
        public int warrantyCycle { get; set; }
        public int repairCycle { get; set; }
        public decimal price { get; set; }
        public int num { get; set; }
        public string detailId { get; set; }
        public string supplierId { get; set; }
        public string epc { get; set; }
    }
}