﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net;
using System.Net.Http;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using JunmpPoliceStation.Extensions;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class PolicemanController : ControllerBase
    {
        private ILogger<PolicemanController> _logger;
        UnitOfWork _unitOfWork;
        HttpHelper _httpHelper;
        public List<BaseJpOrganization> ListEq = new List<BaseJpOrganization>();

        public PolicemanController(ILogger<PolicemanController> logger, UnitOfWork unitOfWork, HttpHelper httpHelper)
        {
            _logger = logger;
            _unitOfWork = unitOfWork;
            _httpHelper = httpHelper;
        }


        /// <summary>
        /// 获取人员列表，第三方
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "updateTime": "",更新时间
        ///         "orgId":"组织编号"
        ///         "level":"本级、本级及下级"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPolicemanDevelop")]
        //[NoSign]
        public async Task<HttpResponseMessage> GetPolicemanDevelop([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.orgId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationCode = entity.orgId;
                        string updateTime = entity.updateTime;

                        if (string.IsNullOrEmpty(updateTime))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        Expression<Func<BaseJpPoliceman, bool>> expressionPoliceman = null;


                        List<BaseJpOrganization> dataList = null;

                        dataList = GetClassID(orgizationCode);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationCode))).ToList();

                        List<string> IdList = dataList.Select(c => c.Id).ToList();

                        if (!String.IsNullOrEmpty(entity.level))
                        {
                            if (entity.level == "本级")
                            {
                                expressionPoliceman = t => t.OrgizationCode.Equals(orgizationCode);
                            }
                            else
                            {
                                expressionPoliceman = t => IdList.Contains(t.OrgizationCode);
                            }
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        expressionPoliceman = expressionPoliceman.AndAlso(t => t.UpdateTime >= DateTime.Parse(updateTime));



                        var param = new string[] {
                       "Cabinet" ,
                       "OrgizationCodeNavigation"
                    };

                        PageData<BaseJpPoliceman> pagedata = _unitOfWork.PolicemanRepository.GetPage(expressionPoliceman, "-UpdateTime", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.Id,
                            c.Sort,
                            c.Name,
                            c.CabinetId,
                            c.OrgizationCode,
                            c.PoliceCode,
                            c.Sex,
                            c.FingerInfo1,
                            c.FingerInfo2,
                            c.FaceInfo,
                            c.Photo,
                            c.Phone,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            c.Cabinet?.CabinetNum,
                            c.Cabinet?.CabinetChildNum,
                            OrgizationName = c.OrgizationCodeNavigation?.Name,
                            c.OrgizationCodeNavigation?.Code
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 通过orgid获取人员列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织编号"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPolicemanByOrgId")]
        //[NoSign]
        public async Task<HttpResponseMessage> GetPolicemanByOrgId([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        string orgizationCode = entity.orgId;



                        var param = new string[]
                        {
                            "Cabinet",
                            "OrgizationCodeNavigation",
                            "CommonJpUsers"
                        };

                        var pagedata = _unitOfWork.PolicemanRepository.GetList(x => x.OrgizationCode == orgizationCode, x => x.CreateTime, false, param);

                        var data = pagedata.ToList().Select(c => new
                        {
                            c.Id,
                            c.Sort,
                            c.Name,
                            c.CabinetId,
                            c.OrgizationCode,
                            c.PoliceCode,
                            c.Sex,
                            c.FingerInfo1,
                            c.FingerInfo2,
                            c.FaceInfo,
                            c.Photo,
                            c.Phone,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            c.Cabinet?.CabinetNum,
                            c.Cabinet?.CabinetChildNum,
                            OrgizationName = c.OrgizationCodeNavigation?.Name,
                            c.OrgizationCodeNavigation?.Code,
                            UserId = c.CommonJpUsers?.FirstOrDefault()?.Id,
                            c.CardNo
                        }
                        ).ToList();

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 获取人员分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "phone": "10",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPolicemanByPhone")]
        public async Task<HttpResponseMessage> GetPolicemanByPhone([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        string phone = entity.phone;

                        if (string.IsNullOrEmpty(phone))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        var param = new string[] {
                       "UsersRoles",
                       "Organization"
                        };



                        var policeInfo = _unitOfWork.CommonJpUserRepository.GetList(t => t.Phone.Equals(phone), null, false, param);

                        var data = policeInfo.Select(c => new
                        {
                            c.Id,
                            code = c.Organization.Code,
                            c.OrganizationId,
                            c.NickName,
                            roles = c.UsersRoles.Select(p => new
                            {
                                p.RoleId
                            })
                        }
                        );


                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取人员分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "name": "姓名",
        ///         "orgizationCode":"组织编号",
        ///         "policeCode":"警员编号",
        ///         "cabinetId":"单警柜ID",
        ///         "level":"是否本级"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPagePoliceman")]
        public async Task<HttpResponseMessage> GetPagePoliceman([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationCode = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgizationCode))
                        {
                            orgizationCode = entity.orgizationCode;
                        }

                        dataList = GetClassID(orgizationCode);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationCode))).ToList();



                        Expression<Func<BaseJpPoliceman, bool>> expressionPoliceman = null;

                        string Name = entity.name;
                        string PoliceCode = entity.policeCode;
                        string CabinetId = entity.cabinetId;

                        List<string> IdList = dataList.Select(c => c.Id).ToList();

                        if (!String.IsNullOrEmpty(entity.level))
                        {
                            if (entity.level == "本级")
                            {
                                expressionPoliceman = t => t.OrgizationCode.Equals(orgizationCode);
                            }
                            else
                            {
                                expressionPoliceman = t => IdList.Contains(t.OrgizationCode);
                            }
                        }
                        else
                        {
                            expressionPoliceman = t => IdList.Contains(t.OrgizationCode);
                        }

                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.Name.Contains(Name));
                        }

                        if (!String.IsNullOrEmpty(entity.policeCode))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.PoliceCode.Contains(PoliceCode));
                        }

                        if (!String.IsNullOrEmpty(entity.cabinetId))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.CabinetId.Contains(CabinetId));
                        }



                        //if ((!String.IsNullOrEmpty(entity.name)) && (!String.IsNullOrEmpty(entity.policeCode)) && (!String.IsNullOrEmpty(entity.cabinetId)))
                        //{
                        //    expressionPoliceman = t => dataList.Select(c => c.Id).Contains(t.OrgizationCode) && t.Name.Contains(Name) && t.PoliceCode.Contains(PoliceCode) && t.CabinetId.Equals(CabinetId);
                        //}
                        //else if ((!String.IsNullOrEmpty(entity.name)) && (!String.IsNullOrEmpty(entity.policeCode)))
                        //{
                        //    expressionPoliceman = t => dataList.Select(c => c.Id).Contains(t.OrgizationCode) && t.Name.Contains(Name) && t.PoliceCode.Contains(PoliceCode);
                        //}
                        //else if ((!String.IsNullOrEmpty(entity.name)) && (!String.IsNullOrEmpty(entity.cabinetId)))
                        //{
                        //    expressionPoliceman = t => dataList.Select(c => c.Id).Contains(t.OrgizationCode) && t.Name.Contains(Name) && t.CabinetId.Equals(CabinetId);
                        //}
                        //else if ((!String.IsNullOrEmpty(entity.policeCode)) && (!String.IsNullOrEmpty(entity.cabinetId)))
                        //{
                        //    expressionPoliceman = t => dataList.Select(c => c.Id).Contains(t.OrgizationCode) && t.PoliceCode.Contains(PoliceCode) && t.CabinetId.Equals(CabinetId);
                        //}
                        //else if (!String.IsNullOrEmpty(entity.name))
                        //{
                        //    expressionPoliceman = t => dataList.Select(c => c.Id).Contains(t.OrgizationCode) && t.Name.Contains(Name);
                        //}
                        //else if (!String.IsNullOrEmpty(entity.policeCode))
                        //{
                        //    expressionPoliceman = t => dataList.Select(c => c.Id).Contains(t.OrgizationCode) && t.PoliceCode.Contains(PoliceCode);
                        //}
                        //else if (!String.IsNullOrEmpty(entity.cabinetId))
                        //{
                        //    expressionPoliceman = t => dataList.Select(c => c.Id).Contains(t.OrgizationCode) && t.CabinetId.Equals(CabinetId);
                        //}
                        //else
                        //{
                        //    expressionPoliceman = t => dataList.Select(c => c.Id).Contains(t.OrgizationCode);
                        //}


                        var param = new string[] {
                       "Cabinet" ,
                       "OrgizationCodeNavigation"
                    };

                        PageData<BaseJpPoliceman> pagedata = _unitOfWork.PolicemanRepository.GetPage(expressionPoliceman, "-UpdateTime", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.Id,
                            c.Sort,
                            c.Name,
                            c.CabinetId,
                            c.OrgizationCode,
                            c.PoliceCode,
                            c.Sex,
                            c.FingerInfo1,
                            c.FingerInfo2,
                            c.FaceInfo,
                            c.Photo,
                            c.Phone,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            c.Cabinet?.CabinetNum,
                            c.Cabinet?.CabinetChildNum,
                            OrgizationName = c.OrgizationCodeNavigation?.Name,
                            c.OrgizationCodeNavigation?.Code,
                            c.IsCreatedAccount,
                            c.CardNo,

                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 添加或修改警员信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号",
        ///        "name":"姓名",
        ///        "orgizationCode":"组织机构",
        ///        "policeCode":"警号编号",
        ///        "sex" : "姓别",
        ///        "cabinetId":"单警柜ID",
        ///        "photo": "人脸照片路径",
        ///        "phone" : "手机号码",
        ///        "updateUser":"操作用户ID",
        ///        "isCreatedAccount":"是否注册账户",
        ///        "account":"注册账户名（缺省为姓名）"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdatePoliceman")]
        //[NoSign]
        public async Task<HttpResponseMessage> AddOrUpdatePoliceman([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.orgizationCode?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        if (string.IsNullOrEmpty(entity.name ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"Name is require");
                        }
                        else if (string.IsNullOrEmpty(entity.policeCode ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"PoliceCode is require");
                        }
                        else if (string.IsNullOrEmpty(entity.orgizationCode ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"OrgizationCode is require");
                        }
                        else if (string.IsNullOrEmpty(entity.phone ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"Phone is require");
                        }
                        else if (string.IsNullOrEmpty(entity.sex ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"Sex is require");
                        }

                        using (var scope = _unitOfWork.BeginTransaction())
                        {
                            try
                            {
                                if (!string.IsNullOrEmpty(id))
                                {
                                    Expression<Func<BaseJpPoliceman, bool>> expression = t => t.Id.Equals(id);
                                    BaseJpPoliceman updateObject = _unitOfWork.PolicemanRepository.Get(expression);
                                    if (updateObject != null)
                                    {
                                        updateObject.Name = entity.name;
                                        updateObject.OrgizationCode = entity.orgizationCode;
                                        updateObject.PoliceCode = entity.policeCode;
                                        if (string.IsNullOrEmpty(entity.cabinetId))
                                        {
                                            updateObject.CabinetId = null;
                                        }
                                        else
                                        {
                                            updateObject.CabinetId = entity.cabinetId;
                                        }
                                        updateObject.Sex = entity.sex;
                                        updateObject.Photo = entity.photo;
                                        updateObject.Phone = entity.phone;
                                        updateObject.UpdateTime = System.DateTime.Now;
                                        updateObject.UpdateUser = entity.updateUser;
                                    }
                                    else
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }

                                    if (Convert.ToBoolean(entity.isCreatedAccount))
                                    {
                                        if (updateObject.IsCreatedAccount == true)
                                        {
                                            //已创建账户，过滤
                                        }
                                        else
                                        {
                                            //注册账户
                                            string name = string.IsNullOrEmpty(entity.account) ? entity.name : entity.account;
                                            var old = _unitOfWork.CommonJpUserRepository.Get(predicate: x => x.Username == name);
                                            if (old != null)
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse("重名注册");
                                            }
                                            var userId = Guid.NewGuid().ToString();
                                            var res = _unitOfWork.CommonJpUserRepository.Insert(new CommonJpUser()
                                            {
                                                Id = userId,
                                                Password = "e10adc3949ba59abbe56e057f20f883e",
                                                Username = name,
                                                Phone = entity.phone,
                                                CreateTime = DateTime.Now,
                                                NickName = entity.name,
                                                OrganizationId = entity.orgizationCode,
                                                Enabled = 1,
                                                PoliceId = updateObject.Id
                                            });
                                            if (!res)
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse("注册失败，请稍后再试");
                                            }
                                            _unitOfWork.UsersRoleRepository.Insert(new UsersRole
                                            {
                                                RoleId = 6,
                                                UserId = userId
                                            });

                                            updateObject.IsCreatedAccount = true;
                                        }
                                    }

                                    bool result = _unitOfWork.PolicemanRepository.Update(updateObject);

                                    if (result)
                                    {
                                        //推送更新数据(不创建账号）
                                        var pushdata = new
                                        {
                                            id = updateObject.Id,
                                            name = updateObject.Name,
                                            orgizationCode = updateObject.OrgizationCode,
                                            policeCode = updateObject.PoliceCode,
                                            sex = updateObject.Sex,
                                            photo = updateObject.Photo,
                                            phone = updateObject.Phone,
                                            updateUser = updateObject.UpdateUser,
                                            account = entity.account,
                                        };
                                        var res = _httpHelper.GetHtml(new HttpItem()
                                        {
                                            URL = _httpHelper._centerServerAddress + "/api/Policeman/AddOrUpdatePoliceman",
                                            Encoding = Encoding.UTF8,
                                            Method = "POST",
                                            ContentType = "application/json",
                                            Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(pushdata)),
                                            Timeout = 5000
                                        });
                                        if (res.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(res.Html))
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleStatusResponse(ResultCode.REMOTE_REPORTING_ERROR);
                                        }

                                        var obj = JsonConvert.DeserializeObject<dynamic>(res.Html);

                                        if (obj.code != "10000")
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse(obj.msg ?? "操作失败");
                                        }

                                        scope.Commit();
                                        return JsonManager.ReturnSuccessResponse(new
                                        {
                                            id = updateObject.Id,
                                            name = updateObject.Name,
                                            orgizationCode = updateObject.OrgizationCode,
                                            phone = updateObject.Phone,
                                            policeCode = updateObject.PoliceCode,
                                            sex = updateObject.Sex,
                                        });
                                    }
                                    else
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }

                                }
                                else
                                {
                                    string cabinetId = null;
                                    if (string.IsNullOrEmpty(entity.cabinetId))
                                    {
                                        cabinetId = null;
                                    }
                                    else
                                    {
                                        cabinetId = entity.cabinetId;
                                    }

                                    string policeCode = entity.policeCode;
                                    Expression<Func<BaseJpPoliceman, bool>> expression = t => t.PoliceCode.Equals(policeCode);
                                    BaseJpPoliceman cfObject = _unitOfWork.PolicemanRepository.Get(expression);
                                    if (cfObject != null)
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleStatusResponse(ResultCode.POLICE_C_ERROR);
                                    }

                                    //新增数据
                                    BaseJpPoliceman addObject = new BaseJpPoliceman()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        Sort = null,
                                        Name = entity.name,
                                        CabinetId = cabinetId,
                                        OrgizationCode = entity.orgizationCode,
                                        PoliceCode = entity.policeCode,
                                        Sex = entity.sex,
                                        FingerInfo1 = null,
                                        FaceInfo = null,
                                        Photo = entity.photo,
                                        Phone = entity.phone,
                                        CreateTime = System.DateTime.Now,
                                        UpdateTime = System.DateTime.Now,
                                        UpdateUser = entity.updateUser,
                                    };
                                    bool result = false;
                                    if (Convert.ToBoolean(entity.isCreatedAccount))
                                    {
                                        //注册账户
                                        string name = string.IsNullOrEmpty(entity.account) ? entity.name : entity.account;
                                        var old = _unitOfWork.CommonJpUserRepository.Get(predicate: x => x.Username == name);
                                        if (old != null)
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("重名注册");
                                        }
                                        var userId = Guid.NewGuid().ToString();
                                        _unitOfWork.CommonJpUserRepository.Insert(new CommonJpUser()
                                        {
                                            Id = userId,
                                            Password = "e10adc3949ba59abbe56e057f20f883e",
                                            Username = name,
                                            Phone = entity.phone,
                                            CreateTime = DateTime.Now,
                                            NickName = entity.name,
                                            OrganizationId = entity.orgizationCode,
                                            Enabled = 1,
                                            PoliceId = addObject.Id
                                        }, false);

                                        _unitOfWork.UsersRoleRepository.Insert(new UsersRole
                                        {
                                            RoleId = 6,
                                            UserId = userId
                                        }, false);

                                        addObject.IsCreatedAccount = true;
                                        _unitOfWork.PolicemanRepository.Insert(addObject, false);
                                        result = _unitOfWork.DbContext.SaveChanges() > 0;
                                        if (!result)
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse("注册失败，请稍后再试");
                                        }
                                    }
                                    else
                                    {
                                        result = _unitOfWork.PolicemanRepository.Insert(addObject);
                                    }

                                    if (result)
                                    {
                                        //上报数据(不创建账号）
                                        var pushdata = new
                                        {
                                            name = addObject.Name,
                                            orgizationCode = addObject.OrgizationCode,
                                            policeCode = addObject.PoliceCode,
                                            sex = addObject.Sex,
                                            photo = addObject.Photo,
                                            phone = addObject.Phone,
                                            updateUser = addObject.UpdateUser,
                                            account = entity.account,
                                            thirdPoliceId = addObject.Id
                                        };
                                        var res = _httpHelper.GetHtml(new HttpItem()
                                        {
                                            URL = _httpHelper._centerServerAddress + "/api/Policeman/AddOrUpdatePoliceman",
                                            Encoding = Encoding.UTF8,
                                            Method = "POST",
                                            ContentType = "application/json",
                                            Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(pushdata)),
                                            Timeout = 5000
                                        });
                                        if (res.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(res.Html))
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleStatusResponse(ResultCode.REMOTE_REPORTING_ERROR);
                                        }

                                        var obj = JsonConvert.DeserializeObject<dynamic>(res.Html);

                                        if (obj.code != "10000")
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleCustResponse(obj.msg ?? "操作失败");
                                        }
                                        scope.Commit();
                                        return JsonManager.ReturnSuccessResponse(new
                                        {
                                            id = addObject.Id,
                                            name = addObject.Name,
                                            orgizationCode = addObject.OrgizationCode,
                                            phone = addObject.Phone,
                                            policeCode = addObject.PoliceCode,
                                            sex = addObject.Sex,
                                        });
                                    }
                                    else
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }
                                }
                            }
                            catch (Exception e)
                            {
                                scope.Rollback();
                                throw;
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 删除警员信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeletePoliceman")]
        public async Task<HttpResponseMessage> DeletePoliceman([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            using (var scope = _unitOfWork.BeginTransaction())
                            {
                                try
                                {
                                    var param = new string[]
                                    {
                                        "CommonJpEquipmentInventories",
                                        "CommonJpUsers"
                                    };
                                    List<CommonJpEquipmentInventory> Invs = new List<CommonJpEquipmentInventory>();
                                    Expression<Func<BaseJpPoliceman, bool>> expression = t => t.Id.Equals(id);
                                    BaseJpPoliceman deleteObject = _unitOfWork.PolicemanRepository.GetList(expression, null, false, param).FirstOrDefault();
                                    if (deleteObject != null)
                                    {
                                        if (deleteObject.CommonJpEquipmentInventories.Count > 0)
                                        {
                                            foreach (var item in deleteObject.CommonJpEquipmentInventories)
                                            {
                                                if (item.Cabinet == null)
                                                {
                                                    return JsonManager.SimpleStatusResponse(ResultCode.DELETE_USER_ERROR);
                                                }
                                                item.CabinetId = null;
                                                item.PoliceCode = null;
                                                Invs.Add(item);

                                            }
                                        }
                                        if (Invs.Count > 0)
                                        {
                                            _unitOfWork.EquipmentInventoryRepository.Update(Invs, false);
                                        }
                                        //删除账号级联关系
                                        if (deleteObject.CommonJpUsers.Count > 0)
                                        {
                                            List<CommonJpUser> usersList = new List<CommonJpUser>();
                                            foreach (var commonJpUser in deleteObject.CommonJpUsers)
                                            {
                                                commonJpUser.PoliceId = null;
                                                usersList.Add(commonJpUser);
                                            }
                                            if (usersList.Count > 0)
                                            {
                                                _unitOfWork.CommonJpUserRepository.Update(usersList, false);
                                            }
                                        }

                                        bool result = _unitOfWork.PolicemanRepository.Delete(deleteObject, true);

                                        if (result)
                                        {
                                            //上报数据
                                            var pushdata = new
                                            {
                                                id = id
                                            };
                                            var res = _httpHelper.GetHtml(new HttpItem()
                                            {
                                                URL = _httpHelper._centerServerAddress + "/api/Policeman/DeletePoliceman",
                                                Encoding = Encoding.UTF8,
                                                Method = "POST",
                                                ContentType = "application/json",
                                                Postdata = _httpHelper.CreatePostData(JsonConvert.SerializeObject(pushdata)),
                                                Timeout = 5000
                                            });
                                            if (res.StatusCode != HttpStatusCode.OK || string.IsNullOrEmpty(res.Html))
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleStatusResponse(ResultCode.REMOTE_REPORTING_ERROR);
                                            }

                                            var obj = JsonConvert.DeserializeObject<dynamic>(res.Html);

                                            if (obj.code != "10000")
                                            {
                                                scope.Rollback();
                                                return JsonManager.SimpleCustResponse(obj.msg ?? "操作失败");
                                            }

                                            scope.Commit();
                                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                        }
                                        else
                                        {
                                            scope.Rollback();
                                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                        }
                                    }
                                    else
                                    {
                                        scope.Rollback();
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }
                                }
                                catch (Exception e)
                                {
                                    scope.Rollback();
                                    throw;
                                }
                            }
                        }
                        else
                        {

                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 警员图片上传
        /// </summary>
        /// <remarks>
        /// 
        /// ## from 类型为enctype="multipart/form-data"   
        /// 
        /// </remarks>
        /// <returns></returns>
        [HttpPost("FileUp")]
        [NoSign]
        public async Task<HttpResponseMessage> FileUp()
        {
            try
            {
                var files = Request.Form.Files;//接收上传的文件，可能多个 看前台
                if (files.Count > 0)
                {
                    var path = @"/wwwroot/personImg/";//绝对路径
                    var pathF = @"/personImg/";//绝对路径
                    string dirPath = Path.Combine(Environment.CurrentDirectory + path);//绝对径路 储存文件路径的文件夹
                    if (!Directory.Exists(dirPath))//查看文件夹是否存在
                        Directory.CreateDirectory(dirPath);
                    var file = files.Where(x => true).FirstOrDefault();//只取多文件的一个
                    string strExtn = System.IO.Path.GetExtension(file.FileName).ToLower();

                    const string fileFilt = ".jpg|.jpeg|.png";
                    if (strExtn == null)
                    {
                        return JsonManager.SimpleCustResponse($"上传的文件没有后缀");
                    }
                    if (fileFilt.IndexOf(strExtn, StringComparison.Ordinal) <= -1)
                    {
                        return JsonManager.SimpleCustResponse($"请上传jpg、png格式的图片");
                    }

                    if (file.Length > 200 * 1024) //200K
                    {
                        return JsonManager.SimpleCustResponse($"上传文件不能大于200K！");
                    }

                    var fileNam = $"{Guid.NewGuid():N}{strExtn}";//新文件名
                    string snPath = $"{dirPath + fileNam}";//储存文件路径
                    using var stream = new FileStream(snPath, FileMode.Create);
                    file.CopyTo(stream);
                    var returnData = new
                    {
                        filePath = pathF + fileNam
                    };

                    return JsonManager.ReturnSuccessResponse(returnData);
                }
                else//没有图片
                {
                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                }
            }
            catch (Exception ex)
            {

                //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
            }

        }

        /// <summary>
        /// 更新警员卡号（批量)
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {   
        ///        "list":[{
        ///                 "policeCode":"",
        ///                 "cardNo":""
        ///               }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("BatchUpdateCardNo")]
        //[NoSignAttribute]
        public async Task<HttpResponseMessage> BatchUpdateCardNo([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }

                        foreach (var obj in entity.list)
                        {
                            string policeCode = obj.policeCode ?? "";
                            string cardNo = obj.cardNo ?? "";
                            var police = _unitOfWork.PolicemanRepository.Get(x => x.PoliceCode == policeCode);

                            if (police == null)
                            {
                                continue;
                            }
                            police.CardNo = cardNo;
                            _unitOfWork.PolicemanRepository.Update(police, false);
                        }

                        if (_unitOfWork.SaveChanges() > 0)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 账号绑定警员
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {   
        ///        "id":"账号id",
        ///        "policeId":"警员id",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("BindUserByPoliceId")]
        //[NoSignAttribute]
        public async Task<HttpResponseMessage> BindUserByPoliceId([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.id ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else if (string.IsNullOrEmpty(entity.policeId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"policeId is require");
                        }
                        CommonJpUser user = _unitOfWork.CommonJpUserRepository.Get(entity.id);
                        if (user == null)
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        BaseJpPoliceman police = _unitOfWork.PolicemanRepository.Get(entity.policeId);
                        if (police == null)
                        {
                            return JsonManager.SimpleCustResponse($"policeId is require");
                        }

                        user.PoliceId = police.Id;
                        var result = _unitOfWork.CommonJpUserRepository.Update(user);

                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        //递归取数据
        private List<BaseJpOrganization> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }



        /// <summary>
        /// 添加信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {   
        ///        "id":"编号",
        ///        "username":"用户名",
        ///        "txt":"内容",
        ///        "type" : "类型"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddTxt")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> AddTxt([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.username ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"username is require");
                        }
                        else if (string.IsNullOrEmpty(entity.type ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"type is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            Expression<Func<CommonJpUserInfo, bool>> expression = t => t.Id.Equals(id);
                            CommonJpUserInfo updateObject = _unitOfWork.CommonJpUserInfoRepository.Get(expression);
                            if (updateObject != null)
                            {
                                updateObject.Txt = entity.txt;
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                            bool result = _unitOfWork.CommonJpUserInfoRepository.Update(updateObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {
                            //新增数据
                            CommonJpUserInfo addObject = new CommonJpUserInfo()
                            {
                                Id = Guid.NewGuid().ToString(),
                                Txt = entity.txt,
                                Username = entity.username,
                                Type = entity.type,
                                CreateTime = System.DateTime.Now
                            };

                            bool result = _unitOfWork.CommonJpUserInfoRepository.Insert(addObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 删除信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteTxt")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> DeleteTxt([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        String id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            Guid sid = Guid.Parse(id);
                            Expression<Func<CommonJpUserInfo, bool>> expression = t => t.Id.Equals(sid);
                            CommonJpUserInfo deleteObject = _unitOfWork.CommonJpUserInfoRepository.Get(expression);
                            if (deleteObject != null)
                            {
                                bool result = _unitOfWork.CommonJpUserInfoRepository.Delete(deleteObject);

                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {

                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 获取信息列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "username":"用户名称",
        ///         "type":"类型"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListTxt")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetListTxt([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (string.IsNullOrEmpty(entity.username ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"username is require");
                        }

                        String username = entity.username;
                        String type = entity.type;




                        Expression<Func<CommonJpUserInfo, bool>> expressionHouse = null;
                        if (!String.IsNullOrEmpty(type))
                        {
                            expressionHouse = t => t.Username.Equals(username) && t.Type.Equals(type);
                        }
                        else
                        {
                            expressionHouse = t => t.Username.Equals(username);
                        }

                        var param = new string[] {
                    };

                        List<CommonJpUserInfo> dataHouseList = _unitOfWork.CommonJpUserInfoRepository.GetArray(expressionHouse, t => t.CreateTime, false, param).ToList();


                        var data = dataHouseList.Select(c => new
                        {
                            c.Id,
                            c.Username,
                            c.Txt,
                            c.Type,
                            c.CreateTime
                        }
                        ).ToList();


                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

    }
}
