﻿using JmpCommon;
using JmpModel.Model;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class EquipmentSizeController : ControllerBase
    {
        //private ICabinetRepository _CabinetRepository;
        private ILogger<EquipmentSizeController> _logger;
        UnitOfWork _unitOfWork;

        public EquipmentSizeController(ILogger<EquipmentSizeController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取装备型号列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "detailId":"装备Id"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListEquipmentSize")]
        public async Task<HttpResponseMessage> GetListEquipmentSize([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        Expression<Func<BaseJpEquipmentSize, bool>> expression = t => !t.Id.Equals(null);

                        if (!String.IsNullOrEmpty(entity.detailId))
                        {
                            string DetailId = entity.detailId;
                            expression = t => t.DetailId.Equals(DetailId);
                        }

                        var param = new string[] {
                       "Detail"
                    };

                        List<BaseJpEquipmentSize> dataList = _unitOfWork.EquipmentSizeRepository.GetList(expression, t => t.UpdateTime, false, param).ToList();

                        var i = 0;
                        var data = dataList.Select(c => new
                        {
                            c.Id,
                            c.SizeName,
                            c.SizeCode,
                            c.DetailId,
                            c.Detail?.Name,
                            c.EpcType,
                            c.Note,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            index = ++i
                        }
                        ).ToList();

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取装备型号列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "detailId":"装备Id"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListEquipmentSizeNoSign")]
        [NoSign]
        public async Task<HttpResponseMessage> GetListEquipmentSizeNoSign([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        Expression<Func<BaseJpEquipmentSize, bool>> expression = t => !t.Id.Equals(null);

                        if (!String.IsNullOrEmpty(entity.detailId))
                        {
                            string DetailId = entity.detailId;
                            expression = t => t.DetailId.Equals(DetailId);
                        }

                        var param = new string[] {
                       "Detail"
                    };

                        List<BaseJpEquipmentSize> dataList = _unitOfWork.EquipmentSizeRepository.GetList(expression, t => t.UpdateTime, false, param).ToList();

                        var i = 0;
                        var data = dataList.Select(c => new
                        {
                            c.Id,
                            c.SizeName,
                            c.SizeCode,
                            c.DetailId,
                            c.Detail?.Name,
                            c.EpcType,
                            c.Note,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            index = ++i
                        }
                        ).ToList();

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取装备型号分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "updateTime": "",
        ///         "detailId":"装备Id"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetEquipmentSizeDevelop")]
        //[NoSignAttribute]
        public async Task<HttpResponseMessage> GetEquipmentSizeDevelop([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);


                        string updateTime = entity.updateTime;
                        Expression<Func<BaseJpEquipmentSize, bool>> expression = t => !t.Id.Equals(null) && t.UpdateTime >= DateTime.Parse(updateTime);
                        if (!String.IsNullOrEmpty(entity.detailId))
                        {
                            string DetailId = entity.detailId;
                            expression = t => t.DetailId.Equals(DetailId);
                        }


                        var param = new string[] {
                       "Detail"
                    };

                        List<BaseJpEquipmentSize> pagedata = _unitOfWork.EquipmentSizeRepository.GetList(expression, p => p.UpdateTime, false, param).ToList();

                        var data = pagedata.Select(c => new
                        {
                            c.Id,
                            c.SizeName,
                            sizeCode = c.SizeCode.ToString().PadLeft(3, '0'),
                            c.DetailId,
                            c.Detail?.Name,
                            c.EpcType,
                            c.Note,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.Count,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取装备型号分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "detailId":"装备Id"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageEquipmentSize")]
        public async Task<HttpResponseMessage> GetPageEquipmentSize([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpEquipmentSize, bool>> expression = t => !t.Id.Equals(null);

                        if (!String.IsNullOrEmpty(entity.detailId))
                        {
                            string DetailId = entity.detailId;
                            expression = t => t.DetailId.Equals(DetailId);
                        }

                        var param = new string[] {
                       "Detail"
                    };

                        PageData<BaseJpEquipmentSize> pagedata = _unitOfWork.EquipmentSizeRepository.GetPage(expression, "-UpdateTime", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.Id,
                            c.SizeName,
                            sizeCode = c.SizeCode.ToString().PadLeft(3, '0'),
                            c.DetailId,
                            c.Detail?.Name,
                            c.EpcType,
                            c.Note,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 添加或修改装备型号信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号",
        ///        "sizeName" : "装备型号名称",
        ///        "detailId":"装备Id",
        ///        "epcType" : "EPC类型",
        ///        "note" : "备注",
        ///        "updateUser":"操作用户ID"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateEquipmentSize")]
        public async Task<HttpResponseMessage> AddOrUpdateEquipmentSize([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        string updateUser = entity?.updateUser ?? "";

                        int.TryParse(entity.epcType, out int epcType);

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.sizeName ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"SizeName is require");
                        }
                        else if (string.IsNullOrEmpty(entity.detailId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"DetailId is require");
                        }
                        else if (string.IsNullOrEmpty(updateUser))
                        {
                            return JsonManager.SimpleCustResponse($"updateUser is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            Expression<Func<BaseJpEquipmentSize, bool>> expression = t => t.Id.Equals(id);
                            BaseJpEquipmentSize updateObject = _unitOfWork.EquipmentSizeRepository.Get(expression);
                            if (updateObject != null)
                            {
                                updateObject.SizeName = entity.sizeName;
                                //updateObject.SizeCode = entity.sizeCode;
                                updateObject.DetailId = entity.detailId;
                                updateObject.EpcType = epcType;
                                updateObject.Note = entity.note;
                                updateObject.UpdateTime = System.DateTime.Now;
                                updateObject.UpdateUser = entity.updateUser;
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                            bool result = _unitOfWork.EquipmentSizeRepository.Update(updateObject);

                            if (result)
                            {
                                return JsonManager.ReturnSuccessResponse(new
                                {
                                    updateObject.Id,
                                    updateObject.SizeName,
                                    updateObject.DetailId,
                                    updateObject.EpcType,
                                    updateObject.Note,
                                    updateObject.UpdateTime,
                                    updateObject.UpdateUser,
                                });
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {
                            var sizeCode = "000";
                            string detailId = entity.detailId;
                            var param = new string[] { };
                            Expression<Func<BaseJpEquipmentSize, bool>> expression = t => t.DetailId.Equals(detailId);
                            List<BaseJpEquipmentSize> sizeList = _unitOfWork.EquipmentSizeRepository.GetList(expression, t => t.UpdateTime, false, param).ToList();


                            int? maxCount = sizeList.Max(c => c.SizeCode);

                            if (maxCount == null)
                            {
                                maxCount = 1;
                            }
                            else
                            {
                                maxCount = maxCount + 1;
                            }

                            if (maxCount > 255)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.NUMBER255_ERROR);
                            }
                            sizeCode = maxCount.ToString().PadLeft(3, '0');


                            //新增数据
                            BaseJpEquipmentSize addObject = new BaseJpEquipmentSize()
                            {
                                Id = Guid.NewGuid().ToString(),
                                SizeName = entity.sizeName,
                                SizeCode = Convert.ToInt32(sizeCode),
                                DetailId = entity.detailId,
                                EpcType = epcType,
                                Note = entity.note,
                                CreateTime = System.DateTime.Now,
                                UpdateTime = System.DateTime.Now,
                                UpdateUser = entity.updateUser
                            };

                            bool result = _unitOfWork.EquipmentSizeRepository.Insert(addObject);

                            if (result)
                            {
                                return JsonManager.ReturnSuccessResponse(new
                                {
                                    addObject.Id,
                                    addObject.SizeName,
                                    addObject.DetailId,
                                    addObject.EpcType,
                                    addObject.Note,
                                    addObject.UpdateTime,
                                    addObject.UpdateUser,
                                });
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 删除装备型号信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteEquipmentSize")]
        public async Task<HttpResponseMessage> DeleteEquipmentSize([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            Expression<Func<BaseJpEquipmentSize, bool>> expression = t => t.Id.Equals(id);
                            BaseJpEquipmentSize deleteObject = _unitOfWork.EquipmentSizeRepository.Get(expression);
                            if (deleteObject != null)
                            {
                                bool result = _unitOfWork.EquipmentSizeRepository.Delete(deleteObject);

                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {

                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

    }
}
