﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Repository;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Controllers;
using Microsoft.AspNetCore.Mvc.Filters;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;
using Nacos;
using Nacos.AspNetCore;
using Nancy.Json;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Drawing.Printing;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Web;

namespace JunmpPoliceStation.App_Start
{

    public class AuthLoginAttribute : ActionFilterAttribute
    {
        private readonly INacosServerManager _serverManager;
        private readonly INacosNamingClient _serverNamingClient;
        private readonly IHttpClientFactory _clientFactory;
        public IConfiguration Configuration { get; }
        private ILogger<PrintController> _logger;
        private Boolean flg;
        ApiConfig apicfg;
        string urlGetSecretKey = string.Empty;//获取seckey的路由
        string urlCheckApp = string.Empty;//获取审核的路由

        public AuthLoginAttribute(IConfiguration configuration, ApiConfig apicfg, INacosServerManager _serverManager, INacosNamingClient _serverNamingClient, IHttpClientFactory _clientFactory, Boolean AuthFlg = true)
        {
            flg = AuthFlg;
            this.apicfg = apicfg;
            this._serverManager = _serverManager;
            this._serverNamingClient = _serverNamingClient;
            this._clientFactory = _clientFactory;
            this.Configuration = configuration;
            _serverNamingClient.RegisterInstanceAsync(new RegisterInstanceRequest
            {
                ServiceName = apicfg.serviceName,
                Ip = apicfg.serviceIp,
                Port = Convert.ToInt32(apicfg.servicePort)
            });
            var url = "http://" + apicfg.serviceIp + ":" + apicfg.servicePort;
            var baseUrl = _serverManager.GetServerAsync(apicfg.serviceName);
            urlGetSecretKey = $"{url}/api/yewu/Auth/GetSecretKey";
            urlCheckApp = $"{url}/api/yewu/Auth/JpVerification";
        }




        public override void OnActionExecuting(ActionExecutingContext context)
        {
            if (bool.TryParse(Configuration.GetSection("Auth:NoSign").Value, out bool noSignFlag) && noSignFlag)
            {
                return;
            }
            try
            {
                //return;
                var noNeedCheck = false;
                if (context.HttpContext.Request.Method.Equals("GET"))
                {
                    return;
                }

                if (context.ActionDescriptor is ControllerActionDescriptor controllerActionDescriptor)
                {
                    noNeedCheck = controllerActionDescriptor.MethodInfo.GetCustomAttributes(inherit: true)
                            .Any(a => a.GetType().Equals(typeof(NoSignAttribute)));
                    if (noNeedCheck)
                    {
                        //return;
                    }
                    else
                    {
                        var _clientPar = JsonConvert.DeserializeObject<ParInfo>(context.ActionArguments["jdata"]?.ToString() ?? "");

                        if (_clientPar == null || string.IsNullOrEmpty(_clientPar.appKey)
                            || string.IsNullOrEmpty(_clientPar.sign)

                            || _clientPar.timestamp <= 0
                            || string.IsNullOrEmpty(_clientPar.version))
                        {
                            context.Result = new JsonResult(ResultCode.REQUEST_DATA_ERROR);
                            return;
                        }

                        DateTime sendTime = WorkTools.GetDateTime(_clientPar.timestamp);
                        if (sendTime.AddMinutes(20) < DateTime.Now)
                        {
                            context.Result = new JsonResult(ResultCode.TIME_ERROR);
                            return;
                        }

                        if (_clientPar.appKey != Configuration["ThirdConfig:AppKey"])
                        {
                            context.Result = new JsonResult(ResultCode.APPKEY_ERROR);
                            return;
                        }
                        string sign = WorkTools.GenerateMD5((Configuration["ThirdConfig:SecretKey"] ?? "") + _clientPar.timestamp + _clientPar.version + _clientPar.body).ToLower();
                        if (!sign.Equals(_clientPar.sign))//校验签名是否通过
                        {
                            context.Result = new JsonResult(ResultCode.SIGN_ERROR);
                            return;
                        }

                        //JavaScriptSerializer jss = new JavaScriptSerializer();
                        //var urlSend = "/api/" + context.ActionDescriptor.RouteValues["controller"].ToString() + "/" + context.ActionDescriptor.RouteValues["action"].ToString();
                        //var urlInfo = new { apiName = urlSend, orgId = _clientPar.orgId, appKey = _clientPar.appKey };
                        //var content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(urlInfo), Encoding.UTF8, "application/json");
                        //var getResult = client.PostAsync(urlCheckApp, content).Result.Content.ReadAsStringAsync();
                        //var _verRes = JsonConvert.DeserializeObject<PlaInfo>(getResult.Result);
                        //if (_verRes.state == 1)
                        //{

                        //}
                        //else if (_verRes.state == 5)
                        //{
                        //    context.Result = new JsonResult(ResultCode.API_ERROR);
                        //    return;
                        //}
                        //else if (_verRes.state == 6)
                        //{
                        //    context.Result = new JsonResult(ResultCode.HAS_NO_LIMITS);
                        //    return;
                        //}
                        //context.ActionArguments["jdata"] = JObject.Parse(HttpUtility.UrlDecode(_clientPar.body, Encoding.UTF8));// cons["body"];

                        noNeedCheck = controllerActionDescriptor.MethodInfo.GetCustomAttributes(inherit: true)
                            .Any(a => a.GetType().Equals(typeof(NoSignAttribute)));
                        if (noNeedCheck)
                            return;

                        if (string.IsNullOrEmpty(_clientPar.body))
                        {
                            context.ActionArguments["jdata"] = JObject.Parse("{}");
                        }
                        else
                        {
                            var jObj = JObject.Parse(HttpUtility.UrlDecode(_clientPar.body, Encoding.UTF8));
                            if (!string.IsNullOrEmpty(_clientPar.orgId))
                            {
                                jObj.Add("_PUSHORG", _clientPar.orgId);
                            }

                            context.ActionArguments["jdata"] = jObj;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                _logger.LogError("Login/SignIn 错误:" + ex.ToString());
                context.Result = new JsonResult(ex.ToString());
            }
        }

    }
    public class PlaInfo
    {
        public string data { get; set; }
        public int state { get; set; }
        public string message { get; set; }
    }
    public class ParInfo
    {
        public string appKey { get; set; }
        public string orgId { get; set; }
        public string version { get; set; }
        public long timestamp { get; set; }
        public string body { get; set; }
        public string sign { get; set; }
    }
}
