﻿// <auto-generated> This file has been auto generated by EF Core Power Tools. </auto-generated>
#nullable disable
using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

namespace JmpSqlServerModel
{
    public partial class JmpSqlServerContext : DbContext
    {
        public JmpSqlServerContext()
        {
        }

        public JmpSqlServerContext(DbContextOptions<JmpSqlServerContext> options)
            : base(options)
        {
        }

        public virtual DbSet<BaseJpCabinet> BaseJpCabinet { get; set; }
        public virtual DbSet<BaseJpEquipmentDetail> BaseJpEquipmentDetail { get; set; }
        public virtual DbSet<BaseJpEquipmentInfo> BaseJpEquipmentInfo { get; set; }
        public virtual DbSet<BaseJpEquipmentSize> BaseJpEquipmentSize { get; set; }
        public virtual DbSet<BaseJpOrganization> BaseJpOrganization { get; set; }
        public virtual DbSet<BaseJpPoliceman> BaseJpPoliceman { get; set; }
        public virtual DbSet<BaseJpProcess> BaseJpProcess { get; set; }
        public virtual DbSet<BaseJpShelfInfo> BaseJpShelfInfo { get; set; }
        public virtual DbSet<BaseJpSupplier> BaseJpSupplier { get; set; }
        public virtual DbSet<BaseJpSupplierEquipment> BaseJpSupplierEquipment { get; set; }
        public virtual DbSet<BaseJpWarehouse> BaseJpWarehouse { get; set; }
        public virtual DbSet<CommonJpChannelCfgV2> CommonJpChannelCfgV2 { get; set; }
        public virtual DbSet<CommonJpEquipmentInventory> CommonJpEquipmentInventory { get; set; }
        public virtual DbSet<CommonJpEquipmentState> CommonJpEquipmentState { get; set; }
        public virtual DbSet<CommonJpEquipmentThreshold> CommonJpEquipmentThreshold { get; set; }
        public virtual DbSet<CommonJpUser> CommonJpUser { get; set; }
        public virtual DbSet<Dept> Dept { get; set; }
        public virtual DbSet<Dict> Dict { get; set; }
        public virtual DbSet<DictDetail> DictDetail { get; set; }
        public virtual DbSet<Menu> Menu { get; set; }
        public virtual DbSet<QuartzJob> QuartzJob { get; set; }
        public virtual DbSet<Role> Role { get; set; }
        public virtual DbSet<RolesMenus> RolesMenus { get; set; }
        public virtual DbSet<UsersRoles> UsersRoles { get; set; }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<BaseJpCabinet>(entity =>
            {
                entity.ToTable("base_jp_cabinet");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.BuyTime)
                    .HasColumnName("buy_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.CabinetChildNum).HasColumnName("cabinet_child_num");

                entity.Property(e => e.CabinetNum)
                    .IsRequired()
                    .HasColumnName("cabinet_num")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CabinetRealNum)
                    .IsRequired()
                    .HasColumnName("cabinet_real_num")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Location)
                    .HasColumnName("location")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.OrganizationId)
                    .HasColumnName("organization_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.ShortName)
                    .HasColumnName("short_name")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.State).HasColumnName("state");

                entity.Property(e => e.Type).HasColumnName("type");

                entity.Property(e => e.UseTime)
                    .HasColumnName("use_time")
                    .HasColumnType("datetime");

                entity.HasOne(d => d.Organization)
                    .WithMany(p => p.BaseJpCabinet)
                    .HasForeignKey(d => d.OrganizationId)
                    .HasConstraintName("base_jp_cabinet_ibfk_1");
            });

            modelBuilder.Entity<BaseJpEquipmentDetail>(entity =>
            {
                entity.ToTable("base_jp_equipment_detail");

                entity.HasIndex(e => e.Code)
                    .HasName("UQ__base_jp___357D4CF97AE516C8")
                    .IsUnique();

                entity.HasIndex(e => new { e.Name, e.Id })
                    .HasName("_dta_index_base_jp_equipment_detail_8_773577794__K1_4");

                entity.HasIndex(e => new { e.EquipmentId, e.Name, e.Id })
                    .HasName("_dta_index_base_jp_equipment_detail_8_773577794__K1_3_4");

                entity.HasIndex(e => new { e.Id, e.Sort, e.EquipmentId, e.Name, e.Type, e.Unit, e.Note, e.State, e.CreateTime, e.UpdateTime, e.UpdateUser, e.Code })
                    .HasName("_dta_index_base_jp_equipment_detail_8_773577794__col__");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Code)
                    .HasColumnName("code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.EquipmentId)
                    .IsRequired()
                    .HasColumnName("equipment_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.Note)
                    .HasColumnName("note")
                    .HasMaxLength(500)
                    .IsUnicode(false);

                entity.Property(e => e.State)
                    .HasColumnName("state")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Type)
                    .HasColumnName("type")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Unit)
                    .HasColumnName("unit")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.UnitType)
                    .HasColumnName("unit_type")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("物资单位");

                entity.Property(e => e.UpdateTime)
                    .HasColumnName("update_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.UpdateUser)
                    .IsRequired()
                    .HasColumnName("update_user")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.HasOne(d => d.Equipment)
                    .WithMany(p => p.BaseJpEquipmentDetail)
                    .HasForeignKey(d => d.EquipmentId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("base_jp_equipment_detail_ibfk_1");
            });

            modelBuilder.Entity<BaseJpEquipmentInfo>(entity =>
            {
                entity.ToTable("base_jp_equipment_info");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.UpdateTime)
                    .HasColumnName("update_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.UpdateUser)
                    .HasColumnName("update_user")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.HasOne(d => d.Parent)
                    .WithMany(p => p.InverseParent)
                    .HasForeignKey(d => d.ParentId)
                    .HasConstraintName("KD_PAREINT_ID");
            });

            modelBuilder.Entity<BaseJpEquipmentSize>(entity =>
            {
                entity.ToTable("base_jp_equipment_size");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.DetailId)
                    .HasColumnName("detail_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.EpcType).HasColumnName("epc_type");

                entity.Property(e => e.Note)
                    .HasColumnName("note")
                    .HasMaxLength(500)
                    .IsUnicode(false);

                entity.Property(e => e.SizeCode).HasColumnName("size_code");

                entity.Property(e => e.SizeName)
                    .HasColumnName("size_name")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.UpdateTime)
                    .HasColumnName("update_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.UpdateUser)
                    .HasColumnName("update_user")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.HasOne(d => d.Detail)
                    .WithMany(p => p.BaseJpEquipmentSize)
                    .HasForeignKey(d => d.DetailId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("base_jp_equipment_size_ibfk_1");
            });

            modelBuilder.Entity<BaseJpOrganization>(entity =>
            {
                entity.ToTable("base_jp_organization");

                entity.HasIndex(e => e.State)
                    .HasName("_dta_index_base_jp_organization_8_837578022__K8");

                entity.HasIndex(e => new { e.Code, e.State })
                    .HasName("_dta_index_base_jp_organization_8_837578022__K3D_K8");

                entity.HasIndex(e => new { e.State, e.Code })
                    .HasName("_dta_index_base_jp_organization_8_837578022__K8_K3D");

                entity.HasIndex(e => new { e.AreaName, e.CreateTime, e.FindCode, e.Id, e.Name, e.NameJc, e.ParentId, e.UpdateTime, e.State, e.Code })
                    .HasName("_dta_index_base_jp_organization_8_837578022__K8_K3_1_2_4_5_6_7_9_10_8066");

                entity.HasIndex(e => new { e.Id, e.Name, e.CreateTime, e.UpdateTime, e.FindCode, e.AreaName, e.ParentId, e.NameJc, e.Code, e.State })
                    .HasName("_dta_index_base_jp_organization_8_837578022__K3D_K8_1_2_4_5_6_7_9_10");

                entity.HasIndex(e => new { e.Id, e.Name, e.CreateTime, e.UpdateTime, e.FindCode, e.AreaName, e.ParentId, e.NameJc, e.State, e.Code })
                    .HasName("_dta_index_base_jp_organization_8_837578022__K8_K3D_1_2_4_5_6_7_9_10");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.AreaName)
                    .HasColumnName("area_name")
                    .HasMaxLength(128)
                    .IsUnicode(false);

                entity.Property(e => e.Code)
                    .IsRequired()
                    .HasColumnName("code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.DName)
                    .HasColumnName("d_name")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.FindCode)
                    .HasColumnName("find_code")
                    .HasMaxLength(10)
                    .IsUnicode(false);

                entity.Property(e => e.IsMap)
                    .HasColumnName("is_map")
                    .HasDefaultValueSql("((0))")
                    .HasComment("是否在地图上");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.NameJc)
                    .HasColumnName("name_jc")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.OrderCount)
                    .HasColumnName("order_count")
                    .HasComment("打印单据数量");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Show)
                    .HasColumnName("show")
                    .HasMaxLength(10)
                    .IsUnicode(false)
                    .HasComment("派出所是否有采购权利");

                entity.Property(e => e.State).HasColumnName("state");

                entity.Property(e => e.UpdateTime)
                    .HasColumnName("update_time")
                    .HasColumnType("datetime");
            });

            modelBuilder.Entity<BaseJpPoliceman>(entity =>
            {
                entity.ToTable("base_jp_policeman");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CabinetId)
                    .HasColumnName("cabinet_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CardNo)
                    .HasColumnName("cardNo")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("卡号");

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.FaceInfo)
                    .HasColumnName("face_info")
                    .HasColumnType("text");

                entity.Property(e => e.FingerInfo1)
                    .HasColumnName("finger_info1")
                    .HasColumnType("text");

                entity.Property(e => e.FingerInfo2)
                    .HasColumnName("finger_info2")
                    .HasColumnType("text");

                entity.Property(e => e.IsCreatedAccount).HasComment("是否已创建账户");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.OrgizationCode)
                    .HasColumnName("orgization_code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Password)
                    .HasColumnName("password")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.Phone)
                    .IsRequired()
                    .HasColumnName("phone")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Photo)
                    .HasColumnName("photo")
                    .HasMaxLength(128)
                    .IsUnicode(false);

                entity.Property(e => e.PoliceCode)
                    .IsRequired()
                    .HasColumnName("police_code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Sex)
                    .HasColumnName("sex")
                    .HasMaxLength(3)
                    .IsUnicode(false);

                entity.Property(e => e.UpdateTime)
                    .HasColumnName("update_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.UpdateUser)
                    .IsRequired()
                    .HasColumnName("update_user")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.HasOne(d => d.Cabinet)
                    .WithMany(p => p.BaseJpPoliceman)
                    .HasForeignKey(d => d.CabinetId)
                    .HasConstraintName("base_jp_policeman_ibfk_2");

                entity.HasOne(d => d.OrgizationCodeNavigation)
                    .WithMany(p => p.BaseJpPoliceman)
                    .HasForeignKey(d => d.OrgizationCode)
                    .HasConstraintName("base_jp_policeman_ibfk_1");
            });

            modelBuilder.Entity<BaseJpProcess>(entity =>
            {
                entity.ToTable("base_jp_process");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(32)
                    .IsUnicode(false);

                entity.Property(e => e.Code)
                    .HasColumnName("code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.Description)
                    .HasColumnName("description")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.OrgId)
                    .HasColumnName("org_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.ProcessXml)
                    .HasColumnName("process_xml")
                    .HasColumnType("text");

                entity.Property(e => e.PublishStatus).HasColumnName("publish_status");

                entity.Property(e => e.UpdateTime)
                    .HasColumnName("update_time")
                    .HasColumnType("datetime");
            });

            modelBuilder.Entity<BaseJpShelfInfo>(entity =>
            {
                entity.ToTable("base_jp_shelf_info");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Code)
                    .HasColumnName("code")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("货架编号");

                entity.Property(e => e.Column)
                    .HasColumnName("column")
                    .HasComment("单层货架列数");

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime")
                    .HasComment("创建时间");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("货架名称");

                entity.Property(e => e.Range)
                    .HasColumnName("range")
                    .HasComment("货架排数（智能货架多货架拼接）");

                entity.Property(e => e.Row)
                    .HasColumnName("row")
                    .HasComment("货架层数");

                entity.Property(e => e.ShelfSize)
                    .HasColumnName("shelf_size")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("货架尺寸");

                entity.Property(e => e.Type)
                    .HasColumnName("type")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment(@"货架类型
Normal:普通货架
Smart:智能货架
");

                entity.Property(e => e.Url)
                    .HasColumnName("url")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("智能货架url");

                entity.Property(e => e.WarehouseId)
                    .HasColumnName("warehouseId")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("仓库id");

                entity.HasOne(d => d.Warehouse)
                    .WithMany(p => p.BaseJpShelfInfo)
                    .HasForeignKey(d => d.WarehouseId)
                    .HasConstraintName("FK__base_jp_s__wareh__05F8DC4F");
            });

            modelBuilder.Entity<BaseJpSupplier>(entity =>
            {
                entity.ToTable("base_jp_supplier");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Contacts)
                    .HasColumnName("contacts")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.Phone)
                    .HasColumnName("phone")
                    .HasMaxLength(20)
                    .IsUnicode(false);

                entity.Property(e => e.ShortName)
                    .HasColumnName("short_name")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.SupplierCode)
                    .HasColumnName("supplier_code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.UpdateTime)
                    .HasColumnName("update_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.UpdateUser)
                    .HasColumnName("update_user")
                    .HasMaxLength(64)
                    .IsUnicode(false);
            });

            modelBuilder.Entity<BaseJpSupplierEquipment>(entity =>
            {
                entity.HasKey(e => new { e.SupplierCode, e.EquipmentId });

                entity.ToTable("base_jp_supplier_equipment");

                entity.HasIndex(e => new { e.Id, e.Sort, e.SupplierCode, e.EquipmentId, e.State, e.UselessUint, e.UselessTime, e.CreateTime, e.UpdateTime, e.UpdateUser, e.Num })
                    .HasName("_dta_index_base_jp_supplier_equipment_8_917578307__col__");

                entity.Property(e => e.SupplierCode)
                    .HasColumnName("supplier_code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.EquipmentId)
                    .HasColumnName("equipment_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.Id)
                    .IsRequired()
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Num)
                    .HasColumnName("num")
                    .HasDefaultValueSql("((0))");

                entity.Property(e => e.State).HasColumnName("state");

                entity.Property(e => e.UpdateTime)
                    .HasColumnName("update_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.UpdateUser)
                    .IsRequired()
                    .HasColumnName("update_user")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.UselessTime).HasColumnName("useless_time");

                entity.Property(e => e.UselessUint)
                    .HasColumnName("useless_uint")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.HasOne(d => d.Equipment)
                    .WithMany(p => p.BaseJpSupplierEquipment)
                    .HasForeignKey(d => d.EquipmentId)
                    .HasConstraintName("FK_base_jp_supplier_equipment_base_jp_equipment_detail");

                entity.HasOne(d => d.SupplierCodeNavigation)
                    .WithMany(p => p.BaseJpSupplierEquipment)
                    .HasForeignKey(d => d.SupplierCode)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK_base_jp_supplier_equipment_base_jp_supplier");
            });

            modelBuilder.Entity<BaseJpWarehouse>(entity =>
            {
                entity.ToTable("base_jp_warehouse");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CameraUrl)
                    .HasColumnName("camera_url")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("摄像头地址");

                entity.Property(e => e.ChannelReadEquTypeJson)
                    .HasColumnName("channel_read_equ_type_json")
                    .HasColumnType("text")
                    .HasComment("通道读取装备类型json");

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.IsEnableChannelReadEqu)
                    .HasColumnName("is_enable_channel_read_equ")
                    .HasComment("是否启用通道读取指定类型装备");

                entity.Property(e => e.IsLocked)
                    .HasColumnName("is_locked")
                    .HasDefaultValueSql("((0))")
                    .HasComment("是否锁库，0：未锁库，1：锁库中");

                entity.Property(e => e.Location)
                    .HasColumnName("location")
                    .HasMaxLength(128)
                    .IsUnicode(false);

                entity.Property(e => e.LocationDetail)
                    .HasColumnName("location_detail")
                    .HasMaxLength(128)
                    .IsUnicode(false);

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.OrgizationId)
                    .IsRequired()
                    .HasColumnName("orgization_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Phone)
                    .HasColumnName("phone")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.UpdateTime)
                    .HasColumnName("update_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.UpdateUser)
                    .HasColumnName("update_user")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.HasOne(d => d.Orgization)
                    .WithMany(p => p.BaseJpWarehouse)
                    .HasForeignKey(d => d.OrgizationId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("base_jp_warehouse_ibfk_1");
            });

            modelBuilder.Entity<CommonJpChannelCfgV2>(entity =>
            {
                entity.ToTable("common_jp_channel_cfg_v2");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Code)
                    .HasColumnName("code")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("通道编号");

                entity.Property(e => e.CreateTime)
                    .HasColumnName("createTime")
                    .HasColumnType("datetime")
                    .HasComment("创建时间");

                entity.Property(e => e.CurrentState)
                    .HasColumnName("currentState")
                    .HasComment("通道状态");

                entity.Property(e => e.FaceConfigJson)
                    .HasColumnName("faceConfigJson")
                    .HasColumnType("text")
                    .HasComment("门禁机配置json");

                entity.Property(e => e.FilterTime)
                    .HasColumnName("filterTime")
                    .HasComment("过滤时间（单位 秒 所有读写器共用）");

                entity.Property(e => e.Location)
                    .HasColumnName("location")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("位置");

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("通道名称");

                entity.Property(e => e.ReaderConfigJson)
                    .HasColumnName("readerConfigJson")
                    .HasColumnType("text")
                    .HasComment("读写器配置json");

                entity.Property(e => e.UpdateUser)
                    .HasColumnName("updateUser")
                    .HasMaxLength(100)
                    .IsUnicode(false)
                    .HasComment("更新用户");

                entity.Property(e => e.WarehouseId)
                    .HasColumnName("warehouseId")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("仓库id");

                entity.HasOne(d => d.Warehouse)
                    .WithMany(p => p.CommonJpChannelCfgV2)
                    .HasForeignKey(d => d.WarehouseId)
                    .HasConstraintName("FK__common_jp__wareh__7B4643B2");
            });

            modelBuilder.Entity<CommonJpEquipmentInventory>(entity =>
            {
                entity.HasKey(e => e.Id);

                entity.ToTable("common_jp_equipment_inventory");

                entity.HasIndex(e => e.Id)
                    .HasName("NonClusteredIndex-20200901-104052")
                    .IsUnique();

                entity.HasIndex(e => e.WarehouseCode)
                    .HasName("ClusteredIndex-20200901-100012");

                entity.HasIndex(e => new { e.WarehouseCode, e.EquipmentSizecode })
                    .HasName("_dta_index_common_jp_equipment_inventory_8_1109578991__K8_K10");

                entity.HasIndex(e => new { e.Id, e.Epc, e.CurrentState })
                    .HasName("_dta_index_common_jp_equipment_inventory_8_1109578991__K1_K4_K12");

                entity.HasIndex(e => new { e.WarehouseCode, e.Id, e.EquipmentSizecode })
                    .HasName("_dta_index_common_jp_equipment_inventory_8_1109578991__K8_K1_K10");

                entity.HasIndex(e => new { e.Id, e.WarrantyCycle, e.UseTime, e.WarehouseCode, e.EquipmentSizecode, e.EquipmentCode, e.SupplierCode })
                    .HasName("_dta_index_common_jp_equipment_inventory_8_1109578991__K20_K23_K8_K10_K6_K3_1");

                entity.HasIndex(e => new { e.Id, e.WarrantyCycle, e.WarehouseCode, e.UseTime, e.EquipmentSizecode, e.EquipmentCode, e.SupplierCode })
                    .HasName("_dta_index_common_jp_equipment_inventory_8_1109578991__K20_K8_K23_K10_K6_K3_1");

                entity.HasIndex(e => new { e.Id, e.SupplierCode, e.WarrantyCycle, e.UseTime, e.EquipmentCode, e.WarehouseCode, e.CabinetId, e.EquipmentSizecode, e.CurrentState })
                    .HasName("_dta_index_common_jp_equipment_inventory_8_1109578991__K6_K8_K9_K10_K12_1_3_20_23");

                entity.HasIndex(e => new { e.Sort, e.SupplierCode, e.Epc, e.PoliceCode, e.EquipmentCode, e.Wzdm, e.CabinetId, e.EquipmentSizecode, e.EquipmentLocation, e.OutTime, e.ReturnTime, e.CreateTime, e.FirstUseTime, e.FixCount, e.CreateUser, e.UpdateUser, e.WarrantyCycle, e.RepairCycle, e.ProductTime, e.UseTime, e.Price, e.UseDirection, e.CurrentState, e.Id, e.WarehouseCode })
                    .HasName("_dta_index_common_jp_equipment_inventory_8_1109578991__K12_K1_K8_2_3_4_5_6_7_9_10_11_13_14_15_16_17_18_19_20_21_22_23_24_25");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Address)
                    .HasColumnName("address")
                    .HasMaxLength(50);

                entity.Property(e => e.BagInventoryId)
                    .HasColumnName("bag_inventory_id")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("装备包实例id");

                entity.Property(e => e.BoxMarkId)
                    .HasColumnName("box_mark_id")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("箱标id");

                entity.Property(e => e.CabinetId)
                    .HasColumnName("cabinet_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.CreateUser)
                    .IsRequired()
                    .HasColumnName("create_user")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.CurrentState).HasColumnName("current_state");

                entity.Property(e => e.Epc)
                    .HasColumnName("epc")
                    .HasMaxLength(128)
                    .IsUnicode(false);

                entity.Property(e => e.EquipmentCode)
                    .IsRequired()
                    .HasColumnName("equipment_code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.EquipmentLocation).HasColumnName("equipment_location");

                entity.Property(e => e.EquipmentSizecode)
                    .IsRequired()
                    .HasColumnName("equipment_sizecode")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.FirstUseTime)
                    .HasColumnName("first_use_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.FixCount).HasColumnName("fix_count");

                entity.Property(e => e.InstantiationState)
                    .HasColumnName("instantiation_state")
                    .HasComment(@"标签实例化状态（打印or绑定过）
0：其他
1：未打印
2：已打印");

                entity.Property(e => e.InventoryState)
                    .HasColumnName("inventory_state")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasDefaultValueSql("('normal')")
                    .HasComment("normal:正常状态,loss:盘亏,profit :盘盈");

                entity.Property(e => e.IsBorrowed)
                    .HasColumnName("is_borrowed")
                    .HasDefaultValueSql("((0))");

                entity.Property(e => e.IsInBox)
                    .HasColumnName("isInBox")
                    .HasDefaultValueSql("((0))")
                    .HasComment("是否在箱内（箱标未拆箱）");

                entity.Property(e => e.LostFlag)
                    .HasColumnName("lostFlag")
                    .HasDefaultValueSql("((0))");

                entity.Property(e => e.OutTime)
                    .HasColumnName("out_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.PoliceCode)
                    .HasColumnName("police_code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Price)
                    .HasColumnName("price")
                    .HasColumnType("decimal(10, 2)");

                entity.Property(e => e.ProductTime)
                    .HasColumnName("productTime")
                    .HasColumnType("datetime");

                entity.Property(e => e.RepairCycle).HasColumnName("repairCycle");

                entity.Property(e => e.ReturnTime)
                    .HasColumnName("return_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.SafeLevel)
                    .HasColumnName("safe_level")
                    .HasDefaultValueSql("((0))")
                    .HasComment(@"安全等级
0：安全
1：即将过期
2：已过期");

                entity.Property(e => e.ShelfColumn)
                    .HasColumnName("shelf_column")
                    .HasComment("货架位置：列");

                entity.Property(e => e.ShelfId)
                    .HasColumnName("shelfId")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("货架id");

                entity.Property(e => e.ShelfRange)
                    .HasColumnName("shelf_range")
                    .HasComment("货架位置：排");

                entity.Property(e => e.ShelfRow)
                    .HasColumnName("shelf_row")
                    .HasComment("货架位置：行");

                entity.Property(e => e.SupplierCode)
                    .HasColumnName("supplier_code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.ThirdCode)
                    .HasColumnName("third_code")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("第三方code（判重用）");

                entity.Property(e => e.UpdateUser)
                    .IsRequired()
                    .HasColumnName("update_user")
                    .HasMaxLength(64)
                    .IsUnicode(false);

                entity.Property(e => e.UseDirection).HasColumnName("useDirection");

                entity.Property(e => e.UseTime)
                    .HasColumnName("useTime")
                    .HasColumnType("datetime");

                entity.Property(e => e.WarehouseCode)
                    .HasColumnName("warehouse_code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.WarrantyCycle).HasColumnName("warrantyCycle");

                entity.Property(e => e.Wzdm)
                    .HasColumnName("wzdm")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.HasOne(d => d.Cabinet)
                    .WithMany(p => p.CommonJpEquipmentInventory)
                    .HasForeignKey(d => d.CabinetId)
                    .HasConstraintName("common_jp_equipment_inventory_ibfk_6");

                entity.HasOne(d => d.EquipmentCodeNavigation)
                    .WithMany(p => p.CommonJpEquipmentInventory)
                    .HasForeignKey(d => d.EquipmentCode)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("common_jp_equipment_inventory_ibfk_3");

                entity.HasOne(d => d.EquipmentSizecodeNavigation)
                    .WithMany(p => p.CommonJpEquipmentInventory)
                    .HasForeignKey(d => d.EquipmentSizecode)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("common_jp_equipment_inventory_ibfk_5");

                entity.HasOne(d => d.PoliceCodeNavigation)
                    .WithMany(p => p.CommonJpEquipmentInventory)
                    .HasForeignKey(d => d.PoliceCode)
                    .HasConstraintName("FK__common_jp__polic__6A1BB7B0");

                entity.HasOne(d => d.Shelf)
                    .WithMany(p => p.CommonJpEquipmentInventory)
                    .HasForeignKey(d => d.ShelfId)
                    .HasConstraintName("FK__common_jp__shelf__06ED0088");

                entity.HasOne(d => d.SupplierCodeNavigation)
                    .WithMany(p => p.CommonJpEquipmentInventory)
                    .HasForeignKey(d => d.SupplierCode)
                    .HasConstraintName("common_jp_equipment_inventory_ibfk_1");

                entity.HasOne(d => d.WarehouseCodeNavigation)
                    .WithMany(p => p.CommonJpEquipmentInventory)
                    .HasForeignKey(d => d.WarehouseCode)
                    .HasConstraintName("common_jp_equipment_inventory_ibfk_4");
            });

            modelBuilder.Entity<CommonJpEquipmentState>(entity =>
            {
                entity.HasKey(e => e.Id);

                entity.ToTable("common_jp_equipment_state");

                entity.HasIndex(e => e.CreateTime)
                    .HasName("ClusteredIndex-20201113-135343");

                entity.HasIndex(e => e.Id)
                    .HasName("NonClusteredIndex-20200901-104118")
                    .IsUnique();

                entity.HasIndex(e => new { e.OutInState, e.ActionState })
                    .HasName("NonClusteredIndex-20201113-125142");

                entity.HasIndex(e => new { e.ActionState, e.State, e.OutTime, e.EqiupmentId, e.ErrorEpc, e.ParentId, e.OrgId })
                    .HasName("_dta_index_common_jp_equipment_state_8_1125579048__K19_K5_K15_K3");

                entity.HasIndex(e => new { e.Id, e.Sort, e.EqiupmentId, e.OutInState, e.State, e.WarehouseId, e.OrgId, e.BorrowId, e.CabinetIdInto, e.CabinetIdOut, e.ErrorEpc, e.PurchaseId, e.TransferId, e.FixId, e.OutTime, e.PoliceId, e.IntoTime, e.CreateTime, e.ActionState, e.PicUrl, e.ParentId })
                    .HasName("_dta_index_common_jp_equipment_state_8_1125579048__col__");

                entity.HasIndex(e => new { e.Sort, e.OutInState, e.State, e.WarehouseId, e.OrgId, e.BorrowId, e.CabinetIdInto, e.CabinetIdOut, e.ErrorEpc, e.PurchaseId, e.TransferId, e.FixId, e.OutTime, e.PoliceId, e.IntoTime, e.CreateTime, e.ActionState, e.PicUrl, e.ParentId, e.EqiupmentId, e.Id })
                    .HasName("_dta_index_common_jp_equipment_state_8_1125579048__K3_K1_2_4_5_6_7_8_9_10_11_12_13_14_15_16_17_18_19_20_21");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.ActionState).HasColumnName("action_state");

                entity.Property(e => e.BagInventoryId)
                    .HasColumnName("bag_inventory_id")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("包实例id");

                entity.Property(e => e.BorrowId)
                    .HasColumnName("borrow_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CabinetIdInto)
                    .HasColumnName("cabinet_id_into")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CabinetIdIntoName)
                    .HasColumnName("cabinet_id_into_name")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("入库单警柜名称");

                entity.Property(e => e.CabinetIdOut)
                    .HasColumnName("cabinet_id_out")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CabinetIdOutName)
                    .HasColumnName("cabinet_id_out_name")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("出库单警柜名称");

                entity.Property(e => e.CreateTime)
                    .HasColumnName("createTime")
                    .HasColumnType("datetime");

                entity.Property(e => e.EqiupmentId)
                    .HasColumnName("eqiupment_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.ErrorEpc)
                    .HasColumnName("error_Epc")
                    .HasMaxLength(128)
                    .IsUnicode(false);

                entity.Property(e => e.FixId)
                    .HasColumnName("fix_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.HistorySafeLevel)
                    .HasColumnName("history_safe_level")
                    .HasDefaultValueSql("((0))")
                    .HasComment(@"历史安全等级
0：安全
1：即将过期
2：已过期");

                entity.Property(e => e.IntoTime)
                    .HasColumnName("intoTime")
                    .HasColumnType("datetime");

                entity.Property(e => e.MissionModelId)
                    .HasColumnName("mission_model_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Note)
                    .HasColumnName("note")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.OrderCode)
                    .HasColumnName("order_code")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.OrgId)
                    .HasColumnName("org_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.OutInState).HasColumnName("out_in_state");

                entity.Property(e => e.OutTime)
                    .HasColumnName("outTime")
                    .HasColumnType("datetime");

                entity.Property(e => e.ParentId)
                    .HasColumnName("parent_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.PicUrl)
                    .HasColumnName("pic_url")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.PoliceId)
                    .HasColumnName("police_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.PurchaseId)
                    .HasColumnName("purchase_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.ReturnId)
                    .HasColumnName("return_id")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("装备回库id");

                entity.Property(e => e.State).HasColumnName("state");

                entity.Property(e => e.ThirdBaseOrgId)
                    .HasColumnName("third_base_org_id")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("自建平台基础orgid");

                entity.Property(e => e.ThirdStateId)
                    .HasColumnName("third_state_id")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("自建平台内stateid");

                entity.Property(e => e.TransferId)
                    .HasColumnName("transfer_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.WarehouseId)
                    .HasColumnName("warehouse_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.HasOne(d => d.CabinetIdIntoNavigation)
                    .WithMany(p => p.CommonJpEquipmentStateCabinetIdIntoNavigation)
                    .HasForeignKey(d => d.CabinetIdInto)
                    .HasConstraintName("common_jp_equipment_state_ibfk_6");

                entity.HasOne(d => d.CabinetIdOutNavigation)
                    .WithMany(p => p.CommonJpEquipmentStateCabinetIdOutNavigation)
                    .HasForeignKey(d => d.CabinetIdOut)
                    .HasConstraintName("common_jp_equipment_state_ibfk_4");

                entity.HasOne(d => d.Eqiupment)
                    .WithMany(p => p.CommonJpEquipmentState)
                    .HasForeignKey(d => d.EqiupmentId)
                    .OnDelete(DeleteBehavior.Cascade)
                    .HasConstraintName("FK_common_jp_equipment_state_common_jp_equipment_inventory");

                entity.HasOne(d => d.Org)
                    .WithMany(p => p.CommonJpEquipmentState)
                    .HasForeignKey(d => d.OrgId)
                    .HasConstraintName("common_jp_equipment_state_ibfk_8");

                entity.HasOne(d => d.Police)
                    .WithMany(p => p.CommonJpEquipmentState)
                    .HasForeignKey(d => d.PoliceId)
                    .HasConstraintName("common_jp_equipment_state_ibfk_9");

                entity.HasOne(d => d.Warehouse)
                    .WithMany(p => p.CommonJpEquipmentState)
                    .HasForeignKey(d => d.WarehouseId)
                    .HasConstraintName("common_jp_equipment_state_ibfk_7");
            });

            modelBuilder.Entity<CommonJpEquipmentThreshold>(entity =>
            {
                entity.ToTable("common_jp_equipment_threshold");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.EquipmentDetailId)
                    .IsRequired()
                    .HasColumnName("equipment_detail_id")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("装备细类id");

                entity.Property(e => e.EquipmentSizeId)
                    .IsRequired()
                    .HasColumnName("equipment_size_id")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("装备型号id");

                entity.Property(e => e.IsEnabled)
                    .HasColumnName("is_enabled")
                    .HasComment("是否启用");

                entity.Property(e => e.OrgId)
                    .IsRequired()
                    .HasColumnName("org_id")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("组织机构id");

                entity.Property(e => e.ScopeType)
                    .IsRequired()
                    .HasColumnName("scope_type")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment(@"范围类型
Organization ：组织机构
Warehouse：仓库");

                entity.Property(e => e.ThresholdCount)
                    .HasColumnName("threshold_count")
                    .HasComment("阈值");

                entity.Property(e => e.WarehouseId)
                    .HasColumnName("warehouse_id")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("仓库id");

                entity.HasOne(d => d.EquipmentDetail)
                    .WithMany(p => p.CommonJpEquipmentThreshold)
                    .HasForeignKey(d => d.EquipmentDetailId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK__common_jp__equip__4D4A6ED8");

                entity.HasOne(d => d.EquipmentSize)
                    .WithMany(p => p.CommonJpEquipmentThreshold)
                    .HasForeignKey(d => d.EquipmentSizeId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK__common_jp__equip__4E3E9311");

                entity.HasOne(d => d.Org)
                    .WithMany(p => p.CommonJpEquipmentThreshold)
                    .HasForeignKey(d => d.OrgId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("FK__common_jp__org_i__4F32B74A");

                entity.HasOne(d => d.Warehouse)
                    .WithMany(p => p.CommonJpEquipmentThreshold)
                    .HasForeignKey(d => d.WarehouseId)
                    .HasConstraintName("FK__common_jp__wareh__5303482E");
            });

            modelBuilder.Entity<CommonJpUser>(entity =>
            {
                entity.ToTable("common_jp_user");

                entity.Property(e => e.Id)
                    .HasColumnName("id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.AvatarId).HasColumnName("avatar_id");

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.DeptId).HasColumnName("dept_id");

                entity.Property(e => e.Email)
                    .HasColumnName("email")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Enabled).HasColumnName("enabled");

                entity.Property(e => e.JobId).HasColumnName("job_id");

                entity.Property(e => e.LastPasswordResetTime)
                    .HasColumnName("last_password_reset_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.NickName)
                    .HasColumnName("nick_name")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.OrganizationId)
                    .HasColumnName("organization_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Password)
                    .HasColumnName("password")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Phone)
                    .HasColumnName("phone")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.PoliceId)
                    .HasColumnName("police_id")
                    .HasMaxLength(36)
                    .IsUnicode(false)
                    .HasComment("警员id");

                entity.Property(e => e.Sex)
                    .HasColumnName("sex")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.Sfzh)
                    .HasColumnName("sfzh")
                    .HasMaxLength(255)
                    .IsUnicode(false)
                    .HasComment("身份证号");

                entity.Property(e => e.Token)
                    .HasColumnName("token")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Username)
                    .HasColumnName("username")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.HasOne(d => d.Dept)
                    .WithMany(p => p.CommonJpUser)
                    .HasForeignKey(d => d.DeptId)
                    .HasConstraintName("common_jp_user_ibfk_1");

                entity.HasOne(d => d.Organization)
                    .WithMany(p => p.CommonJpUser)
                    .HasForeignKey(d => d.OrganizationId)
                    .HasConstraintName("common_jp_user_ibfk_4");

                entity.HasOne(d => d.Police)
                    .WithMany(p => p.CommonJpUser)
                    .HasForeignKey(d => d.PoliceId)
                    .HasConstraintName("FK__common_jp__polic__7869D707");
            });

            modelBuilder.Entity<Dept>(entity =>
            {
                entity.ToTable("dept");

                entity.Property(e => e.Id).HasColumnName("id");

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.Enabled).HasColumnName("enabled");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Pid).HasColumnName("pid");
            });

            modelBuilder.Entity<Dict>(entity =>
            {
                entity.ToTable("dict");

                entity.Property(e => e.Id).HasColumnName("id");

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Remark)
                    .HasColumnName("remark")
                    .HasMaxLength(255)
                    .IsUnicode(false);
            });

            modelBuilder.Entity<DictDetail>(entity =>
            {
                entity.ToTable("dict_detail");

                entity.Property(e => e.Id).HasColumnName("id");

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.DictId).HasColumnName("dict_id");

                entity.Property(e => e.Label)
                    .IsRequired()
                    .HasColumnName("label")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Sort)
                    .HasColumnName("sort")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Value)
                    .IsRequired()
                    .HasColumnName("value")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.HasOne(d => d.Dict)
                    .WithMany(p => p.DictDetail)
                    .HasForeignKey(d => d.DictId)
                    .HasConstraintName("dict_detail_ibfk_1");
            });

            modelBuilder.Entity<Menu>(entity =>
            {
                entity.ToTable("menu");

                entity.Property(e => e.Id).HasColumnName("id");

                entity.Property(e => e.Cache).HasColumnName("cache");

                entity.Property(e => e.Component)
                    .HasColumnName("component")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.ComponentName)
                    .HasColumnName("component_name")
                    .HasMaxLength(200)
                    .IsUnicode(false);

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.Hidden).HasColumnName("hidden");

                entity.Property(e => e.IFrame).HasColumnName("i_frame");

                entity.Property(e => e.Icon)
                    .HasColumnName("icon")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Name)
                    .HasColumnName("name")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Path)
                    .HasColumnName("path")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Permission)
                    .HasColumnName("permission")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Pid).HasColumnName("pid");

                entity.Property(e => e.Sort).HasColumnName("sort");

                entity.Property(e => e.Type).HasColumnName("type");
            });

            modelBuilder.Entity<QuartzJob>(entity =>
            {
                entity.ToTable("quartz_job");

                entity.Property(e => e.Id).HasColumnName("id");

                entity.Property(e => e.BeanName)
                    .HasColumnName("bean_name")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.CronExpression)
                    .HasColumnName("cron_expression")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.IsPause).HasColumnName("is_pause");

                entity.Property(e => e.JobName)
                    .HasColumnName("job_name")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.MethodName)
                    .HasColumnName("method_name")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Params)
                    .HasColumnName("params")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Remark)
                    .HasColumnName("remark")
                    .HasMaxLength(255)
                    .IsUnicode(false);
            });

            modelBuilder.Entity<Role>(entity =>
            {
                entity.ToTable("role");

                entity.Property(e => e.Id).HasColumnName("id");

                entity.Property(e => e.CreateTime)
                    .HasColumnName("create_time")
                    .HasColumnType("datetime");

                entity.Property(e => e.DataScope)
                    .HasColumnName("data_scope")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Level).HasColumnName("level");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Permission)
                    .HasColumnName("permission")
                    .HasMaxLength(255)
                    .IsUnicode(false);

                entity.Property(e => e.Remark)
                    .HasColumnName("remark")
                    .HasMaxLength(255)
                    .IsUnicode(false);
            });

            modelBuilder.Entity<RolesMenus>(entity =>
            {
                entity.HasKey(e => new { e.MenuId, e.RoleId })
                    .HasName("PK__roles_me__9BC06C802A16A570");

                entity.ToTable("roles_menus");

                entity.Property(e => e.MenuId).HasColumnName("menu_id");

                entity.Property(e => e.RoleId).HasColumnName("role_id");

                entity.HasOne(d => d.Menu)
                    .WithMany(p => p.RolesMenus)
                    .HasForeignKey(d => d.MenuId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("roles_menus_ibfk_1");

                entity.HasOne(d => d.Role)
                    .WithMany(p => p.RolesMenus)
                    .HasForeignKey(d => d.RoleId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("roles_menus_ibfk_2");
            });

            modelBuilder.Entity<UsersRoles>(entity =>
            {
                entity.HasKey(e => new { e.UserId, e.RoleId })
                    .HasName("PK__users_ro__6EDEA1538888BC81");

                entity.ToTable("users_roles");

                entity.Property(e => e.UserId)
                    .HasColumnName("user_id")
                    .HasMaxLength(36)
                    .IsUnicode(false);

                entity.Property(e => e.RoleId).HasColumnName("role_id");

                entity.HasOne(d => d.Role)
                    .WithMany(p => p.UsersRoles)
                    .HasForeignKey(d => d.RoleId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("users_roles_ibfk_1");

                entity.HasOne(d => d.User)
                    .WithMany(p => p.UsersRoles)
                    .HasForeignKey(d => d.UserId)
                    .OnDelete(DeleteBehavior.ClientSetNull)
                    .HasConstraintName("users_roles_ibfk_2");
            });

            OnModelCreatingPartial(modelBuilder);
        }

        partial void OnModelCreatingPartial(ModelBuilder modelBuilder);
    }
}