using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.IO.Pipes;
using System.Linq;
using System.Linq.Expressions;
using System.Security.Principal;
using System.Threading;
using System.Threading.Tasks;
using Fleck;
using JmpCommon;
using JmpModel.Model;
using JmpModel.Model.DataContext;
using JmpModel.Model.Repository;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json.Linq;
using NLog;

namespace JmpMsgService
{
    public class GeneralService : BackgroundService
    {
        private readonly ILogger<GeneralService> _logger;
        public IConfiguration Configuration { get; }
        private CancellationTokenSource cMsg;
        public static config cfg;
        UnitOfWork _unitOfWork;

        private Dictionary<string, string> send_dic_client = new Dictionary<string, string>();
        private Dictionary<string, IWebSocketConnection> dic_client = new Dictionary<string, IWebSocketConnection>();
        private readonly NamedPipeServerStream pipeServer;
        public GeneralService(ILogger<GeneralService> logger, UnitOfWork unitOfWork, IConfiguration configuration)
        {
            _logger = logger;
            _unitOfWork = unitOfWork;
            Configuration = configuration;
            pipeServer = new NamedPipeServerStream("DeletePipe", PipeDirection.InOut, 1, PipeTransmissionMode.Byte, PipeOptions.Asynchronous | PipeOptions.WriteThrough);


        }

        //public class config
        //{
        //    public string id { get; set; }
        //    public int updateCicle { get; set; }
        //    public DateTime lastTime { get; set; }
        //    public string urlText { get; set; }
        //    public string logUrlText { get; set; }
        //}
        protected override async Task ExecuteAsync(CancellationToken stoppingToken)
        {
            DateTime CheckTime = DateTime.Now.Date;
            cMsg = new CancellationTokenSource();
            var checkTime = Configuration.GetConnectionString("CheckTime");
            Task taskSend = new Task(PollPipeStream);
            taskSend.Start();
            //ȡһݿϢ
            cfg = new config();
            var LogCfg = _unitOfWork.CommonJpLogCfgRepository.Get(p => p.Id != null);//ȫϢ
            cfg.id = LogCfg.Id;
            cfg.updateCicle = LogCfg.UpdateCicle;
            cfg.lastTime = LogCfg.LastTime;
            cfg.urlText = LogCfg.UrlText;
            cfg.logUrlText = LogCfg.LogUrl;
            while (!stoppingToken.IsCancellationRequested && cfg.lastTime.AddDays(1) < DateTime.Now)
            {
                DeleteImage();


                LogCfg.LastTime = DateTime.Now;
                var result = _unitOfWork.CommonJpLogCfgRepository.Update(LogCfg, true);
                await Task.Delay(int.Parse(checkTime) * 60 * 1000); //λ
            }
        }
        public override Task StopAsync(CancellationToken cancellationToken)
        {
            cMsg?.Cancel();
            pipeServer?.Disconnect();
            pipeServer?.Close();
            return base.StopAsync(cancellationToken);
        }
        /// <summary>
        /// ɾļ
        /// </summary>
        /// <param name="imgpath">ļ·</param>
        /// <param name="operatorId">ID</param>
        public void DeleteImage()
        {

            var _channelPath = cfg.urlText + "\\SnapPic";
            var _cabinetPath = cfg.urlText + "\\LogFile\\Cabinet";
            var _logPath = cfg.logUrlText;
            DirectoryInfo TheFolder = new DirectoryInfo(_channelPath);
            DirectoryInfo TheCabinetFolder = new DirectoryInfo(_cabinetPath);
            DirectoryInfo LogFiles = new DirectoryInfo(_logPath);

            //ļ
            if (File.Exists(@TheFolder.ToString()))
            {
                foreach (DirectoryInfo NextFolder in TheFolder.GetDirectories())//ͨ
                {
                    DirectoryInfo NewTheFolder = new DirectoryInfo(NextFolder.FullName);
                    foreach (DirectoryInfo NextNewFolder in NewTheFolder.GetDirectories())//ֿ
                    {
                        DirectoryInfo NewDataFolder = new DirectoryInfo(NextNewFolder.FullName);
                        foreach (DirectoryInfo item in NewDataFolder.GetDirectories())//ֿµļ
                        {
                            if (item.CreationTime.AddDays(cfg.updateCicle) < DateTime.Now.Date)
                            {

                                if (item.Exists)
                                {

                                    Directory.Delete(item.FullName, true);
                                    //File.Delete(item.FullName);
                                }
                            }
                        }

                    }
                }
            }
            if (File.Exists(TheCabinetFolder.ToString()))
            {
                foreach (DirectoryInfo NextFolder in TheCabinetFolder.GetDirectories())//־ļ
                {
                    DirectoryInfo NewTheFolder = new DirectoryInfo(NextFolder.FullName);
                    foreach (DirectoryInfo NextNewFolder in NewTheFolder.GetDirectories())//
                    {


                        if (NextNewFolder.CreationTime.AddDays(cfg.updateCicle) < DateTime.Now.Date)
                        {
                            Directory.Delete(NextNewFolder.FullName, true);

                        }


                    }
                }
            }
            if (File.Exists(LogFiles.ToString()))
            {
                foreach (DirectoryInfo NextFolder in LogFiles.GetDirectories())//־ļ
                {
                    DirectoryInfo NewTheFolder = new DirectoryInfo(NextFolder.FullName);
                    foreach (FileInfo item in NewTheFolder.GetFiles())//־ļµļ
                    {
                        if (item.CreationTime.AddDays(cfg.updateCicle) < DateTime.Now.Date)
                        {
                            File.Delete(item.FullName);
                        }
                    }
                }
            }



        }
        public void PollPipeStream()
        {
            try
            {
                while (!cMsg.IsCancellationRequested)
                {
                    pipeServer.WaitForConnection();
                    StreamString sr = new StreamString(pipeServer);

                    string con = sr.ReadString();//ǰĿͻ
                    var entity = JsonManager.GetJsonEntity(JObject.Parse(con));
                    string updateCicle = entity.updateCicle ?? "";
                    string urlText = entity.urlText ?? "";
                    string logUrl = entity.logUrl ?? "";
                    var LogCfg = _unitOfWork.CommonJpLogCfgRepository.Get(p => p.Id != null);//ȫϢ
                    LogCfg.UpdateCicle = int.Parse(updateCicle);
                    if (!string.IsNullOrEmpty(logUrl))
                    {
                        LogCfg.LogUrl = logUrl;
                    }
                    if (!string.IsNullOrEmpty(urlText))
                    {
                        LogCfg.UrlText = urlText;
                    }
                    _unitOfWork.CommonJpLogCfgRepository.Update(LogCfg, true);

                }

            }
            catch (Exception ex)
            {

                _logger.LogError("Ϣ WaitData:" + ex.ToString());
            }
        }
    }
}
