﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace JmpCommon
{
    /// <summary>
    /// 结果代码
    /// </summary>
    public class ResultCode
    {
        static volatile public Dictionary<string, string> devDic = new Dictionary<string, string>();

        public static ResultInfo OPERATE_FAILED = new ResultInfo { Code = "19999", Msg = "操作失败" };
        public static ResultInfo OPERATE_SUCCESS = new ResultInfo { Code = "10000", Msg = "操作成功" };
        public static ResultInfo HAS_NO_LIMITS = new ResultInfo { Code = "10001", Msg = "没有操作权限" };
        public static ResultInfo ACCOUNT_NO_EXIST = new ResultInfo { Code = "10002", Msg = "没有该账户信息" };
        public static ResultInfo SIGN_ERROR = new ResultInfo { Code = "10003", Msg = "签名错误" };
        public static ResultInfo ACCOUNT_CANNOT_AUDIT = new ResultInfo { Code = "10004", Msg = "该用户无法被审核" };
        public static ResultInfo ACCOUNT_IS_AUDITED = new ResultInfo { Code = "10005", Msg = "用户已通过审核" };
        public static ResultInfo ORDER_NOT_EXIST = new ResultInfo { Code = "10006", Msg = "订单不存在" };
        public static ResultInfo ACCESSTOKEN_ERROR = new ResultInfo { Code = "10008", Msg = "请求密钥错误或过期" };
        public static ResultInfo REQUEST_DATA_ERROR = new ResultInfo { Code = "10009", Msg = "请求数据不合法" };
        public static ResultInfo ADMIN_DELETE_ERROR = new ResultInfo { Code = "100010", Msg = "不能删除超级管理员" };
        public static ResultInfo ACCOUNT_IS_EXIST = new ResultInfo { Code = "10012", Msg = "该账户已存在" };
        public static ResultInfo ACCOUNT_ISNOT_CORRECT = new ResultInfo { Code = "10013", Msg = "帐号密码不正确" };
        public static ResultInfo COMPANY_IS_EXIST = new ResultInfo { Code = "10014", Msg = "该企业已经注册" };
        public static ResultInfo AUDIT_IS_PASS = new ResultInfo { Code = "10015", Msg = "审核未通过" };
        public static ResultInfo AMONT_IS_NOT_ENOUGH = new ResultInfo { Code = "10016", Msg = "允许打印的标签数量不足" };
        public static ResultInfo CHANNEL_CODE_EXIST = new ResultInfo { Code = "10017", Msg = "通道编号已存在" };
        public static ResultInfo CABINET_ERROR = new ResultInfo { Code = "10018", Msg = "用户不存在或单警柜不存在" };
        public static ResultInfo CABINET_SET_ERROR = new ResultInfo { Code = "10018", Msg = "单警柜已被绑定" };
        public static ResultInfo NUMBER255_ERROR = new ResultInfo { Code = "10019", Msg = "号型最多添加255个" };
        public static ResultInfo APPROVE_ERROR = new ResultInfo { Code = "10020", Msg = "用户已撤回或已被审核，无法审核" };
        public static ResultInfo CHANGE_ERROR = new ResultInfo { Code = "10021", Msg = "无法修改已开始任务的领用单" };
        public static ResultInfo DELETE_ERROR = new ResultInfo { Code = "10022", Msg = "该订单不是领用单或该单据已开始" };
        public static ResultInfo SUPPLIER_ERROR = new ResultInfo { Code = "10023", Msg = "供应商码已存在" };
        public static ResultInfo UPDATE_ERROR = new ResultInfo { Code = "10024", Msg = "错误的异常修改业务" };
        public static ResultInfo POLICE_ERROR = new ResultInfo { Code = "10025", Msg = "警员不存在" };
        public static ResultInfo POLICE_C_ERROR = new ResultInfo { Code = "10125", Msg = "警号已存在" };
        public static ResultInfo EPC_ERROR = new ResultInfo { Code = "10026", Msg = "EPC或物资不存在" };
        public static ResultInfo ORDER_IS_EXIST = new ResultInfo { Code = "10027", Msg = "订单已存在" };
        public static ResultInfo ORDER_ERROR = new ResultInfo { Code = "10028", Msg = "订单号格式不正确" };
        public static ResultInfo ORGANIZATION_ERROR = new ResultInfo { Code = "10029", Msg = "组织机构不正确" };
        public static ResultInfo TIME_ERROR = new ResultInfo { Code = "10030", Msg = "时间戳失效,请求过期" };
        public static ResultInfo APPKEY_ERROR = new ResultInfo { Code = "10031", Msg = "AppKey错误" };
        public static ResultInfo API_ERROR = new ResultInfo { Code = "10032", Msg = "没有权限调用该接口" };
        public static ResultInfo MESSAGE_ERROR = new ResultInfo { Code = "10033", Msg = "认证服务网关超时" };
        public static ResultInfo EQUIPMENT_ERROR = new ResultInfo { Code = "10034", Msg = "物资不存在" };
        public static ResultInfo DELETE_USER_ERROR = new ResultInfo { Code = "10035", Msg = "请先将单警柜内与人员绑定的物资解绑" };
        public static ResultInfo WAREHOUSE_LOCK = new ResultInfo { Code = "10036", Msg = "仓库已锁定，正在盘点中" };
        public static ResultInfo WAREHOUSE_INV_EXIST = new ResultInfo { Code = "10037", Msg = "有未操作的盘点单据，请先进行处理" };
        public static ResultInfo ORDER_EXIST = new ResultInfo { Code = "10038", Msg = "已有单据在审核，请先处理待审核单据" };
        public static ResultInfo CABINET_INVENTORY_EXIST = new ResultInfo { Code = "10039", Msg = "单警柜存在物资" };
        public static ResultInfo ORDER_OPERATE_FAILED = new ResultInfo { Code = "10040", Msg = "单据操作失败" };
        public static ResultInfo ORDER_OPERATE_ERROR = new ResultInfo { Code = "10041", Msg = "单据已完成或单据不存在" };
        
        public static ResultInfo EPC_GEN_FAILED = new ResultInfo { Code = "10020", Msg = "EPC生成失败" };
        public static ResultInfo BASE_EXIST = new ResultInfo { Code = "10034", Msg = "基础信息已存在" };
        public static ResultInfo BOX_MARK_INVALID = new ResultInfo { Code = "10042", Msg = "无效箱标EPC" };
        public static ResultInfo NO_PROCESS = new ResultInfo { Code = "10043", Msg = "无流程信息" };
        public static ResultInfo BAG_EXIST = new ResultInfo { Code = "10044", Msg = "已有物资进行绑定，无法进行修改或删除" };
        public static ResultInfo COUNT_ERROR = new ResultInfo { Code = "10045", Msg = "实际物资数量超过预设装备包数量" };
        public static ResultInfo NAME_ERROR = new ResultInfo { Code = "10046", Msg = "名称重复" };
        public static ResultInfo MISSION_ERROR = new ResultInfo { Code = "10047", Msg = "该单据正在任务中或已有物资出入库" };
        public static ResultInfo MISSION_EXIST = new ResultInfo { Code = "10048", Msg = "存在进行中的任务" };

        public static ResultInfo REMOTE_REPORTING_ERROR = new ResultInfo { Code = "10099", Msg = "远端上报数据失败" };
    }

    /// <summary>
    /// 结果信息 -- 结构体
    /// </summary>
    public struct ResultInfo
    {
        public string Code { get; set; }
        public string Msg { get; set; }
    }
}
