﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Newtonsoft.Json.Serialization;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;

namespace JmpCommon
{
    public partial class JsonManager
    {

        /// <summary>
        /// 获取EPC
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static Dictionary<string, dynamic> GetEpcInfo(JObject obj)
        {
            try
            {
                string warehouseID = string.Empty;
                string userID = string.Empty;
                string supplierID = string.Empty;
                List<Dictionary<string, string>> equipments = new List<Dictionary<string, string>>();

                JToken token = obj["body"];

                if (token.SelectToken("warehouseID") != null)
                {
                    warehouseID = token["warehouseID"].ToString();
                }
                if (token.SelectToken("userID") != null)
                {
                    userID = token["userID"].ToString();
                }

                if (token.SelectToken("equipments") != null)
                {
                    //List<JToken> equipmentsJarray = token["equipments"].ToList();
                    foreach (JToken TokenChild in token["equipments"].ToList())
                    {
                        Dictionary<string, string> equipList = new Dictionary<string, string>();
                        equipList.Add("equipmentID", TokenChild["equipmentID"].ToString());
                        equipList.Add("epc", TokenChild["epc"].ToString());
                        equipList.Add("equipmentSizeID", TokenChild["equipmentSizeID"].ToString());
                        equipList.Add("supplierID", TokenChild["supplierID"].ToString());
                        equipments.Add(equipList);
                    }
                }
                Dictionary<string, dynamic> result = new Dictionary<string, dynamic>();
                //Tuple<string, dynamic, bool> tuple = new Tuple<string, dynamic, bool>();

                result.Add("warehouseID", warehouseID);
                result.Add("userID", userID);
                result.Add("equipments", equipments);
                return result;

            }
            catch (Exception ex)
            {
                return null;
            }
        }

        /// <summary>
        /// 获取新增装备的信息
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static Dictionary<string, dynamic> GetAddEquipmentInfo(JObject obj)
        {
            try
            {
                string warehouseID = string.Empty;
                string userID = string.Empty;
                string supplierID = string.Empty;
                string orgID = string.Empty;
                List<Dictionary<string, string>> equipments = new List<Dictionary<string, string>>();



                if (obj.SelectToken("warehouseid") != null)
                {
                    warehouseID = obj["warehouseid"].ToString();
                }
                if (obj.SelectToken("userid") != null)
                {
                    userID = obj["userid"].ToString();
                }
                if (obj.SelectToken("orgid") != null)
                {
                    orgID = obj["orgid"].ToString();
                }

                if (obj.SelectToken("equipments") != null)
                {
                    //List<JToken> equipmentsJarray = token["equipments"].ToList();
                    foreach (JToken TokenChild in obj["equipments"].ToList())
                    {
                        Dictionary<string, string> equipList = new Dictionary<string, string>();
                        equipList.Add("equipmentid", TokenChild["equipmentid"].ToString());
                        equipList.Add("epc", TokenChild["epc"].ToString());
                        equipList.Add("equipmentsizeid", TokenChild["equipmentsizeid"].ToString());
                        equipList.Add("supplierid", TokenChild["supplierid"].ToString());
                        equipments.Add(equipList);
                    }
                }
                Dictionary<string, dynamic> result = new Dictionary<string, dynamic>();
                //Tuple<string, dynamic, bool> tuple = new Tuple<string, dynamic, bool>();

                result.Add("warehouseid", warehouseID);
                result.Add("userid", userID);
                result.Add("equipments", equipments);
                result.Add("orgID", orgID);
                return result;

            }
            catch (Exception ex)
            {
                return null;
            }
        }

        /// <summary>
        /// 获取新增装备的信息
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static Dictionary<string, dynamic> GetAddPuchaseInfo(JObject obj)
        {
            try
            {
                JToken token = obj["body"];
                if (!token.HasValues) { return default; }
                else
                {
                    var warehouseID = GetDataByKey<string>(token, "warehouseID");
                    var organizationID = GetDataByKey<string>(token, "organizationID");
                    var applyByID = GetDataByKey<string>(token, "applyByID");
                    var applyReason = GetDataByKey<string>(token, "applyReason");
                    var approvalID = GetDataByKey<string>(token, "approvalID");

                    Dictionary<string, dynamic> resultList = new Dictionary<string, dynamic>();
                    resultList.Add("warehouseID", warehouseID);
                    resultList.Add("organizationID", organizationID);
                    resultList.Add("applyByID", applyByID);
                    resultList.Add("applyReason", applyReason);
                    resultList.Add("approvalID", approvalID);

                    List<Dictionary<string, string>> detailList = new List<Dictionary<string, string>>();
                    if (token["purchaseDetailList"].HasValues)
                    {
                        //List<JToken> equipmentsJarray = token["equipments"].ToList();
                        foreach (JToken item in token["purchaseDetailList"].ToList())
                        {
                            Dictionary<string, string> tmp = new Dictionary<string, string>();
                            tmp.Add("equipmentSizeID", GetDataByKey<string>(item, "equipmentSizeID"));
                            tmp.Add("equipmentID", GetDataByKey<string>(item, "equipmentID"));
                            tmp.Add("quantity", GetDataByKey<string>(item, "quantity"));
                            tmp.Add("supplierID", GetDataByKey<string>(item, "supplierID"));
                            tmp.Add("note", GetDataByKey<string>(item, "note"));
                            detailList.Add(tmp);
                        }
                    }
                    resultList.Add("purchaseDetailList", detailList);
                    return resultList;

                }

            }
            catch (Exception ex)
            {
                return null;
            }
        }

        /// <summary>
        /// 获取请求数据Id -- 数据标识
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static string GetRequestId(JObject obj)
        {
            try
            {
                return obj["id"].ToString();
            }
            catch
            {
                return string.Empty;
            }
        }


        /// <summary>
        /// 返回成功的结果
        /// </summary>
        /// <param name="body"></param>
        /// <returns></returns>
        public static HttpResponseMessage ReturnSuccessResponse<T>(T data, bool isNull = false)
        {
            //JObject result = new JObject();
            //result.Add(new JObject(new JProperty("code", ResultCode.OPERATE_SUCCESS.Code), new JProperty("msg", ResultCode.OPERATE_SUCCESS.Message), new JProperty("body", body)));
            var src = new
            {
                code = ResultCode.OPERATE_SUCCESS.Code,
                msg = ResultCode.OPERATE_SUCCESS.Msg,
                data
            };

            JsonSerializerSettings setting = new JsonSerializerSettings();

            setting.DateFormatHandling = DateFormatHandling.MicrosoftDateFormat;
            setting.DateFormatString = "yyyy-MM-dd HH:mm:ss";
            setting.ContractResolver = new CamelCasePropertyNamesContractResolver();
            setting.MaxDepth = 10; //设置序列化的最大层数
            setting.ReferenceLoopHandling = ReferenceLoopHandling.Ignore;
            if (isNull)
            {
                //空值处理
                setting.NullValueHandling = NullValueHandling.Ignore;
            }

            return new HttpResponseMessage { Content = new StringContent(JsonConvert.SerializeObject(src, Formatting.Indented, setting), Encoding.GetEncoding("UTF-8"), "application/json") };
        }

        public static List<string> GetDetailIds(dynamic details)
        {
            List<string> tmpList = new List<string>();
            foreach (var item in details)
            {
                if (string.IsNullOrEmpty(item.id ?? "")) { continue; }
                else
                {
                    tmpList.Add((string)item.id);
                }
            }
            return tmpList;
        }
        public static List<string> GetDetails(dynamic details)
        {
            List<string> tmpList = new List<string>();
            foreach (var item in details)
            {
                if (string.IsNullOrEmpty(item.estimateId ?? "")) { continue; }
                else
                {
                    tmpList.Add((string)item.estimateId);
                }
            }
            return tmpList;
        }

        /// <summary>
        /// 返回执行状态
        /// </summary>
        /// <param name="resultinfo">结果信息</param>
        /// <returns></returns>
        public static HttpResponseMessage SimpleCustResponse(string msg, string code = "")
        {
            //JObject result = new JObject();
            //result.Add(new JObject(new JProperty("code", resultinfo.Code), new JProperty("msg", resultinfo.Message)));
            var src = new
            {
                code = string.IsNullOrEmpty(code) ? ResultCode.OPERATE_FAILED.Code : code,
                msg = msg,
                timestamp = GetCurrTimeStamp()
            };
            return new HttpResponseMessage { Content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(src), Encoding.GetEncoding("UTF-8"), "application/json") };
        }

        /// <summary>
        /// 返回执行状态
        /// </summary>
        /// <param name="resultinfo">结果信息</param>
        /// <returns></returns>
        public static HttpResponseMessage SimpleCustResponse(JObject jobj)
        {
            return new HttpResponseMessage { Content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(jobj), Encoding.GetEncoding("UTF-8"), "application/json") };
        }

        /// <summary>
        /// 返回执行状态
        /// </summary>
        /// <param name="message">结果信息</param>
        /// <param name="data">返回数据</param>
        /// <returns></returns>
        public static HttpResponseMessage SimpleCustResponse<T>(string message, T data)
        {
            //JObject result = new JObject();
            //result.Add(new JObject(new JProperty("code", resultinfo.Code), new JProperty("msg", resultinfo.Message)));
            var src = new
            {
                code = ResultCode.OPERATE_FAILED.Code,
                msg = message,
                data,
                timestamp = GetCurrTimeStamp()
            };
            return new HttpResponseMessage { Content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(src), Encoding.GetEncoding("UTF-8"), "application/json") };
        }

        /// <summary>
        /// 返回执行状态
        /// </summary>
        /// <param name="resultinfo">结果信息</param>
        /// <returns></returns>
        public static HttpResponseMessage SimpleStatusResponse(ResultInfo resultinfo)
        {
            //JObject result = new JObject();
            //result.Add(new JObject(new JProperty("code", resultinfo.Code), new JProperty("msg", resultinfo.Message)));
            var src = new
            {
                code = resultinfo.Code,
                msg = resultinfo.Msg,
                timestamp = GetCurrTimeStamp()
            };
            return new HttpResponseMessage { Content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(src), Encoding.GetEncoding("UTF-8"), "application/json") };
        }

        public static dynamic GetJsonEntity(JObject obj)
        {
            try
            {
               
                if (!obj.HasValues) { return new DynamicModel(); }
                else
                {

                    JToken head = obj;
                    return GetJObj(obj);

                    //老版本写法
                    //dynamic model = new DynamicModel();
                    //foreach (JProperty head_item in head)
                    //{
                    //    if (head_item.Name.Contains("List"))
                    //    {
                    //        model.PropertyName = head_item.Name;
                    //        List<dynamic> array = new List<dynamic>();
                    //        foreach (JToken chil_item in head_item)
                    //        {

                    //            foreach (JToken chil_vle in chil_item)
                    //            {
                    //                dynamic child = new DynamicModel();
                    //                foreach (JProperty chil_pro in chil_vle)
                    //                {
                    //                    child.PropertyName = chil_pro.Name;
                    //                    child.Property = chil_pro.Value?.ToString() ?? "";

                    //                }
                    //                array.Add(child);
                    //            }

                    //        }
                    //        model.Property = array;
                    //    }
                    //    else
                    //    {
                    //        model.PropertyName = head_item.Name;
                    //        model.Property = head_item.Value?.ToString() ?? "";
                    //    }
                    //}
                    //return model;
                }
            }
            catch
            {
                return new DynamicModel();
            }
        }

            private static dynamic GetJObj(JToken obj)
            {
                dynamic node = new DynamicModel();
                foreach (JProperty item in obj)
                {
                    //节点是数组
                    if (item.Value is JArray)
                    {
                        node.PropertyName = item.Name;
                        if (!item.Value.HasValues)
                        {
                            node.Property = null;
                            continue;
                        }
                        else if (item.Value[0].Type == JTokenType.Object)
                        {
                            node.Property = GetJArrayObj(item.Value);
                        }
                        else
                        {
                            node.Property = GetJArrayVale(item.Value);
                        }
                    }
                    //节点值是对象
                    else if (item.Value is JObject)
                    {
                        node.PropertyName = item.Name;
                        node.Property = GetJObj(item);
                    }
                    //节点是属性
                    else
                    {
                        node.PropertyName = item.Name;
                        node.Property = item.Value?.ToString() ?? "";
                    }
                }
                return node;

            }

        /// <summary>
        /// 解析Json数组
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        private static List<string> GetJArrayVale(JToken obj)
        {
            List<string> root_array = new List<string>();
            foreach (JValue root_item in obj)
            {

                if (root_item.Type == JTokenType.Integer ||
                   root_item.Type == JTokenType.Float ||
                   root_item.Type == JTokenType.String ||
                   root_item.Type == JTokenType.Boolean ||
                   root_item.Type == JTokenType.Guid)
                {
                    root_array.Add(root_item.Value?.ToString() ?? "");
                }
                else
                {
                    root_array.Add(root_item.Value?.ToString() ?? "");
                }
            }
            return root_array;
        }

        /// <summary>
        /// 解析Json数组对象
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        private static List<dynamic> GetJArrayObj(JToken obj)
        {
            List<dynamic> root_array = new List<dynamic>();
            foreach (JToken root_item in obj)
            {
                dynamic chile_array = new DynamicModel();
                foreach (JProperty child_item in root_item)
                {
                    if (child_item.Value.Type == JTokenType.Array)
                    {
                        chile_array.PropertyName = child_item.Name;
                        if (!child_item.HasValues)
                        {
                            chile_array.Property = null;
                            continue;
                        }
                        else if (child_item.Value.Count()>0&& child_item.Value[0].Type == JTokenType.Object)
                        {
                            chile_array.Property = GetJArrayObj(child_item.Value);
                        }
                        else
                        {
                            chile_array.Property = GetJArrayVale(child_item.Value);
                        }
                    }
                    else if (child_item.Value.Type == JTokenType.Object)
                    {
                        chile_array.PropertyName = child_item.Name;
                        chile_array.Property = GetJObj(child_item); ;
                    }
                    else
                    {
                        chile_array.PropertyName = child_item.Name;
                        chile_array.Property = child_item.Value?.ToString() ?? "";
                    }
                }
                root_array.Add(chile_array);
            }
            return root_array;
        }

        private static T GetDataByKey<T>(JToken obj, string key)
        {
            if (!obj[key].HasValues) { return default; }
            else
            {
                return obj[key].Value<T>();

            }
        }

        /// <summary>
        /// 获取当前时间戳
        /// </summary>
        /// <returns></returns>
        public static long GetCurrTimeStamp()
        {
            TimeSpan ts = DateTime.Now - new DateTime(1970, 1, 1, 0, 0, 0, 0);
            return Convert.ToInt64(ts.TotalSeconds);
        }
    }

    public class DynamicModel : DynamicObject
    {
        public string PropertyName { get; set; }

        // The inner dictionary.
        protected Dictionary<string, object> DynamicProperty { get; }
             = new Dictionary<string, object>();

        // This property returns the number of elements
        // in the inner dictionary.
        public int Count
        {
            get
            {
                return DynamicProperty.Count;
            }
        }

        // If you try to get a value of a property 
        // not defined in the class, this method is called.
        public override bool TryGetMember(
            GetMemberBinder binder, out object result)
        {
            // Converting the property name to lowercase
            // so that property names become case-insensitive.
            string key = binder.Name;
            if (!DynamicProperty.ContainsKey(key))
            {
                DynamicProperty.Add(key, null);
            }

            // If the property name is found in a dictionary,
            // set the result parameter to the property value and return true.
            // Otherwise, return false.
            result = DynamicProperty[key];
            return true;
        }

        // If you try to set a value of a property that is
        // not defined in the class, this method is called.
        public override bool TrySetMember(
            SetMemberBinder binder, object value)
        {
            // Converting the property name to lowercase
            // so that property names become case-insensitive.
            if (binder.Name == "Property")
            {
                DynamicProperty[PropertyName] = value;
            }
            else
            {
                DynamicProperty[binder.Name] = value;
            }


            // You can always add a value to a dictionary,
            // so this method always returns true.
            return true;
        }

    }
}
