﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Net.WebSockets;
using System.Threading;
using System.Threading.Tasks;
using JunmpPoliceStation.Common;
using JunmpPoliceStation.Model;
using JunmpPoliceStation.Model.Enumerates;
using JunmpPoliceStation.Model.Repository;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json.Linq;
using static JunmpPoliceStation.Model.Enumerates.BorrowEnum;

namespace JunmpPoliceStation.Controllers
{
    public class SocketHandler
    {
        public const int BufferSize = 4096;
        public string basestringjson = string.Empty;

        WebSocket socket;

        SocketHandler(WebSocket socket)
        {
            this.socket = socket;
        }

        async Task EchoLoop()
        {
            var buffer = new byte[BufferSize];
            //代码接收消息并立即发回相同的消息。 循环发送和接收消息，直到客户端关闭连接
            WebSocketReceiveResult result = await socket.ReceiveAsync(new ArraySegment<byte>(buffer), CancellationToken.None);
            while (!result.CloseStatus.HasValue)
            {
                //buffer为收到的信息

                //返回信息
                byte[] backInfo = System.Text.UTF8Encoding.Default.GetBytes("服务端相应内容:OK");

                await socket.SendAsync(new ArraySegment<byte>(backInfo, 0, backInfo.Length), result.MessageType, result.EndOfMessage, CancellationToken.None);

                
                
                
                result = await socket.ReceiveAsync(new ArraySegment<byte>(buffer), CancellationToken.None);
            }
            await socket.CloseAsync(result.CloseStatus.Value, result.CloseStatusDescription, CancellationToken.None);
        }

        static async Task Acceptor(HttpContext hc, Func<Task> n)
        {
            if (!hc.WebSockets.IsWebSocketRequest)
                return;

            var socket = await hc.WebSockets.AcceptWebSocketAsync();//将请求转换为WebSocket
            var h = new SocketHandler(socket);
            await h.EchoLoop();
        }

        /// <summary>
        /// branches the request pipeline for this SocketHandler usage
        /// </summary>
        /// <param name="app"></param>
        public static void Map(IApplicationBuilder app)
        {
            app.UseWebSockets();
            app.Use(SocketHandler.Acceptor);
        }
    }
}